/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.util.Enumeration;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.CIMEnumerationResponse;
import org.eclipse.aperi.discovery.interfaces.CIMExceptionResponse;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskCIMScanner
extends Thread {
    public static String stQueueName = "DiskManager CIM/OM";
    private String cBaseThreadName = "DiskCIMScanner (" + stQueueName + ") ";
    private boolean cContinue = true;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DiskCIMScanner() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"DiskCIMScanner", null);
        try {
            logTraceHelper.objectCreation(this.getClass().getName());
            this.setName(this.cBaseThreadName);
            QueueController.getInstance().addQueue(stQueueName, (IJobQueue)new DefaultJobQueue());
            this.start();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit((Object)logTraceHelper);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit((Object)logTraceHelper);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"run", null);
        try {
            while (this.cContinue) {
                LogTraceHelper logTraceHelper2;
                JobInfo jobInfo;
                block22: {
                    Object var9_12;
                    logTraceHelper.traceHigh("Waiting for a job on queue: " + stQueueName);
                    this.setName(String.valueOf(this.cBaseThreadName) + "- waiting");
                    jobInfo = QueueController.getInstance().getNextJob(stQueueName);
                    if (!this.cContinue || jobInfo == null) continue;
                    logTraceHelper.traceHigh("starting execution of job " + jobInfo.getId());
                    Query query = (Query)jobInfo.getRequest().getData();
                    logTraceHelper2 = LogTraceHelper.entry((String)jobInfo.getId(), (Object)this, (String)"run", (Object[])new Object[]{query});
                    CIMClientWrapper cIMClientWrapper = null;
                    try {
                        try {
                            String string;
                            String string2 = jobInfo.getTarget().length > 2 ? (jobInfo.getTarget()[2] != null ? jobInfo.getTarget()[2] : "") : (string = "");
                            String string3 = jobInfo.getTarget().length > 2 ? (jobInfo.getTarget()[3] != null ? jobInfo.getTarget()[3] : "") : "";
                            cIMClientWrapper = CIMClientPool.getClient((String)string, (String)string3, (String)jobInfo.getTarget()[0], (String)jobInfo.getTarget()[1]);
                            Enumeration enumeration = null;
                            switch (query.getCmd()) {
                                case 6: {
                                    this.setName(String.valueOf(this.cBaseThreadName) + "- executing references call");
                                    enumeration = cIMClientWrapper.references(query.getCOP(), query.getResultClassName(), query.getRole(), true, true, null, logTraceHelper2);
                                    break;
                                }
                                case 7: {
                                    this.setName(String.valueOf(this.cBaseThreadName) + "- executing referenceNames call");
                                    enumeration = cIMClientWrapper.referenceNames(query.getCOP(), logTraceHelper2);
                                    break;
                                }
                                case 0: {
                                    this.setName(String.valueOf(this.cBaseThreadName) + "- executing enumInstances call");
                                    enumeration = cIMClientWrapper.enumerateInstances(new CIMObjectPath(query.getClassName()), true, false, logTraceHelper2);
                                    break;
                                }
                                case 1: {
                                    this.setName(String.valueOf(this.cBaseThreadName) + "- executing enumInstanceNames call");
                                    enumeration = cIMClientWrapper.enumerateInstanceNames(new CIMObjectPath(query.getClassName()), logTraceHelper2);
                                    break;
                                }
                                case 2: {
                                    this.setName(String.valueOf(this.cBaseThreadName) + "- executing associators call");
                                    enumeration = cIMClientWrapper.associators(query.getCOP(), query.getAssocClassName(), query.getResultClassName(), query.getRole(), query.getResultRole(), false, false, null, logTraceHelper2);
                                    break;
                                }
                                case 3: {
                                    this.setName(String.valueOf(this.cBaseThreadName) + "- executing associatorNames call");
                                    enumeration = cIMClientWrapper.associatorNames(query.getCOP(), query.getAssocClassName(), query.getResultClassName(), query.getRole(), query.getResultRole(), logTraceHelper2);
                                    break;
                                }
                                case 5: {
                                    this.setName(String.valueOf(this.cBaseThreadName) + "- executing enumClassNames call");
                                    enumeration = cIMClientWrapper.enumerateClassNames(new CIMObjectPath(query.getClassName()), logTraceHelper2);
                                    break;
                                }
                                case 4: {
                                    this.setName(String.valueOf(this.cBaseThreadName) + "- executing enumClasses call");
                                    enumeration = cIMClientWrapper.enumerateClasses(new CIMObjectPath(query.getClassName()), true, false, false, false, logTraceHelper2);
                                    break;
                                }
                                default: {
                                    logTraceHelper2.traceWarning("Unsuported command: " + query.getCmd());
                                }
                            }
                            jobInfo.setResponse((Response)new CIMEnumerationResponse(enumeration, jobInfo));
                            jobInfo.setReturnCode(2);
                            jobInfo.complete(true);
                        }
                        catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                            logTraceHelper2.traceError("Timeout during CIM call", (Throwable)diskManagerTimeoutException);
                            jobInfo.setResponse((Response)new CIMExceptionResponse((Throwable)diskManagerTimeoutException, jobInfo));
                            jobInfo.setReturnCode(99);
                            jobInfo.complete(false);
                        }
                        catch (Exception exception) {
                            logTraceHelper2.traceError("Unexpected error during CIM call", (Throwable)exception);
                            jobInfo.setResponse((Response)new CIMExceptionResponse((Throwable)exception, jobInfo));
                            jobInfo.setReturnCode(99);
                            jobInfo.complete(false);
                        }
                        catch (Throwable throwable) {
                            logTraceHelper2.traceError("Unexpected error during CIM call", throwable);
                            jobInfo.setResponse((Response)new CIMExceptionResponse(throwable, jobInfo));
                            jobInfo.setReturnCode(99);
                            jobInfo.complete(false);
                        }
                    }
                    catch (Throwable throwable) {
                        var9_12 = null;
                        if (cIMClientWrapper != null) {
                            CIMClientPool.returnClient(cIMClientWrapper);
                        }
                        logTraceHelper2.exit((Object)("Job RC: " + jobInfo.getReturnCode()));
                        throw throwable;
                    }
                    {
                        var9_12 = null;
                        if (cIMClientWrapper == null) break block22;
                    }
                    CIMClientPool.returnClient((CIMClientWrapper)cIMClientWrapper);
                }
                logTraceHelper2.exit((Object)("Job RC: " + jobInfo.getReturnCode()));
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            logTraceHelper.exit((Object)"void");
            throw throwable;
        }
        {
            Object var11_16 = null;
        }
        logTraceHelper.exit((Object)"void");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"shutdown", null);
        try {
            this.cContinue = false;
            if (this.isAlive()) {
                try {
                    logTraceHelper.traceInfo("Sutting down scanner thread");
                    this.interrupt();
                    this.join(30000L);
                }
                catch (Exception exception) {
                    logTraceHelper.traceError("Error shutting down scanner thread", (Throwable)exception);
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            logTraceHelper.exit((Object)"void");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        logTraceHelper.exit((Object)"void");
    }
}

