/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.collection.SVCExtentUpdatePostProcess;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.BackendController;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.interfaces.ParameterException;

public class ExtentUpdatePostProcess
extends SVCExtentUpdatePostProcess {
    public ExtentUpdatePostProcess() {
        this("MDISK Update Post Processing");
    }

    protected ExtentUpdatePostProcess(String string) {
        super(string);
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"ExtentUpdatePostProcess", null);
        logTraceHelper.exit(null);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        return new DiscoverProcess.RegistrationData[]{new DiscoverProcess.RegistrationData("ExtentUpdatePostProcess", null, "Array", null, null, null)};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result process(Request request, Map map) throws ParameterException {
        Result result;
        LogTraceHelper logTraceHelper;
        block14: {
            logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{request, map});
            result = new Result(1);
            DBConnection dBConnection = null;
            try {
                try {
                    Integer.parseInt((String)map.get("DEVICEID"));
                    String string = (String)map.get("SUBSYSTEMID");
                    dBConnection = ServiceUtils.getConnection();
                    StorageSubsystem storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string, (DBConnection)dBConnection);
                    List list = this.getReferencedBackendController(storageSubsystem.getSubsystemId(), dBConnection);
                    Iterator iterator = list.iterator();
                    while (true) {
                        block15: {
                            if (iterator.hasNext()) break block15;
                            result = new Result(0);
                            dBConnection.commit();
                            break;
                        }
                        BackendController backendController = (BackendController)iterator.next();
                        logTraceHelper.traceInfo("Referenced subsystem " + backendController.getOwningSubsystemId() + " is called");
                        StorageSubsystem storageSubsystem2 = this.getStorageSubsystem(backendController.getOwningSubsystemId(), dBConnection, logTraceHelper);
                        this.processMdisk(dBConnection, Integer.toString(storageSubsystem.getSubsystemId()), storageSubsystem2);
                    }
                }
                catch (Exception exception) {
                    if (dBConnection != null) {
                        try {
                            dBConnection.rollback();
                        }
                        catch (SQLException sQLException) {}
                    }
                    result = new Result(1);
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)exception.getMessage(), (Throwable)exception, (LogTraceHelper)logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException) {}
                }
                logTraceHelper.exit((Object)result);
                throw throwable;
            }
            {
                Object var12_15 = null;
                if (dBConnection == null) break block14;
            }
            try {}
            catch (SQLException sQLException) {}
            dBConnection.close();
        }
        logTraceHelper.exit((Object)result);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List getReferencedBackendController(int n, DBConnection dBConnection) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getReferencedBackendController", (Object[])new Object[]{new Integer(n), dBConnection});
        LinkedList<BackendController> linkedList = new LinkedList<BackendController>();
        try {
            try {
                Class<?> clazz;
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                try {
                    clazz = Class.forName("org.eclipse.aperi.infrastructure.database.objects.BackendController");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(clazz, (String)"REFERENCED_SUBSYSTEM_ID", (LogTraceHelper)logTraceHelper);
                hashtable.put(columnInfo, Integer.toString(n));
                BackendController.BackendControllerCursor backendControllerCursor = BackendController.getCursor((DBConnection)dBConnection, hashtable, null);
                while (true) {
                    block8: {
                        if (backendControllerCursor.next()) break block8;
                        backendControllerCursor.close();
                        break;
                    }
                    linkedList.add(backendControllerCursor.getObject());
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", (Throwable)sQLException);
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        logTraceHelper.exit(linkedList);
        return linkedList;
    }
}

