/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.MappingManagement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.sblim.wbem.cim.CIMObjectPath;

public class MappingManagementMultiplePort
extends MappingManagement {
    protected ArrayList cStorageHardwareIDsWithoutProtocolController;
    protected ArrayList cVolumeCOPsWithoutProtocolController;
    protected boolean cNeedToCreatePC = true;

    public MappingManagementMultiplePort(StorageConfigurationPlugin storageConfigurationPlugin, CIMClientWrapper cIMClientWrapper, CIMObjectPath cIMObjectPath, CapabilityData capabilityData, String string, Token token) {
        super(storageConfigurationPlugin, cIMClientWrapper, cIMObjectPath, capabilityData, string, token);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveProtocolControllersForMappings(ArrayList arrayList, ArrayList arrayList2, CIMObjectPath[] cIMObjectPathArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveProtocolControllersForMappings", (Object[])new Object[]{arrayList, arrayList2, cIMObjectPathArray});
        ArrayList arrayList3 = null;
        try {
            block14: {
                arrayList3 = this.retrieveProtocolControllersForStorageHardwareIDs(arrayList, arrayList2);
                if (arrayList3.size() > 1) {
                    String[] stringArray = new String[arrayList.size()];
                    int n = 0;
                    while (true) {
                        if (n >= arrayList.size()) {
                            ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021615E", (Object)stringArray, (Object)this.cStorageSystemID, (LogTraceHelper)logTraceHelper);
                            logTraceHelper.traceError("There are several ProtocolControllers mapped to the HardwareIDs. This will prevent mapping creation for all StorageHardwareIDs" + arrayList, (Throwable)serverException);
                            throw serverException;
                        }
                        stringArray[n] = ((StorageHardwareID)arrayList.get(n)).getWWPN();
                        ++n;
                    }
                }
                this.cVolumeCOPsWithoutProtocolController = new ArrayList();
                ArrayList arrayList4 = this.retrieveProtocolControllersForVolumes(cIMObjectPathArray, this.cVolumeCOPsWithoutProtocolController);
                if (arrayList4.size() > 1) {
                    ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021616E", (Object)this.cPlugin.getParams().getVolumeIDsForCOPs(cIMObjectPathArray), (Object)this.cStorageSystemID, (LogTraceHelper)logTraceHelper);
                    logTraceHelper.traceError("There are several ProtocolControllers mapped to the Volumes. This will prevent mapping creation for all Volumes" + cIMObjectPathArray, (Throwable)serverException);
                    throw serverException;
                }
                int n = 0;
                while (true) {
                    if (n >= arrayList4.size()) {
                        if (arrayList3.size() > 1) {
                            break;
                        }
                        break block14;
                    }
                    if (!arrayList3.contains(arrayList4.get(0))) {
                        arrayList3.add(arrayList4.get(0));
                    }
                    ++n;
                }
                String[] stringArray = new String[arrayList.size()];
                int n2 = 0;
                while (true) {
                    if (n2 >= arrayList.size()) {
                        ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021530E", (Object)this.cPlugin.getParams().getVolumeIDsForCOPs(cIMObjectPathArray), (Object)stringArray, (LogTraceHelper)logTraceHelper);
                        logTraceHelper.traceError("There are different ProtocolControllers mapped to the Volumes and HardwareIDs. The mapping can not be created as specified." + cIMObjectPathArray, (Throwable)serverException);
                        throw serverException;
                    }
                    stringArray[n2] = ((StorageHardwareID)arrayList.get(n2)).getWWPN();
                    ++n2;
                }
            }
            if (arrayList3.size() == 1) {
                this.cNeedToCreatePC = false;
            }
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            logTraceHelper.exit((Object)arrayList3);
            throw throwable;
        }
        {
            Object var9_17 = null;
        }
        logTraceHelper.exit((Object)arrayList3);
        return arrayList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveProtocolControllersForUnmapping(ArrayList arrayList, CIMObjectPath[] cIMObjectPathArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveProtocolControllersForUnmapping", (Object[])new Object[]{arrayList, cIMObjectPathArray});
        ArrayList arrayList2 = new ArrayList();
        try {
            ArrayList arrayList3 = this.retrieveProtocolControllersForStorageHardwareIDs(arrayList, null);
            int n = 0;
            while (true) {
                block11: {
                    int n2;
                    block12: {
                        if (n < cIMObjectPathArray.length) break block12;
                        if (arrayList2.size() > 1) {
                            logTraceHelper.traceWarning("There are several ProtocolControllers mapped to the Volumes and HardwareIDs. This might cause problems in further processing.");
                        }
                        break;
                    }
                    ArrayList arrayList4 = this.retrieveProtocolControllersForVolumes(new CIMObjectPath[]{cIMObjectPathArray[n]}, null);
                    int n3 = arrayList2.size();
                    int n4 = 0;
                    while (true) {
                        if (n4 >= arrayList4.size()) {
                            if (arrayList2.size() <= n3) {
                                break;
                            }
                            break block11;
                        }
                        n2 = arrayList3.indexOf(arrayList4.get(n4));
                        if (n2 >= 0) {
                            arrayList2.add(arrayList3.get(n2));
                        }
                        ++n4;
                    }
                    String[] stringArray = new String[arrayList.size()];
                    n2 = 0;
                    while (true) {
                        if (n2 >= arrayList.size()) {
                            ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021522E", (Object)stringArray, (Object)this.cPlugin.getParams().getVolumeIDsForCOPs(new CIMObjectPath[]{cIMObjectPathArray[n]}), (LogTraceHelper)logTraceHelper);
                            logTraceHelper.traceError("There is no ProtocolController mapped to the HardwareIDs and this volume.", (Throwable)serverException);
                            throw serverException;
                        }
                        stringArray[n2] = ((StorageHardwareID)arrayList.get(n2)).getWWPN();
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            logTraceHelper.exit(arrayList2);
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        logTraceHelper.exit(arrayList2);
        return arrayList2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProtocolControllerToPrivileges[] createProtocolControllers(ArrayList arrayList, ConfigurationParameter configurationParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"createProtocolControllers", (Object[])new Object[]{arrayList, configurationParameter});
        ProtocolControllerToPrivileges[] protocolControllerToPrivilegesArray = new ProtocolControllerToPrivileges[]{};
        try {
            this.cStorageHardwareIDsWithoutProtocolController = arrayList;
            if (this.cNeedToCreatePC) {
                protocolControllerToPrivilegesArray = new ProtocolControllerToPrivileges[1];
                if (!(configurationParameter instanceof AssignStorageVolumesParameter)) {
                    throw new ServerException(new SRMMessage("HWN020003E", new String[]{configurationParameter.getClass().getName()}));
                }
                CIMObjectPath cIMObjectPath = this.createProtocolControllerWithPorts((AssignStorageVolumesParameter)configurationParameter, null, null);
                protocolControllerToPrivilegesArray[0] = new ProtocolControllerToPrivileges(cIMObjectPath, new PrivilegeToWWPNs(null));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            logTraceHelper.exit((Object)protocolControllerToPrivilegesArray);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        logTraceHelper.exit((Object)protocolControllerToPrivilegesArray);
        return protocolControllerToPrivilegesArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList createMapping(ArrayList arrayList, AssignStorageVolumesParameter assignStorageVolumesParameter) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"createMapping", (Object[])new Object[]{arrayList, assignStorageVolumesParameter});
        ArrayList arrayList2 = new ArrayList();
        try {
            CIMObjectPath[] cIMObjectPathArray = this.getVolumeCOPsWithoutProtocolController();
            String[] stringArray = this.getDeviceNumbersForVolumesToAttach(assignStorageVolumesParameter, cIMObjectPathArray);
            String[] stringArray2 = assignStorageVolumesParameter.getVolumeIDsForCOPs(cIMObjectPathArray);
            ProtocolControllerToPrivileges protocolControllerToPrivileges = (ProtocolControllerToPrivileges)arrayList.get(0);
            arrayList2 = this.attachDevices(protocolControllerToPrivileges, cIMObjectPathArray, stringArray2, stringArray, assignStorageVolumesParameter);
            arrayList2.addAll(this.cPlugin.getPrivilegeManagement().assignAccess(protocolControllerToPrivileges, this.cStorageHardwareIDsWithoutProtocolController, assignStorageVolumesParameter));
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            logTraceHelper.exit(arrayList2);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        logTraceHelper.exit((Object)arrayList2);
        return arrayList2;
    }

    public ArrayList deleteMappings(ArrayList arrayList, AssignmentParameter assignmentParameter, ArrayList arrayList2) throws ServerException {
        ProtocolControllerToPrivileges protocolControllerToPrivileges;
        ArrayList arrayList3;
        LogTraceHelper logTraceHelper;
        block10: {
            block9: {
                ArrayList arrayList4;
                logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"deleteMappings", (Object[])new Object[]{arrayList, assignmentParameter, arrayList2});
                arrayList3 = new ArrayList();
                try {
                    protocolControllerToPrivileges = (ProtocolControllerToPrivileges)arrayList.get(0);
                    if (assignmentParameter.getMappingMode() != AssignmentParameter.MASK_AND_MAP) break block9;
                    this.deleteProtocolController(protocolControllerToPrivileges, assignmentParameter.getVolumeIDs(), assignmentParameter);
                    arrayList4 = arrayList3;
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    logTraceHelper.exit(arrayList3);
                    throw throwable;
                }
                logTraceHelper.exit(arrayList3);
                return arrayList4;
            }
            if (assignmentParameter.getMappingMode() != AssignmentParameter.MAP) break block10;
            ArrayList arrayList5 = this.cPlugin.getVolumeManagement().retrieveVolumesOfProtocolController(protocolControllerToPrivileges.getProtocolController());
            CIMObjectPath[] cIMObjectPathArray = this.checkVolumesOfPC(assignmentParameter.getVolumeCOPs(), arrayList5);
            String[] stringArray = assignmentParameter.getVolumeIDsForCOPs(cIMObjectPathArray);
            if (arrayList5.size() == cIMObjectPathArray.length) {
                this.deleteProtocolController(protocolControllerToPrivileges, assignmentParameter.getVolumeIDs(), assignmentParameter);
            } else {
                this.detachDevices(protocolControllerToPrivileges, cIMObjectPathArray, stringArray, assignmentParameter);
            }
            ArrayList arrayList6 = arrayList3;
            Object var10_11 = null;
            logTraceHelper.exit(arrayList3);
            return arrayList6;
        }
        if (assignmentParameter.getMappingMode() == AssignmentParameter.MASK) {
            String[] stringArray = this.checkWWPNsOfPC(assignmentParameter.getInitiatorWWPNsArray(), ((ProtocolControllerToPrivileges)arrayList.get(0)).getWWPNs());
            if (stringArray.length == ((ProtocolControllerToPrivileges)arrayList.get(0)).getWWPNs().size()) {
                this.deleteProtocolController(protocolControllerToPrivileges, assignmentParameter.getVolumeIDs(), assignmentParameter);
            } else {
                this.cPlugin.getPrivilegeManagement().removeAccess(protocolControllerToPrivileges, arrayList2, assignmentParameter);
            }
        }
        ArrayList arrayList7 = arrayList3;
        Object var10_12 = null;
        logTraceHelper.exit(arrayList3);
        return arrayList7;
    }

    protected CIMObjectPath[] getVolumeCOPsWithoutProtocolController() {
        return this.cVolumeCOPsWithoutProtocolController.toArray(new CIMObjectPath[0]);
    }
}

