/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.CIMDiskManagement;
import org.eclipse.aperi.disk.common.ExceptionHelper;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;
import org.eclipse.aperi.disk.control.util.HardwareIDCollection;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;

public class PrivilegeManagement
extends CIMDiskManagement {
    private CIMObjectPath cPrivilegeManagementService;

    public PrivilegeManagement(StorageConfigurationPlugin storageConfigurationPlugin, CIMClientWrapper cIMClientWrapper, CIMObjectPath cIMObjectPath, String string, Token token) {
        super(storageConfigurationPlugin, cIMClientWrapper, cIMObjectPath, string, token);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CIMObjectPath retrieveAssociatedControllerConfigurationService() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveAssociatedControllerConfigurationService", null);
        try {
            this.cPrivilegeManagementService = this.retrieveAssociatedService("CIM_PrivilegeManagementService", "CIM_HostedService", "Antecedent", "Dependent");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit((Object)this.cPrivilegeManagementService);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit((Object)this.cPrivilegeManagementService);
        return this.cPrivilegeManagementService;
    }

    public CIMObjectPath getPrivilege() {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrievePrivilegesForProtocolController(CIMObjectPath cIMObjectPath, ArrayList arrayList) throws ServerException {
        ArrayList arrayList2 = new ArrayList();
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrievePrivilegesForProtocolController", (Object[])new Object[]{cIMObjectPath});
        try {
            try {
                Enumeration enumeration = this.cCimClient.associatorNames(cIMObjectPath, null, "CIM_AuthorizedPrivilege", "TargetElement", "Privilege", this.cLogTraceHelper);
                while (enumeration.hasMoreElements()) {
                    PrivilegeToWWPNs privilegeToWWPNs = new PrivilegeToWWPNs((CIMObjectPath)enumeration.nextElement());
                    int n = arrayList.indexOf(privilegeToWWPNs);
                    if (n != -1) {
                        arrayList2.add(arrayList.get(n));
                        continue;
                    }
                    privilegeToWWPNs = this.cPlugin.getHardwareIDManagement().retrieveInitiatorsOfPrivilege(privilegeToWWPNs);
                    arrayList2.add(privilegeToWWPNs);
                }
            }
            catch (CIMException cIMException) {
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            logTraceHelper.exit(arrayList2);
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        logTraceHelper.exit(arrayList2);
        return arrayList2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrievePrivilegesForStorageHardwareIDsOrHardwareIDCollections(ArrayList arrayList, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrievePrivilegesForStorageHardwareIDsOrHardwareIDCollections", (Object[])new Object[]{arrayList, arrayList2});
        ArrayList<PrivilegeToWWPNs> arrayList3 = new ArrayList<PrivilegeToWWPNs>();
        try {
            try {
                int n = 0;
                while (n < arrayList.size()) {
                    Object object;
                    CIMObjectPath cIMObjectPath = arrayList.get(n) instanceof StorageHardwareID ? ((StorageHardwareID)arrayList.get(n)).getStorageHardwareIDCOP() : ((HardwareIDCollection)arrayList.get(n)).getHardwareIDCollectionCOP();
                    Enumeration enumeration = this.cCimClient.associatorNames(cIMObjectPath, "CIM_AuthorizedSubject", "CIM_AuthorizedPrivilege", "PrivilegedElement", "Privilege", this.cLogTraceHelper);
                    if (!enumeration.hasMoreElements()) {
                        if (arrayList2 == null) {
                            object = ExceptionHelper.generateHardwareIDsHaveNoMappingsException(arrayList.get(n), this.cPlugin.getParams().getStorageSubsystemID(), logTraceHelper);
                            throw object;
                        }
                        arrayList2.add(arrayList.get(n));
                    } else {
                        while (enumeration.hasMoreElements()) {
                            PrivilegeToWWPNs privilegeToWWPNs;
                            object = (CIMObjectPath)enumeration.nextElement();
                            int n2 = arrayList3.indexOf(new PrivilegeToWWPNs((CIMObjectPath)object));
                            if (n2 == -1) {
                                privilegeToWWPNs = new PrivilegeToWWPNs((CIMObjectPath)object, arrayList.get(n));
                                arrayList3.add(privilegeToWWPNs);
                                continue;
                            }
                            privilegeToWWPNs = (PrivilegeToWWPNs)arrayList3.get(n2);
                            privilegeToWWPNs.addInitiator(arrayList.get(n));
                            arrayList3.add(n2, privilegeToWWPNs);
                        }
                    }
                    ++n;
                }
            }
            catch (CIMException cIMException) {
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        logTraceHelper.exit(arrayList3);
        return arrayList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrievePrivilegesForHardwareIDsOfCollections(ArrayList arrayList, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrievePrivilegesForHardwareIDsOfCollections", (Object[])new Object[]{arrayList, arrayList2});
        ArrayList arrayList3 = new ArrayList();
        try {
            ArrayList arrayList4 = new ArrayList();
            ArrayList arrayList5 = this.cPlugin.getHardwareIDManagement().retrieveCollectionsForStorageHardwareIDs(arrayList, arrayList4);
            if (!arrayList4.isEmpty()) {
                if (arrayList2 == null) {
                    ServerException serverException = ExceptionHelper.generateHardwareIDsHaveNoMappingsException(arrayList4.get(0), this.cPlugin.getParams().getStorageSubsystemID(), logTraceHelper);
                    throw serverException;
                }
                arrayList2.addAll(arrayList4);
            }
            ArrayList arrayList6 = null;
            if (arrayList2 != null) {
                arrayList6 = new ArrayList();
            }
            ArrayList arrayList7 = this.retrievePrivilegesForStorageHardwareIDsOrHardwareIDCollections(arrayList5, arrayList6);
            arrayList3.addAll(arrayList7);
            if (arrayList6 != null && !arrayList6.isEmpty()) {
                int n = 0;
                while (n < arrayList6.size()) {
                    arrayList2.addAll(((HardwareIDCollection)arrayList6.get(n)).getStorageHardwareIDs());
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        logTraceHelper.exit(arrayList3);
        return arrayList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList assignAccess(ProtocolControllerToPrivileges protocolControllerToPrivileges, ArrayList arrayList, AssignmentParameter assignmentParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"assignAccess", (Object[])new Object[]{protocolControllerToPrivileges, arrayList, this.cToken});
        ArrayList arrayList2 = new ArrayList();
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n = 0;
        try {
            try {
                stringArray = this.cPlugin.getMappingManagement().getFCPortWWPNs(protocolControllerToPrivileges.getProtocolController());
                stringArray2 = this.cPlugin.getMappingManagement().getDeviceNumbers(protocolControllerToPrivileges.getProtocolController(), assignmentParameter.getVolumeCOPs());
                CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
                n = 0;
                block5: while (true) {
                    block9: {
                        if (n < cIMObjectPathArray.length) break block9;
                        arrayList2.addAll(ConfigurationResultHelper.createMappingResultsForStorageHardwareIDs(stringArray, arrayList, assignmentParameter.getVolumeIDs(), stringArray2, assignmentParameter, this.cPlugin.getHardwareIDManagement(), protocolControllerToPrivileges.getProtocolController(), this.cToken));
                        assignmentParameter.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)assignmentParameter.getAsyncResult(), arrayList2, (String)assignmentParameter.getAPIMethodName()));
                        break;
                    }
                    Vector<CIMArgument> vector = new Vector<CIMArgument>();
                    Vector vector2 = new Vector();
                    vector.add(new CIMArgument("Subject", new CIMValue((Object)((StorageHardwareID)arrayList.get(n)).getStorageHardwareIDCOP(), CIMDataType.getPredefinedType((int)14))));
                    vector.add(new CIMArgument("Target", new CIMValue((Object)protocolControllerToPrivileges.getProtocolController(), CIMDataType.getPredefinedType((int)14))));
                    vector.add(new CIMArgument("PrivilegeGranted", new CIMValue((Object)new Boolean(true), CIMDataType.getPredefinedType((int)9))));
                    vector.add(new CIMArgument("Activities", new CIMValue((Object)new UnsignedInt16[]{new UnsignedInt16(5), new UnsignedInt16(6)}, CIMDataType.getPredefinedType((int)18))));
                    this.invokeCIMMethod(this.getPrivilegeManagementService(), "AssignAccess", vector, vector2);
                    int n2 = 0;
                    while (true) {
                        if (n2 >= vector2.size()) {
                            ++n;
                            continue block5;
                        }
                        CIMArgument cIMArgument = (CIMArgument)vector2.get(n2);
                        if (cIMArgument.getName().compareTo("Privilege") == 0) {
                            cIMObjectPathArray[n] = (CIMObjectPath)cIMArgument.getValue().getValue();
                        }
                        ++n2;
                    }
                    break;
                }
            }
            catch (ServerException serverException) {
                logTraceHelper.traceError("Internal error: ServerException", (Throwable)serverException);
                ConfigurationResultHelper.processPartialMaskingFailure(arrayList, assignmentParameter, arrayList2, n, assignmentParameter.getVolumeIDs(), stringArray2, stringArray, this.cPlugin.getHardwareIDManagement(), protocolControllerToPrivileges.getProtocolController(), serverException, this.cToken);
                throw serverException;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            logTraceHelper.exit(arrayList2);
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        logTraceHelper.exit(arrayList2);
        return arrayList2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList removeAccess(ProtocolControllerToPrivileges protocolControllerToPrivileges, ArrayList arrayList, AssignmentParameter assignmentParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"removeAccess", (Object[])new Object[]{protocolControllerToPrivileges, arrayList, this.cToken});
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        try {
            try {
                ArrayList arrayList3 = protocolControllerToPrivileges.getPrivilegeToWWPNs();
                ArrayList<PrivilegeToWWPNs> arrayList4 = new ArrayList<PrivilegeToWWPNs>();
                n = 0;
                block5: while (true) {
                    block9: {
                        if (n < arrayList3.size()) break block9;
                        arrayList2.addAll(ConfigurationResultHelper.createUnMappingResults(arrayList4, assignmentParameter.getVolumeIDs(), this.cToken));
                        assignmentParameter.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)assignmentParameter.getAsyncResult(), arrayList2, (String)assignmentParameter.getAPIMethodName()));
                        break;
                    }
                    PrivilegeToWWPNs privilegeToWWPNs = (PrivilegeToWWPNs)arrayList3.get(n);
                    int n2 = 0;
                    while (true) {
                        if (n2 >= arrayList.size()) {
                            ++n;
                            continue block5;
                        }
                        if (ParameterHelper.listContainsStringIgnoreCase(privilegeToWWPNs.getWWPNs(), (String)((StorageHardwareID)arrayList.get(n2)).getWWPN())) {
                            Vector<CIMArgument> vector = new Vector<CIMArgument>();
                            Vector vector2 = new Vector();
                            vector.add(new CIMArgument("Subject", new CIMValue((Object)((StorageHardwareID)arrayList.get(n)).getStorageHardwareIDCOP(), CIMDataType.getPredefinedType((int)14))));
                            vector.add(new CIMArgument("Target", new CIMValue((Object)protocolControllerToPrivileges.getProtocolController(), CIMDataType.getPredefinedType((int)14))));
                            vector.add(new CIMArgument("Privilege", new CIMValue((Object)privilegeToWWPNs.getPrivilege(), CIMDataType.getPredefinedType((int)14))));
                            this.invokeCIMMethod(this.getPrivilegeManagementService(), "RemoveAccess", vector, vector2);
                            arrayList4.add(privilegeToWWPNs);
                        }
                        ++n2;
                    }
                    break;
                }
            }
            catch (ServerException serverException) {
                logTraceHelper.traceError("Internal error: ServerException", (Throwable)serverException);
                ConfigurationResultHelper.processPartialUnmaskingFailure(protocolControllerToPrivileges.getPrivilegeToWWPNs(), assignmentParameter, arrayList2, n, assignmentParameter.getVolumeIDs(), serverException, this.cToken);
                throw serverException;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            logTraceHelper.exit(arrayList2);
            throw throwable;
        }
        {
            Object var13_16 = null;
        }
        logTraceHelper.exit(arrayList2);
        return arrayList2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrievePrivilegesForInitiators(ArrayList arrayList, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrievePrivilegesForInitiators", (Object[])new Object[]{arrayList, arrayList2});
        ArrayList arrayList3 = null;
        try {
            boolean bl = arrayList2 == null;
            boolean bl2 = ((AssignmentParameter)this.cPlugin.getParams()).getCapability().getControllerSuppColl() == 1;
            ArrayList arrayList4 = null;
            if (bl2 || arrayList2 != null) {
                arrayList4 = new ArrayList();
            }
            arrayList3 = this.retrievePrivilegesForStorageHardwareIDsOrHardwareIDCollections(arrayList, arrayList4);
            if (arrayList4 != null && !arrayList4.isEmpty()) {
                if (bl2) {
                    ArrayList arrayList5 = null;
                    if (!bl) {
                        arrayList5 = new ArrayList();
                    }
                    ArrayList arrayList6 = this.retrievePrivilegesForHardwareIDsOfCollections(arrayList4, arrayList5);
                    if (arrayList5 != null && !arrayList5.isEmpty()) {
                        arrayList2.addAll(arrayList5);
                    } else if (arrayList2 != null) {
                        arrayList2.clear();
                    }
                    int n = 0;
                    while (n < arrayList6.size()) {
                        if (!arrayList3.contains(arrayList6.get(n))) {
                            arrayList3.add(arrayList6.get(n));
                        }
                        ++n;
                    }
                } else {
                    arrayList2.addAll(arrayList4);
                }
            }
            arrayList3 = this.removeWrongPrivileges(arrayList3);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        logTraceHelper.exit((Object)arrayList3);
        return arrayList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList removeWrongPrivileges(ArrayList arrayList) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"removeWrongPrivileges", (Object[])new Object[]{arrayList});
        ArrayList arrayList2 = new ArrayList();
        try {
            try {
                CIMObjectPath cIMObjectPath = this.getPrivilegeManagementService();
                int n = 0;
                block6: while (n < arrayList.size()) {
                    CIMObjectPath cIMObjectPath2 = ((PrivilegeToWWPNs)arrayList.get(n)).getPrivilege();
                    Enumeration enumeration = this.cCimClient.associatorNames(cIMObjectPath2, "CIM_ConcreteDependency", "CIM_PrivilegeManagementService", "Dependent", "Antecedent", this.cLogTraceHelper);
                    while (true) {
                        if (!enumeration.hasMoreElements()) {
                            ++n;
                            continue block6;
                        }
                        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                        if (!cIMObjectPath3.equals((Object)cIMObjectPath)) continue;
                        arrayList2.add(arrayList.get(n));
                    }
                }
            }
            catch (CIMException cIMException) {
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            logTraceHelper.exit(arrayList2);
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        logTraceHelper.exit(arrayList2);
        return arrayList2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath getPrivilegeManagementService() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"getPrivilegeManagementService", (Object[])new Object[1]);
        try {
            if (this.cPrivilegeManagementService == null) {
                this.retrieveAssociatedControllerConfigurationService();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit((Object)this.cPrivilegeManagementService);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit((Object)this.cPrivilegeManagementService);
        return this.cPrivilegeManagementService;
    }
}

