/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.disk.control.util.VolumeAssignmentModifyParams;
import org.eclipse.aperi.disk.discovery.Capabilities;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.sblim.wbem.cim.CIMObjectPath;

public class AssignmentParameter
extends ConfigurationParameter {
    public static int MASK = 2;
    public static int MAP = 1;
    public static int MASK_AND_MAP = 3;
    protected ArrayList cInitiatorPorts;
    protected ArrayList cInitiatorPortWWPNs = new ArrayList();
    protected ArrayList cInitiatorCOPs = new ArrayList();
    protected Port[] cTargetPorts;
    protected CIMObjectPath[] cTargetPortCOPs;
    protected String[] cTargetPortWWPNs;
    protected String[] cTargetPortIDs;
    protected Capabilities cPCCaps;
    protected boolean cForce;
    protected int cMappingMode;
    protected ArrayList cMappingsToModify = new ArrayList();

    public AssignmentParameter() {
    }

    public AssignmentParameter(StorageSubsystem storageSubsystem, CIMObjectPath cIMObjectPath) {
        super(storageSubsystem, cIMObjectPath);
    }

    public ArrayList getInitiatorWWPNs() {
        return this.cInitiatorPortWWPNs;
    }

    public String[] getInitiatorWWPNsArray() {
        return this.cInitiatorPortWWPNs.toArray(new String[this.cInitiatorPortWWPNs.size()]);
    }

    public void setInitiatorWWPNs(ArrayList arrayList) {
        this.cInitiatorPortWWPNs = arrayList;
    }

    public void setInitiatorWWPNs(String[] stringArray) {
        this.cInitiatorPortWWPNs = new ArrayList(Arrays.asList(stringArray));
    }

    public CIMObjectPath[] getTargetPortCOPs() {
        return this.cTargetPortCOPs;
    }

    public void setTargetPortCOPs(CIMObjectPath[] cIMObjectPathArray) {
        this.cTargetPortCOPs = cIMObjectPathArray;
    }

    public void setPCCaps(Capabilities capabilities) {
        this.cPCCaps = capabilities;
    }

    public String[] getTargetPortWWPNs() {
        return this.cTargetPortWWPNs;
    }

    public void setTargetPortWWPNs(String[] stringArray) {
        this.cTargetPortWWPNs = stringArray;
    }

    public boolean isForce() {
        return this.cForce;
    }

    public void setForce(boolean bl) {
        this.cForce = bl;
    }

    public int getMappingMode() {
        return this.cMappingMode;
    }

    public void setMappingMode(int n) {
        this.cMappingMode = n;
    }

    public Port[] getInitiatorPorts() {
        return this.cInitiatorPorts != null ? this.cInitiatorPorts.toArray(new Port[this.cInitiatorPorts.size()]) : null;
    }

    public ArrayList getInitiatorPortList() {
        return this.cInitiatorPorts;
    }

    public Port[] getTargetPorts() {
        return this.cTargetPorts;
    }

    public void setInitiatorPorts(ArrayList arrayList) {
        this.cInitiatorPorts = arrayList;
    }

    public void setTargetPorts(Port[] portArray) {
        this.cTargetPorts = portArray;
    }

    public String[] getTargetPortIDs() {
        return this.cTargetPortIDs;
    }

    public void setTargetPortIDs(String[] stringArray) {
        this.cTargetPortIDs = stringArray;
    }

    public ArrayList getInitiatorCOPs() {
        return this.cInitiatorCOPs;
    }

    public void setInitiatorCOPs(ArrayList arrayList) {
        this.cInitiatorCOPs = arrayList;
    }

    String prepareToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.prepareToString());
        stringBuffer.append("Initiator Port WWPNs: {");
        stringBuffer.append(OutputHelper.listToCS((List)this.cInitiatorPortWWPNs));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public ArrayList getMappingsToModify() {
        return this.cMappingsToModify;
    }

    public void addMappingsToModify(VolumeAssignmentModifyParams volumeAssignmentModifyParams) {
        this.cMappingsToModify.add(volumeAssignmentModifyParams);
    }
}

