/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.util.List;
import java.util.Stack;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.html.DetailRowState;
import org.eclipse.birt.report.engine.emitter.html.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.html.IDGenerator;
import org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil;
import org.eclipse.birt.report.engine.internal.util.HTMLUtil;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class MetadataEmitter {
    private Stack detailRowStateStack = new Stack();
    private Stack tagStack = new Stack();
    private HTMLWriter writer;
    private boolean displayFilterIcon;
    private boolean displayGroupIcon;
    private boolean wrapTemplateTable;
    private IDGenerator idGenerator;
    private List ouputInstanceIDs;
    private InstanceID wrapperTableIID = null;

    public MetadataEmitter(HTMLWriter writer, HTMLRenderOption htmlOption, IDGenerator idGenerator) {
        this.writer = writer;
        this.displayFilterIcon = htmlOption.getDisplayFilterIcon();
        this.displayGroupIcon = htmlOption.getDisplayGroupIcon();
        this.wrapTemplateTable = htmlOption.getWrapTemplateTable();
        this.ouputInstanceIDs = htmlOption.getInstanceIDs();
        this.idGenerator = idGenerator;
    }

    public void startTable(ITableContent table) {
        Object generateBy = table.getGenerateBy();
        DetailRowState state = null;
        state = generateBy instanceof TableItemDesign ? new DetailRowState(false, false, true) : new DetailRowState(false, false, false);
        this.detailRowStateStack.push(state);
    }

    public void endTable(ITableContent table) {
        this.detailRowStateStack.pop();
    }

    public void startRow(IRowContent row) {
        if (this.isRowInDetailBand(row)) {
            DetailRowState state = (DetailRowState)this.detailRowStateStack.peek();
            if (!state.hasOutput && !state.isStartOfDetail && state.isTable) {
                state.isStartOfDetail = true;
                state.hasOutput = true;
            }
        }
    }

    public void endRow(IRowContent row) {
        DetailRowState state = (DetailRowState)this.detailRowStateStack.peek();
        if (state.isStartOfDetail) {
            state.isStartOfDetail = false;
        }
    }

    public void startCell(ICellContent cell) {
        if (this.needColumnFilter(cell) || this.needGroupIcon(cell)) {
            this.writer.openTag("table");
            this.writer.attribute("height", "100%");
            this.writer.attribute("width", "100%");
            this.writer.openTag("tr");
            this.writer.openTag("td");
            this.writer.attribute("align", cell.getComputedStyle().getTextAlign());
        }
        if (this.needGroupIcon(cell)) {
            this.writer.attribute("style", "vertical-align:top;text-align:right");
            this.writer.attribute("align", cell.getComputedStyle().getTextAlign());
            this.writer.attribute("width", "16px");
            this.writer.openTag("img");
            this.writer.attribute("src", "iv/images/collapsexpand.gif");
            this.writer.attribute("style", "cursor:pointer");
            String bookmark = this.idGenerator.generateUniqueID();
            HTMLEmitterUtil.setBookmark(this.writer, null, bookmark);
            this.setActiveIDTypeIID(bookmark, "GROUP", null, -1);
            this.writer.closeTag("img");
            this.writer.closeTag("td");
            this.writer.openTag("td");
            this.writer.attribute("align", cell.getComputedStyle().getTextAlign());
        }
    }

    public void endCell(ICellContent cell) {
        if (this.needColumnFilter(cell)) {
            this.writer.closeTag("td");
            this.writer.openTag("td");
            this.writer.attribute("style", "vertical-align:top");
            this.writer.openTag("img");
            this.writer.attribute("src", "iv/images/columnicon.gif");
            this.writer.attribute("alt", HTMLUtil.getColumnFilterText((ICellContent)cell));
            this.writer.attribute("style", "cursor:pointer");
            this.writer.attribute("column", cell.getColumnInstance().getInstanceID().toString());
            String bookmark = this.idGenerator.generateUniqueID();
            HTMLEmitterUtil.setBookmark(this.writer, null, bookmark);
            this.setActiveIDTypeIID(bookmark, "COLOUMNINFO", null, -1);
            this.writer.closeTag("img");
        }
        if (this.needColumnFilter(cell) || this.needGroupIcon(cell)) {
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
            this.writer.closeTag("table");
        }
    }

    public boolean startText(ITextContent text, String tag) {
        if (this.needMetadata(text)) {
            String styleName = this.getStyleClass((IContent)text);
            this.startContent((IContent)text, tag, styleName);
            return true;
        }
        return false;
    }

    public void endText(ITextContent text) {
        if (this.needMetadata(text)) {
            this.endContent((IContent)text);
        }
    }

    public boolean startForeign(IForeignContent foreign, String tag) {
        if (this.needMetadata(foreign)) {
            String styleName = this.getStyleClass((IContent)foreign);
            this.startContent((IContent)foreign, tag, styleName);
            return true;
        }
        return false;
    }

    public void endForeign(IForeignContent foreign) {
        if (this.needMetadata(foreign)) {
            this.endContent((IContent)foreign);
        }
    }

    public boolean startImage(IImageContent image) {
        if (image.getGenerateBy() instanceof ExtendedItemDesign) {
            this.startSelectHandle(HTMLEmitterUtil.getElementType((IContent)image), 1, "birt-chart-design");
            String bookmark = image.getBookmark();
            if (bookmark == null) {
                bookmark = this.idGenerator.generateUniqueID();
                image.setBookmark(bookmark);
            }
            this.setActiveIDTypeIID((IContent)image);
            HTMLEmitterUtil.setBookmark(this.writer, "img", bookmark);
            return true;
        }
        return false;
    }

    public void endImage(IImageContent image) {
        if (image.getGenerateBy() instanceof ExtendedItemDesign) {
            this.endSelectHandle(HTMLEmitterUtil.getElementType((IContent)image), 1);
        }
    }

    private void setActiveIDTypeIID(String bookmark, String type, InstanceID iid, int elementId) {
        HTMLEmitterUtil.setActiveIDTypeIID(this.writer, this.ouputInstanceIDs, bookmark, type, iid, elementId);
    }

    private void setActiveIDTypeIID(IContent content) {
        HTMLEmitterUtil.setActiveIDTypeIID(this.writer, this.ouputInstanceIDs, content);
    }

    private void startSelectHandle(int display, int blockType, String cssClass) {
        this.writer.openTag(HTMLEmitterUtil.getTagByType(display, blockType));
        this.writer.attribute("class", cssClass);
    }

    private void endSelectHandle(int display, int blockType) {
        this.writer.closeTag(HTMLEmitterUtil.getTagByType(display, blockType));
    }

    private void startContent(IContent content, String tag, String styleName) {
        this.tagStack.push(tag);
        this.writer.openTag(tag);
        if (content.getBookmark() == null) {
            content.setBookmark(this.idGenerator.generateUniqueID());
        }
        this.writer.attribute("class", styleName);
        this.setActiveIDTypeIID(content);
        HTMLEmitterUtil.setBookmark(this.writer, tag, content.getBookmark());
    }

    private void endContent(IContent content) {
        this.writer.closeTag((String)this.tagStack.pop());
    }

    private boolean needMetadata(ITextContent text) {
        Object generateBy = text.getGenerateBy();
        if (generateBy instanceof LabelItemDesign) {
            return true;
        }
        if (generateBy instanceof DataItemDesign) {
            return this.isAggregatable(text);
        }
        return false;
    }

    private boolean needMetadata(IForeignContent foreign) {
        return foreign.getGenerateBy() instanceof TemplateDesign;
    }

    private boolean isRowInDetailBand(IRowContent row) {
        IElement parent = row.getParent();
        if (!(parent instanceof IBandContent)) {
            return false;
        }
        IBandContent band = (IBandContent)parent;
        return band.getBandType() == 0;
    }

    private boolean isAggregatable(ITextContent text) {
        Object generateBy = text.getGenerateBy();
        DataItemDesign data = (DataItemDesign)generateBy;
        if (data.getQuery() != null) {
            return false;
        }
        for (IElement parent = text.getParent(); parent != null; parent = parent.getParent()) {
            IBandContent bandContent;
            BandDesign bandDesing;
            IContent content;
            ReportItemDesign design;
            if (parent instanceof IContent && (design = (ReportItemDesign)(content = (IContent)parent).getGenerateBy()).getQuery() != null) {
                return false;
            }
            if (!(parent instanceof IBandContent) || (bandDesing = (BandDesign)(bandContent = (IBandContent)parent).getGenerateBy()).getBandType() != 1 && bandDesing.getBandType() != 2 && bandDesing.getBandType() != 3 && bandDesing.getBandType() != 4) continue;
            IElement bandParent = bandContent.getParent();
            while (bandParent instanceof IGroupContent) {
                bandParent = bandParent.getParent();
            }
            if (!(bandParent instanceof ITableContent)) continue;
            return true;
        }
        return false;
    }

    private String getStyleClass(IContent content) {
        Object generateBy = content.getGenerateBy();
        String styleName = null;
        styleName = generateBy instanceof LabelItemDesign ? "birt-label-design" : (generateBy instanceof DataItemDesign ? "birt-data-design" : "birt-label-design");
        return styleName;
    }

    private boolean needColumnFilter(ICellContent cell) {
        DetailRowState state = (DetailRowState)this.detailRowStateStack.peek();
        IColumn columnInstance = cell.getColumnInstance();
        if (columnInstance == null) {
            return false;
        }
        return state.isStartOfDetail && columnInstance.hasDataItemsInDetail() && this.displayFilterIcon && HTMLUtil.getFilterConditions((ICellContent)cell).size() > 0;
    }

    private boolean needGroupIcon(ICellContent cell) {
        return cell.getDisplayGroupIcon() && this.displayGroupIcon;
    }

    private boolean isTopLevelTemplateTable(ITableContent table) {
        TableItemDesign tableDesign;
        DesignElementHandle handle;
        Object genBy = table.getGenerateBy();
        if (genBy instanceof TableItemDesign && null != (handle = (tableDesign = (TableItemDesign)genBy).getHandle()) && handle.isTemplateParameterValue()) {
            for (DesignElementHandle parentHandle = handle.getContainer(); null != parentHandle; parentHandle = parentHandle.getContainer()) {
                if (!(parentHandle instanceof TableHandle) || !parentHandle.isTemplateParameterValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void startWrapTable(ITableContent table) {
        if (this.wrapTemplateTable && this.isTopLevelTemplateTable(table)) {
            this.wrapperTableIID = table.getInstanceID();
            this.writer.openTag("table");
            this.writer.attribute("style", " border: medium none ; border-collapse: collapse;");
            this.writer.openTag("tbody");
            this.writer.openTag("tr");
            this.writer.attribute("style", " vertical-align: top;");
            this.writer.openTag("td");
            this.writer.openTag("img");
            this.writer.attribute("src", "bizRD/images/report/sidetab_active.gif");
            this.writer.attribute("style", " width: 20px; height: 60px;");
            this.writer.closeTag("img");
            this.writer.closeTag("td");
            this.writer.openTag("td");
            this.writer.attribute("style", " border: 2px solid black;");
        }
    }

    public void endWrapTable(ITableContent table) {
        if (this.wrapTemplateTable && table.getInstanceID() == this.wrapperTableIID) {
            this.wrapperTableIID = null;
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
            this.writer.closeTag("tbody");
            this.writer.closeTag("table");
        }
    }
}

