/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.DeviceSnapshotHandler;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotProcessor
implements Runnable {
    ILogger msgLogger = LogConstants.msgLogger;
    ILogger traceLogger = LogConstants.traceLogger;
    static final String className;
    private Vector deviceGroup = new Vector();
    private EventCorrelatorFactory eventMonitor = null;
    private Thread workerThread = null;
    private static SnapshotProcessor mySnapshot;
    private DeviceSnapshotHandler snapshotHndlr = null;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.SnapshotProcessor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        mySnapshot = null;
    }

    private SnapshotProcessor() {
    }

    public static SnapshotProcessor shareInstance() {
        if (mySnapshot == null) {
            mySnapshot = new SnapshotProcessor();
        }
        return mySnapshot;
    }

    public void start(EventCorrelatorFactory eventCorrelatorFactory) {
        String string = "start";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)eventCorrelatorFactory);
        }
        if (this.snapshotHndlr == null) {
            this.snapshotHndlr = new DeviceSnapshotHandler(eventCorrelatorFactory);
        }
        if (this.workerThread == null) {
            this.workerThread = new Thread(this);
            this.workerThread.start();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String string = "stop";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.workerThread = null;
        SnapshotProcessor snapshotProcessor = this;
        synchronized (snapshotProcessor) {
            this.notifyAll();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string;
        block15: {
            string = "run";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            }
            try {
                Thread thread = Thread.currentThread();
                while (this.workerThread == thread) {
                    String string2;
                    try {
                        Object object;
                        while (this.deviceGroup.isEmpty()) {
                            object = this;
                            synchronized (object) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                                if (this.workerThread == null) {
                                    if (this.traceLogger.isLogging()) {
                                        string2 = "SnapshotService was shutdown";
                                        this.traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string, string2);
                                        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                                    }
                                    return;
                                }
                            }
                        }
                        object = (Vector)this.deviceGroup.firstElement();
                        this.process((Vector)object);
                        this.deviceGroup.removeElement(object);
                    }
                    catch (Exception exception) {
                        string2 = "Failed to do Snapshot.";
                        if (!this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string, string2);
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                String string3 = "Failed to start EventPublishThread";
                if (!this.traceLogger.isLogging()) break block15;
                this.traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string, string3);
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void process(Vector vector) {
        String string = "process";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)vector);
        }
        try {
            this.snapshotHndlr.doSnapshot(vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDevicesToProcess(Vector vector) {
        String string = "addDeviceToProcess";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)vector);
        }
        this.deviceGroup.add(vector);
        SnapshotProcessor snapshotProcessor = this;
        synchronized (snapshotProcessor) {
            this.notifyAll();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public static void main(String[] stringArray) {
    }
}

