/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.Null;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.LogWrapper;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class AgentTableReader {
    static final String className;
    protected String _hostTable;
    protected DBConnection _dbc = null;
    PreparedStatement _queryHost1 = null;
    PreparedStatement _queryHost2 = null;
    PreparedStatement _listActiveHosts = null;
    PreparedStatement _listHosts = null;
    PreparedStatement _listAgentsInDomain = null;
    PreparedStatement _queryDomainID = null;
    protected LogWrapper _messages = SANDiskMgrHostService.messages;
    protected LogWrapper _trace = SANDiskMgrHostService.trace;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    AgentTableReader(DBConnection dBConnection, String string) throws InterruptedException, SQLException {
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "HostTableReader", (Object)string);
        }
        this._hostTable = string;
        this._dbc = dBConnection;
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "HostTableReader");
        }
    }

    void close() {
        block5: {
            if (this._trace.isLogging()) {
                this._trace.entry((Object)this, "close");
            }
            if (this._dbc != null) {
                try {
                    this._dbc.close();
                    this._dbc = null;
                }
                catch (SQLException sQLException) {
                    if (!this._trace.isLogging()) break block5;
                    this._trace.exception((Object)this, "close", (Throwable)sQLException);
                }
            }
        }
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "close");
        }
    }

    static String osName(short s) {
        String[] stringArray = new String[]{"Unknown", "Linux", "AIX", "HP-UX", "Windows NT", "Windows", "Solaris", "HP-UX 10.x"};
        return stringArray[s];
    }

    static short osType(String string) {
        int n = 0;
        String string2 = string.toLowerCase();
        if (string2.startsWith("linux")) {
            n = 1;
        } else if (string2.startsWith("aix")) {
            n = 2;
        } else if (string2.startsWith("hp")) {
            n = 3;
        } else if (string2.startsWith("window")) {
            n = string2.indexOf("nt") > 0 ? 4 : 5;
        } else if (string2.startsWith("solaris") || string2.startsWith("sun")) {
            n = 6;
        }
        return (short)n;
    }

    Host getResHost(int n) {
        Host host;
        block4: {
            if (this._trace.isLogging()) {
                this._trace.entry((Object)this, "getResHost", (Object)("" + n));
            }
            host = null;
            try {
                host = new Host();
                host.setComputerId(n);
                host.retrieve(this._dbc);
            }
            catch (SQLException sQLException) {
                if (!this._trace.isLogging()) break block4;
                this._trace.exception((Object)this, "getResHost", (Throwable)sQLException);
            }
        }
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "getResHost");
        }
        return host;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Host getResHost(GUID gUID) {
        Host host;
        block11: {
            if (this._trace.isLogging()) {
                this._trace.entry((Object)this, "getResHost", (Object)gUID);
            }
            host = null;
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(Host.getColumnInfo((String)"GUID"), gUID.toNoDotString());
            Host.HostCursor hostCursor = null;
            try {
                try {
                    hostCursor = Host.getCursor((DBConnection)this._dbc, hashtable, null);
                    if (hostCursor.next()) {
                        host = hostCursor.getAttributes();
                    }
                }
                catch (SQLException sQLException) {
                    if (this._trace.isLogging()) {
                        this._trace.exception((Object)this, "getResHost", (Throwable)sQLException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (hostCursor == null) throw throwable;
                try {
                    hostCursor.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (hostCursor == null) break block11;
            }
            try {}
            catch (SQLException sQLException) {}
            hostCursor.close();
        }
        if (!this._trace.isLogging()) return host;
        this._trace.exit((Object)this, "getResHost");
        return host;
    }

    DeviceAgent.DeviceAgentCursor queryHost(GUID gUID, int n) throws SQLException {
        String string = gUID + ":" + n;
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "queryHost", (Object)string);
        }
        Host host = this.getResHost(gUID);
        Hashtable<ColumnInfo, Object> hashtable = new Hashtable<ColumnInfo, Object>();
        if (host == null) {
            hashtable.put(DeviceAgent.getColumnInfo((String)"HOST_ID"), new Null());
        } else {
            hashtable.put(DeviceAgent.getColumnInfo((String)"HOST_ID"), "" + host.getComputerId());
        }
        hashtable.put(DeviceAgent.getColumnInfo((String)"PORT"), "" + n);
        DeviceAgent.DeviceAgentCursor deviceAgentCursor = DeviceAgent.getCursor((DBConnection)this._dbc, hashtable, null);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "queryHost");
        }
        return deviceAgentCursor;
    }

    DeviceAgent.DeviceAgentCursor listActiveHosts() throws SQLException {
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "listActiveHost");
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(DeviceAgent.getColumnInfo((String)"STATUS"), "AC");
        DeviceAgent.DeviceAgentCursor deviceAgentCursor = DeviceAgent.getCursor((DBConnection)this._dbc, hashtable, null);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "listActiveHost");
        }
        return deviceAgentCursor;
    }

    DeviceAgent.DeviceAgentCursor listHosts() throws SQLException {
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "listHost");
        }
        DeviceAgent.DeviceAgentCursor deviceAgentCursor = DeviceAgent.getCursor((DBConnection)this._dbc, null, null);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "listHost");
        }
        return deviceAgentCursor;
    }

    DeviceAgent.DeviceAgentCursor listAgentsInDomain(int n) throws SQLException {
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "listAgentsInDomain");
        }
        Hashtable<ColumnInfo, Object> hashtable = new Hashtable<ColumnInfo, Object>();
        if (n == 0) {
            hashtable.put(DeviceAgent.getColumnInfo((String)"POLICY_DOMAIN_ID"), new Null());
        } else {
            hashtable.put(DeviceAgent.getColumnInfo((String)"POLICY_DOMAIN_ID"), "" + n);
        }
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "listAgentsInDomain", hashtable + " " + n);
        }
        DeviceAgent.DeviceAgentCursor deviceAgentCursor = DeviceAgent.getCursor((DBConnection)this._dbc, hashtable, null);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "listAgentsInDomain");
        }
        return deviceAgentCursor;
    }

    int getPolicyDomainIDFromAgent(GUID gUID, int n) throws SQLException {
        DeviceAgent deviceAgent;
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "getPolicyDomainIDFromAgent");
        }
        int n2 = -1;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        Host host = this.getResHost(gUID);
        hashtable.put(DeviceAgent.getColumnInfo((String)"HOST_ID"), "" + host.getComputerId());
        hashtable.put(DeviceAgent.getColumnInfo((String)"PORT"), "" + n);
        Vector<String> vector = new Vector<String>();
        vector.add("POLICY_DOMAIN_ID");
        DeviceAgent.DeviceAgentCursor deviceAgentCursor = DeviceAgent.getCursor((DBConnection)this._dbc, hashtable, vector);
        if (deviceAgentCursor.next() && (deviceAgent = deviceAgentCursor.getAttributes()) != null) {
            if (this._trace.isLogging()) {
                this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "getPolicyDomainIDFromAgent", deviceAgent.toString());
            }
            n2 = deviceAgent.getPolicyDomainId();
        }
        deviceAgentCursor.close();
        deviceAgentCursor = null;
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "getPolicyDomainIDFromAgent", n2);
        }
        return n2;
    }
}

