/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.ITdmAgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.DatabaseConnectException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.SqlException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.UnknownAgentException;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class TdmAgentBuilder
extends AgentBuilder
implements ITdmAgentBuilder {
    static final String className;
    private String _osname;
    private String _status;
    private int _index;
    private String _version;
    private Date _statusLastChanged;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.TdmAgentBuilder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TdmAgentBuilder(GUID gUID, int n, AgentTableReader agentTableReader) throws SQLException, UnknownAgentException {
        block15: {
            super(gUID, n, agentTableReader);
            String string = gUID + ":" + n;
            Statement statement = null;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)this, "TdmHostBuilder", (Object)string);
            }
            try {
                Object object;
                DeviceAgent.DeviceAgentCursor deviceAgentCursor = agentTableReader.queryHost(gUID, n);
                if (!deviceAgentCursor.next()) {
                    SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)this, "TdmHostBuilder", "Agent_notExistDB", (Object)string);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        String string2 = String.valueOf(string) + " is not a known Agent";
                        SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "TdmHostBuilder", string2);
                    }
                    throw new UnknownAgentException();
                }
                try {
                    try {
                        object = deviceAgentCursor.getAttributes();
                        Host host = agentTableReader.getResHost(object.getHostId());
                        this._index = object.getDeviceAgentId();
                        this._osname = AgentTableReader.osName(host.getOsType());
                        this._status = object.getStatus().trim();
                        this._statusLastChanged = object.getStatusLastChanged();
                        this._version = object.getVersion();
                    }
                    catch (SQLException sQLException) {
                        SANDiskMgrHostService.messages.exception((Object)className, "TdmHostBuilder", (Throwable)sQLException);
                        if (SANDiskMgrHostService.trace.isLogging()) {
                            SANDiskMgrHostService.trace.exception((Object)className, "TdmHostBuilder", (Throwable)sQLException);
                        }
                        throw sQLException;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    deviceAgentCursor.close();
                    deviceAgentCursor = null;
                    throw throwable;
                }
                {
                    Object var9_13 = null;
                }
                deviceAgentCursor.close();
                deviceAgentCursor = null;
                if (SANDiskMgrHostService.trace.isLogging()) {
                    object = "results = " + this._osname + " " + this._status + " " + this._index + " " + string + " " + this._version;
                    SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "TdmHostBuilder", (String)object);
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            {
                Object var11_16 = null;
                if (statement == null) break block15;
            }
            statement.close();
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)this, "TdmHostBuilder");
        }
    }

    public TdmAgentBuilder(DeviceAgent.DeviceAgentCursor deviceAgentCursor, AgentTableReader agentTableReader) throws SQLException, UnknownAgentException, TdmException {
        super(deviceAgentCursor, agentTableReader);
        try {
            DeviceAgent deviceAgent = deviceAgentCursor.getAttributes();
            Host host = agentTableReader.getResHost(deviceAgent.getHostId());
            this._index = deviceAgent.getDeviceAgentId();
            this._osname = AgentTableReader.osName(host.getOsType());
            this._status = deviceAgent.getStatus().trim();
            this._statusLastChanged = deviceAgent.getStatusLastChanged();
            this._version = deviceAgent.getVersion();
        }
        catch (SQLException sQLException) {
            SANDiskMgrHostService.messages.exception((Object)className, "TdmHostBuilder(java.sql.ResultSet)", (Throwable)sQLException);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "TdmHostBuilder(java.sql.ResultSet)", (Throwable)sQLException);
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TdmAgent getTdmHost(GUID gUID, int n) throws TdmException {
        TdmAgentBuilder tdmAgentBuilder;
        block11: {
            String string = gUID + ":" + n;
            tdmAgentBuilder = null;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "getTdmHost", (Object)string);
            }
            AgentTableReader agentTableReader = null;
            try {
                try {
                    agentTableReader = SANDiskMgrHostService.getHostTableReader();
                    tdmAgentBuilder = new TdmAgentBuilder(gUID, n, agentTableReader);
                }
                catch (SQLException sQLException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "getTdmHost", (Throwable)sQLException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "getTdmHost", (Throwable)sQLException);
                    }
                    throw new SqlException(sQLException);
                }
                catch (InterruptedException interruptedException) {
                    SANDiskMgrHostService.messages.exception((Object)className, "getTdmHost", (Throwable)interruptedException);
                    if (SANDiskMgrHostService.trace.isLogging()) {
                        SANDiskMgrHostService.trace.exception((Object)className, "getTdmHost", (Throwable)interruptedException);
                    }
                    throw new DatabaseConnectException(interruptedException);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (agentTableReader != null) {
                    agentTableReader.close();
                }
                throw throwable;
            }
            {
                Object var6_9 = null;
                if (agentTableReader == null) break block11;
                agentTableReader.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getTdmHost");
        }
        return new TdmAgent((ITdmAgentBuilder)tdmAgentBuilder);
    }

    public static TdmAgent getTdmHost(DeviceAgent.DeviceAgentCursor deviceAgentCursor, AgentTableReader agentTableReader) throws TdmException {
        TdmAgentBuilder tdmAgentBuilder = null;
        try {
            tdmAgentBuilder = new TdmAgentBuilder(deviceAgentCursor, agentTableReader);
        }
        catch (SQLException sQLException) {
            SANDiskMgrHostService.messages.exception((Object)className, "getTdmHost(java.sql.ResultSet)", (Throwable)sQLException);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getTdmHost(java.sql.ResultSet)", (Throwable)sQLException);
            }
            throw new SqlException(sQLException);
        }
        return new TdmAgent((ITdmAgentBuilder)tdmAgentBuilder);
    }

    public String getOSName() {
        return this._osname;
    }

    public String getStatus() {
        return this._status;
    }

    public Date getStatusLastChanged() {
        return this._statusLastChanged;
    }

    public int getIndex() {
        return this._index;
    }

    public String getVersion() {
        return this._version;
    }
}

