/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.util.Calendar;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.UserDataSetHints;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.StackGroup;
import org.eclipse.birt.chart.computation.withaxes.StackedSeriesLookup;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public final class PlotWith2DAxes
extends PlotWithAxes {
    private StackedSeriesLookup ssl = null;

    public PlotWith2DAxes(IDisplayServer _ids, ChartWithAxes _cwa, RunTimeContext _rtc) throws IllegalArgumentException, ChartException {
        this.cwa = _cwa;
        this.ids = _ids;
        this.rtc = _rtc;
        this.ssl = new StackedSeriesLookup(_rtc);
        this.dPointToPixel = (double)this.ids.getDpiResolution() / 72.0;
        this.buildAxes();
    }

    final void buildAxes() throws IllegalArgumentException, ChartException {
        Axis[] axa = this.cwa.getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        if (!axPrimaryBase.isSetOrientation()) {
            axPrimaryBase.setOrientation(Orientation.HORIZONTAL_LITERAL);
        }
        this.validateAxis(axPrimaryBase);
        Axis axPrimaryOrthogonal = this.cwa.getPrimaryOrthogonalAxis(axPrimaryBase);
        if (!axPrimaryOrthogonal.isSetOrientation()) {
            axPrimaryOrthogonal.setOrientation(Orientation.VERTICAL_LITERAL);
        }
        this.validateAxis(axPrimaryOrthogonal);
        Axis[] axaOverlayOrthogonal = this.cwa.getOrthogonalAxes(axPrimaryBase, false);
        this.aax = new AllAxes(this.cwa.getPlot().getClientArea().getInsets().scaledInstance(this.dPointToPixel));
        this.insCA = this.aax.getInsets();
        boolean isTransposed = this.cwa.isTransposed();
        this.aax.swapAxes(isTransposed);
        OneAxis oaxPrimaryBase = new OneAxis(axPrimaryBase);
        oaxPrimaryBase.set(this.getOrientation(1), this.transposeLabelPosition(1, PlotWith2DAxes.getLabelPosition(axPrimaryBase.getLabelPosition())), this.transposeLabelPosition(1, PlotWith2DAxes.getLabelPosition(axPrimaryBase.getTitlePosition())), axPrimaryBase.isSetCategoryAxis() && axPrimaryBase.isCategoryAxis());
        oaxPrimaryBase.setGridProperties(axPrimaryBase.getMajorGrid().getLineAttributes(), axPrimaryBase.getMinorGrid().getLineAttributes(), axPrimaryBase.getMajorGrid().getTickAttributes(), axPrimaryBase.getMinorGrid().getTickAttributes(), this.transposeTickStyle(1, PlotWith2DAxes.getTickStyle(axPrimaryBase, 0)), this.transposeTickStyle(1, PlotWith2DAxes.getTickStyle(axPrimaryBase, 1)), axPrimaryBase.getScale().getMinorGridsPerUnit());
        oaxPrimaryBase.set(axPrimaryBase.getLabel(), axPrimaryBase.getTitle());
        oaxPrimaryBase.set(PlotWith2DAxes.getIntersection(axPrimaryBase));
        oaxPrimaryBase.set(axPrimaryBase.getLineAttributes());
        this.aax.definePrimary(oaxPrimaryBase);
        OneAxis oaxPrimaryOrthogonal = new OneAxis(axPrimaryOrthogonal);
        oaxPrimaryOrthogonal.set(this.getOrientation(2), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? this.switchPosition(axPrimaryOrthogonal.getLabelPosition()) : axPrimaryOrthogonal.getLabelPosition())), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? this.switchPosition(axPrimaryOrthogonal.getTitlePosition()) : axPrimaryOrthogonal.getTitlePosition())), axPrimaryOrthogonal.isSetCategoryAxis() && axPrimaryOrthogonal.isCategoryAxis());
        oaxPrimaryOrthogonal.setGridProperties(axPrimaryOrthogonal.getMajorGrid().getLineAttributes(), axPrimaryOrthogonal.getMinorGrid().getLineAttributes(), axPrimaryOrthogonal.getMajorGrid().getTickAttributes(), axPrimaryOrthogonal.getMinorGrid().getTickAttributes(), this.transposeTickStyle(2, !isTransposed ? this.switchTickStyle(PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 0)) : PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 0)), this.transposeTickStyle(2, !isTransposed ? this.switchTickStyle(PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 1)) : PlotWith2DAxes.getTickStyle(axPrimaryOrthogonal, 1)), axPrimaryOrthogonal.getScale().getMinorGridsPerUnit());
        oaxPrimaryOrthogonal.set(axPrimaryOrthogonal.getLabel(), axPrimaryOrthogonal.getTitle());
        oaxPrimaryOrthogonal.set(this.switchIntersection(PlotWith2DAxes.getIntersection(axPrimaryOrthogonal)));
        oaxPrimaryOrthogonal.set(axPrimaryOrthogonal.getLineAttributes());
        this.aax.definePrimary(oaxPrimaryOrthogonal);
        this.aax.initOverlays(axaOverlayOrthogonal.length, this.getOrientation(2));
        for (int i = 0; i < axaOverlayOrthogonal.length; ++i) {
            if (!axaOverlayOrthogonal[i].isSetOrientation()) {
                axaOverlayOrthogonal[i].setOrientation(Orientation.VERTICAL_LITERAL);
            }
            this.validateAxis(axaOverlayOrthogonal[i]);
            OneAxis oaxOverlayOrthogonal = new OneAxis(axaOverlayOrthogonal[i]);
            oaxOverlayOrthogonal.set(this.getOrientation(2), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? this.switchPosition(axaOverlayOrthogonal[i].getLabelPosition()) : axaOverlayOrthogonal[i].getLabelPosition())), this.transposeLabelPosition(2, PlotWith2DAxes.getLabelPosition(!isTransposed ? this.switchPosition(axaOverlayOrthogonal[i].getTitlePosition()) : axaOverlayOrthogonal[i].getTitlePosition())), axaOverlayOrthogonal[i].isSetCategoryAxis() && axaOverlayOrthogonal[i].isCategoryAxis());
            oaxOverlayOrthogonal.setGridProperties(axaOverlayOrthogonal[i].getMajorGrid().getLineAttributes(), axaOverlayOrthogonal[i].getMinorGrid().getLineAttributes(), axaOverlayOrthogonal[i].getMajorGrid().getTickAttributes(), axaOverlayOrthogonal[i].getMinorGrid().getTickAttributes(), this.transposeTickStyle(2, !isTransposed ? this.switchTickStyle(PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 0)) : PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 0)), this.transposeTickStyle(2, !isTransposed ? this.switchTickStyle(PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 1)) : PlotWith2DAxes.getTickStyle(axaOverlayOrthogonal[i], 1)), axaOverlayOrthogonal[i].getScale().getMinorGridsPerUnit());
            oaxOverlayOrthogonal.set(axaOverlayOrthogonal[i].getLabel(), axaOverlayOrthogonal[i].getTitle());
            oaxOverlayOrthogonal.set(axaOverlayOrthogonal[i].getLineAttributes());
            oaxOverlayOrthogonal.set(this.switchIntersection(PlotWith2DAxes.getIntersection(axaOverlayOrthogonal[i])));
            this.aax.defineOverlay(i, oaxOverlayOrthogonal);
        }
        this.ssl = StackedSeriesLookup.create(this.cwa, this.rtc);
    }

    private final Object getMinMax(Axis ax, int iType) throws ChartException, IllegalArgumentException {
        DataSet ds;
        Series[] sea = ax.getRuntimeSeries();
        int iSeriesCount = sea.length;
        Object oMin = null;
        Object oMax = null;
        PluginSettings ps = PluginSettings.instance();
        IDataSetProcessor iDSP = null;
        boolean bAnyStacked = false;
        for (int i = 0; i < iSeriesCount; ++i) {
            CDateTime cdtMax;
            if (sea[i].isStacked()) {
                if (sea[i].canBeStacked()) {
                    bAnyStacked = true;
                    continue;
                }
                throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.unstackable.is.stacked"), sea[i]));
            }
            iDSP = ps.getDataSetProcessor(sea[i].getClass());
            ds = sea[i].getDataSet();
            Object oV1 = iDSP.getMinimum(ds);
            Object oV2 = iDSP.getMaximum(ds);
            if ((iType & 1) == 1) {
                if (oV1 != null) {
                    if (oMin == null) {
                        oMin = oV1;
                    } else {
                        double dV1 = PlotWith2DAxes.asDouble(oV1);
                        if (Math.min(PlotWith2DAxes.asDouble(oMin), dV1) == dV1) {
                            oMin = oV1;
                        }
                    }
                }
                if (oV2 == null) continue;
                if (oMax == null) {
                    oMax = oV2;
                    continue;
                }
                double dV2 = PlotWith2DAxes.asDouble(oV2);
                if (Math.max(PlotWith2DAxes.asDouble(oMax), dV2) != dV2) continue;
                oMax = oV2;
                continue;
            }
            if ((iType & 8) != 8) continue;
            if (oV1 != null) {
                if (oMin == null) {
                    oMin = oV1;
                } else {
                    CDateTime cdtMin;
                    CDateTime cdtV1 = PlotWith2DAxes.asDateTime(oV1);
                    if (cdtV1.before((Object)(cdtMin = PlotWith2DAxes.asDateTime(oMin)))) {
                        oMin = cdtV1;
                    }
                }
            }
            if (oV2 == null) continue;
            if (oMax == null) {
                oMax = oV2;
                continue;
            }
            CDateTime cdtV2 = PlotWith2DAxes.asDateTime(oV2);
            if (!cdtV2.after((Object)(cdtMax = PlotWith2DAxes.asDateTime(oMax)))) continue;
            oMax = cdtV2;
        }
        if (bAnyStacked || ax.isPercent()) {
            if (ax.getType().getValue() == 3) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.stacked.datetime.axis.series"), ax));
            }
            double dPercentMax = 0.0;
            double dPercentMin = 0.0;
            double dAxisMin = Double.MAX_VALUE;
            double dAxisMax = -1.7976931348623157E308;
            ArrayList alSeriesGroupsPerAxis = this.ssl.getStackGroups(ax);
            DataSetIterator[] dsi = new DataSetIterator[this.ssl.getSeriesCount(ax)];
            if (alSeriesGroupsPerAxis == null) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.internal.stack.series.setup", new Object[]{ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            logger.log(1, Messages.getString("info.processing.stacked.info", new Object[]{ax}, this.rtc.getULocale()));
            int iDataSetCount = this.ssl.getUnitCount();
            for (int k = 0; k < iDataSetCount; ++k) {
                double dAbsTotal = 0.0;
                int iSeriesIndex = 0;
                for (int i = 0; i < alSeriesGroupsPerAxis.size(); ++i) {
                    StackGroup sg = (StackGroup)alSeriesGroupsPerAxis.get(i);
                    ArrayList alSeriesPerGroup = sg.getSeries();
                    int iSeriesPerGroup = alSeriesPerGroup.size();
                    if (iSeriesPerGroup <= 0) continue;
                    Series se = (Series)alSeriesPerGroup.get(0);
                    ds = se.getDataSet();
                    if (dsi[iSeriesIndex] == null) {
                        dsi[iSeriesIndex] = new DataSetIterator(ds);
                        if ((dsi[iSeriesIndex].getDataType() & 1) != 1) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.percent.stacked.non.numerical", Messages.getResourceBundle(this.rtc.getULocale()));
                        }
                    }
                    iDataSetCount = dsi[iSeriesIndex].size();
                    double dGroupMin = 0.0;
                    double dGroupMax = 0.0;
                    if (ax.isPercent()) {
                        dAbsTotal = 0.0;
                    }
                    for (int j = 0; j < iSeriesPerGroup; ++j) {
                        Object oValue;
                        se = (Series)alSeriesPerGroup.get(j);
                        if (j > 0 && dsi[iSeriesIndex] == null) {
                            ds = se.getDataSet();
                            dsi[iSeriesIndex] = new DataSetIterator(ds);
                            if ((dsi[iSeriesIndex].getDataType() & 1) != 1) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.percent.stacked.non.numerical", Messages.getResourceBundle(this.rtc.getULocale()));
                            }
                        }
                        if ((oValue = dsi[iSeriesIndex].next()) != null) {
                            double dValue = (Double)oValue;
                            dAbsTotal += Math.abs(dValue);
                            if (dValue > 0.0) {
                                dGroupMax += dValue;
                            } else if (dValue < 0.0) {
                                dGroupMin += dValue;
                            }
                        }
                        ++iSeriesIndex;
                    }
                    AxisSubUnit au = this.ssl.getSubUnit(sg, k);
                    au.setPositiveTotal(dGroupMax);
                    au.setNegativeTotal(dGroupMin);
                    dAxisMax = Math.max(dGroupMax, dAxisMax);
                    dAxisMin = Math.min(dGroupMin, dAxisMin);
                    if (!ax.isPercent() || dAbsTotal == 0.0) continue;
                    dPercentMax = Math.max(dGroupMax / dAbsTotal * 100.0, dPercentMax);
                    dPercentMin = Math.min(dGroupMin / dAbsTotal * 100.0, dPercentMin);
                }
            }
            if (ax.isPercent()) {
                if (dPercentMax >= 100.0) {
                    dPercentMax = 99.9;
                }
                if (dPercentMin <= -100.0) {
                    dPercentMin = -99.9;
                }
                if (dPercentMax == 0.0 && dPercentMin == 0.0) {
                    dPercentMax = 99.0;
                }
                dAxisMin = dPercentMin;
                dAxisMax = dPercentMax;
            }
            if ((iType & 4) == 4) {
                dAxisMin = 1.0;
            }
            oMin = new Double(dAxisMin);
            oMax = new Double(dAxisMax);
        }
        if (oMin == null && oMax == null) {
            if (iType == 8) {
                oMin = new CDateTime(1, 1, 2005);
                oMax = new CDateTime(1, 1, 2006);
            } else if ((iType & 1) == 1) {
                if ((iType & 0x20) == 32) {
                    oMin = new Double(0.0);
                    oMax = new Double(99.99);
                } else if ((iType & 4) == 4) {
                    oMin = new Double(1.0);
                    oMax = new Double(999.0);
                } else {
                    oMin = new Double(-0.9);
                    oMax = new Double(0.9);
                }
            }
        }
        if (iType == 8) {
            try {
                return new Calendar[]{PlotWith2DAxes.asDateTime(oMin), PlotWith2DAxes.asDateTime(oMax)};
            }
            catch (ClassCastException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.numerical.data.datetime.axis", Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
        if ((iType & 1) == 1) {
            try {
                return new double[]{PlotWith2DAxes.asDouble(oMin), PlotWith2DAxes.asDouble(oMax)};
            }
            catch (ClassCastException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.datetime.data.numerical.axis", Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
        return null;
    }

    public final void compute(Bounds bo) throws ChartException, IllegalArgumentException {
        bo = bo.scaledInstance(this.dPointToPixel);
        this.dSeriesThickness = (double)this.ids.getDpiResolution() / 72.0 * this.cwa.getSeriesThickness();
        double dX = bo.getLeft() + this.insCA.getLeft();
        double dY = bo.getTop() + this.insCA.getTop();
        double dW = bo.getWidth() - this.insCA.getLeft() - this.insCA.getRight();
        double dH = bo.getHeight() - this.insCA.getTop() - this.insCA.getBottom();
        this.iDimension = PlotWith2DAxes.getDimension(this.cwa.getDimension());
        this.dXAxisPlotSpacing = (double)this.cwa.getPlot().getHorizontalSpacing() * this.dPointToPixel;
        this.dYAxisPlotSpacing = (double)this.cwa.getPlot().getVerticalSpacing() * this.dPointToPixel;
        if (this.iDimension == 1) {
            bo.setHeight(dH -= this.dSeriesThickness);
            bo.setTop(dY += this.dSeriesThickness);
            bo.setWidth(dW -= this.dSeriesThickness);
        }
        if (this.aax.getOverlayCount() > 0) {
            if (this.aax.areAxesSwapped()) {
                this.updateOverlayScales(this.aax, dX, dX + dW, dY, dH);
                dY = this.aax.getStart();
                dH = this.aax.getLength();
            } else {
                this.updateOverlayScales(this.aax, dY - dH, dY, dX, dW);
                dX = this.aax.getStart();
                dW = this.aax.getLength();
            }
        }
        Axis[] axa = this.cwa.getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        Axis axPrimaryOrthogonal = this.cwa.getPrimaryOrthogonalAxis(axPrimaryBase);
        Scale sc = axPrimaryBase.getScale();
        AutoScale scPrimaryBase = null;
        OneAxis oaxPrimaryBase = this.aax.getPrimaryBase();
        int iAxisType = PlotWith2DAxes.getAxisType(axPrimaryBase);
        Object oaData = null;
        if (iAxisType == 16 || oaxPrimaryBase.isCategoryScale()) {
            oaData = this.getTypedDataSet(axPrimaryBase, iAxisType, 0);
        } else if ((iAxisType & 1) == 1) {
            oaData = this.getMinMax(axPrimaryBase, iAxisType);
        } else if ((iAxisType & 8) == 8) {
            oaData = this.getMinMax(axPrimaryBase, iAxisType);
        }
        DataSetIterator dsi = oaData instanceof DataSetIterator ? oaData : new DataSetIterator(oaData, iAxisType);
        oaData = null;
        double dStart = this.aax.areAxesSwapped() ? dY + dH : dX;
        double dEnd = this.aax.areAxesSwapped() ? dY : dStart + dW;
        int iDirection = 0;
        if (this.isRightToLeft()) {
            if (!this.aax.areAxesSwapped()) {
                double dTmp = dStart;
                dStart = dEnd;
                dEnd = dTmp;
                iDirection = -1;
            } else {
                dStart = dY;
                dEnd = dY + dH;
                iDirection = 1;
            }
        }
        scPrimaryBase = AutoScale.computeScale(this.ids, oaxPrimaryBase, dsi, iAxisType, dStart, dEnd, sc.getMin(), sc.getMax(), sc.isSetStep() ? new Double(sc.getStep()) : null, axPrimaryBase.getFormatSpecifier(), this.rtc, iDirection);
        oaxPrimaryBase.set(scPrimaryBase);
        AutoScale scPrimaryOrthogonal = null;
        OneAxis oaxPrimaryOrthogonal = this.aax.getPrimaryOrthogonal();
        iAxisType = PlotWith2DAxes.getAxisType(axPrimaryOrthogonal);
        oaData = null;
        if ((iAxisType & 1) != 1 && (iAxisType & 8) != 8) {
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.orthogonal.axis.numerical.datetime", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        dsi = new DataSetIterator(this.getMinMax(axPrimaryOrthogonal, iAxisType), iAxisType);
        dStart = this.aax.areAxesSwapped() ? dX : dY + dH;
        dEnd = this.aax.areAxesSwapped() ? dX + dW : dY;
        sc = axPrimaryOrthogonal.getScale();
        scPrimaryOrthogonal = AutoScale.computeScale(this.ids, oaxPrimaryOrthogonal, dsi, iAxisType, dStart, dEnd, sc.getMin(), sc.getMax(), sc.isSetStep() ? new Double(sc.getStep()) : null, axPrimaryOrthogonal.getFormatSpecifier(), this.rtc, 0);
        oaxPrimaryOrthogonal.set(scPrimaryOrthogonal);
        double dYAxisLocation = this.adjustHorizontal(dX, dW, this.aax);
        double dXAxisLocation = this.adjustVerticalDueToHorizontal(dY, dH, this.aax);
        iAxisType = PlotWith2DAxes.getAxisType(axPrimaryOrthogonal);
        oaData = this.getTypedDataSet(axPrimaryOrthogonal, iAxisType, 0);
        scPrimaryOrthogonal.setData(dsi);
        iAxisType = PlotWith2DAxes.getAxisType(axPrimaryBase);
        if (iAxisType != 16) {
            scPrimaryBase.setData(this.getTypedDataSet(axPrimaryBase, iAxisType, 0));
        }
        scPrimaryBase.resetShifts();
        scPrimaryOrthogonal.resetShifts();
        this.updateOverlayAxes(this.aax);
        this.growBaseAxis(this.aax, bo);
        OneAxis axPH = this.aax.areAxesSwapped() ? this.aax.getPrimaryOrthogonal() : this.aax.getPrimaryBase();
        OneAxis axPV = this.aax.areAxesSwapped() ? this.aax.getPrimaryBase() : this.aax.getPrimaryOrthogonal();
        axPH.setAxisCoordinate(dXAxisLocation);
        axPV.setAxisCoordinate(dYAxisLocation);
        double[] daX = axPH.getScale().getEndPoints();
        double[] daY = axPV.getScale().getEndPoints();
        if (axPH.getScale().getDirection() == -1) {
            this.boPlotBackground.setLeft(daX[1] - this.insCA.getLeft());
            this.boPlotBackground.setWidth(daX[0] - daX[1] + this.insCA.getLeft() + this.insCA.getRight() + 1.0);
        } else {
            this.boPlotBackground.setLeft(daX[0] - this.insCA.getLeft());
            this.boPlotBackground.setWidth(daX[1] - daX[0] + this.insCA.getLeft() + this.insCA.getRight() + 1.0);
        }
        if (axPV.getScale().getDirection() == 1) {
            this.boPlotBackground.setTop(daY[0] - this.insCA.getTop());
            this.boPlotBackground.setHeight(daY[1] - daY[0] + this.insCA.getTop() + this.insCA.getBottom() + 1.0);
        } else {
            this.boPlotBackground.setTop(daY[1] - this.insCA.getTop());
            this.boPlotBackground.setHeight(daY[0] - daY[1] + this.insCA.getTop() + this.insCA.getBottom() + 1.0);
        }
        if (this.iDimension == 1) {
            this.boPlotBackground.delta(this.dSeriesThickness, -this.dSeriesThickness, 0.0, 0.0);
        }
    }

    private final void growBaseAxis(AllAxes aax, Bounds bo) throws ChartException {
        OneAxis oaxBase = aax.getPrimaryBase();
        OneAxis oaxOrthogonal = aax.getPrimaryOrthogonal();
        AutoScale scBase = oaxBase.getScale();
        if (aax.getOverlayCount() <= 0) {
            return;
        }
        if (!aax.areAxesSwapped()) {
            if (this.isRightToLeft() && oaxOrthogonal.getIntersectionValue().getType() != 2 || !this.isRightToLeft() && oaxOrthogonal.getIntersectionValue().getType() != 1) {
                if (this.isRightToLeft() && aax.anyOverlayPositionedAt(2) || !this.isRightToLeft() && aax.anyOverlayPositionedAt(1)) {
                    scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 0, oaxBase.getLabelPosition(), aax);
                    if (this.isRightToLeft()) {
                        double dEndShift;
                        double dLeftThreshold = bo.getLeft();
                        double dEnd = scBase.getEnd();
                        if (dEnd - (dEndShift = scBase.getEndShift()) > dLeftThreshold) {
                            double dStart = scBase.getStart();
                            scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 0, dStart, dEnd -= dEndShift, false, null);
                        }
                    } else {
                        double dEndShift;
                        double dRightThreshold = bo.getLeft() + bo.getWidth();
                        double dEnd = scBase.getEnd();
                        if (dEnd + (dEndShift = scBase.getEndShift()) < dRightThreshold) {
                            scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 0, scBase.getStart(), dEnd += dEndShift, false, null);
                        }
                    }
                }
            } else if ((this.isRightToLeft() && oaxOrthogonal.getIntersectionValue().getType() != 1 || !this.isRightToLeft() && oaxOrthogonal.getIntersectionValue().getType() != 2) && (this.isRightToLeft() && aax.anyOverlayPositionedAt(1) || !this.isRightToLeft() && aax.anyOverlayPositionedAt(2))) {
                scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 0, oaxBase.getLabelPosition(), aax);
                if (this.isRightToLeft()) {
                    double dStartShift;
                    double dRightThreshold = bo.getLeft() + bo.getWidth();
                    double dStart = scBase.getStart();
                    if (dStart + (dStartShift = scBase.getStartShift()) < dRightThreshold) {
                        double dEnd = scBase.getEnd();
                        scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 0, dStart += dStartShift, dEnd, false, null);
                    }
                } else {
                    double dLeftThreshold = bo.getLeft();
                    double dStart = scBase.getStart();
                    double dEndShift = scBase.getEndShift();
                    double dStartShift = scBase.getStartShift();
                    if (dStart - dStartShift > dLeftThreshold) {
                        double dEnd = scBase.getEnd() + dEndShift;
                        scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 0, dStart -= dStartShift, dEnd, false, null);
                    }
                }
            }
        } else if (oaxOrthogonal.getIntersectionValue().getType() != 1) {
            if (aax.anyOverlayPositionedAt(1)) {
                scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 1, oaxBase.getLabelPosition(), aax);
                if (this.isRightToLeft()) {
                    double dEndShift;
                    double dBottomThreshold = bo.getTop() + bo.getHeight();
                    double dEnd = scBase.getEnd();
                    if (dEnd + (dEndShift = Math.floor(scBase.getEndShift())) < dBottomThreshold) {
                        double dStart = scBase.getStart();
                        scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 1, dStart, dEnd += dEndShift, false, null);
                    }
                } else {
                    double dEndShift;
                    double dTopThreshold = bo.getTop();
                    double dEnd = scBase.getEnd();
                    if (dEnd - (dEndShift = Math.floor(scBase.getEndShift())) > dTopThreshold) {
                        double dStart = scBase.getStart();
                        scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 1, dStart, dEnd -= dEndShift, false, null);
                    }
                }
            }
        } else if (oaxOrthogonal.getIntersectionValue().getType() != 2 && aax.anyOverlayPositionedAt(2)) {
            scBase.computeAxisStartEndShifts(this.ids, oaxBase.getLabel(), 1, oaxBase.getLabelPosition(), aax);
            if (this.isRightToLeft()) {
                double dStartShift;
                double dTopThreshold = bo.getTop();
                double dStart = scBase.getStart();
                if (dStart - (dStartShift = scBase.getStartShift()) > dTopThreshold) {
                    double dEnd = scBase.getEnd();
                    scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 1, dStart -= dStartShift, dEnd, false, null);
                }
            } else {
                double dStartShift;
                double dBottomThreshold = bo.getTop() + bo.getHeight();
                double dStart = scBase.getStart();
                if (dStart + (dStartShift = scBase.getStartShift()) < dBottomThreshold) {
                    double dEnd = scBase.getEnd();
                    scBase.computeTicks(this.ids, oaxBase.getLabel(), oaxBase.getLabelPosition(), 1, dStart += dStartShift, dEnd, false, null);
                }
            }
        }
    }

    private final void updateOverlayScales(AllAxes aax, double dAxisStart, double dAxisEnd, double dBlockStart, double dBlockLength) throws ChartException, IllegalArgumentException {
        Axis[] axa = ((ChartWithAxesImpl)this.cwa).getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        Axis[] axaOrthogonal = ((ChartWithAxesImpl)this.cwa).getOrthogonalAxes(axPrimaryBase, false);
        AutoScale sc = null;
        OneAxis oaxOverlay = null;
        int iOverlayCount = aax.getOverlayCount();
        int iOrientation = aax.getOrientation();
        for (int i = 0; i < iOverlayCount; ++i) {
            double dY;
            double dDelta;
            int j = iOverlayCount - i - 1;
            oaxOverlay = aax.getOverlay(j);
            int iTickStyle = oaxOverlay.getCombinedTickStyle();
            int iTitleLocation = oaxOverlay.getTitlePosition();
            Label laAxisTitle = oaxOverlay.getTitle();
            int iAxisType = PlotWith2DAxes.getAxisType(axaOrthogonal[j]);
            Scale scModel = axaOrthogonal[j].getScale();
            sc = AutoScale.computeScale(this.ids, oaxOverlay, new DataSetIterator(this.getMinMax(axaOrthogonal[j], iAxisType), iAxisType), iAxisType, dAxisStart, dAxisEnd, scModel.getMin(), scModel.getMax(), scModel.isSetStep() ? new Double(scModel.getStep()) : null, axaOrthogonal[j].getFormatSpecifier(), this.rtc, 0);
            oaxOverlay.set(sc);
            IntersectionValue iv = oaxOverlay.getIntersectionValue();
            double dStart = sc.getStart();
            double dEnd = sc.getEnd();
            sc.computeTicks(this.ids, oaxOverlay.getLabel(), oaxOverlay.getLabelPosition(), iOrientation, dStart, dEnd, true, null);
            if (!sc.isStepFixed()) {
                Object[] oaMinMax = sc.getMinMax();
                while (!sc.checkFit(this.ids, oaxOverlay.getLabel(), oaxOverlay.getLabelPosition()) && sc.zoomOut()) {
                    sc.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    sc.computeTicks(this.ids, oaxOverlay.getLabel(), oaxOverlay.getLabelPosition(), iOrientation, dStart, dEnd, true, null);
                }
            }
            double dAxisLabelsThickness = sc.computeAxisLabelThickness(this.ids, oaxOverlay.getLabel(), iOrientation);
            double dAxisTitleThickness = 0.0;
            sc.resetShifts();
            if (iOrientation == 1) {
                double dX = 0.0;
                double dX1 = 0.0;
                double dX2 = 0.0;
                boolean bTicksLeft = (iTickStyle & 1) == 1;
                boolean bTicksRight = (iTickStyle & 2) == 2;
                double dAppliedYAxisPlotSpacing = this.dYAxisPlotSpacing;
                if (laAxisTitle.isVisible()) {
                    String sPreviousValue = laAxisTitle.getCaption().getValue();
                    laAxisTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
                    dAxisTitleThickness = PlotWith2DAxes.computeBox(this.ids, iTitleLocation, laAxisTitle, 0.0, 0.0).getWidth();
                    laAxisTitle.getCaption().setValue(sPreviousValue);
                }
                if (iv.getType() == 2) {
                    dX = dBlockStart;
                    dX1 = dX -= dAppliedYAxisPlotSpacing;
                    dX2 = dX;
                    if (bTicksLeft) {
                        dX1 -= 5.0;
                    }
                    if (oaxOverlay.getLabelPosition() == 1) {
                        dX1 -= dAxisLabelsThickness;
                        dX2 += Math.max(bTicksRight ? 5.0 : 0.0, dAppliedYAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 2) {
                        dX2 += Math.max((double)(bTicksRight ? 5 : 0) + dAxisLabelsThickness, dAppliedYAxisPlotSpacing);
                    }
                    if (iTitleLocation == 1) {
                        dX1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 2) {
                        dX2 += dAxisTitleThickness;
                    }
                    if (dX1 < dBlockStart) {
                        double dDelta2 = dBlockStart - dX1;
                        dX1 = dBlockStart;
                        dX += dDelta2;
                        dX2 += dDelta2;
                    }
                    dBlockStart += dX2 - dX1;
                } else if (iv.getType() == 1) {
                    dX = dBlockStart + dBlockLength;
                    dX1 = dX += dAppliedYAxisPlotSpacing;
                    dX2 = dX;
                    if (bTicksRight) {
                        dX2 += 5.0;
                    }
                    if (oaxOverlay.getLabelPosition() == 2) {
                        dX2 += dAxisLabelsThickness;
                        dX1 -= Math.max(bTicksLeft ? 5.0 : 0.0, dAppliedYAxisPlotSpacing);
                    } else if (oaxOverlay.getLabelPosition() == 1) {
                        dX1 -= Math.max((double)(bTicksLeft ? 5 : 0) + dAxisLabelsThickness, dAppliedYAxisPlotSpacing);
                    }
                    if (iTitleLocation == 1) {
                        dX1 -= dAxisTitleThickness;
                    } else if (iTitleLocation == 2) {
                        dX2 += dAxisTitleThickness;
                    }
                    if (dX2 > dBlockStart + dBlockLength) {
                        double dDelta3 = dX2 - (dBlockStart + dBlockLength);
                        dX2 = dBlockStart + dBlockLength;
                        dX -= dDelta3;
                        dX1 -= dDelta3;
                    }
                }
                dBlockLength -= dX2 - dX1;
                dDelta = 0.0;
                if (iv.getType() == 2) {
                    dDelta = -this.insCA.getLeft();
                } else if (iv.getType() == 1) {
                    dDelta = this.insCA.getRight();
                }
                oaxOverlay.setAxisCoordinate(dX + dDelta);
                oaxOverlay.setTitleCoordinate(iTitleLocation == 1 ? dX1 + dDelta - 1.0 : dX2 + 1.0 - dAxisTitleThickness + dDelta);
                continue;
            }
            if (iOrientation != 0) continue;
            double dY1 = dY = 0.0;
            double dY2 = dY;
            boolean bTicksAbove = (iTickStyle & 1) == 1;
            boolean bTicksBelow = (iTickStyle & 2) == 2;
            double dAppliedXAxisPlotSpacing = this.dXAxisPlotSpacing;
            if (laAxisTitle.isVisible()) {
                String sPreviousValue = laAxisTitle.getCaption().getValue();
                laAxisTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
                dAxisTitleThickness = PlotWith2DAxes.computeBox(this.ids, iTitleLocation, laAxisTitle, 0.0, 0.0).getHeight();
                laAxisTitle.getCaption().setValue(sPreviousValue);
            }
            if (this.isRightToLeft() && iv.getType() == 2 || !this.isRightToLeft() && iv.getType() == 1) {
                dY = dBlockStart;
                dY1 = dY -= dAppliedXAxisPlotSpacing;
                dY2 = dY;
                if (bTicksAbove) {
                    dY1 -= 5.0;
                }
                if (oaxOverlay.getLabelPosition() == 3) {
                    dY1 -= dAxisLabelsThickness;
                    dY2 += Math.max(bTicksBelow ? 5.0 : 0.0, dAppliedXAxisPlotSpacing);
                } else if (oaxOverlay.getLabelPosition() == 4) {
                    dY2 += Math.max((double)(bTicksBelow ? 5 : 0) + dAxisLabelsThickness, dAppliedXAxisPlotSpacing);
                }
                if (iTitleLocation == 3) {
                    dY1 -= dAxisTitleThickness;
                } else if (iTitleLocation == 4) {
                    dY2 += dAxisTitleThickness;
                }
                if (dY1 < dBlockStart) {
                    double dDelta4 = dBlockStart - dY1;
                    dY1 = dBlockStart;
                    dY += dDelta4;
                    dY2 += dDelta4;
                }
                dBlockStart += dY2 - dY1;
            } else if (this.isRightToLeft() && iv.getType() == 1 || !this.isRightToLeft() && iv.getType() == 2) {
                dY = dBlockStart + dBlockLength;
                dY1 = dY += dAppliedXAxisPlotSpacing;
                dY2 = dY;
                if (bTicksBelow) {
                    dY2 += 5.0;
                }
                if (oaxOverlay.getLabelPosition() == 4) {
                    dY2 += dAxisLabelsThickness;
                    dY1 -= Math.max(bTicksAbove ? 5.0 : 0.0, dAppliedXAxisPlotSpacing);
                } else if (oaxOverlay.getLabelPosition() == 3) {
                    dY1 -= Math.max((double)(bTicksAbove ? 5 : 0) + dAxisLabelsThickness, dAppliedXAxisPlotSpacing);
                }
                if (iTitleLocation == 3) {
                    dY1 -= dAxisTitleThickness;
                } else if (iTitleLocation == 4) {
                    dY2 += dAxisTitleThickness;
                }
                if (dY2 > dBlockStart + dBlockLength) {
                    double dDelta5 = dY2 - (dBlockStart + dBlockLength);
                    dY2 = dBlockStart + dBlockLength;
                    dY -= dDelta5;
                    dY1 -= dDelta5;
                }
            }
            dDelta = 0.0;
            if (this.isRightToLeft() && iv.getType() == 2 || !this.isRightToLeft() && iv.getType() == 1) {
                dDelta = -this.insCA.getTop();
            } else if (this.isRightToLeft() && iv.getType() == 1 || !this.isRightToLeft() && iv.getType() == 2) {
                dDelta = this.insCA.getBottom();
            }
            oaxOverlay.setAxisCoordinate(dY + dDelta);
            oaxOverlay.setTitleCoordinate(iTitleLocation == 3 ? dY1 + dDelta - 1.0 : dY2 + 1.0 - dAxisTitleThickness + dDelta);
            dBlockLength -= dY2 - dY1;
        }
        aax.setBlockCordinates(dBlockStart, dBlockLength);
    }

    private final void updateOverlayAxes(AllAxes aax) throws ChartException, IllegalArgumentException {
        int iDirection = aax.getOrientation() == 0 ? 1 : -1;
        Axis[] axa = this.cwa.getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        Axis[] axaOverlayOrthogonal = this.cwa.getOrthogonalAxes(axPrimaryBase, false);
        OneAxis axPrimary = aax.getPrimaryOrthogonal();
        AutoScale sc = axPrimary.getScale();
        int iAxisType = aax.getOverlayCount() > 0 ? aax.getOverlay(0).getScale().getType() : 0;
        for (int i = 0; i < aax.getOverlayCount(); ++i) {
            OneAxis axOverlay = aax.getOverlay(i);
            Label la = axOverlay.getLabel();
            AutoScale scOA = axOverlay.getScale();
            scOA.setEndPoints(scOA.getStart() - scOA.getStartShift() * (double)iDirection, scOA.getEnd() + scOA.getEndShift() * (double)iDirection);
            double dStart = sc.getStart();
            double dEnd = sc.getEnd();
            scOA.setEndPoints(dStart, dEnd);
            scOA.computeTicks(this.ids, la, axOverlay.getLabelPosition(), aax.getOrientation(), dStart, dEnd, false, null);
            if (!scOA.isStepFixed()) {
                Object[] oaMinMax = scOA.getMinMax();
                while (!scOA.checkFit(this.ids, la, axOverlay.getLabelPosition()) && scOA.zoomOut()) {
                    scOA.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    scOA.computeTicks(this.ids, la, axOverlay.getLabelPosition(), aax.getOrientation(), dStart, dEnd, false, null);
                }
            }
            scOA.setData(this.getTypedDataSet(axaOverlayOrthogonal[i], iAxisType, 0));
        }
    }

    public final ISeriesRenderingHints getSeriesRenderingHints(SeriesDefinition sdOrthogonal, Series seOrthogonal) throws ChartException, IllegalArgumentException {
        double dBaseZero;
        double dUnitSize;
        int iTickCount;
        if (seOrthogonal == null || seOrthogonal.getClass() == SeriesImpl.class) {
            return null;
        }
        OneAxis oaxOrthogonal = this.findOrthogonalAxis(seOrthogonal);
        if (oaxOrthogonal == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 6, "exception.axis.series.link.broken", new Object[]{seOrthogonal}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        OneAxis oaxBase = this.aax.getPrimaryBase();
        SeriesDefinition sdBase = (SeriesDefinition)oaxBase.getModelAxis().getSeriesDefinitions().get(0);
        AutoScale scBase = oaxBase.getScale();
        AutoScale scOrthogonal = oaxOrthogonal.getScale();
        int iUnitCount = iTickCount = scBase.getTickCount();
        int iDirection = scBase.getDirection();
        double d = dUnitSize = iDirection == -1 || iDirection == 0 && this.aax.areAxesSwapped() ? -scBase.getUnitSize() : scBase.getUnitSize();
        if (scBase.getType() == 8) {
            // empty if block
        }
        double[] daTickCoordinates = scBase.getTickCordinates();
        Object oDataBase = null;
        DataSetIterator dsiDataBase = scBase.getData();
        DataSetIterator dsiDataOrthogonal = this.getTypedDataSet(seOrthogonal, oaxOrthogonal.getScale().getType());
        double dOrthogonalZero = 0.0;
        dOrthogonalZero = (scOrthogonal.getType() & 1) == 1 ? PlotWith2DAxes.getLocation(scOrthogonal, 0.0) : scOrthogonal.getStart();
        double d2 = dBaseZero = (scBase.getType() & 1) == 1 && !oaxBase.isCategoryScale() ? PlotWith2DAxes.getLocation(scBase, 0.0) : scBase.getStart();
        if (scBase.getType() == 16 || oaxBase.isCategoryScale()) {
            --iUnitCount;
        }
        double dX = 0.0;
        double dY = 0.0;
        double dLength = 0.0;
        int iBaseCount = dsiDataBase.size();
        int iOrthogonalCount = dsiDataOrthogonal.size();
        DataPointHints[] dpa = null;
        if (iBaseCount != iOrthogonalCount) {
            logger.log(1, Messages.getString("exception.base.orthogonal.inconsistent.count", new Object[]{new Integer(iBaseCount), new Integer(iOrthogonalCount)}, this.rtc.getULocale()));
        } else {
            int i;
            dpa = new DataPointHints[iBaseCount];
            boolean bScatter = oaxBase.getScale().getType() != 16 && !oaxBase.isCategoryScale();
            DataPoint dp = seOrthogonal.getDataPoint();
            EList el = dp.getComponents();
            FormatSpecifier fsBase = null;
            FormatSpecifier fsOrthogonal = null;
            FormatSpecifier fsSeries = null;
            FormatSpecifier fsPercentile = null;
            for (int i2 = 0; i2 < el.size(); ++i2) {
                DataPointComponent dpc = (DataPointComponent)el.get(i2);
                DataPointComponentType dpct = dpc.getType();
                if (dpct == DataPointComponentType.BASE_VALUE_LITERAL) {
                    fsBase = dpc.getFormatSpecifier();
                    if (fsBase != null) continue;
                    fsBase = sdBase.getFormatSpecifier();
                    continue;
                }
                if (dpct == DataPointComponentType.ORTHOGONAL_VALUE_LITERAL) {
                    fsOrthogonal = dpc.getFormatSpecifier();
                    if (fsOrthogonal != null || !(seOrthogonal.eContainer() instanceof SeriesDefinition)) continue;
                    fsOrthogonal = ((SeriesDefinition)seOrthogonal.eContainer()).getFormatSpecifier();
                    continue;
                }
                if (dpct == DataPointComponentType.SERIES_VALUE_LITERAL) {
                    fsSeries = dpc.getFormatSpecifier();
                    continue;
                }
                if (dpct != DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL) continue;
                fsPercentile = dpc.getFormatSpecifier();
            }
            dsiDataBase.reset();
            dsiDataOrthogonal.reset();
            UserDataSetHints udsh = new UserDataSetHints(seOrthogonal.getDataSets());
            udsh.reset();
            double total = 0.0;
            boolean isZeroValue = true;
            for (i = 0; i < iOrthogonalCount; ++i) {
                Object v = dsiDataOrthogonal.next();
                if (v instanceof Number) {
                    if (((Number)v).doubleValue() != 0.0) {
                        isZeroValue = false;
                    }
                    total += ((Number)v).doubleValue();
                    continue;
                }
                if (!(v instanceof NumberDataElement)) continue;
                if (((NumberDataElement)v).getValue() != 0.0) {
                    isZeroValue = false;
                }
                total += ((NumberDataElement)v).getValue();
            }
            dsiDataOrthogonal.reset();
            for (i = 0; i < iBaseCount; ++i) {
                oDataBase = dsiDataBase.next();
                Object oDataOrthogonal = dsiDataOrthogonal.next();
                if (!bScatter) {
                    if (this.aax.areAxesSwapped()) {
                        dY = daTickCoordinates[0] + dUnitSize * (double)i;
                        try {
                            dX = PlotWith2DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                        }
                        catch (IllegalArgumentException nvex) {
                            dX = Double.NaN;
                        }
                        catch (ChartException dfex) {
                            dX = dOrthogonalZero;
                        }
                    } else {
                        dX = daTickCoordinates[0] + dUnitSize * (double)i;
                        try {
                            dY = PlotWith2DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                        }
                        catch (IllegalArgumentException nvex) {
                            dY = Double.NaN;
                        }
                        catch (ChartException dfex) {
                            dY = dOrthogonalZero;
                        }
                    }
                } else {
                    try {
                        dX = PlotWith2DAxes.getLocation(scBase, oDataBase);
                    }
                    catch (IllegalArgumentException nvex) {
                        dX = dBaseZero;
                    }
                    catch (ChartException dfex) {
                        dX = dBaseZero;
                    }
                    try {
                        dY = PlotWith2DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                    }
                    catch (IllegalArgumentException nvex) {
                        dX = Double.NaN;
                    }
                    catch (ChartException dfex) {
                        dY = dOrthogonalZero;
                    }
                    if (this.aax.areAxesSwapped()) {
                        double dTemp = dX;
                        dX = dY;
                        dY = dTemp;
                    }
                }
                Location lo = LocationImpl.create(dX, dY);
                dLength = i < iTickCount - 1 ? daTickCoordinates[i + 1] - daTickCoordinates[i] : 0.0;
                Double percentileValue = null;
                if (total != 0.0) {
                    if (oDataOrthogonal instanceof Number) {
                        percentileValue = new Double(((Number)oDataOrthogonal).doubleValue() / total);
                    } else if (oDataOrthogonal instanceof NumberDataElement) {
                        percentileValue = new Double(((NumberDataElement)oDataOrthogonal).getValue() / total);
                    }
                } else if (isZeroValue) {
                    percentileValue = new Double(1.0 / (double)iOrthogonalCount);
                }
                dpa[i] = new DataPointHints(oDataBase, oDataOrthogonal, seOrthogonal.getSeriesIdentifier(), (Object)percentileValue, seOrthogonal.getDataPoint(), fsBase, fsOrthogonal, fsSeries, fsPercentile, i, lo, dLength, this.rtc);
                udsh.next(dpa[i]);
            }
        }
        return new SeriesRenderingHints(this, oaxBase.getAxisCoordinate(), scOrthogonal.getStart(), dOrthogonalZero, this.dSeriesThickness, daTickCoordinates, dpa, scBase, scOrthogonal, this.ssl, dsiDataBase, dsiDataOrthogonal);
    }

    public final StackedSeriesLookup getStackedSeriesLookup() {
        return this.ssl;
    }
}

