/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.nas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.aperi.Nas.common.DiscoveryData;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.server.agentreq.ManNasReq;
import org.eclipse.aperi.agent.discovery.ExecDiscovery;
import org.eclipse.aperi.agent.discovery.LANManagerDiscovery;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.nas.AutoMounts;
import org.eclipse.aperi.agent.nas.Contactor;
import org.eclipse.aperi.agent.nas.ImportManager;
import org.eclipse.aperi.agent.nas.NasUtil;
import org.eclipse.aperi.agent.nas.netware.NetWareDiscovery;
import org.eclipse.aperi.agent.probe.ExecProbe;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.agent.util.NetWareLoader;
import org.eclipse.aperi.agent.util.SnmpPeer;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ManNasConfigHandler
implements IAgentRequestHandler {
    private ManNasReq reqData;
    private Request request;
    private Response response;
    private File tempFile;
    private PrintWriter oldThreadLog;
    private PrintWriter myPrintWriter;

    static {
        new ExecProbe();
    }

    public void handle(Request request, Response response, Socket socket) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"handle", (String)"request, response, connection");
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.TStorm.server.agentreq.ManNasReq");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)"ManNasConfigHandler", (String)"handle");
            }
            return;
        }
        this.request = request;
        this.response = response;
        this.response.status = (short)12;
        this.reqData = (ManNasReq)request.requestData;
        this.reqData.unpack();
        this.oldThreadLog = MessageLog.getThreadLog();
        this.tempFile = null;
        try {
            this.tempFile = File.createTempFile("mannas", null);
            this.myPrintWriter = new PrintWriter(new FileWriter(this.tempFile));
        }
        catch (IOException iOException) {
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0036E", (Exception)iOException);
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)"ManNasConfigHandler", (String)"handle", (Throwable)iOException);
            }
            return;
        }
        if (this.reqData.mnAddNas) {
            if (Agent.isWindows) {
                this.addWindowsNasServer();
            } else {
                this.addUnixNasServer();
            }
            if (response.status < 12 && this.reqData.mnFiler != null) {
                this.getNasVendor();
            }
        } else {
            this.addNetwareServer();
        }
        this.delTempFile();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"handle");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addWindowsNasServer() {
        block23: {
            block22: {
                NasFiler nasFiler;
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)"ManNasConfigHandler", (String)"addNasServer", (String)"");
                }
                boolean bl = false;
                Contactor contactor = this.contactFiler();
                if (contactor == null) {
                    TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNasServer");
                    return;
                }
                try {
                    NasUtil.cifsLogIn(Agent.domain, this.reqData.mnNetworkName, this.reqData.mnUserid, this.reqData.mnPassword);
                    bl = true;
                }
                catch (LocalizableException localizableException) {
                    this.response.errorMessage = localizableException.getMessage();
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)"ManNasConfigHandler", (String)"addNasServer", (Throwable)localizableException);
                    }
                    return;
                }
                if (!bl) {
                    this.response.errorMessage = MessageLog.getMessage((String)"NAA0201E");
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNasServer");
                    }
                    return;
                }
                String[] stringArray = null;
                try {
                    try {
                        stringArray = LANManagerDiscovery.manualQuery(this.reqData.mnNetworkName);
                    }
                    catch (LocalizableException localizableException) {
                        this.response.errorMessage = localizableException.getMessage();
                        Object var5_7 = null;
                        NasUtil.cifsLogOut(this.reqData.mnNetworkName);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    NasUtil.cifsLogOut(this.reqData.mnNetworkName);
                    throw throwable;
                }
                {
                    nasFiler = null;
                }
                NasUtil.cifsLogOut(this.reqData.mnNetworkName);
                if (stringArray == null) {
                    this.response.errorMessage = MessageLog.getMessage((String)"NAA0202E");
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNasServer");
                    }
                    return;
                }
                Domain domain = new Domain();
                domain.domName = stringArray[1];
                nasFiler = ExecDiscovery.newFiler(contactor.peer, this.reqData.mnNetworkName, contactor, domain);
                try {
                    MessageLog.setThreadLog((PrintWriter)this.myPrintWriter);
                    ExecDiscovery execDiscovery = new ExecDiscovery();
                    execDiscovery.setRejectNonRoot(this.reqData.mnRejectNonRoot);
                    if (!execDiscovery.contactFiler(nasFiler, contactor.vendorID, this.reqData.mnUserid, this.reqData.mnPassword, false)) {
                        this.response.errorMessage = this.getLogMessages();
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNasServer");
                        }
                        Object var7_12 = null;
                        break block22;
                    }
                    if (execDiscovery.rc <= 4) {
                        this.response.status = 0;
                        nasFiler.pack();
                        this.reqData.mnFiler = nasFiler;
                        this.response.responseData = this.reqData;
                        break block23;
                    } else {
                        this.response.errorMessage = this.getLogMessages();
                    }
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
                    throw throwable;
                }
            }
            MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
            return;
        }
        Object var7_14 = null;
        MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNasServer");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addUnixNasServer() {
        NasFiler nasFiler;
        Contactor contactor;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"addUnixNasServer", (String)"");
        }
        if ((contactor = this.contactFiler()) == null) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addUnixNasServer");
            return;
        }
        String string = contactor.peer.name;
        contactor = null;
        Computer computer = new Computer();
        ImportManager importManager = new ImportManager(computer, null, this.reqData.mnCommunities, this.reqData.mnRejectNonRoot);
        Mounts mounts = new Mounts();
        try {
            block19: {
                block18: {
                    block17: {
                        MessageLog.setThreadLog((PrintWriter)this.myPrintWriter);
                        if (this.handleMounts(importManager, mounts) <= 4) break block17;
                        this.getLogMessages();
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addUnixNasServer");
                        }
                        break block18;
                    }
                    if (Agent.hardwareID.osType != 6) break block19;
                    importManager.enterAutomountMode();
                    mounts = new AutoMounts();
                    if (this.handleMounts(importManager, mounts) <= 4) break block19;
                    this.getLogMessages();
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)"ManNasConfigHandler", (String)"addUnixNasServer");
                    }
                }
                Object var6_6 = null;
                MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
                return;
            }
            nasFiler = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
            throw throwable;
        }
        MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
        if (computer.cmpNasFiler == null) {
            this.getLogMessages();
            return;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        nasFiler = computer.cmpNasFiler;
        while (nasFiler != null) {
            if (nasFiler.nfName.compareToIgnoreCase(string) == 0) {
                nasFiler.nfNext = null;
                nasFiler.pack();
                this.reqData.mnFiler = nasFiler;
                this.response.status = 0;
                this.response.responseData = this.reqData;
                break;
            }
            if (n < 3) {
                stringBuffer.append(nasFiler.nfNetworkName);
                stringBuffer.append('\n');
                n = (short)(n + 1);
            }
            nasFiler = nasFiler.nfNext;
        }
        if (this.reqData.mnFiler == null) {
            this.response.errorMessage = MessageLog.getMessage((String)"NAA0205E", (Object)this.reqData.mnNetworkName, (Object)Agent.localName, (Object)stringBuffer.toString());
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addUnixNasServer");
        }
    }

    /*
     * Unable to fully structure code
     */
    private int handleMounts(ImportManager var1_1, Mounts var2_2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"handleMounts", (String)"thing, mounts");
        }
        var3_3 = 0;
        if (var2_2.openMnttab()) ** GOTO lbl10
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"handleMounts", (int)8);
        }
        return 8;
lbl-1000:
        // 1 sources

        {
            if (var2_2.type == null || !var2_2.type.startsWith("nfs") || (var4_4 = var1_1.handleImport(var2_2, this.reqData.mnNetworkName)) <= 4) continue;
            var3_3 = var4_4;
lbl10:
            // 3 sources

            ** while (var3_3 <= 4 && var2_2.nextMount())
        }
lbl11:
        // 1 sources

        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"handleMounts", (int)var3_3);
        }
        return var3_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Contactor contactFiler() {
        Contactor contactor;
        block9: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)"ManNasConfigHandler", (String)"contactFiler", (String)"");
            }
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(this.reqData.mnNetworkName);
            }
            catch (UnknownHostException unknownHostException) {
                this.response.errorMessage = MessageLog.getMessageWithException((String)"NAA0200E", (Exception)unknownHostException, (Object)this.reqData.mnNetworkName);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)"ManNasConfigHandler", (String)"contactFiler", (Throwable)unknownHostException);
                }
                return null;
            }
            NameList nameList = NameList.cloneNameList((NameList)this.reqData.mnCommunities);
            SnmpPeer snmpPeer = new SnmpPeer(this.reqData.mnNetworkName, inetAddress);
            contactor = new Contactor(snmpPeer, null, nameList, false);
            try {
                MessageLog.setThreadLog((PrintWriter)this.myPrintWriter);
                if (contactor.contact() != null && contactor.rc <= 4) break block9;
                this.response.errorMessage = this.getLogMessages();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)"ManNasConfigHandler", (String)"contactFiler");
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
                throw throwable;
            }
            MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
            return null;
        }
        Object var5_8 = null;
        MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"contactFiler", (boolean)true);
        }
        return contactor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addNetwareServer() {
        DiscoveryData discoveryData;
        block8: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)"ManNasConfigHandler", (String)"addNetwareServer", (String)"");
            }
            if (!NetWareLoader.loadNetWare(true)) {
                this.response.errorMessage = MessageLog.getMessage((String)"STA0247E");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNetwareServer", (Object)"");
                }
                return;
            }
            LdapTree[] ldapTreeArray = new LdapTree[]{this.reqData.mnLdapTree};
            NetWareDiscovery netWareDiscovery = new NetWareDiscovery(ldapTreeArray);
            discoveryData = null;
            try {
                MessageLog.setThreadLog((PrintWriter)this.myPrintWriter);
                discoveryData = netWareDiscovery.go(this.reqData.mnNetworkName);
                if (netWareDiscovery.rc <= 4) break block8;
                this.response.errorMessage = this.getLogMessages();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNetwareServer", (Object)"");
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
                throw throwable;
            }
            MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
            return;
        }
        NasFiler nasFiler = null;
        MessageLog.setThreadLog((PrintWriter)this.oldThreadLog);
        this.response.status = 0;
        nasFiler = discoveryData.ddNasFiler;
        nasFiler.pack();
        this.reqData.mnFiler = nasFiler;
        this.response.responseData = this.reqData;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"addNetwareServer");
        }
    }

    private String getLogMessages() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"getLogMessages", (String)"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.myPrintWriter.flush();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.tempFile));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"getLogMessages");
        }
        return stringBuffer.toString();
    }

    private void delTempFile() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"delTempFile", (String)"");
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"delTempFile");
        }
    }

    private void getNasVendor() {
        NameList nameList;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)"ManNasConfigHandler", (String)"getNasVendor", (String)"");
        }
        NameList nameList2 = nameList = NasUtil.parseVendorArray(this.reqData.mnNasVendors);
        while (nameList2 != null) {
            if (nameList2.nlID == this.reqData.mnFiler.nfVendorID) {
                this.reqData.mnFiler.nfManufacturer = nameList2.nlName;
                break;
            }
            nameList2 = nameList2.nlNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)"ManNasConfigHandler", (String)"getNasVendor");
        }
    }
}

