/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.status;

import java.net.Socket;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.req.AgentStatusReq;
import org.eclipse.aperi.agent.req.AgtStatusResp;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.AuthChecker;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class StatusHandler
implements IAgentRequestHandler {
    public void handle(Request request, Response response, Socket socket) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.agent.handler.status.StatusHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"handle", (String)"request, response, connection");
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.agent.req.AgentStatusReq");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.agent.handler.status.StatusHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"handle");
            }
            return;
        }
        boolean bl = !((AgentStatusReq)request.requestData).isVerbose();
        boolean bl2 = AuthChecker.check(request, response, socket, bl);
        if (bl || !bl2) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.agent.handler.status.StatusHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz4.getName(), (String)"handle");
            }
            return;
        }
        AgtStatusResp agtStatusResp = new AgtStatusResp();
        agtStatusResp.upSince = Agent.started;
        Date date = new Date();
        agtStatusResp.upTime = date.getTime() - agtStatusResp.upSince;
        agtStatusResp.vmSize = Runtime.getRuntime().totalMemory();
        agtStatusResp.manufacturer = Agent.hardwareID.manufacturer;
        agtStatusResp.hostName = Agent.hardwareID.hostName;
        agtStatusResp.osType = Agent.hardwareID.osType;
        agtStatusResp.cpuArchitecture = Agent.hardwareID.cpuArchitecture;
        agtStatusResp.jobs = new HashSet();
        Agent.jobManager.getRunningJobs(agtStatusResp.jobs);
        Agent.reporter.addUnreported(agtStatusResp.jobs);
        response.responseData = agtStatusResp;
        if (TraceLogger.enableTrace) {
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("org.eclipse.aperi.agent.handler.status.StatusHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz5.getName(), (String)"handle");
        }
    }
}

