/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas.netapp;

import java.io.Serializable;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.agent.nas.ImportManager;
import org.eclipse.aperi.agent.nas.netapp.TableHandler;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.xmsg.MessageLog;

public class FilesystemTableHandler
extends TableHandler {
    protected int currentVolume;
    protected int nVols;

    public FilesystemTableHandler(OID oID, NasFiler nasFiler, SnmpSession snmpSession, int n) {
        super(oID, nasFiler, snmpSession);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"FilesystemTableHandler", (String)"pOID, pFiler, pListener, pNVols");
        }
        this.badTypeMsgID = "NAA0088E";
        this.tableOIDLength = 12;
        this.currentVolume = this.nVols = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"FilesystemTableHandler");
        }
    }

    protected String checkNameLength() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkNameLength", (String)"");
        }
        String string = this.array.length == 13 ? null : "NAA0087E";
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkNameLength", (Object)string2);
        }
        return string2;
    }

    protected boolean typeOK(Serializable serializable) {
        return serializable instanceof OctetString;
    }

    protected void finishProcessing(String string, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"finishProcessing", (String)"fsName, volNo");
        }
        LogicalDisk logicalDisk = this.comp.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldPath.compareTo(string) == 0) break;
            logicalDisk = logicalDisk.ldNext;
        }
        if (logicalDisk == null) {
            Object[] objectArray = new Object[]{string, new Integer(this.currentVolume)};
            String string2 = MessageLog.getMessage((String)"NAA0090E", (Object[])objectArray);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"finishProcessing");
            }
            throw new GeneralException(string2);
        }
        Filesystem filesystem = new Filesystem();
        filesystem.fsComputerID = this.filer.nfComputerID;
        filesystem.fsMaxFiles = -1;
        filesystem.fsUsedInodes = -1;
        filesystem.fsFreeInodes = -1;
        filesystem.fsMountPoint = string;
        filesystem.fsPhysicalSize = logicalDisk.ldCapacity;
        filesystem.fsCapacity = -1L;
        filesystem.fsUsedSpace = -1L;
        filesystem.fsFreeSpace = -1L;
        filesystem.fsType = (short)15;
        filesystem.fsClusterSize = (int)this.array[this.array.length - 1];
        filesystem.fsLogicalDisk = logicalDisk;
        logicalDisk.ldFilesystem = filesystem;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"finishProcessing");
        }
    }

    protected void process(Serializable serializable) throws GeneralException {
        int n;
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"process", (String)"content");
        }
        if (!ImportManager.isNetAppVolume(string = ((OctetString)serializable).toDisplayString())) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"process");
            }
            return;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = this.currentVolume - 1) < 0) {
            Object[] objectArray = new Object[]{string, new Integer(this.nVols)};
            String string2 = MessageLog.getMessage((String)"NAA0089E", (Object[])objectArray);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"process");
            }
            throw new GeneralException(string2);
        }
        this.currentVolume = n;
        this.finishProcessing(string, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"process");
        }
    }
}

