/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import org.eclipse.aperi.agent.probe.IPoller;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class UpTime
implements IPoller {
    public long downTime;
    public long beganMonitoring;
    public long powerCycles;
    private static final int MON_START_OFFSET = 0;
    private static final int BOOT_OFFSET = 8;
    private static final int DOWNTIME_OFFSET = 16;
    private static final int ALIVE_OFFSET = 24;
    private static final int BOOT_COUNT_OFFSET = 32;
    private String fileName;
    private RandomAccessFile file;
    private boolean resetMonStart;
    private Thread shutdownWaiter;
    private boolean up;
    private byte[] buf;

    private long longAt(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"longAt", (String)"offset");
        }
        long l = 0L;
        int n2 = 0;
        while (n2 < 8) {
            long l2 = (long)this.buf[n + n2] & 0xFFL;
            l |= l2 << (n2 << 3);
            ++n2;
        }
        long l3 = l;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"longAt", (long)l3);
        }
        return l3;
    }

    private void dumpLong(long l, int n) {
        int n2 = 0;
        while (n2 < 8) {
            this.buf[n + n2] = (byte)l;
            l >>= 8;
            ++n2;
        }
    }

    private boolean writeBuf() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"writeBuf", (String)"");
        }
        this.dumpLong(System.currentTimeMillis(), 24);
        boolean bl = true;
        try {
            this.file.seek(0L);
            this.file.write(this.buf);
            this.file.getFD().sync();
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"writeBuf", (Throwable)iOException);
            }
            MessageLog.logException((String)"STA0118E", (Exception)iOException, (Object)this.fileName);
            bl = false;
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"writeBuf", (boolean)bl2);
        }
        return bl2;
    }

    private void checkPollInterval() {
        if (Agent.upTimePoll <= 0) {
            MessageLog.logMessage((String)"STA0117W");
        }
    }

    private boolean initialize() {
        long l;
        FileInputStream fileInputStream;
        block39: {
            block37: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"initialize", (String)"");
                }
                this.up = true;
                this.shutdownWaiter = null;
                this.resetMonStart = false;
                this.fileName = String.valueOf(Variables.homeDirectory) + File.separator + "UPTIME." + Agent.localName;
                fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(this.fileName);
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block37;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"initialize", (Throwable)iOException);
                }
            }
            l = Agent.systemBoot;
            this.buf = new byte[40];
            if (fileInputStream != null) {
                int n = 0;
                String string = MessageLog.getMessageNoID((String)"STA0120E", null);
                try {
                    n = ((InputStream)fileInputStream).read(this.buf);
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"initialize", (Throwable)iOException);
                    }
                    string = iOException.getMessage();
                }
                if (n < 24) {
                    block38: {
                        MessageLog.logMessage((String)"STA0119E", (Object)this.fileName);
                        PrintWriter printWriter = MessageLog.getThreadLog();
                        printWriter.println("                         " + string);
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) break block38;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"initialize", (Throwable)iOException);
                        }
                    }
                    fileInputStream = null;
                } else {
                    this.beganMonitoring = this.longAt(0);
                    l = this.longAt(8);
                    this.downTime = this.longAt(16);
                    this.powerCycles = this.longAt(32);
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block39;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"initialize", (Throwable)iOException);
                    }
                }
            }
        }
        if (fileInputStream == null) {
            this.beganMonitoring = Agent.started;
            this.dumpLong(this.beganMonitoring, 0);
            this.dumpLong(l, 8);
            this.dumpLong(0L, 16);
            this.dumpLong(0L, 32);
        }
        try {
            this.file = new RandomAccessFile(this.fileName, "rw");
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"initialize", (Throwable)iOException);
            }
            MessageLog.logException((String)"STA0069W", (Exception)iOException, (Object)this.fileName);
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"initialize", (boolean)bl);
            }
            return bl;
        }
        if (Agent.systemBoot - l > 5000L) {
            this.dumpLong(Agent.systemBoot, 8);
            long l2 = Agent.systemBoot - this.longAt(24);
            if (l2 < 20000L) {
                l2 = 20000L;
            }
            this.downTime += l2;
            this.dumpLong(this.downTime, 16);
            ++this.powerCycles;
            this.dumpLong(this.powerCycles, 32);
        }
        this.checkPollInterval();
        boolean bl = this.writeBuf();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initialize", (boolean)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        UpTime upTime;
        block28: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"");
            }
            boolean bl = this.initialize();
            while (bl) {
                boolean bl2;
                upTime = this;
                synchronized (upTime) {
                    block27: {
                        if (this.shutdownWaiter == null) {
                            long l = Agent.upTimePoll * 1000;
                            try {
                                if (l > 0L) {
                                    this.wait(l);
                                } else {
                                    this.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Class<?> clazz;
                                if (!TraceLogger.enableTrace) break block27;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)interruptedException);
                            }
                        }
                    }
                    bl2 = this.resetMonStart;
                }
                if (bl2) {
                    this.resetMonStart = false;
                    this.dumpLong(this.beganMonitoring, 0);
                    this.dumpLong(this.downTime, 16);
                    this.dumpLong(this.powerCycles, 32);
                }
                boolean bl3 = bl = this.writeBuf() && this.shutdownWaiter == null;
            }
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block28;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)iOException);
                }
            }
        }
        upTime = this;
        synchronized (upTime) {
            this.up = false;
        }
        if (this.shutdownWaiter != null) {
            this.shutdownWaiter.interrupt();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run");
        }
    }

    public synchronized void timeoutChanged() {
        this.checkPollInterval();
        this.notify();
    }

    public synchronized void reset(long l) {
        this.beganMonitoring = l;
        this.downTime = 0L;
        this.powerCycles = 0L;
        this.resetMonStart = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block14: {
            boolean bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"shutdown", (String)"");
            }
            UpTime upTime = this;
            synchronized (upTime) {
                bl = this.up;
                this.shutdownWaiter = Thread.currentThread();
                this.notify();
            }
            if (bl) {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException interruptedException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block14;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"shutdown", (Throwable)interruptedException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.UpTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"shutdown");
        }
    }
}

