/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.reporter;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.aperi.agent.reporter.IReporter;
import org.eclipse.aperi.agent.reporter.SendResult;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.agent.req.HostAndPort;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.CheckedRequest;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketRegistry;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.server.req.AgentRegReq;
import org.eclipse.aperi.server.req.AgentStateReq;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class Reporter
implements Runnable,
IReporter {
    private HostAndPort server;
    private LinkedList outgoing;
    private Request oldRequest;
    private JobRun jobRun;
    private boolean running;
    private boolean shutdownRequested;
    private Object mutexForShutdown;
    private int napLength;

    public HostAndPort getServer() {
        return this.server;
    }

    public int getNapLength() {
        return this.napLength;
    }

    public void setNapLength(int n) {
        this.napLength = n;
    }

    public void setServer(HostAndPort hostAndPort) {
        this.server = hostAndPort;
    }

    public boolean isBacklogged() {
        boolean bl = false;
        if (this.outgoing.size() > Agent.maxBacklog) {
            bl = true;
        }
        return bl;
    }

    public synchronized void addUnreported(Set set) {
        Iterator iterator = this.outgoing.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            this.addUnreported(set, request);
        }
        if (this.oldRequest != null) {
            this.addUnreported(set, this.oldRequest);
        }
    }

    private void addUnreported(Set set, Request request) {
        Serializable serializable = request.requestData;
        if (serializable instanceof StartedJob) {
            StartedJob startedJob = (StartedJob)serializable;
            if (startedJob.getJobRun() == null) {
                startedJob.setJobRun(this.jobRun);
            }
            set.add(startedJob);
        }
    }

    public synchronized void add(Request request) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"add", (String)"request");
        }
        this.outgoing.addLast(request);
        this.notify();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"add");
        }
    }

    private synchronized void addHiPri(Request request) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addHiPri", (String)"request");
        }
        this.outgoing.addFirst(request);
        this.shutdownRequested = true;
        this.notify();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addHiPri");
        }
    }

    private String saveFileName() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveFileName", (String)"");
        }
        String string = String.valueOf(Variables.homeDirectory) + File.separator + "UNSENT." + Agent.localName;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveFileName", (Object)string);
        }
        return string;
    }

    private Request createRegistration() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"createRegistration", (String)"");
        }
        CheckedRequest checkedRequest = Agent.makeCheckedRequest();
        TimeZone timeZone = TimeZone.getDefault();
        checkedRequest.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        checkedRequest.serviceName = RequestTypeManager.getInternalName((String)checkedRequest.typeCode);
        checkedRequest.subType = "org.eclipse.aperi.server.handler.server.AgentRegHndlr";
        checkedRequest.machineName = Agent.localName;
        checkedRequest.userName = null;
        checkedRequest.flags = 0;
        AgentRegReq agentRegReq = new AgentRegReq();
        agentRegReq.hwID = Agent.hardwareID;
        agentRegReq.newLogDir = Agent.logFileDirectory;
        agentRegReq.timezone = timeZone.getID().indexOf("Custom") == -1 ? TimeZone.getDefault().getID() : timeZone.getDisplayName(timeZone.useDaylightTime(), 0);
        agentRegReq.port = Agent.listeningPort;
        agentRegReq.installedProducts = Agent.installedProducts;
        agentRegReq.guidO = Agent.guidO;
        agentRegReq.featureSet = 0;
        agentRegReq.networkName = Agent.networkName;
        checkedRequest.requestData = agentRegReq;
        CheckedRequest checkedRequest2 = checkedRequest;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"createRegistration", (Object)checkedRequest2);
        }
        return checkedRequest2;
    }

    public void queueRegistration() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"queueRegistration", (String)"");
        }
        Request request = this.createRegistration();
        this.add(request);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"queueRegistration");
        }
    }

    public Reporter(HostAndPort hostAndPort, int n) {
        Request request;
        ObjectInputStream objectInputStream;
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"Reporter", (String)"pServer, pNapLength");
        }
        this.oldRequest = null;
        this.jobRun = null;
        this.server = hostAndPort;
        this.napLength = n;
        this.mutexForShutdown = new Object();
        String string = this.saveFileName();
        File file = new File(string);
        this.outgoing = null;
        if (file.canRead()) {
            block62: {
                object = null;
                objectInputStream = null;
                try {
                    object = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)fileNotFoundException);
                    }
                    MessageLog.logException((String)"GEN0029E", (Exception)fileNotFoundException);
                }
                if (object != null) {
                    try {
                        objectInputStream = new ObjectInputStream((InputStream)object);
                    }
                    catch (ObjectStreamException objectStreamException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)objectStreamException);
                        }
                        MessageLog.logException((String)"AGT0036W", (Exception)objectStreamException, (Object)string);
                    }
                    catch (IOException iOException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)iOException);
                        }
                        MessageLog.logException((String)"AGT0035W", (Exception)iOException, (Object)string);
                    }
                }
                if (objectInputStream == null) {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (IOException iOException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) break block62;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)iOException);
                        }
                    }
                } else {
                    try {
                        this.outgoing = (LinkedList)objectInputStream.readObject();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                            }
                            catch (ClassNotFoundException classNotFoundException2) {
                                throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)classNotFoundException);
                        }
                        MessageLog.logMessage((String)"AGT0038W", (Object)classNotFoundException.getMessage(), (Object)string);
                    }
                    catch (ObjectStreamException objectStreamException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)objectStreamException);
                        }
                        MessageLog.logException((String)"AGT0036W", (Exception)objectStreamException, (Object)string);
                    }
                    catch (EOFException eOFException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)eOFException);
                        }
                        MessageLog.logException((String)"AGT0037W", (Exception)eOFException, (Object)string);
                    }
                    catch (IOException iOException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)iOException);
                        }
                        MessageLog.logException((String)"AGT0035W", (Exception)iOException, (Object)string);
                    }
                    catch (ClassCastException classCastException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)classCastException);
                        }
                        MessageLog.logException((String)"AGT0039W", (Exception)classCastException, (Object)string, (Object)"LinkedList");
                    }
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block62;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)iOException);
                    }
                }
            }
            file.delete();
        }
        if (this.outgoing == null) {
            this.outgoing = new LinkedList();
        } else {
            object = this.outgoing.iterator();
            objectInputStream = null;
            while (object.hasNext()) {
                try {
                    objectInputStream = (ObjectInputStream)object.next();
                    request = (Request)objectInputStream;
                    if (!request.typeCode.equals("org.eclipse.aperi.server.svp.ServerSvp") || !request.subType.equals("org.eclipse.aperi.server.handler.server.AgentRegHndlr") && !request.subType.equals("org.eclipse.aperi.server.handler.server.AgentStateHndlr")) continue;
                    object.remove();
                }
                catch (ClassCastException classCastException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"Reporter", (Throwable)classCastException);
                    }
                    object.remove();
                }
            }
        }
        request = this.createRegistration();
        this.outgoing.addFirst(request);
        this.running = true;
        this.shutdownRequested = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"Reporter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"shutdown", (String)"quick");
        }
        Request request = new Request();
        request.machineName = Agent.localName;
        request.userName = null;
        ServerRequest.agentState((Request)request, null, (byte)0);
        if (bl) {
            request.flags = (byte)(request.flags | 1);
        }
        this.addHiPri(request);
        Object object = this.mutexForShutdown;
        synchronized (object) {
            while (this.running) {
                try {
                    this.mutexForShutdown.wait();
                }
                catch (InterruptedException interruptedException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"shutdown", (Throwable)interruptedException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"shutdown");
        }
    }

    public Response sendRequest(Request request) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendRequest", (String)"request");
        }
        Response response = this.sendRequest(request, (byte)0, Agent.patienceWithServer);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendRequest", (Object)response);
        }
        return response;
    }

    public Response sendRequest(Request request, byte by) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendRequest", (String)"request, retryLevel");
        }
        Response response = this.sendRequest(request, by, Agent.patienceWithServer);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendRequest", (Object)response);
        }
        return response;
    }

    public Response sendRequest(Request request, byte by, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendRequest", (String)"request, retryLevel, timeoutInSeconds");
        }
        SendResult sendResult = new SendResult();
        this.sendWithResult(request, by, n, sendResult);
        if (sendResult.zrTransceiver != null) {
            sendResult.zrTransceiver.close();
        }
        Response response = sendResult.zrResponse;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendRequest", (Object)response);
        }
        return response;
    }

    public void sendWithResult(Request request, byte by, int n, SendResult sendResult) {
        Response response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendWithResult", (String)"request, retryLevel, timeoutInSeconds, result");
        }
        sendResult.zrTransceiver = null;
        sendResult.zrResponse = null;
        do {
            HostAndPort hostAndPort = this.server;
            Socket socket = null;
            response = null;
            try {
                socket = SocketRegistry.connect((String)hostAndPort.host, (int)hostAndPort.port);
            }
            catch (UnknownHostException unknownHostException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"sendWithResult", (Throwable)unknownHostException);
                }
                MessageLog.logMessage((String)"GEN0039E", (Object)unknownHostException.getMessage());
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"sendWithResult");
                }
                return;
            }
            SocketTransceiver socketTransceiver = null;
            if (socket != null) {
                socketTransceiver = new SocketTransceiver(socket, hostAndPort.host, n);
                if ((request.flags & 2) == 0) {
                    response = socketTransceiver.transmitRequest(request, null);
                } else {
                    Serializable serializable = request.requestData;
                    request.requestData = null;
                    response = socketTransceiver.transmitRequest(request, (Object)serializable);
                    request.requestData = serializable;
                }
            }
            if (response != null && response.status <= 4) {
                sendResult.zrTransceiver = socketTransceiver;
            } else if (socketTransceiver != null) {
                socketTransceiver.close();
            }
            if (response != null ? (response.status != 8 || by < 1) && (response.status != 24 || by != 2) : by < 2) break;
        } while (this.waitToResend());
        sendResult.zrResponse = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendWithResult");
        }
    }

    private boolean waitToResend() {
        boolean bl;
        block11: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"waitToResend", (String)"");
            }
            if (Agent.state == 1) {
                try {
                    Thread.sleep(Agent.sendFailWait * 1000);
                }
                catch (InterruptedException interruptedException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block11;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"waitToResend", (Throwable)interruptedException);
                }
            }
        }
        boolean bl2 = bl = Agent.state == 1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"waitToResend", (boolean)bl);
        }
        return bl;
    }

    private Response sendRequestOptimized(Request request) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendRequestOptimized", (String)"request");
        }
        if (!(request.requestData instanceof StartedJob)) {
            Response response = this.sendRequest(request, (byte)0, Agent.patienceWithServer);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"sendRequestOptimized", (Object)response);
            }
            return response;
        }
        StartedJob startedJob = (StartedJob)request.requestData;
        this.jobRun = startedJob.getJobRun();
        startedJob.setJobRun(null);
        Response response = this.sendRequest(request, (byte)0, Agent.patienceWithServer);
        startedJob.setJobRun(this.jobRun);
        Response response2 = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendRequestOptimized", (Object)response2);
        }
        return response2;
    }

    public boolean sendNoWaitRequest(Request request) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendNoWaitRequest", (String)"request");
        }
        HostAndPort hostAndPort = this.server;
        Socket socket = null;
        boolean bl = false;
        try {
            socket = SocketRegistry.connect((String)hostAndPort.host, (int)hostAndPort.port);
        }
        catch (UnknownHostException unknownHostException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"sendNoWaitRequest", (Throwable)unknownHostException);
            }
            boolean bl2 = bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"sendNoWaitRequest", (boolean)bl2);
            }
            return bl2;
        }
        if (socket != null) {
            SocketTransceiver socketTransceiver = new SocketTransceiver(socket, hostAndPort.host);
            socketTransceiver.writeObject((Object)request, -1);
            socketTransceiver.close();
            bl = true;
        }
        boolean bl3 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendNoWaitRequest", (boolean)bl3);
        }
        return bl3;
    }

    private synchronized void save() {
        boolean bl;
        String string;
        block34: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"");
            }
            if (this.outgoing.size() <= 0) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"save");
                }
                return;
            }
            string = this.saveFileName();
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)iOException);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"save");
                }
                return;
            }
            bl = false;
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.outgoing);
                bl = true;
            }
            catch (ObjectStreamException objectStreamException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)objectStreamException);
                }
                MessageLog.logException((String)"AGT0043E", (Exception)objectStreamException, (Object)string);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)iOException);
                }
                MessageLog.logException((String)"AGT0042E", (Exception)iOException, (Object)string);
            }
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)iOException);
                    }
                    if (!bl) break block34;
                    MessageLog.logException((String)"AGT0042E", (Exception)iOException, (Object)string);
                    bl = false;
                }
            }
        }
        if (!bl) {
            File file = new File(string);
            file.delete();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegistration(Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handleRegistration", (String)"response");
        }
        AgentRequestData agentRequestData = (AgentRequestData)response.responseData;
        if (ComputerID.cachedCID != null) {
            ComputerID.cachedCID.computerID = agentRequestData.getComputerID();
        } else {
            ComputerID.cachedCID = new ComputerID(agentRequestData.getComputerID());
            if (agentRequestData.getServerToken() != Agent.serverToken) {
                if (Agent.serverToken != 0L) {
                    MessageLog.logMessage((String)"AGT0106I");
                    Reporter reporter = this;
                    synchronized (reporter) {
                        this.outgoing.clear();
                    }
                }
                Agent.serverToken = agentRequestData.getServerToken();
                Agent.writeToken();
            }
        }
        MessageLog.logMessage((String)"AGT0003I");
        Agent.registered();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handleRegistration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"");
        }
        Request request = null;
        Response response = null;
        boolean bl = false;
        while (true) {
            object = this;
            synchronized (object) {
                if (this.outgoing.size() == 0 && this.oldRequest != null) {
                    request = this.oldRequest;
                } else {
                    while (true) {
                        if (this.outgoing.size() != 0) {
                            request = (Request)this.outgoing.getFirst();
                            boolean bl2 = bl = request.typeCode.equals("org.eclipse.aperi.server.svp.ServerSvp") && request.subType.equals("org.eclipse.aperi.server.handler.server.AgentStateHndlr");
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) continue;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)interruptedException);
                        }
                    }
                    if (this.oldRequest == null || bl) {
                        this.outgoing.removeFirst();
                    } else {
                        request = this.oldRequest;
                    }
                }
            }
            if (bl) {
                if (this.oldRequest != null) {
                    this.addHiPri(this.oldRequest);
                    this.oldRequest = null;
                }
                object = ComputerID.cachedCID;
                if ((request.flags & 1) != 0 || object == null) break;
                AgentStateReq agentStateReq = (AgentStateReq)request.requestData;
                agentStateReq.computerID = object;
                this.sendRequest(request, (byte)0, 300);
                break;
            }
            this.oldRequest = request;
            response = this.sendRequestOptimized(request);
            if (response != null && response.status <= 4) {
                this.oldRequest = null;
                if (!request.typeCode.equals("org.eclipse.aperi.server.svp.ServerSvp") || !request.subType.equals("org.eclipse.aperi.server.handler.server.AgentRegHndlr")) continue;
                this.handleRegistration(response);
                continue;
            }
            object = this;
            synchronized (object) {
                block35: {
                    if (!this.shutdownRequested) {
                        try {
                            this.wait(1000L * (long)this.napLength);
                        }
                        catch (InterruptedException interruptedException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) break block35;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)interruptedException);
                        }
                    }
                }
            }
        }
        if (Agent.shutdownMode != 3) {
            this.save();
        }
        object = this.mutexForShutdown;
        synchronized (object) {
            this.running = false;
            this.mutexForShutdown.notify();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.reporter.Reporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run");
        }
    }
}

