/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.common;

import java.util.Date;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class LunAdjuster
extends CustomReportDataAdjuster {
    static final String SUBSYSTEM = MessageLog.getMessageNoID("SAG0001L");
    static final String LUN_NAME = MessageLog.getMessageNoID("SAG0514L");
    static final String LUN_WWN = MessageLog.getMessageNoID("SAG0620L");
    static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    static final String OVERHEAD = MessageLog.getMessageNoID("SAG0202L");
    static final String SURFACED = MessageLog.getMessageNoID("SAG0201L");
    static final String VCMDB = MessageLog.getMessageNoID("SAG0014L");
    static final String MIRROR = MessageLog.getMessageNoID("SAG0203L");
    static final String PRIMARY = MessageLog.getMessageNoID("SAG0204L");
    static final String REPLICATION = MessageLog.getMessageNoID("SAG0205L");
    static final String MANUFACTURER = MessageLog.getMessageNoID("STG1105L");
    static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    static final String PROBE_TIME = MessageLog.getMessageNoID("STG1182L");
    static final String FORMAT = MessageLog.getMessageNoID("SAG0033L");
    static final String YES = MessageLog.getMessageNoID("GUI0121T");
    static final String NO = MessageLog.getMessageNoID("GUI0122T");
    static final String UNKNOWN = MessageLog.getMessageNoID("GUI0129T");
    public static final String NA = MessageLog.getMessageNoID("STG0019T");
    public static final String FIXBLK = MessageLog.getMessageNoID("SAG0034L");
    public static final String ZSERIES = MessageLog.getMessageNoID("SAG0035L");
    public static final String SOURCE = MessageLog.getMessageNoID("SAG0206L");
    public static final String TARGET = MessageLog.getMessageNoID("SAG0207L");
    public static final String NONE = MessageLog.getMessageNoID("SAG0508L");
    public static final String VARBLK = MessageLog.getMessageNoID("SAG0087L");
    public String[] colNames = new String[]{SUBSYSTEM, LUN_NAME, LUN_WWN, CAPACITY, OVERHEAD, SURFACED, VCMDB, MIRROR, PRIMARY, REPLICATION, FORMAT, MANUFACTURER, MODEL, PROBE_TIME};
    private static final int SUBSYSTEM_COL = 0;
    private static final int LUN_NAME_COL = 1;
    private static final int LUN_WWN_COL = 2;
    private static final int CAPACITY_COL = 3;
    private static final int OVERHEAD_COL = 4;
    private static final int SURFACED_COL = 5;
    private static final int VCMDB_COL = 6;
    private static final int MIRROR_COL = 7;
    private static final int PRIMARY_COL = 8;
    private static final int REPLICATION_COL = 9;
    private static final int FORMAT_COL = 10;
    private static final int MANUFACTURER_COL = 11;
    private static final int MODEL_COL = 12;
    private static final int PROBE_TIME_COL = 13;
    private GuiReportReq grr;
    private Lun[] lunArray;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private int[] rendererArray;
    private int rowCount;
    public int frozenRows;
    public int totalRow;

    public LunAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.frozenColumns = 2;
        this.firstColumn = guiReportReq.reportSubtype == 18 ? 13 : 3;
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[13] = 1;
        this.rendererArray[3] = 7;
        this.rendererArray[4] = 7;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.lunArray = (Lun[])objectArray;
        this.rowCount = this.lunArray.length;
        if (this.rowCount > 1) {
            this.addTotal();
        }
        this.mDate = new Date[this.rowCount];
        this.mLong = new MutableLong[this.rowCount];
        this.mInt = new MutableInteger[this.rowCount];
        int n = 0;
        while (n < this.rowCount) {
            this.mDate[n] = new Date();
            this.mLong[n] = new MutableLong();
            this.mInt[n] = new MutableInteger();
            ++n;
        }
    }

    public void adjustData() {
        int n = 0;
        while (n < this.rowCount) {
            Lun lun = this.lunArray[n];
            LogicalDisk logicalDisk = lun.lunLogicalDisk;
            logicalDisk.ldCapacity *= 512L;
            logicalDisk.ldOverhead *= 512L;
            if (n >= this.totalRow && logicalDisk.isSnapshot() && lun.lunPrimaryName == null) {
                lun.lunPrimaryName = UNKNOWN;
            }
            ++n;
        }
    }

    public void undo() {
        Lun lun = this.lunArray[0];
        LogicalDisk logicalDisk = lun.lunLogicalDisk;
        logicalDisk.ldCapacity /= 512L;
        logicalDisk.ldOverhead /= 512L;
        if (logicalDisk.isSnapshot() && lun.lunPrimaryName == UNKNOWN) {
            lun.lunPrimaryName = null;
        }
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArray3[2] = 9;
        int[] nArray4 = nArray3;
        int[] nArray5 = new int[]{7, 8, 58, 9};
        int[] nArray6 = new int[]{10, 11, 12, 9};
        columnDescriptorArray[5].cdValidValue = nArray2;
        columnDescriptorArray[6].cdValidValue = nArray4;
        columnDescriptorArray[7].cdValidValue = nArray4;
        columnDescriptorArray[9].cdValidValue = nArray6;
        columnDescriptorArray[10].cdValidValue = nArray5;
    }

    public int getNumberRows() {
        return this.lunArray.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public Object getArray() {
        return this.lunArray;
    }

    public Object getCellData(int n, int n2) {
        if (n == 0 && this.bHasTotalRow && n2 != 0 && n2 != 3 && n2 != 4) {
            return " ";
        }
        switch (n2) {
            case 0: {
                return this.lunArray[n].lunDaAlias;
            }
            case 1: {
                int n3;
                String string = this.lunArray[n].lunName;
                if (this.lunArray[n].lunOSType == 21 && (n3 = string.indexOf(":")) > 0) {
                    string = string.substring(0, n3);
                }
                return string;
            }
            case 2: {
                String string = this.lunArray[n].lunWWN;
                if (Util.isEmpty(string)) {
                    return UNKNOWN;
                }
                return string;
            }
            case 3: {
                this.mLong[n].value = this.lunArray[n].lunLogicalDisk.ldCapacity;
                return this.mLong[n];
            }
            case 4: {
                this.mLong[n].value = this.lunArray[n].lunLogicalDisk.ldOverhead;
                return this.mLong[n];
            }
            case 5: {
                return this.lunArray[n].lunLogicalDisk.notExposed() ? NO : YES;
            }
            case 6: {
                if (Constants.isCimomManaged(this.lunArray[n].lunOSType)) {
                    return NA;
                }
                return this.lunArray[n].lunLogicalDisk.isVCMDB() ? YES : NO;
            }
            case 7: {
                if (Constants.isCimomManaged(this.lunArray[n].lunOSType)) {
                    return NA;
                }
                return this.lunArray[n].lunLogicalDisk.isSnapshot() ? YES : NO;
            }
            case 8: {
                if (Constants.isCimomManaged(this.lunArray[n].lunOSType)) {
                    return NA;
                }
                String string = this.lunArray[n].lunPrimaryName;
                return string == null ? "" : string;
            }
            case 9: {
                if (Constants.isCimomManaged(this.lunArray[n].lunOSType)) {
                    return NA;
                }
                byte by = this.lunArray[n].lunLogicalDisk.getReplicationMode();
                if (by == 0) {
                    return NONE;
                }
                return by == 1 ? SOURCE : TARGET;
            }
            case 10: {
                return LogicalDisk.FORMATS[this.lunArray[n].lunLogicalDisk.ldStorageType];
            }
            case 11: {
                if (this.lunArray[n].lunDaManufacturer.toLowerCase().equals("unknown")) {
                    return MessageLog.getMessageNoID("STG1020L");
                }
                return this.lunArray[n].lunDaManufacturer;
            }
            case 12: {
                if (this.lunArray[n].lunOSType == 21) {
                    return "2145";
                }
                return this.lunArray[n].lunDaModel;
            }
            case 13: {
                this.mDate[n].setTime(this.lunArray[n].lunProbeTime);
                return this.mDate[n];
            }
        }
        return null;
    }

    private void addTotal() {
        Lun lun;
        long l = 0L;
        long l2 = 0L;
        Lun[] lunArray = new Lun[this.rowCount + 1];
        lunArray[0] = lun = new Lun();
        lun.lunLogicalDisk = new LogicalDisk();
        lun.lunDaAlias = MessageLog.getMessageNoID("STG4136L");
        int n = 0;
        while (n < this.rowCount) {
            if (this.lunArray[n].lunLogicalDisk.ldCapacity > -1L) {
                l += this.lunArray[n].lunLogicalDisk.ldCapacity;
            }
            if (this.lunArray[n].lunLogicalDisk.ldOverhead > -1L) {
                l2 += this.lunArray[n].lunLogicalDisk.ldOverhead;
            }
            lunArray[n + 1] = this.lunArray[n];
            ++n;
        }
        lun.lunLogicalDisk.ldCapacity = l;
        lun.lunLogicalDisk.ldOverhead = l2;
        this.lunArray = lunArray;
        this.bHasTotalRow = true;
        this.totalRow = 1;
        ++this.frozenRows;
        ++this.rowCount;
    }
}

