/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableLongExt;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class SpaceUsedAdjuster
extends CustomReportDataAdjuster {
    private static final String DOMAIN = MessageLog.getMessageNoID("STG1104L");
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String CLUSTER = MessageLog.getMessageNoID("STG1136L");
    private static final String CREATOR = MessageLog.getMessageNoID("STG0021L");
    private static final String GROUP = MessageLog.getMessageNoID("STG1103L");
    private static final String MOUNTPNT = MessageLog.getMessageNoID("STG1230L");
    public static final String FREESPACE = MessageLog.getMessageNoID("STG1184L");
    public static final String USEDSPACE = MessageLog.getMessageNoID("STG1237L");
    private static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    private static final String PCT_FREE = MessageLog.getMessageNoID("STG2040L");
    private static final String PCT_USED = MessageLog.getMessageNoID("STG2041L");
    private static final String USED_INODES = MessageLog.getMessageNoID("STG1235L");
    private static final String FREE_INODES = MessageLog.getMessageNoID("STG1236L");
    private static final String PCT_FREEI = MessageLog.getMessageNoID("STG2042L");
    private static final String PCT_USEDI = MessageLog.getMessageNoID("STG2043L");
    private static final String NETWORK = MessageLog.getMessageNoID("STG5048L");
    private static final String FILE_CNT = MessageLog.getMessageNoID("STG2054L");
    private static final String DIR_CNT = MessageLog.getMessageNoID("STG2055L");
    private static final String VOL_GRP = MessageLog.getMessageNoID("STG6101L");
    private static final String VOL_ALLOC = MessageLog.getMessageNoID("STG6211L");
    private static final String DETECTABLE = MessageLog.getMessageNoID("STG7748L");
    static final String YES = MessageLog.getMessageNoID("GUI0121T");
    static final String NO = MessageLog.getMessageNoID("GUI0122T");
    public String[] colNames;
    public String[] COL_LABELS = new String[]{" ", " ", PCT_FREE, USEDSPACE, FREESPACE, CAPACITY, FILE_CNT, DIR_CNT, PCT_FREE, USED_INODES, FREE_INODES};
    public String[] BYFS_LABELS = new String[]{" ", " ", DETECTABLE, PCT_FREE, USEDSPACE, FREESPACE, CAPACITY, FILE_CNT, DIR_CNT, PCT_FREE, USED_INODES, FREE_INODES, VOL_GRP, VOL_ALLOC};
    public final int QUAL_COL;
    public final int NAME_COL;
    public final int DETECTABLE_COL;
    public final int PCT_FS_COL;
    public final int USED_COL;
    public final int FREE_COL;
    public final int CAPACITY_COL;
    public final int FILE_CNT_COL;
    public final int DIR_CNT_COL;
    public final int PCT_FI_COL;
    public final int IUSED_COL;
    public final int IFREE_COL;
    public final int VGRP_COL;
    public final int ALLOC_COL;
    private GuiReportReq grr;
    private RespFSspace[] data;
    private MutableLong[] mLong;
    private MutableShort[] mShort;
    private MutableLongExt[] mLongExt;
    private int[] rendererArray;
    private boolean batch;
    private int rows;
    public int frozenRows;
    private boolean bHasTotalRow = false;
    private boolean ignoreTotalColumn = false;

    public SpaceUsedAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.frozenColumns = 2;
        if (guiReportReq.reportSubtype == 10) {
            this.colNames = this.BYFS_LABELS;
            this.QUAL_COL = 0;
            this.NAME_COL = 1;
            this.DETECTABLE_COL = 2;
            this.PCT_FS_COL = 3;
            this.USED_COL = 4;
            this.FREE_COL = 5;
            this.CAPACITY_COL = 6;
            this.FILE_CNT_COL = 7;
            this.DIR_CNT_COL = 8;
            this.PCT_FI_COL = 9;
            this.IUSED_COL = 10;
            this.IFREE_COL = 11;
            this.VGRP_COL = 12;
            this.ALLOC_COL = 13;
        } else {
            this.colNames = this.COL_LABELS;
            this.QUAL_COL = 0;
            this.NAME_COL = 1;
            this.PCT_FS_COL = 2;
            this.USED_COL = 3;
            this.FREE_COL = 4;
            this.CAPACITY_COL = 5;
            this.FILE_CNT_COL = 6;
            this.DIR_CNT_COL = 7;
            this.PCT_FI_COL = 8;
            this.IUSED_COL = 9;
            this.IFREE_COL = 10;
            this.VGRP_COL = 11;
            this.ALLOC_COL = 12;
            this.DETECTABLE_COL = -777;
        }
        if (guiReportReq.reportType == 10) {
            this.colNames[this.PCT_FS_COL] = PCT_FREE;
            this.colNames[this.PCT_FI_COL] = PCT_FREEI;
        } else {
            this.colNames[this.PCT_FS_COL] = PCT_USED;
            this.colNames[this.PCT_FI_COL] = PCT_USEDI;
        }
        switch (guiReportReq.reportSubtype) {
            case 10: {
                this.colNames[this.QUAL_COL] = COMPUTER;
                this.colNames[this.NAME_COL] = MOUNTPNT;
                this.colNames[this.DETECTABLE_COL] = DETECTABLE;
                break;
            }
            case 11: {
                this.colNames[this.QUAL_COL] = CREATOR;
                this.colNames[this.NAME_COL] = GROUP;
                this.ignoreTotalColumn = true;
                break;
            }
            case 12: {
                this.colNames[this.NAME_COL] = COMPUTER;
                break;
            }
            case 13: {
                this.colNames[this.QUAL_COL] = CREATOR;
                this.colNames[this.NAME_COL] = GROUP;
                this.ignoreTotalColumn = true;
                break;
            }
            case 82: {
                this.colNames[this.NAME_COL] = CLUSTER;
                break;
            }
            case 14: {
                this.colNames[this.NAME_COL] = DOMAIN;
                break;
            }
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[this.FREE_COL] = 7;
        this.rendererArray[this.USED_COL] = 7;
        this.rendererArray[this.CAPACITY_COL] = 7;
        this.rendererArray[this.FILE_CNT_COL] = 5;
        this.rendererArray[this.DIR_CNT_COL] = 5;
        this.rendererArray[this.IUSED_COL] = 5;
        this.rendererArray[this.IFREE_COL] = 5;
        this.rendererArray[this.PCT_FS_COL] = 6;
        this.rendererArray[this.PCT_FI_COL] = 6;
        if (guiReportReq.reportSubtype == 10) {
            this.rendererArray[this.ALLOC_COL] = 7;
        }
        switch (guiReportReq.reportSubtype) {
            case 8: {
                this.frozenColumns = 0;
                break;
            }
            case 9: {
                this.frozenColumns = 0;
                break;
            }
            case 12: 
            case 82: {
                this.hiddenColumns = new int[1];
                this.hiddenColumns[0] = this.QUAL_COL;
                break;
            }
            case 14: {
                this.hiddenColumns = new int[1];
                this.hiddenColumns[0] = this.QUAL_COL;
                break;
            }
            case 15: {
                this.frozenColumns = 0;
                this.hiddenColumns = new int[2];
                this.hiddenColumns[0] = this.QUAL_COL;
                this.hiddenColumns[1] = this.NAME_COL;
            }
        }
        this.firstColumn = guiReportReq.reportType == 9 ? this.USED_COL : (guiReportReq.reportType == 10 ? this.FREE_COL : this.CAPACITY_COL);
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
        int n = this.data.length;
        if (this.grr.reportType == 9) {
            Arrays.sort(this.data, this.frozenRows, n, new PercentSorter());
        } else if (this.grr.reportType == 10) {
            Arrays.sort(this.data, this.frozenRows, n, new PercentSorter());
        } else {
            Arrays.sort(this.data, this.frozenRows, n, new CapacitySorter());
        }
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.data = (RespFSspace[])objectArray;
        this.rows = this.data.length;
        if (this.rows > 1) {
            this.addTotal();
        }
        this.mLong = new MutableLong[this.rows];
        this.mLongExt = new MutableLongExt[this.rows];
        this.mShort = new MutableShort[this.rows];
        int n = 0;
        while (n < this.rows) {
            this.mLong[n] = new MutableLong();
            this.mLongExt[n] = new MutableLongExt();
            this.mShort[n] = new MutableShort();
            ++n;
        }
    }

    public void adjustData() {
        int n = 0;
        while (n < this.rows) {
            RespFSspace respFSspace = this.data[n];
            respFSspace.freeSpace *= 512L;
            respFSspace.usedSpace *= 512L;
            respFSspace.capacity *= 512L;
            if (this.grr.reportType == 10) {
                respFSspace.spacePercent = this.getPercent(respFSspace.freeSpace, respFSspace.usedSpace);
                respFSspace.inodePercent = this.getPercent(respFSspace.freeInodes, respFSspace.usedInodes);
            } else {
                respFSspace.spacePercent = this.getPercent(respFSspace.usedSpace, respFSspace.freeSpace);
                respFSspace.inodePercent = this.getPercent(respFSspace.usedInodes, respFSspace.freeInodes);
            }
            if (n >= this.frozenRows) {
                if (!this.batch) {
                    switch (this.grr.reportSubtype) {
                        case 10: {
                            respFSspace.creator = GuiUtil.getComputer((int)respFSspace.id).gcTSName;
                            break;
                        }
                        case 12: {
                            respFSspace.setName(GuiUtil.getComputer((int)respFSspace.id).gcTSName);
                        }
                        case 14: 
                        case 82: {
                            respFSspace.creator = " ";
                            break;
                        }
                        case 15: {
                            respFSspace.setName(NETWORK);
                            respFSspace.creator = " ";
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (this.grr.reportSubtype == 27 || this.grr.reportSubtype == 13 || this.grr.reportSubtype == 10 || this.grr.reportSubtype == 11) {
                respFSspace.creator = MessageLog.getMessageNoID("STG4136L");
                respFSspace.setName("");
            }
            ++n;
        }
    }

    public Object getArray() {
        return this.data;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public boolean hasTotalsRow() {
        return this.bHasTotalRow;
    }

    public int[] initHistoryLegend() {
        HistChartProcessor.initLegend(this.grr);
        int n = 0;
        while (n < this.data.length) {
            RespFSspace respFSspace = this.data[n];
            int n2 = respFSspace.id;
            if (this.grr.reportSubtype == 10) {
                n2 = respFSspace.fs_id;
            }
            HistChartProcessor.addLegend(this.grr, respFSspace.creator, respFSspace.getName(), n2);
            ++n;
        }
        return null;
    }

    public int[] getSelectedIDs() {
        int[] nArray = new int[this.data.length];
        int n = 0;
        while (n < this.data.length) {
            RespFSspace respFSspace = this.data[n];
            int n2 = respFSspace.id;
            if (this.grr.reportSubtype == 10) {
                n2 = respFSspace.fs_id;
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public Object getCellData(int n, int n2) {
        if (n2 == this.QUAL_COL) {
            return this.data[n].creator;
        }
        if (n2 == this.NAME_COL) {
            return this.data[n].getName();
        }
        if (n2 == this.DETECTABLE_COL) {
            if (this.bHasTotalRow && n > 0 || !this.bHasTotalRow) {
                return this.data[n].isDetectable() ? YES : NO;
            }
            return " ";
        }
        if (n2 == this.PCT_FS_COL) {
            this.mShort[n].value = this.data[n].spacePercent;
            if (this.mLongExt[n].value < 0L) {
                this.mLongExt[n].value = -1L;
            }
            return this.mShort[n];
        }
        if (n2 == this.FREE_COL) {
            this.mLong[n].value = this.data[n].freeSpace;
            if (this.mLongExt[n].value < 0L) {
                this.mLongExt[n].value = -1L;
            }
            return this.mLong[n];
        }
        if (n2 == this.USED_COL) {
            this.mLong[n].value = this.data[n].usedSpace;
            if (this.mLongExt[n].value < 0L) {
                this.mLongExt[n].value = -1L;
            }
            return this.mLong[n];
        }
        if (n2 == this.CAPACITY_COL) {
            this.mLong[n].value = this.data[n].capacity;
            if (this.mLongExt[n].value < 0L) {
                this.mLongExt[n].value = -1L;
            }
            return this.mLong[n];
        }
        if (n2 == this.FILE_CNT_COL) {
            this.mLongExt[n].value = this.data[n].fileCount;
            if (this.mLongExt[n].value < 0L) {
                this.mLongExt[n].value = -1L;
            }
            return this.mLongExt[n];
        }
        if (n2 == this.DIR_CNT_COL) {
            this.mLongExt[n].value = this.data[n].directoryCount;
            if (this.mLongExt[n].value < 0L) {
                this.mLongExt[n].value = -1L;
            }
            return this.mLongExt[n];
        }
        if (n2 == this.IUSED_COL) {
            this.mLongExt[n].value = this.data[n].usedInodes;
            if (this.mLongExt[n].value < 0L || this.mLongExt[n].value == 0L && this.data[n].freeInodes == 0L && this.data[n].inodePercent < 0) {
                this.mLongExt[n].value = -1L;
            }
            return this.mLongExt[n];
        }
        if (n2 == this.IFREE_COL) {
            this.mLongExt[n].value = this.data[n].freeInodes;
            if (this.mLongExt[n].value < 0L || this.mLongExt[n].value == 0L && this.data[n].usedInodes == 0L && this.data[n].inodePercent < 0) {
                this.mLongExt[n].value = -1L;
            }
            return this.mLongExt[n];
        }
        if (n2 == this.PCT_FI_COL) {
            this.mShort[n].value = this.data[n].inodePercent;
            if (this.mShort[n].value < 0) {
                this.mShort[n].value = (short)-1;
            }
            return this.mShort[n];
        }
        if (n2 == this.VGRP_COL) {
            return this.data[n].serialNumber;
        }
        if (n2 == this.ALLOC_COL) {
            this.mLongExt[n].value = this.data[n].unknown;
            if (this.mLongExt[n].value <= 0L) {
                this.mLongExt[n].value = -1L;
            }
            return this.mLongExt[n];
        }
        return null;
    }

    private short getPercent(long l, long l2) {
        if (l + l2 <= 0L) {
            return -1;
        }
        return (short)(l * 100L / (l + l2));
    }

    private void addTotal() {
        if (this.ignoreTotalColumn) {
            return;
        }
        this.bHasTotalRow = true;
        RespFSspace[] respFSspaceArray = new RespFSspace[this.rows + 1];
        respFSspaceArray[0] = new RespFSspace();
        respFSspaceArray[0].setName(MessageLog.getMessageNoID("STG4136L"));
        respFSspaceArray[0].serialNumber = new String(MessageLog.getMessageNoID("GEN0185T"));
        respFSspaceArray[0].creator = " ";
        respFSspaceArray[0].inodePercent = 0;
        respFSspaceArray[0].spacePercent = 0;
        int n = 0;
        while (n < this.rows) {
            if (this.data[n].capacity > 0L) {
                respFSspaceArray[0].capacity += this.data[n].capacity;
            }
            if (this.data[n].freeSpace > 0L) {
                respFSspaceArray[0].freeSpace += this.data[n].freeSpace;
            }
            if (this.data[n].usedSpace > 0L) {
                respFSspaceArray[0].usedSpace += this.data[n].usedSpace;
            }
            if (this.data[n].usedInodes > 0L) {
                respFSspaceArray[0].usedInodes += this.data[n].usedInodes;
            }
            if (this.data[n].freeInodes > 0L) {
                respFSspaceArray[0].freeInodes += this.data[n].freeInodes;
            }
            if (this.data[n].fileCount > 0L) {
                respFSspaceArray[0].fileCount += this.data[n].fileCount;
            }
            if (this.data[n].directoryCount > 0L) {
                respFSspaceArray[0].directoryCount += this.data[n].directoryCount;
            }
            if (this.data[n].unknown > 0L) {
                respFSspaceArray[0].unknown += this.data[n].unknown;
            }
            respFSspaceArray[n + 1] = this.data[n];
            ++n;
        }
        this.data = respFSspaceArray;
        this.frozenRows = 1;
        ++this.rows;
    }

    private class CapacitySorter
    implements Comparator {
        private CapacitySorter() {
        }

        public int compare(Object object, Object object2) {
            RespFSspace respFSspace = (RespFSspace)object;
            RespFSspace respFSspace2 = (RespFSspace)object2;
            if (respFSspace.capacity > respFSspace2.capacity) {
                return -1;
            }
            if (respFSspace.capacity < respFSspace2.capacity) {
                return 1;
            }
            return 0;
        }
    }

    private class PercentSorter
    implements Comparator {
        private PercentSorter() {
        }

        public int compare(Object object, Object object2) {
            RespFSspace respFSspace = (RespFSspace)object;
            RespFSspace respFSspace2 = (RespFSspace)object2;
            if (respFSspace.spacePercent > respFSspace2.spacePercent) {
                return -1;
            }
            if (respFSspace.spacePercent < respFSspace2.spacePercent) {
                return 1;
            }
            return 0;
        }
    }
}

