/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.SpaceUsedAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class SpaceUsedGrapher
extends Grapher {
    String title;
    public static final byte CHART_SIZE = 101;
    public static final byte CHART_SIZE_X = 102;
    public static final String GRAPH_SIZE_SEL = "STG1251T";
    public static final String GRAPH_SIZE = "STG7528L";
    public static final String GRAPH_SIZE_ALL = "STG1276T";
    public static final String COUNT_HIST = "STG5104L";
    public static final String COUNT_HISTORY = "STG7536L";
    public static final String FREE_HIST = "STG5105L";
    public static final String FREE_HISTORY = "STG7530L";
    public static final String FREE_PERCENT_HIST = "STG5106L";
    public static final String FREE_PERCENT_HISTORY = "STG7531L";
    public static final String USED_HIST = "STG5107L";
    public static final String USED_HISTORY = "STG7537L";
    public static final String USED_PERCENT_HIST = "STG5108L";
    public static final String USED_PERCENT_HISTORY = "STG7538L";
    public static final String CAPACITY_HIST = "STG5109L";
    public static final String CAPACITY_HISTORY = "STG7539L";

    public String getChartType(GuiReportReq guiReportReq, ReportDataAdjuster reportDataAdjuster) {
        if (guiReportReq.chartSubtype > 0) {
            return null;
        }
        this.title = guiReportReq.histSubtype == 0 ? COUNT_HIST : (guiReportReq.histSubtype == 1 ? FREE_HIST : (guiReportReq.histSubtype == 2 ? FREE_PERCENT_HIST : (guiReportReq.histSubtype == 3 ? USED_HIST : (guiReportReq.histSubtype == 4 ? USED_PERCENT_HIST : CAPACITY_HIST))));
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq guiReportReq) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, GuiChartSettingsReq guiChartSettingsReq) {
        AperiChart aperiChart = null;
        if (guiReportReq.chartSubtype > 0) {
            aperiChart = this.createChart(guiReportReq, objectArray, nArray, reportDataAdjuster, null, guiChartSettingsReq);
        } else {
            GuiReportReq guiReportReq2 = this.createHistory(guiReportReq, objectArray, nArray, this.title);
            aperiChart = (AperiChart)new SpaceHistChart().batch(guiReportReq2, guiChartSettingsReq);
        }
        return aperiChart;
    }

    public AperiCustomizableChart createChart(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, ReportDataAdjuster reportDataAdjuster, ReportingDDI reportingDDI, GuiChartSettingsReq guiChartSettingsReq) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SpaceUsedGrapher.class.getName(), "createChart", "grr, pData, rows, pAdjuster, ddi, gcsr");
        }
        RespFSspace[] respFSspaceArray = (RespFSspace[])objectArray;
        SpaceUsedAdjuster spaceUsedAdjuster = (SpaceUsedAdjuster)reportDataAdjuster;
        int n = nArray.length;
        Number[][] numberArray = new Number[2][n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[2];
        int n2 = 0;
        if (guiReportReq.reportType == 10) {
            n2 = 1;
        }
        stringArray2[n2] = SpaceUsedAdjuster.USEDSPACE;
        stringArray2[1 - n2] = SpaceUsedAdjuster.FREESPACE;
        int n3 = n - 1;
        while (n3 >= 0) {
            int n4 = nArray[n3];
            numberArray[n2][n3] = new Double(respFSspaceArray[n4].usedSpace);
            numberArray[1 - n2][n3] = new Double(respFSspaceArray[n4].freeSpace);
            switch (guiReportReq.reportSubtype) {
                case 10: {
                    stringArray[n3] = String.valueOf(respFSspaceArray[n4].creator) + " : " + respFSspaceArray[n4].getName();
                    break;
                }
                case 11: 
                case 13: {
                    stringArray[n3] = String.valueOf(respFSspaceArray[n4].creator) + "." + respFSspaceArray[n4].getName();
                    break;
                }
                case 12: 
                case 14: 
                case 15: 
                case 82: {
                    stringArray[n3] = respFSspaceArray[n4].getName();
                }
            }
            --n3;
        }
        AperiCustomizableChart aperiCustomizableChart = new AperiCustomizableChart(1, 7, numberArray, stringArray2, stringArray, new ChartOptions(), guiReportReq);
        if (reportingDDI != null) {
            reportingDDI.addChart(guiReportReq, aperiCustomizableChart, "");
        }
        return aperiCustomizableChart;
    }

    public GuiReportReq createHistory(GuiReportReq guiReportReq, Object[] objectArray, int[] nArray, String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SpaceUsedGrapher.class.getName(), "createHistory", "grr, pData, rows, actionCommand");
        }
        RespFSspace[] respFSspaceArray = (RespFSspace[])objectArray;
        GuiReportReq guiReportReq2 = guiReportReq.explode(-1);
        guiReportReq2.reportSubtype = guiReportReq.reportSubtype;
        guiReportReq2.idSubtype = -1;
        SpaceHistChart.initLegend(guiReportReq2);
        guiReportReq2.selectedResources = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            RespFSspace respFSspace = respFSspaceArray[nArray[n]];
            int n2 = respFSspace.id;
            if (guiReportReq.reportSubtype == 10) {
                n2 = respFSspace.fs_id;
            }
            guiReportReq2.selectedResources[n] = n2;
            SpaceHistChart.addLegend(guiReportReq2, respFSspace.creator, respFSspace.getName(), n2);
            ++n;
        }
        if (string == COUNT_HIST) {
            guiReportReq2.chartLabelType = (byte)6;
            guiReportReq2.histSubtype = 0;
            guiReportReq2.historyTitle = "STG4118L";
        } else if (string == FREE_HIST) {
            guiReportReq2.chartLabelType = 1;
            guiReportReq2.histSubtype = 1;
            guiReportReq2.historyTitle = "STG5111L";
        } else if (string == FREE_PERCENT_HIST) {
            guiReportReq2.chartLabelType = (byte)8;
            guiReportReq2.histSubtype = (byte)2;
            guiReportReq2.historyTitle = "STG5112L";
        } else if (string == USED_HIST) {
            guiReportReq2.chartLabelType = 1;
            guiReportReq2.histSubtype = (byte)3;
            guiReportReq2.historyTitle = "STG1278T";
        } else if (string == USED_PERCENT_HIST) {
            guiReportReq2.chartLabelType = (byte)8;
            guiReportReq2.histSubtype = (byte)4;
            guiReportReq2.historyTitle = "STG5110L";
        } else {
            guiReportReq2.chartLabelType = 1;
            guiReportReq2.histSubtype = (byte)5;
            guiReportReq2.historyTitle = "STG5113L";
        }
        guiReportReq2.reportSubtypeOrig = guiReportReq.reportSubtype;
        guiReportReq2.reportSubtype = 28;
        GuiReportReq guiReportReq3 = guiReportReq2;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(SpaceUsedGrapher.class.getName(), "createHistory", guiReportReq3);
        }
        return guiReportReq3;
    }
}

