/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.DiskAdjuster;
import org.eclipse.aperi.TStorm.common.DiskGrapher;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.gui.DiskDDI;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskTable
extends JPanel
implements ActionListener,
DisplaysChartPopupInterface,
GuiRequestor,
HistoryChoiceInterface,
TJCTableMouseInterface {
    private MegaTable dskTable = new MegaTable();
    private Share[] shArray;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private DiskAdjuster adjuster;
    private DiskGrapher grapher;
    private DiskModel diskModel;
    int dataCount;
    int[] rows;

    public DiskTable(GuiReportReq guiReportReq, ReportingDDI reportingDDI) {
        this.grr = guiReportReq;
        this.ddi = reportingDDI;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.adjuster = new DiskAdjuster(guiReportReq);
        this.grapher = new DiskGrapher();
    }

    public void handleResponse(short s, Response response) {
        this.setLayout(new BorderLayout());
        this.shArray = s <= 4 ? (Share[])response.responseData : null;
        int n = this.shArray != null ? this.shArray.length : 0;
        if (n == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.shArray, false);
        this.shArray = (Share[])this.adjuster.getArray();
        this.diskModel = new DiskModel();
        this.dskTable.setFrozenColumns(this.adjuster.frozenColumns);
        this.dskTable.setMouseListener(this);
        this.dskTable.iconChanger = this.diskModel;
        if (this.adjuster.frozenRows > 0) {
            this.dskTable.setFrozenRows(this.adjuster.frozenRows);
            this.dskTable.setFrozenRowBackground(Color.yellow);
        }
        this.dskTable.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.dskTable.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.dskTable.setCellRenderer(Date.class, TableCellRenderers.date);
        this.dskTable.setRowIcon(13, true);
        this.dskTable.alternateRowIcon = IconFactory.getBlankIcon(38, 16);
        this.dskTable.setBaseTableModel(this.diskModel);
        if (this.adjuster.firstColumn > 0) {
            this.dskTable.setAsFirstColumn(this.adjuster.firstColumn);
        }
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.dskTable, "Center");
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        if (this.grr.reportSubtype != 18 && this.grr.reportSubtype != 37) {
            return this;
        }
        return null;
    }

    public boolean select(int n, int n2) {
        return !this.adjuster.hasTotalsRow() || n != 0;
    }

    public void selectionChanged(boolean bl) {
    }

    public void doubleClick(int n, int n2) {
        if (!this.adjuster.hasTotalsRow() || n != 0) {
            new DiskDDI(null, this.shArray[n].shResourceID, this.adjuster.daArray[n].daPath, this.shArray[n].shComputerID);
        }
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
        if (this.grr.reportSubtype != 18 && this.grr.reportSubtype != 37) {
            String string;
            String string2;
            boolean bl;
            boolean bl2 = bl = this.shArray != null && this.shArray.length > 0;
            if (this.grr.reportSubtype == 39) {
                string2 = "STG5557T";
                string = "STG5558T";
            } else if (this.grr.reportSubtype == 24) {
                string2 = "STG5559T";
                string = "STG5560T";
            } else if (this.grr.reportSubtype == 23) {
                string2 = "STG5561T";
                string = "STG5562T";
            } else if (this.grr.reportSubtype == 25) {
                string2 = "STG5563T";
                string = "STG5564T";
            } else {
                string2 = "STG5565T";
                string = "STG5566T";
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID(string2));
            jMenuItem.setActionCommand("STG3207L");
            jMenuItem.setEnabled(this.dskTable.rowsSelected());
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID(string));
            jMenuItem.setEnabled(bl);
            jMenuItem.setActionCommand("STG7556L");
            jMenuItem.addActionListener(this);
            jPopupMenu.show(component, n3, n4);
            jPopupMenu.requestFocus();
        }
    }

    public void showJumpChart() {
        if (this.grr.reportSubtype != 18 && this.grr.reportSubtype != 37) {
            this.dataCount = this.shArray.length;
            this.rows = new int[this.dataCount];
            int n = 0;
            while (n < this.dataCount) {
                this.rows[n] = this.dskTable.getDataRow(n);
                ++n;
            }
            this.createHistory("STG7556L");
        }
    }

    public void showDefaultChart(int n) {
        if (this.isDataValid(n)) {
            this.rows = new int[1];
            this.rows[0] = n;
            this.dataCount = 1;
            this.createHistory("STG7556L");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "STG3207L") {
            this.rows = this.dskTable.getSelectedRows();
            this.dataCount = this.rows.length;
        } else {
            this.dataCount = this.shArray.length;
            this.rows = new int[this.dataCount];
            int n = 0;
            while (n < this.dataCount) {
                this.rows[n] = this.dskTable.getDataRow(n);
                ++n;
            }
        }
        this.createHistory(string);
    }

    private void createHistory(String string) {
        if (this.dataCount > 0) {
            GuiReportReq guiReportReq = this.grapher.createHistory(this.grr, this.shArray, this.rows, this.adjuster, string);
            this.ddi.addObject(this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", guiReportReq, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(guiReportReq.historyTitle), this);
        }
    }

    public boolean isDataValid(int n) {
        boolean bl = false;
        switch (this.grr.reportSubtype) {
            case 24: {
                if (this.adjuster.dkhArray[n].dkhGrownDefects < 0) break;
                bl = true;
                break;
            }
            case 25: {
                if (this.adjuster.dkhArray[n].dkhRecoveredReadErrors + this.adjuster.dkhArray[n].dkhRecoveredWriteErrors + this.adjuster.dkhArray[n].dkhRecoveredVerifyErrors < 0) break;
                bl = true;
                break;
            }
            case 26: {
                if (this.adjuster.dkhArray[n].dkhUnrecoveredReadErrors + this.adjuster.dkhArray[n].dkhUnrecoveredWriteErrors + this.adjuster.dkhArray[n].dkhUnrecoveredVerifyErrors < 0) break;
                bl = true;
                break;
            }
            case 39: {
                if (this.adjuster.dkhArray[n].dkhFreeSpace < 0L) break;
                bl = true;
                break;
            }
            case 23: {
                if (this.adjuster.dkhArray[n].dkhPrimaryDefects < 0) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public DiskTable(String string, String string2, String string3, String string4) {
    }

    public Object[] getChoices(int n, int n2) {
        Object[] objectArray = null;
        if (n2 != 18 && n2 != 37) {
            objectArray = new Object[3];
            String[] stringArray = new String[]{"STG7556L"};
            byte[] byArray = new byte[]{n2 == 39 ? (byte)1 : 6};
            byte[] byArray2 = new byte[]{3};
            objectArray[0] = stringArray;
            objectArray[1] = byArray;
            objectArray[2] = byArray2;
        }
        return objectArray;
    }

    public Object[] getCharts(int n, int n2) {
        return null;
    }

    public int[] getGraphID(String string) {
        int[] nArray = new int[2];
        nArray[0] = string == "STG3207L" ? 3 : 1;
        return nArray;
    }

    private class DiskModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        DiskModel() {
            this.columnNames = ((DiskTable)DiskTable.this).adjuster.colNames;
            this.rowCount = DiskTable.this.shArray.length;
            this.commonAdjuster = DiskTable.this.adjuster;
        }

        public Object getTableDataItem(int n, int n2) {
            return DiskTable.this.adjuster.getCellData(n, DiskTable.this.adjuster.translateColumn(n2));
        }

        public boolean changeIcon(int n) {
            return !DiskTable.this.isDataValid(n);
        }
    }
}

