/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.TStorm.gui.ReportingTreeLabel;
import org.eclipse.aperi.TStorm.gui.SavedReportDDI;
import org.eclipse.aperi.TStorm.gui.SavedReportNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class SavedReportLabel
extends BaseTreeNode
implements GuiRequestor,
ObjectChangeListener {
    private boolean expanded;
    private boolean systemReports;
    private String reportOwner;
    private byte productCode;

    public SavedReportLabel(boolean bl, byte by) {
        this(bl, by, 0);
    }

    public SavedReportLabel(boolean bl, byte by, int n) {
        this.systemReports = bl;
        this.productCode = by;
        String string = "";
        if (bl) {
            if (n == 1) {
                string = Util.getString("DATA");
                this.reportOwner = "Default";
            } else if (n == 3) {
                string = Util.getString("STG1240L");
                this.reportOwner = "DiskDefault";
            } else if (n == 2) {
                string = Util.getString("LABEL_FABRIC");
                this.reportOwner = "FabricDefault";
            }
        } else {
            this.reportOwner = GuiUtil.getUserName();
            string = MessageLog.getMessageNoID("STG4152L", this.reportOwner);
            ChangeManager.addListener(this, (short)35);
        }
        this.setUserObject(string);
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (!this.expanded) {
            Request request = new Request();
            GuiRequest.computerList(request);
            GuiListReq guiListReq = (GuiListReq)request.requestData;
            guiListReq.listRequested = 10035;
            guiListReq.resourceType = this.productCode;
            guiListReq.qualifier = (short)(this.systemReports ? 1 : 0);
            guiListReq.qualifierObject = this.reportOwner;
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        this.expanded = true;
        this.removeAllChildren();
        NameList nameList = (NameList)response.responseData;
        int n = 0;
        while (nameList != null) {
            String string = nameList.nlName;
            int n2 = 0;
            while (n2 < Constants.REPORT_NAMES.length) {
                if (string.equals(Constants.REPORT_NAMES[n2][0]) || string.equals(Constants.REPORT_NAMES[n2][1])) {
                    nameList.nlName = Util.getString(Constants.REPORT_NAMES[n2][1]);
                    break;
                }
                ++n2;
            }
            SavedReportNode savedReportNode = new SavedReportNode(nameList);
            BaseTree.MyTree.insertNodeInto(savedReportNode, this, n++);
            nameList = nameList.nlNext;
        }
    }

    public void changeOccurred(int n, NameList nameList) {
        switch (n) {
            case 1: {
                BaseTreeNode baseTreeNode;
                if (!this.expanded || (baseTreeNode = this.find(nameList.nlID)) != null) break;
                baseTreeNode = new SavedReportNode(nameList);
                this.addSorted(baseTreeNode);
                SavedReportDDI savedReportDDI = (SavedReportDDI)DataDisplayInfo.getCurrent();
                if (savedReportDDI.treeNode != null) {
                    savedReportDDI.treeNode.ddi = null;
                }
                SavedReportNode savedReportNode = (SavedReportNode)baseTreeNode;
                savedReportDDI.treeNode = savedReportNode;
                savedReportNode.ddi = savedReportDDI;
                savedReportNode.selectionServices = ReportingTreeLabel.selectionServiceArray[savedReportDDI.gsrr.grr.reportType];
                guiMain.getBaseTree().reselect(savedReportNode, true);
                break;
            }
            case 0: {
                BaseTreeNode baseTreeNode = this.find(nameList.nlID);
                if (baseTreeNode == null) break;
                BaseTree.MyTree.removeNodeFromParent(baseTreeNode);
                int n2 = nameList.nlName.indexOf(46) + 1;
                if (n2 > 0) {
                    nameList.nlName = nameList.nlName.substring(n2);
                }
                baseTreeNode.setUserObject(nameList);
                this.addSorted(baseTreeNode);
                break;
            }
            case -1: {
                BaseTreeNode baseTreeNode = this.find(nameList.nlID);
                if (baseTreeNode == null) break;
                BaseTree.MyTree.removeNodeFromParent(baseTreeNode);
            }
        }
    }

    private BaseTreeNode find(int n) {
        BaseTreeNode baseTreeNode = null;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            baseTreeNode = (BaseTreeNode)enumeration.nextElement();
            NameList nameList = (NameList)baseTreeNode.getUserObject();
            if (nameList.nlID == n) break;
            baseTreeNode = null;
        }
        return baseTreeNode;
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        defaultTreeCellRenderer.setIcon(NameListTreeCellRenderer.iconForType((short)35));
        defaultTreeCellRenderer.setFont(BaseTree.boldFont);
    }

    public boolean isSystemReport() {
        return this.systemReports;
    }
}

