/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.eclipse.aperi.TStorm.gui.rptfilter.WidgetListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.xmsg.MessageLog;

public class TimestampWidget
implements DocumentListener,
ItemListener,
ActionListener,
ChangeListener {
    public static final short RELATIVE = 0;
    public static final short ABSOLUTE = 1;
    private static final short N_SCALE = 2;
    public static final int BIG_INDENT = 25;
    public static final int LIL_INDENT = 5;
    private static final int REL_YEARS_FIELD = 0;
    private static final int REL_WEEKS_FIELD = 1;
    private static final int REL_DAYS_FIELD = 2;
    private static final int REL_HOURS_FIELD = 3;
    private static final int REL_MINS_FIELD = 4;
    private static final int N_REL_FIELDS = 5;
    private static final int[] relLengths = new int[]{2, 3, 3, 2, 2};
    private static final int REL_YEARS_LABEL = 5;
    private static final int REL_WEEKS_LABEL = 6;
    private static final int REL_DAYS_LABEL = 7;
    private static final int REL_HOURS_LABEL = 8;
    private static final int REL_MINS_LABEL = 9;
    private static final int N_REL_LABELS = 5;
    private static final String[] relIDs = new String[]{"STG3066L", "STG3070L", "STG3058T", "STG3071L", "STG3072L"};
    private static final int ABS_YEAR_FIELD = 0;
    private static final int ABS_HOUR_FIELD = 1;
    private static final int ABS_MIN_FIELD = 2;
    private static final int N_ABS_FIELDS = 3;
    private static final int[] absLengths = new int[]{4, 2, 2};
    private static final int ABS_MONTH_COMBO = 3;
    private static final int ABS_DAY_COMBO = 4;
    private static final int N_ABS_COMBOS = 2;
    private static final int YEAR_OFFSET = 0;
    private static final int HOUR_OFFSET = 1;
    private static final int MIN_OFFSET = 2;
    private static final int MONTH_OFFSET = 3;
    private static final int DAY_OFFSET = 4;
    private static final String[] monthNameIDs = new String[]{"GUI2001T", "GUI2002T", "GUI2003T", "GUI2004T", "GUI2005T", "GUI2006T", "GUI2007T", "GUI2008T", "GUI2009T", "GUI2010T", "GUI2011T", "GUI2012T"};
    public long number;
    public short scale;
    public transient JRadioButton[] buttons;
    private transient JTextField[] relFields;
    private transient Document[] relDocuments;
    private transient Component[] relComponents;
    private transient int[] relFieldValues;
    private transient JTextField[] absFields;
    private transient Document[] absDocuments;
    private transient int[] absFieldValues;
    private transient Component[] absComponents;
    private transient JComboBox monthList;
    private transient JComboBox dayList;
    private transient WidgetListener listener;
    private static int CANONICAL_YEAR = 31536000;
    private static int ONE_WEEK = 604800;
    private static final int[] monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public boolean isGreaterThan(long l, short s) {
        if (this.scale != s) {
            return false;
        }
        return this.number > l;
    }

    public boolean isIncomplete() {
        if (this.scale == 0 || this.absFieldValues == null) {
            return false;
        }
        return this.absFieldValues[0] < 0 || this.absFieldValues[1] < 0 || this.absFieldValues[2] < 0;
    }

    public void enableAppropriateControls() {
        int n;
        Component[] componentArray;
        Component[] componentArray2;
        if (this.scale == 0) {
            componentArray2 = this.relComponents;
            componentArray = this.absComponents;
        } else {
            componentArray2 = this.absComponents;
            componentArray = this.relComponents;
        }
        if (componentArray != null) {
            n = 0;
            while (n < componentArray.length) {
                componentArray[n].setEnabled(false);
                ++n;
            }
        }
        n = 0;
        while (n < componentArray2.length) {
            componentArray2[n].setEnabled(true);
            ++n;
        }
    }

    private void fillFieldArray(JTextField[] jTextFieldArray, int[] nArray, Document[] documentArray, int[] nArray2, boolean bl) {
        int n = 0;
        while (n < jTextFieldArray.length) {
            documentArray[n] = new SizeLimitedDocument(nArray[n], true);
            int n2 = nArray2[n];
            String string = Integer.toString(n2);
            if (bl && n >= jTextFieldArray.length - 2 && n2 < 10) {
                string = String.valueOf('0') + string;
            }
            jTextFieldArray[n] = new JTextField(documentArray[n], string, nArray[n]);
            jTextFieldArray[n].addActionListener(this);
            documentArray[n].addDocumentListener(this);
            GuiUtil.setAccessible(jTextFieldArray[n], string, string);
            ++n;
        }
    }

    private void fillLabelArray(Component[] componentArray, int n, String[] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            componentArray[n + n2] = new JLabel(MessageLog.getMessageNoID(stringArray[n2]));
            ++n2;
        }
    }

    private void decomposeRelative() {
        int n;
        if (this.scale == 1) {
            n = 0;
        } else {
            n = (int)this.number;
            if (n < 0) {
                n = -n;
            }
        }
        this.relFieldValues[0] = n / CANONICAL_YEAR;
        this.relFieldValues[1] = (n %= CANONICAL_YEAR) / ONE_WEEK;
        this.relFieldValues[2] = (n %= ONE_WEEK) / 86400;
        this.relFieldValues[3] = (n %= 86400) / 3600;
        this.relFieldValues[4] = (n %= 3600) / 60;
    }

    private void reconstructRelative() {
        this.number = this.relFieldValues[4] * 60;
        this.number += (long)(this.relFieldValues[3] * 3600);
        this.number += (long)(this.relFieldValues[2] * 86400);
        this.number += (long)(this.relFieldValues[1] * ONE_WEEK);
        this.number += (long)(this.relFieldValues[0] * CANONICAL_YEAR);
    }

    private void decomposeAbsolute() {
        Date date = this.scale == 0 ? new Date() : new Date(this.number * 1000L);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.absFieldValues[0] = gregorianCalendar.get(1);
        this.absFieldValues[1] = gregorianCalendar.get(11);
        this.absFieldValues[2] = gregorianCalendar.get(12);
        this.absFieldValues[3] = gregorianCalendar.get(2);
        this.absFieldValues[4] = gregorianCalendar.get(5);
    }

    private void reconstructAbsolute() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(this.absFieldValues[0], this.absFieldValues[3], this.absFieldValues[4], this.absFieldValues[1], this.absFieldValues[2], 0);
        Date date = gregorianCalendar.getTime();
        this.number = date.getTime() / 1000L;
    }

    private void reconstruct() {
        if (this.scale == 0) {
            this.reconstructRelative();
        } else {
            this.reconstructAbsolute();
        }
    }

    private boolean yearIsLeap(int n) {
        return (n & 3) == 0;
    }

    private int daysInMonth(int n, int n2) {
        int n3 = monthDays[n2];
        if (n2 == 1 && this.yearIsLeap(n)) {
            ++n3;
        }
        return n3;
    }

    public TimestampWidget(long l, short s, WidgetListener widgetListener, String string) {
        this.number = l;
        this.scale = s;
        this.listener = widgetListener;
        this.buttons = new JRadioButton[2];
        String string2 = MessageLog.getMessageNoID(string);
        this.buttons[0] = new JRadioButton(string2);
        GuiUtil.setAccessible(this.buttons[0], string2, string2);
        string2 = MessageLog.getMessageNoID("STG3065L");
        this.buttons[1] = new JRadioButton(string2);
        GuiUtil.setAccessible(this.buttons[1], string2, string2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.buttons[0]);
        buttonGroup.add(this.buttons[1]);
        this.buttons[this.scale].setSelected(true);
    }

    public TimestampWidget(long l, short s, WidgetListener widgetListener) {
        this(l, s, widgetListener, "STG3270L");
    }

    public Component makeRelativePanel() {
        this.relFields = new JTextField[5];
        this.relDocuments = new Document[5];
        this.relFieldValues = new int[5];
        this.decomposeRelative();
        this.fillFieldArray(this.relFields, relLengths, this.relDocuments, this.relFieldValues, false);
        this.relComponents = new JComponent[10];
        int n = 0;
        while (n < 5) {
            this.relComponents[n] = this.relFields[n];
            ++n;
        }
        this.fillLabelArray(this.relComponents, 5, relIDs);
        this.buttons[0].addChangeListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 3;
        gridBagConstraints.insets.right = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        n = 5;
        while (n < this.relComponents.length - 1) {
            jPanel.add(this.relComponents[n], gridBagConstraints);
            ++n;
        }
        gridBagConstraints.gridwidth = 0;
        jPanel.add(this.relComponents[n], gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        n = 0;
        while (n < 4) {
            jPanel.add((Component)this.relFields[n], gridBagConstraints);
            ++n;
        }
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.relFields[n], gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalStrut(30), gridBagConstraints);
        return jPanel;
    }

    public Component makeAbsolutePanel() {
        this.absFields = new JTextField[3];
        this.absDocuments = new Document[3];
        this.absFieldValues = new int[5];
        this.decomposeAbsolute();
        this.fillFieldArray(this.absFields, absLengths, this.absDocuments, this.absFieldValues, true);
        this.absComponents = new JComponent[5];
        int n = 0;
        while (n < 3) {
            this.absComponents[n] = this.absFields[n];
            ++n;
        }
        Object[] objectArray = new Object[monthNameIDs.length];
        n = 0;
        while (n < monthNameIDs.length) {
            objectArray[n] = MessageLog.getMessageNoID(monthNameIDs[n]);
            ++n;
        }
        this.monthList = new TComboBox(objectArray);
        this.monthList.setSelectedIndex(this.absFieldValues[3]);
        this.absComponents[3] = this.monthList;
        this.dayList = new TComboBox();
        int n2 = this.daysInMonth(this.absFieldValues[0], this.absFieldValues[3]);
        n = 1;
        while (n <= n2) {
            this.dayList.addItem(Integer.toString(n));
            ++n;
        }
        this.dayList.setSelectedIndex(this.absFieldValues[4] - 1);
        this.absComponents[4] = this.dayList;
        this.dayList.addItemListener(this);
        this.monthList.addItemListener(this);
        GuiUtil.setAccessible(this.monthList, Util.getString("NAME_MONTHSLIST"), Util.getString("DESCRIPTION_MONTHSLIST"));
        GuiUtil.setAccessible(this.dayList, Util.getString("NAME_DAYSLIST"), Util.getString("DESCRIPTION_DAYSLIST"));
        this.buttons[1].addChangeListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 3;
        gridBagConstraints.insets.right = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        if (!GuiUtil.wrapAtWords()) {
            jPanel.add((Component)this.absFields[0], gridBagConstraints);
            jPanel.add((Component)this.monthList, gridBagConstraints);
            jPanel.add((Component)this.dayList, gridBagConstraints);
        } else if (Locale.getDefault().toString().equals("en_US")) {
            jPanel.add((Component)this.monthList, gridBagConstraints);
            jPanel.add((Component)this.dayList, gridBagConstraints);
            jPanel.add((Component)this.absFields[0], gridBagConstraints);
        } else {
            jPanel.add((Component)this.dayList, gridBagConstraints);
            jPanel.add((Component)this.monthList, gridBagConstraints);
            jPanel.add((Component)this.absFields[0], gridBagConstraints);
        }
        gridBagConstraints.insets.right = 2;
        jPanel.add((Component)this.absFields[1], gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        JLabel jLabel = new JLabel(":");
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(1));
        jLabel.setForeground(Color.black);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.right = 15;
        jPanel.add((Component)this.absFields[2], gridBagConstraints);
        return jPanel;
    }

    public Component makeSwitchable(boolean bl) {
        Component component;
        Component component2;
        int n;
        int n2;
        Component component3 = this.makeRelativePanel();
        Component component4 = this.makeAbsolutePanel();
        this.enableAppropriateControls();
        if (bl) {
            n2 = 0;
            n = 1;
            component2 = component3;
            component = component4;
        } else {
            n2 = 1;
            n = 0;
            component2 = component4;
            component = component3;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = MessageLog.getMessageNoID("STG3063L");
        jPanel.setBorder(GuiUtil.getBorder(string));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)this.buttons[n2], gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.left = 25;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add(component2, gridBagConstraints);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)this.buttons[n], gridBagConstraints);
        gridBagConstraints.insets.left = 25;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 15;
        jPanel.add(component, gridBagConstraints);
        return jPanel;
    }

    public void setFocus() {
        JTextField jTextField = this.scale == 0 ? this.relFields[2] : this.absFields[0];
        jTextField.requestFocus();
    }

    private int whichDocument(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        int n = 0;
        while (n < this.relDocuments.length && this.relDocuments[n] != document) {
            ++n;
        }
        if (n < this.relDocuments.length) {
            if (this.scale == 0) {
                return n;
            }
            return Integer.MAX_VALUE;
        }
        n = 0;
        while (n < this.absDocuments.length && this.absDocuments[n] != document) {
            ++n;
        }
        if (n < this.absDocuments.length && this.scale == 1) {
            return ~n;
        }
        return Integer.MAX_VALUE;
    }

    private void possiblyAdjustDays() {
        int n;
        int n2 = this.daysInMonth(this.absFieldValues[0], this.absFieldValues[3]);
        if (n2 != (n = this.dayList.getItemCount())) {
            if (n2 > n) {
                do {
                    this.dayList.addItem(Integer.toString(++n));
                } while (n < n2);
            } else {
                do {
                    this.dayList.removeItemAt(--n);
                } while (n > n2);
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        boolean bl;
        int n = this.whichDocument(documentEvent);
        if (n == Integer.MAX_VALUE) {
            return;
        }
        boolean bl2 = n >= 0;
        String string = null;
        int n2 = 0;
        if (bl2) {
            Document document = this.relDocuments[n];
            int n3 = document.getLength();
            try {
                string = document.getText(0, n3);
            }
            catch (BadLocationException badLocationException) {}
            this.relFieldValues[n] = Integer.parseInt(string);
            this.reconstructRelative();
            bl = true;
        } else {
            if (this.absFieldValues[n ^= 0xFFFFFFFF] < 0) {
                n2 = 1;
            }
            Document document = this.absDocuments[n];
            int n4 = document.getLength();
            try {
                string = document.getText(0, n4);
            }
            catch (BadLocationException badLocationException) {}
            this.absFieldValues[n] = Integer.parseInt(string);
            if (n == 0) {
                this.possiblyAdjustDays();
            }
            boolean bl3 = bl = !this.isIncomplete();
            if (bl) {
                this.reconstructAbsolute();
            }
        }
        if (bl && this.listener != null) {
            this.listener.valueChanged(n2);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        boolean bl;
        int n = this.whichDocument(documentEvent);
        if (n == Integer.MAX_VALUE) {
            return;
        }
        boolean bl2 = n >= 0;
        String string = null;
        int n2 = 0;
        if (bl2) {
            Document document = this.relDocuments[n];
            int n3 = document.getLength();
            if (n3 == 0) {
                this.relFieldValues[n] = 0;
            } else {
                try {
                    string = document.getText(0, n3);
                }
                catch (BadLocationException badLocationException) {}
                this.relFieldValues[n] = Integer.parseInt(string);
            }
            this.reconstructRelative();
            bl = true;
        } else {
            bl = !this.isIncomplete();
            Document document = this.absDocuments[n ^= 0xFFFFFFFF];
            int n4 = document.getLength();
            if (n4 == 0) {
                this.absFieldValues[n] = -1;
                n2 = -1;
            } else {
                try {
                    string = document.getText(0, n4);
                }
                catch (BadLocationException badLocationException) {}
                this.absFieldValues[n] = Integer.parseInt(string);
            }
            if (n == 0) {
                this.possiblyAdjustDays();
            }
            if (bl && n2 == 0) {
                this.reconstructAbsolute();
            }
        }
        if (bl && this.listener != null) {
            this.listener.valueChanged(n2);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        int n = 0;
        AbstractButton abstractButton = null;
        while (n < 2 && (abstractButton = this.buttons[n]) != object) {
            n = (short)(n + 1);
        }
        if (n >= 2 || !abstractButton.isSelected()) {
            return;
        }
        this.scale = (short)n;
        this.enableAppropriateControls();
        if (this.isIncomplete()) {
            n = -1;
        } else {
            this.reconstruct();
            n = 1;
        }
        if (this.listener != null) {
            this.listener.valueChanged(n);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.dayList) {
            this.absFieldValues[4] = this.dayList.getSelectedIndex() + 1;
        } else if (object == this.monthList) {
            this.absFieldValues[3] = this.monthList.getSelectedIndex();
            this.possiblyAdjustDays();
        } else {
            return;
        }
        this.reconstructAbsolute();
        if (!this.isIncomplete() && this.listener != null) {
            this.listener.valueChanged(0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIncomplete()) {
            Toolkit.getDefaultToolkit().beep();
        } else if (this.listener != null) {
            this.listener.notifyEnterStruck();
        }
    }
}

