/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class ConfigParser {
    public String configFile;
    private StreamTokenizer tokenizer;
    private Map map;
    private BufferedReader reader;

    public ConfigParser(String string) {
        this.configFile = string;
    }

    private void initializeTokenizer() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ConfigParser.class.getName(), "initializeTokenizer", "");
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(this.configFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(ConfigParser.class.getName(), "initializeTokenizer", fileNotFoundException);
            }
            MessageLog.logException("GEN0029E", fileNotFoundException);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(ConfigParser.class.getName(), "initializeTokenizer");
            }
            throw new GeneralException();
        }
        this.map = new HashMap();
        this.reader = new BufferedReader(fileReader);
        this.tokenizer = new StreamTokenizer(this.reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(47, 47);
        this.tokenizer.wordChars(92, 92);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.wordChars(45, 45);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(34);
        this.tokenizer.quoteChar(39);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.lowerCaseMode(false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ConfigParser.class.getName(), "initializeTokenizer");
        }
    }

    private int nextToken(boolean bl, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ConfigParser.class.getName(), "nextToken", "tokenRequired, expectedTokenType");
        }
        if (this.tokenizer.ttype != -1) {
            try {
                this.tokenizer.nextToken();
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(ConfigParser.class.getName(), "nextToken", iOException);
                }
                MessageLog.logException("AGT0035W", (Exception)iOException, this.configFile);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(ConfigParser.class.getName(), "nextToken");
                }
                throw new GeneralException();
            }
        }
        if (this.tokenizer.ttype == -1) {
            if (bl) {
                MessageLog.logMessage("AGT0037W", this.configFile);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(ConfigParser.class.getName(), "nextToken");
                }
                throw new GeneralException();
            }
        } else {
            if (this.tokenizer.ttype == 34 || this.tokenizer.ttype == 39) {
                this.tokenizer.ttype = -3;
            }
            if (n != 0 && n != this.tokenizer.ttype) {
                MessageLog.logMessage("AGT0045E", this.configFile, new Integer(this.tokenizer.lineno()));
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(ConfigParser.class.getName(), "nextToken");
                }
                throw new GeneralException();
            }
        }
        int n2 = this.tokenizer.ttype;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ConfigParser.class.getName(), "nextToken", n2);
        }
        return n2;
    }

    private boolean getKeyValuePair(String[] stringArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ConfigParser.class.getName(), "getKeyValuePair", "keyValuePair");
        }
        if (this.nextToken(false, 0) == -1) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(ConfigParser.class.getName(), "getKeyValuePair", bl);
            }
            return bl;
        }
        if (this.tokenizer.ttype != -3) {
            MessageLog.logMessage("AGT0045E", this.configFile, new Integer(this.tokenizer.lineno()));
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(ConfigParser.class.getName(), "getKeyValuePair");
            }
            throw new GeneralException();
        }
        stringArray[0] = this.tokenizer.sval.toLowerCase();
        this.nextToken(true, 61);
        this.nextToken(true, -3);
        stringArray[1] = this.tokenizer.sval;
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ConfigParser.class.getName(), "getKeyValuePair", bl);
        }
        return bl;
    }

    public void readValues(String[][] stringArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ConfigParser.class.getName(), "readValues", "variables");
        }
        this.initializeTokenizer();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n][0].toLowerCase();
            this.map.put(string, stringArray[n]);
            ++n;
        }
        String[] stringArray2 = new String[2];
        try {
            while (this.getKeyValuePair(stringArray2)) {
                String[] stringArray3 = (String[])this.map.get(stringArray2[0]);
                if (stringArray3 == null) continue;
                stringArray3[1] = stringArray2[1];
            }
        }
        finally {
            block12: {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    if (!TraceLogger.enableTrace) break block12;
                    TraceLogger.exception(ConfigParser.class.getName(), "readValues", iOException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ConfigParser.class.getName(), "readValues");
        }
    }
}

