/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.Serializable;

public class SoftwareVersion
implements Serializable,
Comparable {
    static final long serialVersionUID = 2952212367749539552L;
    private static final int VENDOR_MULTIPLIER = 10000000;
    private static final int VERSION_MULTIPLIER = 1000000;
    private static final int RELEASE_MULTIPLIER = 10000;
    private static final int MODIFICATION_MULTIPLIER = 100;
    public static final int VERSION_2_1_0 = SoftwareVersion.encode(2, 1, 0);
    public static final int VERSION_1_4_0 = SoftwareVersion.encode(1, 4, 0);
    public static final int VERSION_1_3_3 = SoftwareVersion.encode(1, 3, 3);
    public static final int VERSION_2_2_1 = SoftwareVersion.encode(2, 2, 1);
    public SoftwareVersion svNext;
    public byte svVersion = 0;
    public byte svRelease = 0;
    public short svModification = 0;
    public byte svVendor = 0;
    public short svSubModification = 0;
    public static final byte APERI = 0;
    public static final byte IBM = 1;

    public static byte getVendor() {
        return 0;
    }

    public SoftwareVersion(byte by, byte by2, short s, short s2, byte by3) {
        this.svVersion = by;
        this.svRelease = by2;
        this.svModification = s;
        this.svSubModification = s2;
        this.svVendor = by3;
    }

    public SoftwareVersion() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(Byte.toString(this.svVersion));
        stringBuffer.append('.');
        stringBuffer.append(Byte.toString(this.svRelease));
        stringBuffer.append('.');
        stringBuffer.append(Short.toString(this.svModification));
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        SoftwareVersion softwareVersion = (SoftwareVersion)object;
        int n = this.svVendor - softwareVersion.svVendor;
        if (n == 0 && (n = this.svVersion - softwareVersion.svVersion) == 0 && (n = this.svRelease - softwareVersion.svRelease) == 0 && (n = this.svModification - softwareVersion.svModification) == 0) {
            n = this.svSubModification - softwareVersion.svSubModification;
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public static int encode(int n, int n2, int n3, int n4, int n5) {
        return n * 10000000 + n2 * 1000000 + n3 * 10000 + n4 * 100 + n5;
    }

    public static int encode(int n, int n2, int n3) {
        return SoftwareVersion.encode(0, n, n2, n3, 0);
    }

    public static String decode(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n % 10000000;
        stringBuffer.append(n / 10000000);
        stringBuffer.append('.');
        int n3 = n2 % 1000000;
        stringBuffer.append(n2 / 1000000);
        stringBuffer.append('.');
        int n4 = n3 % 10000;
        stringBuffer.append(n3 / 10000);
        stringBuffer.append('.');
        int n5 = n4 % 100;
        stringBuffer.append(n4 / 100);
        stringBuffer.append('.');
        stringBuffer.append(n5);
        return stringBuffer.toString();
    }

    public static SoftwareVersion decodeToSV(int n) {
        SoftwareVersion softwareVersion = new SoftwareVersion();
        int n2 = n % 10000000;
        softwareVersion.svVendor = (byte)(n / 10000000);
        int n3 = n2 % 1000000;
        softwareVersion.svVersion = (byte)(n2 / 1000000);
        int n4 = n3 % 10000;
        softwareVersion.svRelease = (byte)(n3 / 10000);
        int n5 = n4 % 100;
        softwareVersion.svModification = (short)(n4 / 100);
        softwareVersion.svSubModification = (short)n5;
        return softwareVersion;
    }
}

