/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.dbaccess;

import java.net.InetAddress;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.SlpAttributes;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.Vendor;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.util.SRMCrypto;

public class CIMOMDbAccess {
    static final String className = CIMOMDbAccess.class.getName();
    private static final String DEVICE_TYPE_UNKNOWN = "type_unknown";
    private static final String VENDOR_UNKNOWN = "vendor_unknown";
    private static final Map stParsDevTypeDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.SaxParsing.SubsystemTypes");
    private static final Map stParsVendorDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.SaxParsing.Vendors");
    private static final Map stParsNSpcDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.SaxParsing.NameSpaces");
    private static final Map stDevTypeDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.ReqSync.SubsystemTypes");
    private static final Map stVendorDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.ReqSync.Vendors");
    private static final Map stNSpcDef = CIMOMDbAccess.getDefinitionForSync("CIMClientWrapper.ReqSync.NameSpaces");
    protected static Map<String, Boolean> stSaxParsing = Collections.synchronizedMap(new HashMap());
    protected static Map<String, Boolean> stConcurrentAccess = Collections.synchronizedMap(new HashMap());
    private static int cUniqueInt = 0;
    private static final short UNIQUENUMBERLENGTHDEFAULT = 7;

    public static CIMOM getCIMMOMByDBKey(int n) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(className, "getCIMMOMByDBKey", new Object[]{String.valueOf(n)});
        CIMOM cIMOM = null;
        try {
            DBConnection dBConnection = ServiceUtils.getConnection();
            DBCursor dBCursor = null;
            if (dBConnection == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
            }
            try {
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResRegisteredCimomTable.getColumnInfo("REG_CIMOM_ID"), Integer.toString(n));
                    dBCursor = RegisteredCimom.getCursor(dBConnection, hashtable, null);
                    if (dBCursor == null) {
                        throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                    }
                    if (dBCursor.next()) {
                        RegisteredCimom registeredCimom = ((RegisteredCimom.RegisteredCimomCursor)dBCursor).getObject();
                        if (registeredCimom == null || registeredCimom.getStatus() == CIMOMConnectionStatus.PENDING_DELETION.toID()) {
                            throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                        }
                        cIMOM = CIMOMDbAccess.createCIMOMObject(registeredCimom, dBConnection, logTraceHelper);
                    }
                }
                catch (SQLException sQLException) {
                    logTraceHelper.traceError("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            finally {
                try {
                    if (dBCursor != null) {
                        dBCursor.close();
                    }
                    dBConnection.close();
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
        }
        finally {
            logTraceHelper.exit(null);
        }
        return cIMOM;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CIMOM[] getCIMOMs(String[] stringArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(className, "getCIMOMs", stringArray);
        Object[] objectArray = new CIMOM[]{};
        try {
            DBConnection dBConnection = ServiceUtils.getConnection();
            if (dBConnection == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, logTraceHelper);
            }
            RegisteredCimom.RegisteredCimomCursor registeredCimomCursor = null;
            Vector<String> vector = new Vector<String>();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    vector.add(stringArray[n]);
                    ++n;
                }
            }
            Vector<CIMOM> vector2 = new Vector<CIMOM>();
            try {
                try {
                    registeredCimomCursor = RegisteredCimom.getCursor(dBConnection, null, null);
                    if (registeredCimomCursor == null) {
                        throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                    }
                    while (registeredCimomCursor.next()) {
                        RegisteredCimom registeredCimom = registeredCimomCursor.getObject();
                        if (registeredCimom == null) {
                            throw DiskMessageHelper.getServerException("HWN021801E", null, logTraceHelper);
                        }
                        String string = registeredCimom.getServiceUrl();
                        if (vector.size() != 0 && !vector.contains(string) || registeredCimom.getStatus() == CIMOMConnectionStatus.PENDING_DELETION.toID()) continue;
                        CIMOM cIMOM = CIMOMDbAccess.createCIMOMObject(registeredCimom, dBConnection, logTraceHelper);
                        vector2.add(cIMOM);
                    }
                }
                catch (SQLException sQLException) {
                    logTraceHelper.traceError("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            finally {
                try {
                    if (registeredCimomCursor != null) {
                        registeredCimomCursor.close();
                    }
                    dBConnection.close();
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
                }
            }
            objectArray = new CIMOM[vector2.size()];
            vector2.copyInto(objectArray);
            return objectArray;
        }
        finally {
            logTraceHelper.exit(objectArray);
        }
    }

    private static CIMOM createCIMOMObject(RegisteredCimom registeredCimom, DBConnection dBConnection, LogTraceHelper logTraceHelper) throws SQLException, ServerException {
        Object object;
        SlpAttributes.SlpAttributesCursor slpAttributesCursor = null;
        String string = registeredCimom.getServiceUrl();
        CIMOM cIMOM = new CIMOM();
        cIMOM.setServiceUrl(string);
        cIMOM.setHiName(registeredCimom.getHiName());
        cIMOM.setDescription(registeredCimom.getDescription());
        cIMOM.setSoftwareLevel(registeredCimom.getSoftwareLevel());
        cIMOM.setProtocolVersion(registeredCimom.getProtocolVersion());
        cIMOM.setAuthenticationMechanism(registeredCimom.getAuthenticationMechanism());
        cIMOM.setUserId(registeredCimom.getUserId());
        cIMOM.setServiceId(String.valueOf(registeredCimom.getRegCimomId()));
        String string2 = registeredCimom.getPassword();
        if (string2 != null) {
            try {
                cIMOM.setPassword(SRMCrypto.decrypt(string2));
            }
            catch (Exception exception) {
                logTraceHelper.traceError("Failed to decrypt password " + string2 + " for CIMOM " + string + "due to " + exception.getMessage(), exception);
            }
        }
        cIMOM.setTrustStoreLocation(registeredCimom.getTrustStoreLocation());
        cIMOM.setTrustStorePassphrase(registeredCimom.getTrustStorePassphrase());
        cIMOM.setInteropSchemaNamespace(registeredCimom.getInteropSchemaNamespace());
        cIMOM.setProtocol(registeredCimom.getProtocol());
        cIMOM.setDisplayName(registeredCimom.getDisplayName());
        cIMOM.setStatus(CIMOMConnectionStatus.getStatus(registeredCimom.getStatus()));
        Timestamp timestamp = registeredCimom.getStatusTimestamp();
        if (timestamp != null) {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(timestamp);
            cIMOM.setStatusTimestamp((Calendar)object);
        }
        try {
            try {
                slpAttributesCursor = SlpAttributes.getCursor(dBConnection, null, null);
                if (slpAttributesCursor == null) {
                    throw DiskMessageHelper.getServerException("HWN021804E", string, logTraceHelper);
                }
                object = new String();
                while (slpAttributesCursor.next()) {
                    SlpAttributes slpAttributes = slpAttributesCursor.getObject();
                    if (slpAttributes == null) {
                        throw DiskMessageHelper.getServerException("HWN021804E", string, logTraceHelper);
                    }
                    if (slpAttributes.getRegCimomId() != registeredCimom.getRegCimomId()) continue;
                    object = String.valueOf(object) + slpAttributes.getAttributeName() + ":" + slpAttributes.getValue();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Getting CIMOMs failed due to " + sQLException.getMessage(), sQLException);
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
            }
        }
        finally {
            try {
                if (slpAttributesCursor != null) {
                    slpAttributesCursor.close();
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)sQLException.getMessage(), sQLException, logTraceHelper);
            }
        }
        return cIMOM;
    }

    public static final boolean needsSaxParsing(String string) {
        LogTraceHelper logTraceHelper = null;
        Boolean bl = null;
        try {
            bl = stSaxParsing.get(string);
            if (bl == null) {
                logTraceHelper = LogTraceHelper.entry(CIMOMDbAccess.class.getName(), "needsSaxParsing", new Object[]{string});
                String string2 = "subsystem type";
                bl = CIMOMDbAccess.checkForSubsystemCIMOMParsing(string);
                if (bl == null) {
                    string2 = "switch vendor";
                    bl = CIMOMDbAccess.checkForVendorParsing(string, CIMOMDbAccess.getSwitchVendorForCIMOM(string));
                    if (bl == null) {
                        string2 = "tape library vendor";
                        bl = CIMOMDbAccess.checkForVendorParsing(string, CIMOMDbAccess.getLibraryVendorForCIMOM(string));
                        if (bl == null) {
                            string2 = "namespace";
                            bl = CIMOMDbAccess.checkForNamespaceofCIMOMParsing(string);
                            if (bl == null) {
                                bl = Boolean.FALSE;
                                return false;
                            }
                        }
                    }
                }
                logTraceHelper.traceWarning("Caching 'SAX parsing needed = " + bl.toString() + "' for CIMOM " + string + " (Reason: " + string2 + ")");
                stSaxParsing.put(string, bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (logTraceHelper != null) {
                logTraceHelper.exit(bl);
            }
        }
    }

    private static final Boolean checkForNamespaceofCIMOMParsing(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(CIMOMDbAccess.class.getName(), "checkForNamespaceofCIMOMParsing", new Object[]{string});
        Boolean bl = null;
        try {
            List list = CIMOMDbAccess.getNamespacesForCIMOM(string);
            Iterator iterator = list.iterator();
            String string2 = null;
            String string3 = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                string3 = (String)stParsNSpcDef.get(string2);
                if (string3 == null) continue;
                bl = Boolean.TRUE;
            }
            Boolean bl2 = bl;
            return bl2;
        }
        finally {
            logTraceHelper.exit(bl);
        }
    }

    private static final Boolean checkForVendorParsing(String string, String string2) {
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block3: {
            logTraceHelper = LogTraceHelper.entry(CIMOMDbAccess.class.getName(), "checkForVendorParsing", new Object[]{string, string2});
            bl = null;
            try {
                if (!VENDOR_UNKNOWN.equals(string2)) break block3;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stParsVendorDef.get(string2);
        bl = string3 == null ? Boolean.FALSE : Boolean.TRUE;
        Boolean bl2 = bl;
        logTraceHelper.exit(bl);
        return bl2;
    }

    private static final Boolean checkForSubsystemCIMOMParsing(String string) {
        String string2;
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block3: {
            logTraceHelper = LogTraceHelper.entry(CIMOMDbAccess.class.getName(), "checkForSubsystemCIMOMParsing", new Object[]{string});
            bl = null;
            try {
                string2 = CIMOMDbAccess.getSubsystemTypeForCIMOM(string);
                if (!DEVICE_TYPE_UNKNOWN.equals(string2) && !"Unknown".equals(string2)) break block3;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stParsDevTypeDef.get(string2);
        bl = string3 == null ? Boolean.FALSE : Boolean.TRUE;
        Boolean bl2 = bl;
        logTraceHelper.exit(bl);
        return bl2;
    }

    public static final boolean allowsConcurrentAccess(String string) {
        LogTraceHelper logTraceHelper = null;
        Boolean bl = null;
        try {
            bl = stConcurrentAccess.get(string);
            if (bl == null) {
                logTraceHelper = LogTraceHelper.entry(CIMOMDbAccess.class.getName(), "allowsConcurrentAccess", new Object[]{string});
                String string2 = "subsystem type";
                bl = CIMOMDbAccess.checkForSubsystemCIMOM(string);
                if (bl == null) {
                    string2 = "switch vendor";
                    bl = CIMOMDbAccess.checkForVendor(string, CIMOMDbAccess.getSwitchVendorForCIMOM(string));
                    if (bl == null) {
                        string2 = "tape library vendor";
                        bl = CIMOMDbAccess.checkForVendor(string, CIMOMDbAccess.getLibraryVendorForCIMOM(string));
                        if (bl == null) {
                            string2 = "namespace";
                            bl = CIMOMDbAccess.checkForNamespaceofCIMOM(string);
                            if (bl == null) {
                                bl = Boolean.TRUE;
                                return true;
                            }
                        }
                    }
                }
                logTraceHelper.traceWarning("Caching 'concurrent access = " + bl.toString() + "' for CIMOM " + string + " (Reason: " + string2 + ")");
                stConcurrentAccess.put(string, bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (logTraceHelper != null) {
                logTraceHelper.exit(bl);
            }
        }
    }

    private static final Boolean checkForSubsystemCIMOM(String string) {
        String string2;
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block3: {
            logTraceHelper = LogTraceHelper.entry(CIMOMDbAccess.class.getName(), "checkForSubsystemCIMOM", new Object[]{string});
            bl = null;
            try {
                string2 = CIMOMDbAccess.getSubsystemTypeForCIMOM(string);
                if (!DEVICE_TYPE_UNKNOWN.equals(string2) && !"Unknown".equals(string2)) break block3;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stDevTypeDef.get(string2);
        bl = string3 == null ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl2 = bl;
        logTraceHelper.exit(bl);
        return bl2;
    }

    private static final Boolean checkForNamespaceofCIMOM(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(CIMOMDbAccess.class.getName(), "checkForNamespaceofCIMOM", new Object[]{string});
        Boolean bl = null;
        try {
            List list = CIMOMDbAccess.getNamespacesForCIMOM(string);
            Iterator iterator = list.iterator();
            String string2 = null;
            String string3 = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                string3 = (String)stNSpcDef.get(string2);
                if (string3 == null) continue;
                bl = Boolean.FALSE;
            }
            Boolean bl2 = bl;
            return bl2;
        }
        finally {
            logTraceHelper.exit(bl);
        }
    }

    private static final Boolean checkForVendor(String string, String string2) {
        Boolean bl;
        LogTraceHelper logTraceHelper;
        block3: {
            logTraceHelper = LogTraceHelper.entry(CIMOMDbAccess.class.getName(), "checkForVendor", new Object[]{string, string2});
            bl = null;
            try {
                if (!VENDOR_UNKNOWN.equals(string2)) break block3;
                logTraceHelper.exit(bl);
                return null;
            }
            catch (Throwable throwable) {
                logTraceHelper.exit(bl);
                throw throwable;
            }
        }
        String string3 = (String)stVendorDef.get(string2);
        bl = string3 == null ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl2 = bl;
        logTraceHelper.exit(bl);
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getSubsystemTypeForCIMOM(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ss.").append("TYPE").append(" from ");
        stringBuffer.append(StorageSubsystem.getTablename()).append(" as ss where ss.");
        stringBuffer.append("SUBSYSTEM_ID").append(" in (select ck.");
        stringBuffer.append("SUBSYSTEM_ID").append(" from ").append(CimkeySubsystem.getTablename());
        stringBuffer.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
        stringBuffer.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
        stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?)))");
        DBConnection dBConnection = null;
        DBPreparedStatement dBPreparedStatement = null;
        DBResultSet dBResultSet = null;
        try {
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            if (dBResultSet.next()) {
                String string2 = dBResultSet.getString(1);
                return string2;
            }
            return DEVICE_TYPE_UNKNOWN;
        }
        catch (Exception exception) {
            return DEVICE_TYPE_UNKNOWN;
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getSwitchVendorForCIMOM(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select v.").append("VENDOR_NAME").append(" from ");
        stringBuffer.append(Vendor.getTablename()).append(" as v where v.").append("VENDOR_ID").append(" in (");
        stringBuffer.append("select sw.").append("VENDOR_ID").append(" from ");
        stringBuffer.append(Switch.getTablename()).append(" as sw where sw.");
        stringBuffer.append("SWITCH_WWN").append(" in (select ck.");
        stringBuffer.append("SWITCH_WWN").append(" from ").append(CimkeySwitch.getTablename());
        stringBuffer.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
        stringBuffer.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
        stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?))))");
        DBConnection dBConnection = null;
        DBPreparedStatement dBPreparedStatement = null;
        DBResultSet dBResultSet = null;
        try {
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            if (dBResultSet.next()) {
                String string2 = dBResultSet.getString(1);
                return string2;
            }
            return VENDOR_UNKNOWN;
        }
        catch (Exception exception) {
            return VENDOR_UNKNOWN;
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getLibraryVendorForCIMOM(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select v.").append("VENDOR_NAME").append(" from ");
        stringBuffer.append(Vendor.getTablename()).append(" as v where v.").append("VENDOR_ID").append(" in (");
        stringBuffer.append("select tf.").append("VENDOR_ID").append(" from ");
        stringBuffer.append(TapeFrame.getTablename()).append(" as tf where tf.");
        stringBuffer.append("TAPE_LIBRARY_ID").append(" in (select ck.");
        stringBuffer.append("TAPE_LIBRARY_ID").append(" from ").append(CimkeyTapeLibrary.getTablename());
        stringBuffer.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
        stringBuffer.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
        stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?))))");
        DBConnection dBConnection = null;
        DBPreparedStatement dBPreparedStatement = null;
        DBResultSet dBResultSet = null;
        try {
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            if (dBResultSet.next()) {
                String string2 = dBResultSet.getString(1);
                return string2;
            }
            return VENDOR_UNKNOWN;
        }
        catch (Exception exception) {
            return VENDOR_UNKNOWN;
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private static final List getNamespacesForCIMOM(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select c2n.").append("NAMESPACE").append(" from ").append(Cimom2namespace.getTablename());
        stringBuffer.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        stringBuffer.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        stringBuffer.append(" as rc where rc.").append("SERVICE_URL").append("=?)");
        DBConnection dBConnection = null;
        DBPreparedStatement dBPreparedStatement = null;
        DBResultSet dBResultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            dBConnection = ServiceUtils.getConnection();
            dBPreparedStatement = dBConnection.prepareStatement(stringBuffer.toString());
            dBPreparedStatement.clearParameters();
            dBPreparedStatement.setString(1, string);
            dBResultSet = dBPreparedStatement.executeQuery();
            while (dBResultSet.next()) {
                arrayList.add(dBResultSet.getString(1));
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            ArrayList arrayList3 = new ArrayList();
            return arrayList3;
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
                if (dBPreparedStatement != null) {
                    dBPreparedStatement.close();
                }
                if (dBConnection != null) {
                    dBConnection.commit();
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private static final Map getDefinitionForSync(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(className, "getDefinitionForSync", new Object[]{string});
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string2 = DiskManagerConfigSvc.getConfigValue(string, null);
            if (string2 != null && string2.trim().length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "]");
                String string3 = null;
                String[] stringArray = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken().substring(1);
                    stringArray = string3.split(";");
                    logTraceHelper.traceWarning("Using synchronized access for device type " + string3);
                    if (stringArray.length > 1) {
                        hashMap.put(stringArray[0], stringArray[1]);
                        continue;
                    }
                    hashMap.put(stringArray[0], "*");
                }
            }
            HashMap<String, String> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            logTraceHelper.exit(hashMap);
        }
    }

    public static int getCIMOMIDforURL(String string) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(className, "getCIMOMIDforURL", new Object[]{string});
        DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        DBResultSet dBResultSet = null;
        int n = 0;
        try {
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResRegisteredCimomTable.getColumnInfo("SERVICE_URL"), string);
            String string2 = "SELECT REG_CIMOM_ID,SERVICE_URL FROM " + TResRegisteredCimomTable.getTablename() + " WHERE " + "SERVICE_URL" + " = ?";
            dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
            if (dBResultSet.next()) {
                n = dBResultSet.getInt(1);
            }
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.closeAll();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database result set due to " + sQLException.getMessage(), sQLException);
            }
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database connection due to " + sQLException.getMessage(), sQLException);
            }
            logTraceHelper.exit(Integer.toString(n));
        }
        return n;
    }

    public static CIMOM[] findCIMOMsByNetAddress(InetAddress inetAddress) {
        try {
            CIMOM[] cIMOMArray = CIMOMDbAccess.searchCimomInDb(inetAddress.getHostAddress());
            if (cIMOMArray.length == 0) {
                cIMOMArray = CIMOMDbAccess.searchCimomInDb(inetAddress.getCanonicalHostName());
            }
            return cIMOMArray;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private static CIMOM[] searchCimomInDb(String string) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(className, "searchCimomInDb", new Object[]{string});
        DBResultSet dBResultSet = null;
        CIMOM[] cIMOMArray = null;
        DBConnection dBConnection = null;
        try {
            dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResRegisteredCimomTable.getColumnInfo("SERVICE_URL"), "%//" + string + ":%");
            String string2 = "SELECT REG_CIMOM_ID,SERVICE_URL FROM " + TResRegisteredCimomTable.getTablename() + " WHERE " + "SERVICE_URL" + " LIKE (?)";
            dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (dBResultSet.next()) {
                arrayList.add(dBResultSet.getString("SERVICE_URL"));
            }
            CIMOM[] cIMOMArray2 = cIMOMArray = CIMOMDbAccess.getCIMOMs(arrayList.toArray(new String[arrayList.size()]));
            return cIMOMArray2;
        }
        finally {
            try {
                if (dBResultSet != null) {
                    dBResultSet.closeAll();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database result set due to " + sQLException.getMessage(), sQLException);
            }
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database connection due to " + sQLException.getMessage(), sQLException);
            }
            logTraceHelper.exit(cIMOMArray);
        }
    }

    public static String getUniqueNumberString() {
        int n;
        String string;
        int n2 = 7;
        if ((string = Integer.toString(n = cUniqueInt++)).length() > n2) {
            return string.substring(string.length() - n2);
        }
        if (string.length() < n2) {
            return String.valueOf("000000000000000000000000000".substring(0, n2 - string.length())) + string;
        }
        return string;
    }

    public static int getRegCimomIDForCimomURL(String string, ILogger iLogger) throws Exception {
        DBConnection dBConnection;
        String string2 = "getRegCimomIDForCimomURL";
        int n = -1;
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, string);
        }
        if ((dBConnection = ServiceUtils.getConnection()) == null) {
            return -1;
        }
        String string3 = "SELECT REG_CIMOM_ID FROM " + TResRegisteredCimomTable.getTablename() + " " + "WHERE SERVICE_URL = '" + string + "'";
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.text(IRecordType.TYPE_INFO, className, string2, "query = " + string3);
        }
        DBResultSet dBResultSet = null;
        try {
            try {
                dBResultSet = ComplexQuery.sqlQuery(dBConnection, string3, new Hashtable());
                if (dBResultSet.next()) {
                    n = dBResultSet.getInt(1);
                }
                dBConnection.commit();
            }
            catch (Exception exception) {
                if (iLogger != null && iLogger.isLogging()) {
                    iLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
                }
                throw exception;
            }
        }
        catch (Throwable throwable) {
            try {
                if (dBResultSet != null) {
                    dBResultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (dBResultSet != null) {
                dBResultSet.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (dBConnection != null) {
                dBConnection.close();
            }
        }
        catch (Exception exception) {}
        if (iLogger != null && iLogger.isLogging()) {
            iLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return n;
    }
}

