/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.AlertLogDetailPanel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertLogDetailDDI
extends DataDisplayInfo
implements GuiRequestor {
    private ExtAlertLog record;
    private boolean textFetched;

    public AlertLogDetailDDI(ExtAlertLog extAlertLog) {
        this.record = extAlertLog;
        this.textFetched = false;
        String string = AlertConditionManager.getConditionMessageId(this.record.alAlertCondition);
        string = string != null ? MessageLog.getMessageNoID(string) : "?";
        Object[] objectArray = new Object[]{string};
        this.setDescription(MessageLog.getMessageNoID("GUI2030L", objectArray));
    }

    private void create() {
        this.panel = new AlertLogDetailPanel(this.record);
        this.show();
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        this.textFetched = true;
        this.record.alMessage = (String)((Object)response.responseData);
        this.create();
    }

    private void submitRequest() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.server.AlertLogIDHndlr.Message";
        request.flags = (byte)4;
        request.requestData = this.record;
        GuiClient.doRequest(this, request);
    }

    public void reDisplay() {
        if (this.panel != null) {
            this.show();
        } else if (this.textFetched) {
            this.create();
        } else {
            this.submitRequest();
        }
    }
}

