/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.FilterResultsViewer;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;

public class FilterPanel
extends GridBagPanel
implements ListSelectionListener,
ActionListener {
    private Vector filterVec;
    private JList filterList;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private DefaultListModel listModel;
    private short resourceType;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public FilterPanel(Vector vector, Insets insets, short s) {
        super(new Insets(0, insets.left, 0, insets.right));
        String string;
        this.filterVec = vector;
        this.resourceType = s;
        this.filterVec.trimToSize();
        this.filterList = new JList(this.filterVec);
        this.filterList.setSelectionMode(0);
        this.filterList.setSelectedIndex(0);
        this.filterList.setVisibleRowCount(3);
        switch (s) {
            case 89: {
                string = Util.getString("LABEL_COMPUTER_FILTERS");
                break;
            }
            case 93: {
                string = Util.getString("LABEL_DA_FILTERS");
                break;
            }
            case 90: {
                string = Util.getString("LABEL_FS_FILTERS");
                break;
            }
            default: {
                string = "";
            }
        }
        this.add((JComponent)new JLabel(string), new Insets(2, 0, 0, 0));
        this.newRow();
        JScrollPane jScrollPane = new JScrollPane(this.filterList);
        this.add(jScrollPane, 3, 1, 2, new Insets(0, 0, 0, 0));
        this.newRow();
        this.addButton = new JButton(Util.getString("NAME_ADD"));
        this.editButton = new JButton(Util.getString("LABEL_EDIT"));
        this.removeButton = new JButton(Util.getString("LABEL_DELETE"));
        this.add((JComponent)this.addButton, 22, 0, new Insets(2, 4, 0, 0));
        this.add((JComponent)this.editButton, 22, 0, new Insets(2, 4, 0, insets.right));
        this.add((JComponent)this.removeButton, 22, 0, new Insets(2, 4, 0, insets.right));
        if (vector.size() == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.filterList.addListSelectionListener(this);
        this.addButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.removeButton.addActionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.filterList.isSelectionEmpty()) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton || object == this.editButton) {
            FilterResultsViewer filterResultsViewer = object == this.addButton ? new FilterResultsViewer(this.guiMain.getFrame(), FilterResultsViewer.ADD, this, 0, null, this.resourceType, Util.getString("TITLE_ADD_FILTER")) : new FilterResultsViewer(this.guiMain.getFrame(), FilterResultsViewer.EDIT, this, this.filterList.getSelectedIndex(), this.filterList.getSelectedValue(), this.resourceType, Util.getString("TITLE_EDIT_FILTER"));
            GuiUtil.centerDialog(filterResultsViewer);
            filterResultsViewer.displayDialog();
        } else if (object == this.removeButton) {
            this.removeSelectedFilter();
        }
    }

    public boolean addFilter(String string) {
        return this.addFilter(string, this.filterList.getModel().getSize());
    }

    public boolean addFilter(String string, int n) {
        if (this.filterVec.contains(string)) {
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI1620E"), "GUI1620E", 0);
            return false;
        }
        int n2 = this.filterList.getSelectedIndex();
        this.filterVec.add(n, string);
        this.filterList.setListData(this.filterVec);
        this.filterList.setSelectedIndex(n2);
        return true;
    }

    public void removeSelectedFilter() {
        int n = this.filterList.getSelectedIndex();
        this.filterVec.remove(n);
        this.filterVec.trimToSize();
        this.filterList.setListData(this.filterVec);
        int n2 = this.filterVec.size();
        if (n2 == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            if (n == n2) {
                --n;
            }
            this.filterList.setSelectedIndex(n);
        }
    }

    public boolean updateFilter(String string) {
        if (this.filterVec.contains(string)) {
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI1620E"), "GUI1620E", 0);
            return false;
        }
        int n = this.filterList.getSelectedIndex();
        this.removeSelectedFilter();
        this.addFilter(string, n);
        return true;
    }
}

