/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.eclipse.aperi.gui.DoubleLineBorder;
import org.eclipse.aperi.gui.GuiUtil;

public class GridBagPanel
extends JPanel {
    public static final int HORZ = 2;
    public static final int VERT = 3;
    public static final int BOTH = 1;
    public static final int NONE = 0;
    public static final int CENTER = 10;
    public static final int WEST = 21;
    public static final int EAST = 22;
    public static final int NW = 23;
    public static final int NE = 24;
    public static final int SW = 25;
    public static final int SE = 26;
    public static final int NORTH = 19;
    public static final int SOUTH = 20;
    public static final Color TEXT_COLOR = new Color(72, 102, 150);
    private int WIDTH = 1;
    private int HEIGHT = 1;
    public static final Dimension TEXTFIELDSIZE = new Dimension(165, 25);
    public static final Dimension TEXTAREASIZE;
    public static final Dimension TABLESIZE;
    private GridBagConstraints gbc;
    private Insets m_insets;
    private Insets titleInsets = new Insets(10, 5, 2, 8);
    private Insets subtitleInsets = new Insets(10, 10, 2, 8);
    private Insets descriptionInsets = new Insets(4, 12, 12, 8);
    private int m_anchor = 23;
    private int m_column = 0;
    private int m_fill = 0;
    private int m_row = 0;
    private JLabel topLabel = new JLabel();
    private JLabel descriptionLabel;

    static {
        TABLESIZE = TEXTAREASIZE = new Dimension(165, 100);
    }

    public GridBagPanel() {
        this(new Insets(4, 12, 4, 8));
    }

    public GridBagPanel(Insets insets) {
        super(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = this.m_anchor;
        this.gbc.insets = this.m_insets = insets;
        this.gbc.fill = this.m_fill;
    }

    public void setDefaultAnchor(int n) {
        this.gbc.anchor = this.m_anchor = n;
    }

    public void setDefaultInsets(Insets insets) {
        this.gbc.insets = this.m_insets = insets;
    }

    public void setTitle(String string) {
        this.topLabel = new JLabel(string);
        Font font = this.topLabel.getFont();
        this.topLabel.setFont(font.deriveFont(1, (float)font.getSize() + 4.0f));
        this.topLabel.setBorder(new DoubleLineBorder(this.topLabel.getForeground(), this.topLabel.getForeground()));
        this.add(this.topLabel, 0, 1, 2, this.titleInsets);
        this.newRow();
    }

    public void changeTitle(String string) {
        this.topLabel.setText(string);
    }

    public void setDescription(String string) {
        JTextArea jTextArea = new JTextArea(){

            public boolean isFocusable() {
                return false;
            }
        };
        Font font = jTextArea.getFont();
        jTextArea.setFont(font.deriveFont(0, font.getSize()));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(GuiUtil.wrapAtWords());
        jTextArea.setText(string);
        jTextArea.setForeground(this.topLabel.getForeground());
        jTextArea.setBackground(this.getBackground());
        this.add(jTextArea, 0, 1, 2, this.descriptionInsets);
        this.newRow();
    }

    public void changeDescription(String string) {
        this.descriptionLabel.setText(string);
    }

    public void setSubtitle(String string) {
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(1, (float)font.getSize() + 1.0f));
        jLabel.setBorder(new DoubleLineBorder(jLabel.getForeground(), null));
        this.add(jLabel, 0, 1, 2, this.subtitleInsets);
        this.newRow();
        this.gbc.insets = this.m_insets = new Insets(this.m_insets.top, this.subtitleInsets.left, this.m_insets.bottom, this.m_insets.right);
    }

    public void setSubtitleDescription(String string) {
        JTextArea jTextArea = new JTextArea(){

            public boolean isFocusable() {
                return false;
            }
        };
        Font font = jTextArea.getFont();
        this.topLabel.setFont(font.deriveFont(0, font.getSize()));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(GuiUtil.wrapAtWords());
        jTextArea.setText(string);
        jTextArea.setBackground(this.getBackground());
        this.add(jTextArea, 0, 1, 2, new Insets(4, 18, 2, 8));
        this.newRow();
    }

    public void newRow() {
        ++this.m_row;
        this.m_column = 0;
    }

    public void skipColumn() {
        ++this.m_column;
    }

    public void add(JComponent jComponent) {
        this.addComponent(jComponent, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, this.m_fill);
    }

    public void add(JComponent jComponent, int n) {
        this.addComponent(jComponent, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, n);
    }

    public void add(JComponent jComponent, Insets insets) {
        this.gbc.insets = insets;
        this.addComponent(jComponent, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, this.m_fill);
    }

    public void add(JComponent jComponent, int n, int n2) {
        this.addComponent(jComponent, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, n, n2);
    }

    public void add(JComponent jComponent, int n, Insets insets) {
        this.gbc.insets = insets;
        this.addComponent(jComponent, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, n);
    }

    public void add(JComponent jComponent, int n, int n2, Insets insets) {
        this.gbc.insets = insets;
        this.addComponent(jComponent, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, n, n2);
    }

    public void add(JComponent jComponent, int n, int n2, int n3) {
        this.addComponent(jComponent, this.m_row, this.m_column, n, n2, this.m_anchor, n3);
    }

    public void add(JComponent jComponent, int n, int n2, int n3, Insets insets) {
        this.gbc.insets = insets;
        this.addComponent(jComponent, this.m_row, this.m_column, n, n2, this.m_anchor, n3);
    }

    public void add(JComponent jComponent, int n, int n2, int n3, int n4, int n5, int n6, Insets insets) {
        this.gbc.insets = insets;
        this.addComponent(jComponent, n, n2, n3, n4, n5, n6);
    }

    public void createBox() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.getBackground());
        this.addComponent(jPanel, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, 0);
    }

    public void createStretchBox() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.getBackground());
        this.addComponent(jPanel, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, 1);
    }

    public void addComponent(JComponent jComponent, int n, int n2, int n3, int n4, int n5, int n6) {
        this.gbc.gridx = n2;
        this.gbc.gridy = n;
        this.gbc.gridwidth = n3;
        this.gbc.gridheight = n4;
        this.gbc.anchor = n5;
        switch (n6) {
            case 2: {
                this.gbc.weightx = 1.0;
                this.gbc.weighty = 0.0;
                break;
            }
            case 3: {
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 1.0;
                break;
            }
            case 1: {
                this.gbc.weightx = 1.0;
                this.gbc.weighty = 1.0;
                break;
            }
            case 0: {
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 0.0;
                break;
            }
        }
        this.gbc.fill = n6;
        super.add((Component)jComponent, this.gbc);
        this.gbc.insets = this.m_insets;
        this.gbc.anchor = this.m_anchor;
        this.m_column = n2 + n3;
        this.m_row = n + n4 - 1;
    }
}

