/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.eclipse.aperi.gui.About;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.HelpBrokerTS;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

public class Help
implements ActionListener {
    private static HelpSet rootHelpSet = null;
    public static HelpBrokerTS helpBroker = null;
    private static final String HELP_ROOT_DIR = "org/eclipse/aperi/gui/help/";
    private static final String helpSetNameData = "data/data_helpset.hs";
    private static final String helpSetNameADM = "admin_services/adm_services_helpset.hs";
    private static final String helpSetNameCommon = "common/common_helpset.hs";
    private static final String helpSetNameDisk = "disk/disk_manager_helpset.hs";
    private static final String helpSetNameFabric = "fabric/fabric_helpset.hs";
    private static final String helpSetNameTape = "tape/tape_helpset.hs";
    private static final String helpSetNameGettingStarted = "getting_started/gettingstarted_helpset.hs";
    public static final String defaultHelp = "welcome_gettingstarted";
    public static final String helpDirText = MessageLog.getMessageNoID("GUI0073L");
    public static final String helpCSText = MessageLog.getMessageNoID("GUI0075L");
    public static final String helpAboutText = MessageLog.getMessageNoID("GUI0074L");
    private JMenuItem helpDir = new JMenuItem();
    private JMenuItem helpCS = new JMenuItem();
    private JMenuItem about = new JMenuItem();

    public Help() {
        this.buildHelpRoot(helpSetNameGettingStarted);
        this.addHelpSet(helpSetNameADM);
        this.addHelpSet(helpSetNameCommon);
        this.addHelpSet(helpSetNameData);
        this.addHelpSet(helpSetNameDisk);
        this.addHelpSet(helpSetNameFabric);
        this.addHelpSet(helpSetNameTape);
    }

    private URL findHelpSet(String string) {
        URL uRL = HelpSet.findHelpSet((ClassLoader)Help.class.getClassLoader(), (String)(HELP_ROOT_DIR + string));
        if (uRL == null) {
            throw new RuntimeException("Help Set org/eclipse/aperi/gui/help/" + string + " not found");
        }
        return uRL;
    }

    private HelpSet newHelpSet(String string) {
        HelpSet helpSet = null;
        try {
            helpSet = new HelpSet(Help.class.getClassLoader(), this.findHelpSet(string));
        }
        catch (HelpSetException helpSetException) {
            System.out.println("Help Set " + string + " could not be loaded.");
            helpSetException.printStackTrace();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            System.err.println("initialization error:");
            exceptionInInitializerError.getException().printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return helpSet;
    }

    private void buildHelpRoot(String string) {
        IGuiMain iGuiMain = GuiManager.getGuiManager().getGuiMain();
        rootHelpSet = this.newHelpSet(string);
        if (rootHelpSet != null) {
            helpBroker = new HelpBrokerTS(rootHelpSet);
            helpBroker.enableHelpKey(iGuiMain.getFrame(), defaultHelp, null);
        }
    }

    private void addHelpSet(String string) {
        HelpSet helpSet;
        if (rootHelpSet != null && (helpSet = this.newHelpSet(string)) != null) {
            rootHelpSet.add(helpSet);
        }
    }

    protected void createMenu(JMenu jMenu) {
        jMenu.add(this.helpDir);
        this.helpDir.setText(helpDirText);
        this.helpDir.addActionListener(this);
        GuiUtil.setAccessible(this.helpDir, helpDirText, helpDirText);
        jMenu.add(this.helpCS);
        this.helpCS.setText(MessageLog.getMessageNoID("GUI0075L"));
        this.helpCS.addActionListener(helpBroker);
        this.helpCS.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        GuiUtil.setAccessible(this.helpCS, helpCSText, helpCSText);
        jMenu.add(this.about);
        this.about.setText(MessageLog.getMessageNoID("GUI0074L"));
        this.about.addActionListener(this);
        GuiUtil.setAccessible(this.about, helpAboutText, helpAboutText);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.helpDir) {
            helpBroker.setCurrentID(defaultHelp);
            helpBroker.setDisplayed(true);
        } else if (object == this.about) {
            new About();
        }
    }

    public static void setHelpID(Component component, String string) {
        if (helpBroker != null) {
            helpBroker.enableHelp(component, string, rootHelpSet);
        }
    }

    public static void setCurrentID(String string) {
        helpBroker.setCurrentID(string);
    }

    public static void setDisplayed(boolean bl) {
        helpBroker.setDisplayed(bl);
    }

    public static ActionListener getDisplayHelpFromSource() {
        ActionListener actionListener = null;
        if (helpBroker != null) {
            actionListener = helpBroker.getDisplayHelpFromSource();
        }
        return actionListener;
    }

    public static boolean isValidID(String string) {
        boolean bl = false;
        if (rootHelpSet != null) {
            bl = rootHelpSet.getCombinedMap().isValidID(string, rootHelpSet);
        }
        return bl;
    }
}

