/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DateTimeSelector;
import org.eclipse.aperi.gui.GuiMain;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TimeSelector;
import org.eclipse.aperi.xmsg.MessageLog;

public class JSgcScheduleCreateWhenData
implements ActionListener {
    protected GridBagConstraints gbcIndent = new GridBagConstraints();
    protected GridBagConstraints gbcIndentLast = new GridBagConstraints();
    protected GridBagConstraints gbcPlop = new GridBagConstraints();
    protected GridBagConstraints gbcLast = new GridBagConstraints();
    protected GridBagConstraints gbcThree = new GridBagConstraints();
    protected Insets insetA = new Insets(0, 18, 0, 0);
    protected Insets insetB = new Insets(0, 55, 0, 0);
    protected Insets insetC = new Insets(0, 36, 0, 0);
    protected Insets insetD = new Insets(3, 36, 0, 0);
    protected Insets insetE = new Insets(0, 18, 5, 0);
    JPanel panel;
    protected JPanel whenPanel;
    JPanel zonePanel;
    protected JLabel filler = new JLabel(" ");
    protected JRadioButton runApplicationDefined;
    protected JRadioButton runNow;
    protected JRadioButton runOnce;
    protected JRadioButton runRepeat;
    protected DateTimeSelector onceDateTime;
    protected DateTimeSelector repeatDateTime;
    protected TimeSelector repeatTime;
    JLabel runAt = new JLabel();
    protected JRadioButton repeatRepeat;
    protected JRadioButton repeatOnDays;
    protected JComboBox repeatNumber;
    protected JComboBox repeatTerm;
    protected JCheckBox repeatSunday;
    protected JCheckBox repeatMonday;
    protected JCheckBox repeatTuesday;
    protected JCheckBox repeatWednesday;
    protected JCheckBox repeatThursday;
    protected JCheckBox repeatFriday;
    protected JCheckBox repeatSaturday;
    protected JRadioButton zoneLocal;
    protected JRadioButton zoneGlobal;
    protected JRadioButton tzServer;
    protected JRadioButton tzZone;
    protected JComboBox zoneName;
    protected boolean repeatOnDaysOnly;
    protected String[] repeatChoices = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99"};
    protected String[] repeatTypes = new String[]{MessageLog.getMessageNoID("GUI5034L"), MessageLog.getMessageNoID("GUI5035L"), MessageLog.getMessageNoID("GUI5036L"), MessageLog.getMessageNoID("GUI5037L"), MessageLog.getMessageNoID("GUI5038L")};
    String[] zoneChoices = new String[]{MessageLog.getMessageNoID("GUI5041L"), MessageLog.getMessageNoID("GUI5042L")};
    int currentYear;
    int currentMonth;
    int currentDay;
    int currentHour;
    int currentMinute;
    int currentAmPm;
    public Object[] msgParm = new String[1];
    protected short startYear;
    boolean serverJob;
    protected ScheduleHeader header;
    private CreateOrEditDDI DDI;
    protected boolean noRepeats;
    private short jobType;
    private boolean displayLastScheduledTime;
    protected static IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public JSgcScheduleCreateWhenData(short s, CreateOrEditDDI createOrEditDDI) {
        this(s, createOrEditDDI, false, false, null);
    }

    public JSgcScheduleCreateWhenData(short s, CreateOrEditDDI createOrEditDDI, boolean bl) {
        this(s, createOrEditDDI, bl, false, null);
    }

    public JSgcScheduleCreateWhenData(short s, CreateOrEditDDI createOrEditDDI, boolean bl, boolean bl2) {
        this(s, createOrEditDDI, bl, false, null);
        this.displayLastScheduledTime = bl2;
    }

    public JSgcScheduleCreateWhenData(short s, CreateOrEditDDI createOrEditDDI, boolean bl, boolean bl2, JRadioButton jRadioButton) {
        String string;
        this.DDI = createOrEditDDI;
        this.repeatOnDaysOnly = bl;
        this.noRepeats = bl2;
        this.runApplicationDefined = jRadioButton;
        this.jobType = s;
        switch (s) {
            case 16: {
                string = "GUI5045L";
                break;
            }
            case 17: {
                this.serverJob = true;
                string = "GUI5044L";
                break;
            }
            case 36: {
                string = "GUI5075L";
                break;
            }
            default: {
                this.serverJob = true;
                string = "STG4092L";
            }
        }
        this.msgParm[0] = Util.getString(string);
    }

    public JPanel build(ScheduleHeader scheduleHeader) {
        this.header = scheduleHeader;
        this.setDefaults();
        this.gbcIndent.anchor = 17;
        this.gbcIndentLast.anchor = 17;
        this.gbcIndentLast.gridwidth = 0;
        this.gbcPlop.anchor = 17;
        this.gbcLast.anchor = 17;
        this.gbcLast.gridwidth = 0;
        this.gbcThree.anchor = 17;
        this.gbcThree.gridwidth = 3;
        this.gbcThree.insets = this.insetC;
        this.makeWhenPanel();
        this.makeZonePanel();
        this.panel = GuiUtil.getPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.whenPanel, "North");
        if (this.jobType != 104) {
            this.panel.add((Component)this.zonePanel, "Center");
        }
        this.setFields();
        this.enableWhenFields();
        this.addListeners();
        return this.panel;
    }

    private void setDefaults() {
        if (this.header.scheduleType == 0) {
            this.header.scheduleType = 1;
        }
        if (this.serverJob) {
            this.header.timezoneType = (byte)2;
        }
        Calendar calendar = Calendar.getInstance();
        this.startYear = (short)calendar.get(1);
        if (this.startYear < 2000) {
            this.startYear = (short)2000;
        }
        if (this.header.startYear < 2000) {
            this.header.startYear = this.startYear;
            this.header.startMonth = (short)(calendar.get(2) + 1);
            this.header.startDay = (short)calendar.get(5);
            this.header.startHour = (short)calendar.get(11);
            this.header.startMinute = (short)calendar.get(12);
        }
        if (this.header.startYear < this.startYear) {
            this.startYear = this.header.startYear;
        }
    }

    protected void makeWhenPanel() {
        this.whenPanel = new JPanel();
        this.whenPanel.setBorder(GuiUtil.getBorder(MessageLog.getMessageNoID("GUI5046L")));
        this.whenPanel.setLayout(new BorderLayout());
        JPanel jPanel = this.getPanel1();
        if (!this.repeatOnDaysOnly) {
            this.whenPanel.add((Component)jPanel, "North");
        }
        this.whenPanel.add((Component)this.getPanel2(), "Center");
        this.whenPanel.add((Component)this.getPanel3(), "South");
    }

    protected JPanel getPanel1() {
        JPanel jPanel = GuiUtil.getPanel();
        this.runNow = new JRadioButton(MessageLog.getMessageNoID("GUI8219L"));
        this.runOnce = new JRadioButton(MessageLog.getMessageNoID("GUI8220L"));
        this.runRepeat = new JRadioButton(MessageLog.getMessageNoID("GUI8221L"));
        GuiUtil.setAccessible(this.runNow, MessageLog.getMessageNoID("GUI5018L"), MessageLog.getMessageNoID("GUI5018L"));
        GuiUtil.setAccessible(this.runOnce, MessageLog.getMessageNoID("GUI5019L"), MessageLog.getMessageNoID("GUI5019L"));
        GuiUtil.setAccessible(this.runRepeat, MessageLog.getMessageNoID("GUI5020L"), MessageLog.getMessageNoID("GUI5020L"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.runNow);
        buttonGroup.add(this.runOnce);
        if (!this.noRepeats) {
            buttonGroup.add(this.runRepeat);
        }
        if (this.runApplicationDefined != null) {
            buttonGroup.add(this.runApplicationDefined);
            jPanel.add((Component)this.runApplicationDefined, this.gbcLast);
        }
        jPanel.add((Component)this.runNow, this.gbcLast);
        jPanel.add((Component)this.runOnce, this.gbcLast);
        this.gbcIndent.insets = this.insetA;
        this.onceDateTime = new DateTimeSelector(this.header.startYear, this.header.startMonth, this.header.startDay, this.header.startHour, this.header.startMinute);
        jPanel.add((Component)this.onceDateTime, this.gbcIndent);
        GuiUtil.setAccessible(this.onceDateTime, Util.getString("LABEL_DATE_TIME_SELECTOR"), Util.getString("LABEL_DATE_TIME_SELECTOR"));
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    protected JPanel getPanel2() {
        JPanel jPanel = GuiUtil.getPanel();
        this.repeatDateTime = new DateTimeSelector(this.header.startYear, this.header.startMonth, this.header.startDay, this.header.startHour, this.header.startMinute);
        GuiUtil.setAccessible(this.repeatDateTime, Util.getString("LABEL_DATE_TIME_SELECTOR"), Util.getString("LABEL_DATE_TIME_SELECTOR"));
        this.repeatRepeat = new JRadioButton(MessageLog.getMessageNoID("GUI5048L"));
        this.repeatOnDays = new JRadioButton(MessageLog.getMessageNoID("GUI5049L"));
        GuiUtil.setAccessible(this.repeatRepeat, MessageLog.getMessageNoID("GUI5048L"), MessageLog.getMessageNoID("GUI5048L"));
        GuiUtil.setAccessible(this.repeatOnDays, MessageLog.getMessageNoID("GUI5049L"), MessageLog.getMessageNoID("GUI5049L"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.repeatRepeat);
        buttonGroup.add(this.repeatOnDays);
        this.repeatNumber = new TComboBox(this.repeatChoices);
        this.repeatTerm = new TComboBox(this.repeatTypes);
        GuiUtil.setAccessible(this.repeatNumber, MessageLog.getMessageNoID("GUI5048L"), MessageLog.getMessageNoID("GUI5048L"));
        GuiUtil.setAccessible(this.repeatTerm, MessageLog.getMessageNoID("GUI5048L"), MessageLog.getMessageNoID("GUI5048L"));
        if (this.repeatOnDaysOnly) {
            this.runAt.setText(MessageLog.getMessageNoID("GUI0258L"));
            this.gbcIndentLast.insets = this.insetE;
            jPanel.add((Component)this.runAt, this.gbcIndentLast);
            if (this.displayLastScheduledTime) {
                short[] sArray = this.repeatDateTime.getDateTime();
                Calendar calendar = Calendar.getInstance();
                calendar.set(sArray[0], sArray[1], sArray[2], sArray[3], sArray[4]);
                this.repeatTime = new TimeSelector();
                this.repeatTime.setTime(calendar.getTime().getTime());
            } else {
                this.repeatTime = new TimeSelector();
            }
            GuiUtil.setAccessible(this.repeatTime, Util.getString("LABEL_DATE_TIME_SELECTOR"), Util.getString("LABEL_DATE_TIME_SELECTOR"));
            this.gbcIndentLast.insets = this.insetA;
            if (!this.noRepeats) {
                jPanel.add((Component)this.repeatTime, this.gbcIndentLast);
            }
        } else if (!this.noRepeats) {
            jPanel.add((Component)this.runRepeat, this.gbcLast);
            this.runAt.setText(MessageLog.getMessageNoID("GUI5047L"));
            this.gbcIndentLast.insets = this.insetE;
            jPanel.add((Component)this.runAt, this.gbcIndentLast);
            this.gbcIndentLast.insets = this.insetA;
            jPanel.add((Component)this.repeatDateTime, this.gbcIndentLast);
            jPanel.add((Component)this.filler, this.gbcLast);
            jPanel.add((Component)this.repeatRepeat, this.gbcThree);
            jPanel.add((Component)this.repeatNumber, this.gbcPlop);
            jPanel.add((Component)this.repeatTerm, this.gbcLast);
        }
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    protected JPanel getPanel3() {
        Serializable serializable;
        JPanel jPanel = GuiUtil.getPanel();
        this.gbcIndentLast.insets = this.insetC;
        if (!this.noRepeats) {
            if (this.repeatOnDaysOnly) {
                serializable = new JLabel(MessageLog.getMessageNoID("GUI0259L"));
                jPanel.add((Component)serializable, this.gbcIndentLast);
            } else {
                jPanel.add((Component)this.repeatOnDays, this.gbcIndentLast);
            }
        }
        this.repeatSunday = new JCheckBox(MessageLog.getMessageNoID("GUI5050L"));
        this.repeatMonday = new JCheckBox(MessageLog.getMessageNoID("GUI5051L"));
        this.repeatTuesday = new JCheckBox(MessageLog.getMessageNoID("GUI5052L"));
        this.repeatWednesday = new JCheckBox(MessageLog.getMessageNoID("GUI5053L"));
        this.repeatThursday = new JCheckBox(MessageLog.getMessageNoID("GUI5054L"));
        this.repeatFriday = new JCheckBox(MessageLog.getMessageNoID("GUI5055L"));
        this.repeatSaturday = new JCheckBox(MessageLog.getMessageNoID("GUI5056L"));
        GuiUtil.setAccessible(this.repeatSunday, MessageLog.getMessageNoID("GUI5050L"), MessageLog.getMessageNoID("GUI5050L"));
        GuiUtil.setAccessible(this.repeatMonday, MessageLog.getMessageNoID("GUI5051L"), MessageLog.getMessageNoID("GUI5051L"));
        GuiUtil.setAccessible(this.repeatTuesday, MessageLog.getMessageNoID("GUI5052L"), MessageLog.getMessageNoID("GUI5052L"));
        GuiUtil.setAccessible(this.repeatWednesday, MessageLog.getMessageNoID("GUI5053L"), MessageLog.getMessageNoID("GUI5053L"));
        GuiUtil.setAccessible(this.repeatThursday, MessageLog.getMessageNoID("GUI5054L"), MessageLog.getMessageNoID("GUI5054L"));
        GuiUtil.setAccessible(this.repeatFriday, MessageLog.getMessageNoID("GUI5055L"), MessageLog.getMessageNoID("GUI5055L"));
        GuiUtil.setAccessible(this.repeatSaturday, MessageLog.getMessageNoID("GUI5056L"), MessageLog.getMessageNoID("GUI5056L"));
        this.gbcIndent.insets = this.insetB;
        if (!this.noRepeats) {
            boolean bl;
            serializable = Calendar.getInstance();
            boolean bl2 = bl = ((Calendar)serializable).getFirstDayOfWeek() == 1;
            if (Locale.getDefault().getLanguage().equals(new Locale("hu").getLanguage())) {
                bl = false;
            }
            if (bl) {
                jPanel.add((Component)this.repeatSunday, this.gbcIndent);
                jPanel.add((Component)this.repeatMonday, this.gbcPlop);
            } else {
                jPanel.add((Component)this.repeatMonday, this.gbcIndent);
            }
            jPanel.add((Component)this.repeatTuesday, this.gbcPlop);
            jPanel.add((Component)this.repeatWednesday, this.gbcPlop);
            jPanel.add((Component)this.repeatThursday, this.gbcPlop);
            jPanel.add((Component)this.repeatFriday, this.gbcPlop);
            if (!bl) {
                jPanel.add((Component)this.repeatSaturday, this.gbcPlop);
                jPanel.add((Component)this.repeatSunday, this.gbcLast);
            } else {
                jPanel.add((Component)this.repeatSaturday, this.gbcLast);
            }
        }
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    private void makeZonePanel() {
        JLabel jLabel;
        this.zonePanel = GuiUtil.getTitledBorderedPanel(MessageLog.getMessageNoID("GUI5057L"));
        String string = (String)this.msgParm[0];
        JLabel jLabel2 = new JLabel(string);
        this.zoneLocal = new JRadioButton(MessageLog.getMessageNoID("GUI5058L"));
        this.zoneGlobal = new JRadioButton(MessageLog.getMessageNoID("GUI5059L"));
        GuiUtil.setAccessible(this.zoneLocal, MessageLog.getMessageNoID("GUI5058L"), MessageLog.getMessageNoID("GUI5058L"));
        GuiUtil.setAccessible(this.zoneGlobal, MessageLog.getMessageNoID("GUI5059L"), MessageLog.getMessageNoID("GUI5059L"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.zoneLocal);
        buttonGroup.add(this.zoneGlobal);
        if (!this.serverJob) {
            this.zonePanel.add((Component)jLabel2, this.gbcLast);
            this.gbcIndentLast.insets = this.insetA;
            this.zonePanel.add((Component)this.zoneLocal, this.gbcIndentLast);
            this.zonePanel.add((Component)this.zoneGlobal, this.gbcIndentLast);
            jLabel = new JLabel(MessageLog.getMessageNoID("GUI5060L"));
        } else {
            jLabel = new JLabel(MessageLog.getMessageNoID("GUI5064L"));
        }
        this.gbcLast.insets = this.insetD;
        this.zonePanel.add((Component)jLabel, this.gbcLast);
        this.tzServer = new JRadioButton(MessageLog.getMessageNoID("GUI5061L"));
        this.tzZone = new JRadioButton(MessageLog.getMessageNoID("GUI5062L"));
        GuiUtil.setAccessible(this.tzServer, MessageLog.getMessageNoID("GUI5061L"), MessageLog.getMessageNoID("GUI5061L"));
        GuiUtil.setAccessible(this.tzZone, MessageLog.getMessageNoID("GUI5062L"), MessageLog.getMessageNoID("GUI5062L"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.tzServer);
        buttonGroup2.add(this.tzZone);
        this.gbcIndentLast.insets = this.insetB;
        this.zonePanel.add((Component)this.tzServer, this.gbcIndentLast);
        this.gbcIndent.insets = this.insetB;
        this.zonePanel.add((Component)this.tzZone, this.gbcIndent);
        String[] stringArray = TimeZone.getAvailableIDs();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (!arrayList.contains(TimeZone.getTimeZone(stringArray[n]).getDisplayName(false, 0))) {
                arrayList.add(TimeZone.getTimeZone(stringArray[n]).getDisplayName(false, 0));
            }
            ++n;
        }
        this.zoneName = new TComboBox(arrayList.toArray());
        GuiUtil.setAccessible(this.zoneName, Util.getString("LABEL_TIME_ZONE"), Util.getString("LABEL_TIME_ZONE"));
        this.zonePanel.add((Component)this.zoneName, this.gbcLast);
        GuiUtil.completePanel(this.zonePanel);
    }

    public void setFields() {
        if (this.header.scheduleType == 3) {
            this.runRepeat.setSelected(true);
        } else if (this.header.scheduleType == 2) {
            this.runOnce.setSelected(true);
        } else if (this.header.scheduleType == 4 && this.runApplicationDefined != null) {
            this.runApplicationDefined.setSelected(true);
        } else {
            this.runNow.setSelected(true);
        }
        if (this.header.repeatType == 2) {
            this.repeatOnDays.setSelected(true);
        } else {
            this.repeatRepeat.setSelected(true);
        }
        if (this.header.intervalNumber < 1) {
            this.header.intervalNumber = 1;
        }
        this.repeatNumber.setSelectedIndex(this.header.intervalNumber - 1);
        if (this.header.intervalType == 5) {
            this.repeatTerm.setSelectedIndex(4);
        } else if (this.header.intervalType == 4) {
            this.repeatTerm.setSelectedIndex(3);
        } else if (this.header.intervalType == 3) {
            this.repeatTerm.setSelectedIndex(2);
        } else if (this.header.intervalType == 2) {
            this.repeatTerm.setSelectedIndex(1);
        } else {
            this.repeatTerm.setSelectedIndex(0);
        }
        if (this.header.runSunday == 2) {
            this.repeatSunday.setSelected(true);
        }
        if (this.header.runMonday == 2) {
            this.repeatMonday.setSelected(true);
        }
        if (this.header.runTuesday == 2) {
            this.repeatTuesday.setSelected(true);
        }
        if (this.header.runWednesday == 2) {
            this.repeatWednesday.setSelected(true);
        }
        if (this.header.runThursday == 2) {
            this.repeatThursday.setSelected(true);
        }
        if (this.header.runFriday == 2) {
            this.repeatFriday.setSelected(true);
        }
        if (this.header.runSaturday == 2) {
            this.repeatSaturday.setSelected(true);
        }
        if (this.header.timezoneType == 2) {
            this.zoneGlobal.setSelected(true);
            this.tzServer.setEnabled(true);
            this.tzZone.setEnabled(true);
            if (this.header.globalType == 2) {
                this.zoneName.setEnabled(true);
            } else {
                this.zoneName.setEnabled(false);
            }
        } else {
            this.zoneLocal.setSelected(true);
            this.tzServer.setEnabled(false);
            this.tzZone.setEnabled(false);
            this.zoneName.setEnabled(false);
        }
        if (this.header.globalType == 2) {
            this.tzZone.setSelected(true);
            try {
                this.zoneName.setSelectedItem(this.header.timezone);
            }
            catch (Exception exception) {
                System.err.println("Failed to set timezone to saved value");
                this.zoneName.setSelectedItem("GMT");
            }
        } else {
            this.tzServer.setSelected(true);
            try {
                this.zoneName.setSelectedItem(TimeZone.getDefault().getDisplayName(false, 0));
            }
            catch (Exception exception) {
                System.err.println("Failed to set timezone to local JVM default");
                this.zoneName.setSelectedItem("GMT");
            }
        }
    }

    private void addListeners() {
        if (this.runApplicationDefined != null) {
            this.runApplicationDefined.addActionListener(this);
        }
        this.runNow.addActionListener(this);
        this.runOnce.addActionListener(this);
        this.runRepeat.addActionListener(this);
        this.repeatRepeat.addActionListener(this);
        this.repeatOnDays.addActionListener(this);
        this.zoneLocal.addActionListener(this);
        this.zoneGlobal.addActionListener(this);
        this.tzServer.addActionListener(this);
        this.tzZone.addActionListener(this);
    }

    public ScheduleHeader getData() {
        short s = this.header.startYear;
        short s2 = this.header.startMonth;
        short s3 = this.header.startDay;
        this.header.clear();
        if (this.runNow.isSelected()) {
            this.header.scheduleType = 1;
        } else if (this.runApplicationDefined != null && this.runApplicationDefined.isSelected()) {
            this.header.scheduleType = (byte)4;
        } else {
            short[] sArray;
            if (this.runOnce.isSelected()) {
                this.header.scheduleType = (byte)2;
                sArray = this.onceDateTime.getDateTime();
            } else {
                this.header.scheduleType = (byte)3;
                if (this.repeatRepeat.isSelected()) {
                    this.header.repeatType = 1;
                    this.header.intervalNumber = (short)(this.repeatNumber.getSelectedIndex() + 1);
                    int n = this.repeatTerm.getSelectedIndex();
                    switch (n) {
                        case 4: {
                            this.header.intervalType = (byte)5;
                            break;
                        }
                        case 3: {
                            this.header.intervalType = (byte)4;
                            break;
                        }
                        case 2: {
                            this.header.intervalType = (byte)3;
                            break;
                        }
                        case 1: {
                            this.header.intervalType = (byte)2;
                            break;
                        }
                        default: {
                            this.header.intervalType = 1;
                            break;
                        }
                    }
                } else {
                    this.header.repeatType = (byte)2;
                    this.header.intervalType = (byte)3;
                    if (this.repeatSunday.isSelected()) {
                        this.header.runSunday = (byte)2;
                    }
                    if (this.repeatMonday.isSelected()) {
                        this.header.runMonday = (byte)2;
                    }
                    if (this.repeatTuesday.isSelected()) {
                        this.header.runTuesday = (byte)2;
                    }
                    if (this.repeatWednesday.isSelected()) {
                        this.header.runWednesday = (byte)2;
                    }
                    if (this.repeatThursday.isSelected()) {
                        this.header.runThursday = (byte)2;
                    }
                    if (this.repeatFriday.isSelected()) {
                        this.header.runFriday = (byte)2;
                    }
                    if (this.repeatSaturday.isSelected()) {
                        this.header.runSaturday = (byte)2;
                    }
                }
                sArray = this.repeatOnDaysOnly ? this.repeatTime.getTime() : this.repeatDateTime.getDateTime();
            }
            if (this.repeatOnDaysOnly) {
                this.header.startYear = s;
                this.header.startMonth = s2;
                this.header.startDay = s3;
                this.header.startHour = sArray[0];
                this.header.startMinute = sArray[1];
            } else {
                this.header.startYear = sArray[0];
                this.header.startMonth = (short)(sArray[1] + 1);
                this.header.startDay = sArray[2];
                this.header.startHour = sArray[3];
                this.header.startMinute = sArray[4];
            }
        }
        if (this.zoneLocal.isSelected()) {
            this.header.timezoneType = 1;
        } else {
            this.header.timezoneType = (byte)2;
            if (this.tzServer.isSelected()) {
                this.header.globalType = 1;
            } else {
                this.header.globalType = (byte)2;
                this.header.timezone = this.zoneName.getSelectedItem().toString();
            }
        }
        return this.header;
    }

    public void validate(ScheduleHeader scheduleHeader) throws GeneralException {
        if (scheduleHeader.repeatType == 2 && scheduleHeader.runSunday != 2 && scheduleHeader.runMonday != 2 && scheduleHeader.runTuesday != 2 && scheduleHeader.runWednesday != 2 && scheduleHeader.runThursday != 2 && scheduleHeader.runFriday != 2 && scheduleHeader.runSaturday != 2) {
            throw new GeneralException(MessageLog.getMessageNoTS("GUI0262E"));
        }
        if (this.runOnce.isSelected() && this.onceDateTime.getMilliseconds() < Calendar.getInstance().getTimeInMillis()) {
            throw new GeneralException(MessageLog.getMessageNoTS("GUI0272E"));
        }
        if (this.runRepeat.isSelected() && this.repeatDateTime.getMilliseconds() < Calendar.getInstance().getTimeInMillis() && this.DDI.isModified() && !this.DDI.isSwitchPanel()) {
            JOptionPane.showMessageDialog(GuiMain.pGuiMain, MessageLog.getMessageNoTS("GUI0273W"), GuiUtil.getString("PERF_NOTICE"), 1);
        }
    }

    public static void displayJobSubmittedMessage(Object[] objectArray) {
        String string = null;
        string = MessageLog.getMessageNoID("GUI2017M", objectArray);
        String string2 = MessageLog.getMessageNoID("GUI0228L");
        JOptionPane.showMessageDialog(guiMain.getFrame(), string, string2, 1);
    }

    public void replace(ScheduleHeader scheduleHeader) {
        this.header = scheduleHeader;
        if (scheduleHeader.scheduleType == 1 && scheduleHeader.enabled && this.DDI.responseStatus <= 4) {
            JSgcScheduleCreateWhenData.displayJobSubmittedMessage(this.DDI.msgParm);
        }
    }

    private void enableWhenFields() {
        if (this.runNow.isSelected() || this.runApplicationDefined != null && this.runApplicationDefined.isSelected()) {
            this.onceDateTime.setEnabled(false);
            this.runAt.setEnabled(false);
            this.repeatDateTime.setEnabled(false);
            this.repeatNumber.setEnabled(false);
            this.repeatTerm.setEnabled(false);
            this.repeatRepeat.setEnabled(false);
            this.repeatOnDays.setEnabled(false);
            this.repeatSunday.setEnabled(false);
            this.repeatMonday.setEnabled(false);
            this.repeatTuesday.setEnabled(false);
            this.repeatWednesday.setEnabled(false);
            this.repeatThursday.setEnabled(false);
            this.repeatFriday.setEnabled(false);
            this.repeatSaturday.setEnabled(false);
        } else if (this.runOnce.isSelected()) {
            this.onceDateTime.setEnabled(true);
            this.runAt.setEnabled(false);
            this.repeatDateTime.setEnabled(false);
            this.repeatNumber.setEnabled(false);
            this.repeatTerm.setEnabled(false);
            this.repeatRepeat.setEnabled(false);
            this.repeatOnDays.setEnabled(false);
            this.repeatSunday.setEnabled(false);
            this.repeatMonday.setEnabled(false);
            this.repeatTuesday.setEnabled(false);
            this.repeatWednesday.setEnabled(false);
            this.repeatThursday.setEnabled(false);
            this.repeatFriday.setEnabled(false);
            this.repeatSaturday.setEnabled(false);
        } else {
            this.onceDateTime.setEnabled(false);
            this.runAt.setEnabled(true);
            this.repeatDateTime.setEnabled(true);
            this.repeatRepeat.setEnabled(true);
            this.repeatOnDays.setEnabled(true);
            if (this.repeatRepeat.isSelected()) {
                this.repeatNumber.setEnabled(true);
                this.repeatTerm.setEnabled(true);
                this.repeatSunday.setEnabled(false);
                this.repeatMonday.setEnabled(false);
                this.repeatTuesday.setEnabled(false);
                this.repeatWednesday.setEnabled(false);
                this.repeatThursday.setEnabled(false);
                this.repeatFriday.setEnabled(false);
                this.repeatSaturday.setEnabled(false);
            } else {
                this.repeatNumber.setEnabled(false);
                this.repeatTerm.setEnabled(false);
                this.repeatSunday.setEnabled(true);
                this.repeatMonday.setEnabled(true);
                this.repeatTuesday.setEnabled(true);
                this.repeatWednesday.setEnabled(true);
                this.repeatThursday.setEnabled(true);
                this.repeatFriday.setEnabled(true);
                this.repeatSaturday.setEnabled(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.runNow) {
            this.enableWhenFields();
        } else if (object == this.runApplicationDefined) {
            this.enableWhenFields();
        } else if (object == this.runOnce) {
            this.enableWhenFields();
        } else if (object == this.runRepeat) {
            this.enableWhenFields();
        } else if (object == this.repeatRepeat) {
            this.enableWhenFields();
        } else if (object == this.repeatOnDays) {
            this.enableWhenFields();
        } else if (object == this.zoneLocal) {
            this.tzServer.setEnabled(false);
            this.tzZone.setEnabled(false);
            this.zoneName.setEnabled(false);
        } else if (object == this.zoneGlobal) {
            this.tzServer.setEnabled(true);
            this.tzZone.setEnabled(true);
            if (this.tzServer.isSelected()) {
                this.zoneName.setEnabled(false);
            } else {
                this.zoneName.setEnabled(true);
            }
        } else if (object == this.tzServer) {
            this.zoneName.setEnabled(false);
        } else if (object == this.tzZone) {
            this.zoneName.setEnabled(true);
        }
    }
}

