/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.LogViewerDDI;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogViewer
extends JPanel
implements ActionListener,
GuiRequestor {
    private int LINES = 90;
    private LogViewerDDI ddi;
    private Request request = new Request();
    private ReadLogRequest rlreq = new ReadLogRequest();
    private LogFilePos logStart = new LogFilePos();
    private LogFilePos logEnd = new LogFilePos();
    private ReadLogResponse rlresp;
    private JPanel buttonPanel = new JPanel();
    private JLabel findLabel = new JLabel(MessageLog.getMessageNoID("GUI0026L", null));
    private JTextField find = new JTextField(15);
    private JButton findPrevButton = new JButton(IconFactory.getUpArrowIcon());
    private JButton findNextButton = new JButton(IconFactory.getDownArrowIcon());
    private JButton topButton = new JButton(MessageLog.getMessageNoID("GUI0036L", null));
    private JButton bottomButton = new JButton(MessageLog.getMessageNoID("GUI0038L", null));
    protected JScrollPane scrollPane = new JScrollPane();
    private JPanel pageUpPanel = new JPanel();
    private JButton pageUpButton = new JButton(IconFactory.getDoubleUpArrowIcon());
    private JPanel pageDownPanel = new JPanel();
    private JButton pageDownButton = new JButton(IconFactory.getDoubleDownArrowIcon());
    private JPanel titlePanel = new JPanel();
    private JLabel titleText = new JLabel();
    protected JTextPane textPane = new MyTextPane();
    private Document doc = this.textPane.getDocument();
    private Style def = StyleContext.getDefaultStyleContext().getStyle("default");
    private Style info = this.textPane.addStyle("info", this.def);
    private Style warning = this.textPane.addStyle("warning", this.def);
    private Style error = this.textPane.addStyle("error", this.def);
    private int type;
    private static final int UP = 1;
    private static final int DOWN = 2;
    private static final int TOP = 3;
    private static final int BOTTOM = 4;
    private static final int PREV = 5;
    private static final int NEXT = 6;
    private static final int END = -99;
    private int docend;
    private int findlen;
    private int current;
    private String searchFor;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public LogViewer(LogViewerDDI logViewerDDI) {
        this.ddi = logViewerDDI;
        logViewerDDI.panel = this;
        this.main();
    }

    public LogViewer(BaseTreeNode baseTreeNode, String string) {
        this.ddi = new LogViewerDDI();
        this.ddi.panel = this;
        this.ddi.treeNode = baseTreeNode;
        this.ddi.logType = LogViewerDDI.SERVICE;
        this.ddi.serviceID = string;
        this.ddi.name = RequestTypeManager.getLogPrefix(string);
        Object[] objectArray = new Object[]{RequestTypeManager.getLogPrefix(string)};
        this.ddi.title = MessageLog.getMessageNoID("GUI0031T", objectArray);
        this.ddi.setDescription(this.ddi.title);
        this.ddi.show();
        this.main();
    }

    public LogViewer(int n, BaseTreeNode baseTreeNode) {
        this(n, baseTreeNode, baseTreeNode.toString(), 0);
    }

    public LogViewer(int n, BaseTreeNode baseTreeNode, String string, int n2) {
        this.ddi = new LogViewerDDI();
        this.ddi.panel = this;
        this.ddi.treeNode = baseTreeNode;
        this.ddi.logType = LogViewerDDI.AGENT;
        this.ddi.computerID = n;
        this.ddi.name = RequestTypeManager.getLogPrefix("org.eclipse.aperi.agent.svp.AgentSvp");
        this.ddi.title = String.valueOf(MessageLog.getMessageNoID("GUI0029T", null)) + " " + string;
        this.ddi.setDescription(this.ddi.title);
        this.ddi.show();
        this.main();
    }

    public LogViewer(int n, BaseTreeNode baseTreeNode, String string) {
        this.ddi = new LogViewerDDI();
        this.ddi.panel = this;
        this.ddi.treeNode = baseTreeNode;
        this.ddi.logType = LogViewerDDI.AGENT_JOB;
        this.ddi.computerID = n;
        this.ddi.name = string;
        Object[] objectArray = new Object[]{string};
        this.ddi.title = MessageLog.getMessageNoID("GUI0030T", objectArray);
        this.ddi.setDescription(this.ddi.title);
        this.ddi.show();
        this.main();
    }

    public LogViewer(int n, BaseTreeNode baseTreeNode, String string, int n2, int n3) {
        this.ddi = new LogViewerDDI();
        this.ddi.panel = this;
        this.ddi.treeNode = baseTreeNode;
        this.ddi.computerID = n;
        this.ddi.name = string;
        Object[] objectArray = new Object[]{string};
        this.ddi.title = MessageLog.getMessageNoID("GUI0030T", objectArray);
        this.ddi.setDescription(this.ddi.title);
        this.ddi.logType = n3 == -1 ? LogViewerDDI.AGENT_JOB : LogViewerDDI.DEVICE_JOB;
        this.ddi.show();
        this.main();
    }

    public LogViewer(int n, BaseTreeNode baseTreeNode, int n2) {
        this.ddi = new LogViewerDDI();
        this.ddi.panel = this;
        this.ddi.treeNode = baseTreeNode;
        this.ddi.computerID = n;
        this.ddi.logType = n2;
        Object[] objectArray = new Object[]{" "};
        this.ddi.title = MessageLog.getMessageNoID("GUI0030T", objectArray);
        this.ddi.setDescription(this.ddi.title);
        this.ddi.show();
        this.main();
    }

    private void main() {
        this.ddi.panel = this;
        this.rlreq.name = this.ddi.name;
        this.rlreq.position = this.logEnd;
        this.rlreq.direction = (byte)-1;
        this.rlreq.linesDesired = this.LINES;
        if (this.ddi.logType == LogViewerDDI.AGENT) {
            ServerRequest.agentReadLog(this.request, this.ddi.computerID, this.rlreq);
        } else if (this.ddi.logType == LogViewerDDI.AGENT_JOB) {
            ServerRequest.agentReadJobLog(this.request, this.ddi.computerID, this.rlreq);
        } else if (this.ddi.logType == LogViewerDDI.AGENT_INBAND) {
            ServerRequest.readInbandAgentLog(this.request, this.ddi.computerID, this.rlreq);
        } else if (this.ddi.logType == LogViewerDDI.DEVICE_JOB) {
            ServerRequest.deviceReadJobLog(this.request, this.ddi.computerID, this.rlreq);
        } else {
            ServerRequest.readServiceLog(this.request, this.rlreq);
        }
        StyleConstants.setForeground(this.warning, Color.blue);
        StyleConstants.setItalic(this.warning, true);
        StyleConstants.setForeground(this.error, Color.red);
        StyleConstants.setBold(this.error, true);
        this.textPane.setEditable(false);
        this.pageUpButton.setToolTipText("   " + MessageLog.getMessageNoID("GUI0024T", null) + "   ");
        this.pageUpButton.addActionListener(this);
        this.pageUpPanel.setLayout(new BorderLayout());
        this.pageUpPanel.add((Component)this.pageUpButton, "South");
        this.pageDownButton.setToolTipText(MessageLog.getMessageNoID("GUI0025T", null));
        this.pageDownButton.addActionListener(this);
        this.pageDownPanel.setLayout(new BorderLayout());
        this.pageDownPanel.add((Component)this.pageDownButton, "North");
        this.findPrevButton.setToolTipText("   " + MessageLog.getMessageNoID("GUI0027T", null) + "   ");
        this.findPrevButton.addActionListener(this);
        this.findNextButton.setToolTipText(MessageLog.getMessageNoID("GUI0028T", null));
        this.findNextButton.addActionListener(this);
        this.find.setMaximumSize(new Dimension(20, 20));
        this.topButton.setToolTipText(MessageLog.getMessageNoID("GUI0037M", null));
        this.topButton.addActionListener(this);
        this.bottomButton.setToolTipText(MessageLog.getMessageNoID("GUI0039M", null));
        this.bottomButton.addActionListener(this);
        GuiUtil.setAccessible(this.textPane, "NAME_TEXTPANE", "DESCRIPTION_TEXTPANE");
        GuiUtil.setAccessible(this.find, "NAME_SEARCH", "DESCRIPTION_SEARCH");
        GuiUtil.setAccessible(this.topButton, this.topButton.getText(), this.topButton.getToolTipText());
        GuiUtil.setAccessible(this.bottomButton, this.bottomButton.getText(), this.bottomButton.getToolTipText());
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.findLabel);
        this.buttonPanel.add(this.find);
        this.buttonPanel.add(this.findPrevButton);
        this.buttonPanel.add(this.findNextButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.topButton);
        this.buttonPanel.add(this.bottomButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.titleText.setText(this.ddi.title);
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        this.titlePanel.add(Box.createHorizontalStrut(5));
        this.titlePanel.add(this.titleText);
        this.titlePanel.add(Box.createHorizontalStrut(10));
        this.titlePanel.add(Box.createHorizontalGlue());
        this.titlePanel.add(Box.createHorizontalStrut(5));
        this.scrollPane.setViewportView(this.textPane);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", this.pageUpPanel);
        this.scrollPane.setCorner("LOWER_RIGHT_CORNER", this.pageDownPanel);
        this.scrollPane.setColumnHeaderView(this.titlePanel);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.type = 4;
        this.getLogData();
        try {
            this.doc.insertString(0, " ", this.info);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Couldn't insert text into log.");
        }
        this.textPane.requestFocus();
    }

    private int lookForColon(String string, int n) {
        int n2 = string.indexOf(58, n);
        if (n2 != -1 && string.charAt(n2 - 1) != 'I' && string.charAt(n2 - 1) != 'W' && string.charAt(n2 - 1) != 'E') {
            n2 = this.lookForColon(string, n2 + 1);
        }
        return n2;
    }

    private void addLogData(String[] stringArray, int n) {
        Style style = this.info;
        try {
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    int n3 = this.lookForColon(stringArray[n2], 0);
                    if (n3 > -1) {
                        if (stringArray[n2].indexOf("E: ") != -1 && stringArray[n2].trim().length() > 7) {
                            if (n3 - 2 > 0 && Character.isDigit(stringArray[n2].charAt(n3 - 2))) {
                                style = this.error;
                            }
                        } else if (stringArray[n2].indexOf("W: ") != -1 && stringArray[n2].trim().length() > 7) {
                            if (n3 - 2 > 0 && Character.isDigit(stringArray[n2].charAt(n3 - 2))) {
                                style = this.warning;
                            }
                        } else {
                            style = this.info;
                        }
                    }
                    this.doc.insertString(n, stringArray[n2], style);
                    n += stringArray[n2].length();
                    ++n2;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Couldn't insert text into log.");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.pageUpButton) {
            this.textPane.setCaretPosition(0);
            if (this.logStart.offset > 0L) {
                this.rlreq.position = this.logStart;
                this.rlreq.direction = (byte)-1;
                this.rlreq.linesDesired = 30;
                this.type = 1;
                this.getLogData();
            }
        } else if (object == this.pageDownButton) {
            if (this.logEnd.offset != -99L) {
                this.docend = this.doc.getLength();
                this.rlreq.position = this.logEnd;
                this.rlreq.direction = 1;
                this.rlreq.linesDesired = 30;
                this.type = 2;
                this.getLogData();
            } else {
                this.textPane.setCaretPosition(Math.max(0, this.doc.getLength() - 1));
            }
        } else if (object == this.topButton) {
            this.rlreq.position = new LogFilePos();
            this.rlreq.direction = 1;
            this.rlreq.linesDesired = this.LINES;
            this.type = 3;
            this.getLogData();
        } else if (object == this.bottomButton) {
            this.rlreq.position = new LogFilePos();
            this.rlreq.direction = (byte)-1;
            this.rlreq.linesDesired = this.LINES;
            this.type = 4;
            this.getLogData();
        } else if (object == this.findPrevButton) {
            this.findPrev();
        } else if (object == this.findNextButton) {
            this.findNext();
        }
    }

    private void findPrev() {
        if (this.find.getText().length() == 0) {
            this.find.setText(this.textPane.getSelectedText());
            if (this.find.getText().length() == 0) {
                JOptionPane.showMessageDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI0032M", null), MessageLog.getMessageNoID("GUI0034T", null), 1);
                return;
            }
        }
        this.current = this.textPane.getSelectionStart();
        String string = "";
        try {
            string = this.textPane.getText(0, this.current);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Couldn't get text from log.");
        }
        this.searchFor = this.find.getText();
        this.findlen = this.searchFor.length();
        while (this.current >= 0) {
            if (string.regionMatches(true, this.current, this.searchFor, 0, this.findlen)) {
                this.textPane.setSelectionStart(this.current);
                this.textPane.setSelectionEnd(this.current + this.findlen);
                return;
            }
            --this.current;
        }
        this.rlreq.position = this.logStart;
        this.rlreq.direction = (byte)-1;
        this.rlreq.searchFor = this.searchFor;
        this.type = 5;
        this.getLogData();
    }

    private void findNext() {
        if (this.find.getText().length() == 0) {
            this.find.setText(this.textPane.getSelectedText());
            if (this.find.getText().length() == 0) {
                JOptionPane.showMessageDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI0032M", null), MessageLog.getMessageNoID("GUI0034T", null), 1);
                return;
            }
        }
        this.current = this.textPane.getSelectionEnd();
        String string = "";
        try {
            string = this.textPane.getText(this.current, this.doc.getLength() - this.current);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Couldn't get text from log.");
        }
        this.searchFor = this.find.getText();
        this.findlen = this.searchFor.length();
        int n = string.length() - this.findlen;
        int n2 = 0;
        while (n2 < n) {
            if (string.regionMatches(true, n2, this.searchFor, 0, this.findlen)) {
                this.textPane.setSelectionStart(this.current + n2);
                this.textPane.setSelectionEnd(this.current + n2 + this.findlen);
                return;
            }
            ++n2;
        }
        this.rlreq.position = this.logEnd;
        this.rlreq.direction = 1;
        this.rlreq.searchFor = this.searchFor;
        this.type = 6;
        this.getLogData();
    }

    private void getLogData() {
        GuiClient.doRequest(this, this.request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        this.rlresp = (ReadLogResponse)response.responseData;
        String[] stringArray = new String[]{};
        stringArray = this.rlresp.lineArray;
        switch (this.type) {
            case 1: {
                this.addLogData(stringArray, 0);
                this.logStart = this.rlresp.start;
                break;
            }
            case 2: {
                this.addLogData(stringArray, this.doc.getLength());
                this.logEnd = this.rlresp.end;
                this.textPane.setCaretPosition(Math.max(0, this.doc.getLength() - 1));
                break;
            }
            case 3: {
                try {
                    this.doc.remove(0, this.doc.getLength());
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Couldn't remove text from log.");
                }
                this.addLogData(stringArray, 0);
                if (this.logStart != null) {
                    this.logStart.offset = 0L;
                }
                this.logEnd = this.rlresp.end;
                this.textPane.setCaretPosition(0);
                break;
            }
            case 4: {
                try {
                    this.doc.remove(0, this.doc.getLength());
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Couldn't remove text from log.");
                }
                this.addLogData(stringArray, 0);
                this.logStart = this.rlresp.start;
                if (this.logEnd != null) {
                    this.logEnd.offset = -99L;
                }
                this.textPane.setCaretPosition(Math.max(0, this.doc.getLength() - 1));
                break;
            }
            case 5: {
                this.rlreq.searchFor = null;
                if (this.rlresp.status == 0) {
                    if (!this.logStart.equals(this.rlresp.end)) {
                        this.logEnd = this.rlresp.end;
                        try {
                            this.doc.remove(0, this.doc.getLength());
                        }
                        catch (BadLocationException badLocationException) {
                            System.err.println("Couldn't remove text from log.");
                        }
                    }
                    this.logStart = this.rlresp.start;
                    this.addLogData(stringArray, 0);
                    this.current = 0;
                    int n = 0;
                    while (n < this.rlresp.foundIndex) {
                        this.current += stringArray[n].length();
                        ++n;
                    }
                    this.current += this.rlresp.foundOffset;
                    this.textPane.setSelectionStart(this.current);
                    this.textPane.setSelectionEnd(this.current + this.findlen);
                    break;
                }
                JOptionPane.showMessageDialog(this.guiMain.getFrame(), String.valueOf(MessageLog.getMessageNoID("GUI0033M", null)) + " " + this.searchFor, MessageLog.getMessageNoID("GUI0034T", null), 1);
                break;
            }
            case 6: {
                this.rlreq.searchFor = null;
                if (this.rlresp.status == 0) {
                    if (!this.logEnd.equals(this.rlresp.start)) {
                        this.logStart = this.rlresp.start;
                        try {
                            this.doc.remove(0, this.doc.getLength());
                        }
                        catch (BadLocationException badLocationException) {
                            System.err.println("Couldn't remove text from log.");
                        }
                    }
                    this.logEnd = this.rlresp.end;
                    this.current = this.doc.getLength();
                    this.addLogData(stringArray, this.current);
                    int n = 0;
                    while (n < this.rlresp.foundIndex) {
                        this.current += stringArray[n].length();
                        ++n;
                    }
                    this.current += this.rlresp.foundOffset;
                    this.textPane.setSelectionStart(this.current);
                    this.textPane.setSelectionEnd(this.current + this.findlen);
                    return;
                }
                JOptionPane.showMessageDialog(this.guiMain.getFrame(), String.valueOf(MessageLog.getMessageNoID("GUI0033M", null)) + " " + this.searchFor, MessageLog.getMessageNoID("GUI0034T", null), 1);
            }
        }
    }

    private class MyTextPane
    extends JTextPane {
        private MyTextPane() {
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    }
}

