/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.common.CIMOMMgmtAgentTreeLabel;
import org.eclipse.aperi.gui.common.CIMOMMgmtDetailsDDI;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class CIMOMMgmtAgentTreeNode
extends BaseTreeNode {
    private CIMOM cimom;

    public CIMOMMgmtAgentTreeNode(CIMOM cIMOM) {
        super(CIMOMMgmtAgentTreeNode.getLabel(cIMOM));
        this.cimom = cIMOM;
        this.setAllowsChildren(false);
    }

    public static String getLabel(CIMOM cIMOM) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CIMOMMgmtAgentTreeNode.getBestDisplayName(cIMOM));
        return stringBuffer.toString();
    }

    private static String getBestDisplayName(CIMOM cIMOM) {
        String string = cIMOM.getDisplayName();
        if (string == null || string.length() == 0) {
            string = cIMOM.getServiceUrl();
        }
        return string;
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (this.cimom.getStatus() == CIMOMConnectionStatus.SUCCESS) {
            defaultTreeCellRenderer.setIcon(IconFactory.getStateUpIcon());
            defaultTreeCellRenderer.setFont(BaseTree.plainFont);
        } else if (this.cimom.getStatus() == CIMOMConnectionStatus.UNKNOWN) {
            defaultTreeCellRenderer.setIcon(IconFactory.getStateUnknownIcon());
            defaultTreeCellRenderer.setFont(BaseTree.boldFont);
        } else {
            defaultTreeCellRenderer.setIcon(IconFactory.getStateFailedIcon());
            defaultTreeCellRenderer.setFont(BaseTree.boldFont);
        }
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        this.launchDDI();
    }

    private void launchDDI() {
        if (this.ddi == null) {
            this.ddi = new CIMOMMgmtDetailsDDI(this, this.cimom);
        } else {
            this.ddi.reDisplay();
        }
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            JPopupMenu jPopupMenu = this.getPopupMenu();
            jPopupMenu.add(this.checkCIMOMMenu());
            jPopupMenu.add(this.removeCIMOMMenu());
            this.showPopupMenu(jPopupMenu, mouseEvent);
        }
    }

    private JMenuItem removeCIMOMMenu() {
        JMenuItem jMenuItem = new JMenuItem(Util.getString("CIMOM_MGMT_REM"));
        jMenuItem.setToolTipText(Util.getString("CIMOM_MGMT_REM_TIP"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(CIMOMMgmtAgentTreeNode.access$0().getFrame(), Util.getString("GUI8100I", CIMOMMgmtAgentTreeNode.getBestDisplayName(CIMOMMgmtAgentTreeNode.this.cimom)), Util.getString("CIMOM_MGMT_REM_TITLE"), 0, 2);
                if (n == 0) {
                    CIMOMMgmtAgentTreeNode.this.removeCIMOMrequest(CIMOMMgmtAgentTreeNode.this.cimom);
                }
            }
        });
        jMenuItem.setEnabled(this.capabilities.isAperiAdmin());
        return jMenuItem;
    }

    protected void removeCIMOMrequest(CIMOM cIMOM) {
        Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtRemoveCIMOMsHandler");
        request.requestData = cIMOM;
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    ((CIMOMMgmtAgentTreeLabel)CIMOMMgmtAgentTreeNode.this.getParent()).buildCIMOMList((CIMOM[])response.responseData);
                }
            }
        }, request);
    }

    private JMenuItem checkCIMOMMenu() {
        JMenuItem jMenuItem = new JMenuItem(Util.getString("CIMOM_MGMT_TST"));
        jMenuItem.setToolTipText(Util.getString("CIMOM_MGMT_TST_TIP"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtTestCIMOMsHandler");
                request.requestData = CIMOMMgmtAgentTreeNode.this.cimom;
                GuiClient.doRequest(new GuiRequestor(){

                    public void handleResponse(short s, Response response) {
                        if (s <= 4) {
                            int n;
                            String string;
                            CIMOMConnectionStatus cIMOMConnectionStatus = (CIMOMConnectionStatus)response.responseData;
                            if (cIMOMConnectionStatus == CIMOMConnectionStatus.SUCCESS) {
                                string = Util.getString("GUI8102I", CIMOMMgmtAgentTreeNode.getBestDisplayName(CIMOMMgmtAgentTreeNode.this.cimom));
                                n = 1;
                            } else {
                                string = Util.getString("GUI8101I", CIMOMMgmtAgentTreeNode.getBestDisplayName(CIMOMMgmtAgentTreeNode.this.cimom), CIMOMMgmtAgentTreeNode.this.getLocalizedStatus(cIMOMConnectionStatus));
                                n = 0;
                            }
                            JOptionPane.showMessageDialog(CIMOMMgmtAgentTreeNode.access$0().getFrame(), string, Util.getString("CIMOM_MGMT_TST_TITLE"), n);
                        }
                    }
                }, request);
            }
        });
        return jMenuItem;
    }

    public void cleanYourself() {
        if (this.ddi != null) {
            this.ddi.remove();
        }
    }

    public Object getState() {
        return new Boolean(this.ddi != null);
    }

    public Object getUniqueID() {
        return this.cimom.getServiceUrl();
    }

    public void setState(Object object) {
        if (object != null && ((Boolean)object).booleanValue()) {
            this.launchDDI();
        }
    }

    private String getLocalizedStatus(CIMOMConnectionStatus cIMOMConnectionStatus) {
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SUCCESS) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_SUCCESS");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.UNCONFIGURED) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.UNKNOWN) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.INVALID_NAMESPACE) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.TIMEOUT) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_TIMEOUT");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.REFUSED) {
            return Util.getString("DISK_COMMON_STATE_UNREACHABLE");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.LOGIN_FAILED) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SSL_REGISTRATION_INVALID) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.CIMCLIENT_ERROR) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR");
        }
        return Util.getString("CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
    }

    static /* synthetic */ IGuiMain access$0() {
        return BaseTreeNode.guiMain;
    }
}

