/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.common.model.GUIEntity;
import org.eclipse.aperi.gui.disk.common.DiskConstants;

public class GUIEntityUtil {
    public static final int STORAGE_CAPACITY_UNIT_BYTE = 0;
    public static final int STORAGE_CAPACITY_UNIT_KB = 1;
    public static final int STORAGE_CAPACITY_UNIT_MB = 2;
    public static final int STORAGE_CAPACITY_UNIT_GB = 3;
    public static final int STORAGE_CAPACITY_UNIT_TB = 4;
    public static final int STORAGE_CAPACITY_UNIT_PB = 5;
    private static final int[] STORAGE_CAPACITY_CONVERSION_TABLE;
    private static BigInteger STORAGE_CAPACITY_CONVERSION_BASE;

    static {
        int[] nArray = new int[6];
        nArray[1] = 10;
        nArray[2] = 20;
        nArray[3] = 30;
        nArray[4] = 40;
        nArray[5] = 50;
        STORAGE_CAPACITY_CONVERSION_TABLE = nArray;
        STORAGE_CAPACITY_CONVERSION_BASE = BigInteger.valueOf(2L);
    }

    public static double convertStorageCapacity(double d, int n, int n2, int n3) {
        BigDecimal bigDecimal = new BigDecimal(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[n]));
        BigDecimal bigDecimal2 = new BigDecimal(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[n2]));
        BigDecimal bigDecimal3 = new BigDecimal(d);
        return bigDecimal3.multiply(bigDecimal).divide(bigDecimal2, n3, 4).doubleValue();
    }

    public static long convertStorageCapacity(long l, int n, int n2) {
        return BigInteger.valueOf(l).multiply(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[n])).divide(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[n2])).longValue();
    }

    public static float convertStorageCapacityDecimal(double d, int n, int n2, int n3) {
        BigDecimal bigDecimal = new BigDecimal(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[n]));
        BigDecimal bigDecimal2 = new BigDecimal(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[n2]));
        BigDecimal bigDecimal3 = new BigDecimal(d);
        return bigDecimal3.multiply(bigDecimal).divide(bigDecimal2, n3, 4).floatValue();
    }

    public static String convertStorageCapacityString(Object object, DecimalFormat decimalFormat) {
        String string;
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setMinimumFractionDigits(2);
        int n = object.toString().indexOf("E");
        if (n != -1) {
            int n2 = Integer.parseInt(object.toString().substring(n + 1));
            BigDecimal bigDecimal = new BigDecimal(object.toString().substring(0, n));
            string = n2 < 0 ? bigDecimal.movePointRight(n2).toString() : bigDecimal.movePointLeft(n2).toString();
        } else {
            string = decimalFormat.format((Number)object);
        }
        return string;
    }

    public static String getNumberString(Number number, Locale locale) {
        try {
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            return numberFormat.format(number);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }

    public static String getNumberString(Number number, int n, Locale locale) {
        try {
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            numberFormat.setMaximumFractionDigits(n);
            return numberFormat.format(number);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }

    public static String getTimeLongString(Date date, Locale locale) {
        if (date.getTime() <= 0L) {
            return "";
        }
        try {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, locale);
            return dateFormat.format(date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }

    public static String getTimeString(Date date, Locale locale) {
        if (date.getTime() <= 0L) {
            return "";
        }
        try {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
            return dateFormat.format(date);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }

    public static Number getNumber(String string, Locale locale) throws ParseException {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        return numberFormat.parse(string);
    }

    public static JLabel getEntityStateLabel(GUIEntity gUIEntity) {
        String string = "";
        ImageIcon imageIcon = null;
        if (!gUIEntity.isDetectable()) {
            string = Util.getString("DISK_COMMON_STATE_UNREACHABLE");
            imageIcon = IconFactory.getStateUreachableIcon();
        } else {
            switch (gUIEntity.getState()) {
                case 0: {
                    string = Util.getString("DISK_COMMON_STATE_NORMAL");
                    imageIcon = IconFactory.getStateUpIcon();
                    break;
                }
                case 1: {
                    string = Util.getString("DISK_COMMON_STATE_WARNING");
                    imageIcon = IconFactory.getStateWarningIcon();
                    break;
                }
                case 2: {
                    string = Util.getString("DISK_COMMON_STATE_CRITICAL");
                    imageIcon = IconFactory.getStateFailedIcon();
                    break;
                }
                case -1: {
                    string = Util.getString("DISK_COMMON_UNKNOWN");
                    imageIcon = IconFactory.getStateUnknownIcon();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown state: " + gUIEntity.getState());
                }
            }
        }
        if (imageIcon != null) {
            imageIcon.setDescription(string);
        }
        return new JLabel(string, imageIcon, 10);
    }

    public static Vector sort(Vector vector) {
        Vector vector2 = new Vector();
        Vector<String> vector3 = new Vector<String>();
        int n = -1;
        int n2 = 0;
        while (n2 < vector.size()) {
            vector3.add(((GUIEntity)vector.get(n2)).getName());
            ++n2;
        }
        Collections.sort(vector3);
        n2 = 0;
        while (n2 < vector3.size()) {
            n = GUIEntityUtil.findName(vector, vector3.get(n2).toString());
            if (n != -1) {
                vector2.insertElementAt(vector.get(n), n2);
            }
            ++n2;
        }
        return vector2;
    }

    public static int findName(Vector vector, String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (string.equals(((GUIEntity)vector.get(n2)).getName())) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    public static int getRaidLevel(int n, int n2) {
        int n3 = -1;
        if (n2 == 0 && n == 1) {
            n3 = 0;
        } else if (n2 == 1 && n == 2) {
            n3 = 10;
        } else if (n2 == 1 && n == 1) {
            n3 = 5;
        } else if (n2 == 2 && n == 1) {
            n3 = 6;
        } else if (n2 == 2 && n == 2) {
            n3 = 15;
        }
        return n3;
    }

    public static String getDisplayText(Object object) {
        if (object != null && !object.equals("")) {
            return String.valueOf(object);
        }
        return DiskConstants.DISK_VALUE_IS_NULL;
    }

    public static Number getNumberValue(Number number) {
        if (number == null) {
            return (short)0;
        }
        return number;
    }

    public static String getStringValue(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println("Result (double)= " + GUIEntityUtil.convertStorageCapacity(7.5E12, 0, 3, 2) + " GB");
        System.out.println("Result (long) = " + GUIEntityUtil.convertStorageCapacity(7500000000000L, 0, 3) + " GB");
    }
}

