/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntity;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStoragePool;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSelectSubsystemPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeWizard;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeZoneActionStep;
import org.eclipse.aperi.request.Response;

public class CreateVolumeReviewStep
extends WizardPage {
    private JLabel titleLabel = null;
    private JTextArea descLabel = null;
    private JLabel quantityLabel = null;
    private JLabel sizeLabel = null;
    private JLabel arrayLabel = null;
    private JLabel raidLevelLabel = null;
    private JLabel zoneActionLabel = null;
    private JLabel hostPortLabel = null;
    private JLabel subSystemPortLabel = null;
    private JLabel nameLabel = null;
    private JLabel nameTextLabel = null;
    private JLabel volumeListLabel = null;
    private JLabel hostPortTypeLabel = null;
    private JLabel hostPortTypeTextLabel = null;
    private JLabel quantityTextLabel = null;
    private JLabel sizeTextLabel = null;
    private JLabel arrayTextLabel = null;
    private JLabel raidLevelTextLabel = null;
    private JList zoneActionList = null;
    private JList hostPortList = null;
    private JList subSystemPortList = null;
    private JList volumeList = null;
    private DefaultListModel zoneActionListModel = null;
    private DefaultListModel hostPortListModel = null;
    private DefaultListModel subSystemPortListModel = null;
    private DefaultListModel volumeListModel = null;
    private CreateVolumeWizard cvWizard = null;
    private HashMap volumeData = null;
    private int width = 0;
    private int height = 0;
    private HashMap volumesmap = new HashMap();
    private String subsystemID;

    public CreateVolumeReviewStep(int n, String string) {
        super(n);
        this.setName("CreateVolumeReviewStep");
        this.subsystemID = string;
        Container container = this.getContentPane();
        container.add(this.create());
        this.getExistingVolumes();
        this.setUpHelp(DiskConstants.DISK_CREATE_VOLUME_REVIEW);
    }

    public Object next() {
        return null;
    }

    public Container create() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.setDefaultInsets(new Insets(0, 12, 0, 8));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VOLUME_REVIEW_SETTINGS_LABEL"));
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 3, 5));
        jPanel.add(this.titleLabel);
        jPanel.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        gridBagPanel.add((JComponent)jPanel, 23);
        gridBagPanel.newRow();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.descLabel = new JTextArea(Util.getString("DISK_VOLUME_REVIEW_SETTINGS_DESC_LABEL"));
        this.descLabel.setEditable(false);
        this.descLabel.setLineWrap(true);
        this.descLabel.setWrapStyleWord(true);
        this.descLabel.setBackground((Color)UIManager.get("Label.background"));
        this.descLabel.setForeground((Color)UIManager.get("Label.foreground"));
        this.descLabel.setFont((Font)UIManager.get("Label.font"));
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 5));
        jPanel2.add(this.descLabel);
        jPanel2.add(Box.createHorizontalGlue());
        gridBagPanel.add((JComponent)jPanel2, 0, 1, 2);
        gridBagPanel.newRow();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        this.quantityLabel = new JLabel(Util.getString("DISK_VOLUME_QUANTITY_LABEL"));
        this.quantityTextLabel = new JLabel();
        this.width = 16 * this.quantityTextLabel.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.quantityTextLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.quantityTextLabel.setMinimumSize(new Dimension(this.width, this.height));
        this.quantityTextLabel.setPreferredSize(new Dimension(this.width, this.height));
        this.quantityTextLabel.setMaximumSize(new Dimension(this.width * 2, this.height));
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)this.quantityLabel, gridBagConstraints);
        this.quantityLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.quantityTextLabel, gridBagConstraints);
        this.quantityTextLabel.setAlignmentX(0.0f);
        this.sizeLabel = new JLabel(Util.getString("DISK_VOLUME_SIZE_LABEL"));
        this.sizeTextLabel = new JLabel();
        this.width = 16 * this.sizeTextLabel.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.sizeTextLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.sizeTextLabel.setMinimumSize(new Dimension(this.width, this.height));
        this.sizeTextLabel.setPreferredSize(new Dimension(this.width, this.height));
        this.sizeTextLabel.setMaximumSize(new Dimension(this.width * 2, this.height));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel3.add((Component)this.sizeLabel, gridBagConstraints);
        this.sizeLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.sizeTextLabel, gridBagConstraints);
        this.sizeTextLabel.setAlignmentX(0.0f);
        this.arrayLabel = new JLabel(Util.getString("DISK_ARRAY_LABEL"));
        this.arrayTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel3.add((Component)this.arrayLabel, gridBagConstraints);
        this.arrayLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.arrayTextLabel, gridBagConstraints);
        this.arrayTextLabel.setAlignmentX(0.0f);
        this.width = 16 * this.arrayTextLabel.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.arrayTextLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.arrayTextLabel.setMinimumSize(new Dimension(this.width, this.height));
        this.arrayTextLabel.setPreferredSize(new Dimension(this.width, this.height));
        this.arrayTextLabel.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.raidLevelLabel = new JLabel(Util.getString("DISK_RAIDLEVEL_LABEL"));
        this.raidLevelTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel3.add((Component)this.raidLevelLabel, gridBagConstraints);
        this.raidLevelLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.raidLevelTextLabel, gridBagConstraints);
        this.raidLevelTextLabel.setAlignmentX(0.0f);
        this.width = 16 * this.raidLevelTextLabel.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.raidLevelTextLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.raidLevelTextLabel.setMinimumSize(new Dimension(this.width, this.height));
        this.raidLevelTextLabel.setPreferredSize(new Dimension(this.width, this.height));
        this.raidLevelTextLabel.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.hostPortTypeLabel = new JLabel(GuiUtil.getString("DISK_VOLUME_HOST_PORT_TYPE_LABEL"));
        this.hostPortTypeTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.hostPortTypeLabel, gridBagConstraints);
        this.hostPortTypeLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.hostPortTypeTextLabel, gridBagConstraints);
        this.hostPortTypeTextLabel.setAlignmentX(0.0f);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.nameLabel = new JLabel(Util.getString("DISK_VOLUME_NAME_PREFIX_LABEL"));
        this.nameTextLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.nameLabel, gridBagConstraints);
        this.nameLabel.setAlignmentX(1.0f);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.nameTextLabel, gridBagConstraints);
        this.nameTextLabel.setAlignmentX(0.0f);
        gridBagPanel.add(jPanel3);
        gridBagPanel.newRow();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.volumeListLabel = new JLabel(Util.getString("DISK_VOLUME_CREATE_VOLUME_LABEL"));
        jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel5.add(this.volumeListLabel);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.volumeList = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.volumeList);
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel4.add(jScrollPane);
        gridBagPanel.add(jPanel5);
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)jPanel4, 0, 1, 2);
        gridBagPanel.newRow();
        this.width = 16 * this.volumeList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.volumeList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        jPanel4.setMinimumSize(new Dimension(this.width, this.height));
        jPanel4.setPreferredSize(new Dimension(this.width, this.height));
        jPanel4.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.volumeList.setSelectionMode(0);
        GuiUtil.setAccessibleLabel(this.volumeListLabel, this.volumeList, "", this.volumeListLabel.getText(), this.volumeListLabel.getText());
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        this.zoneActionLabel = new JLabel(Util.getString("DISK_ZONE_ACTIONS_LABEL"));
        jPanel7.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel7.add(this.zoneActionLabel);
        gridBagPanel.newRow();
        jPanel7.add(Box.createHorizontalGlue());
        gridBagPanel.newRow();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        this.zoneActionList = new JList();
        JScrollPane jScrollPane2 = new JScrollPane(this.zoneActionList);
        jPanel6.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel6.add(jScrollPane2);
        this.width = 16 * this.zoneActionList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.zoneActionList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        jPanel6.setMinimumSize(new Dimension(this.width, this.height));
        jPanel6.setPreferredSize(new Dimension(this.width, this.height));
        jPanel6.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiUtil.setAccessibleLabel(this.zoneActionLabel, this.zoneActionList, "", this.zoneActionLabel.getText(), this.zoneActionLabel.getText());
        gridBagPanel.add(jPanel7);
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)jPanel6, 0, 1, 2);
        gridBagPanel.newRow();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        this.hostPortLabel = new JLabel(Util.getString("DISK_HOSTPORTS_LABEL"));
        jPanel9.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel9.add(this.hostPortLabel);
        jPanel9.add(Box.createHorizontalGlue());
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        this.hostPortList = new JList();
        JScrollPane jScrollPane3 = new JScrollPane(this.hostPortList);
        jPanel8.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel8.add(jScrollPane3);
        this.width = 16 * this.hostPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.hostPortList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        jPanel8.setMinimumSize(new Dimension(this.width, this.height));
        jPanel8.setPreferredSize(new Dimension(this.width, this.height));
        jPanel8.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiUtil.setAccessibleLabel(this.hostPortLabel, this.hostPortList, "", this.hostPortLabel.getText(), this.hostPortLabel.getText());
        gridBagPanel.add(jPanel9);
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)jPanel8, 0, 1, 2);
        gridBagPanel.newRow();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 0));
        this.subSystemPortLabel = new JLabel(Util.getString("DISK_SUBSYSTEMPORTS_LABEL"));
        jPanel11.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel11.add(this.subSystemPortLabel);
        jPanel11.add(Box.createHorizontalGlue());
        jPanel10.setLayout(new BoxLayout(jPanel10, 0));
        this.subSystemPortList = new JList();
        JScrollPane jScrollPane4 = new JScrollPane(this.subSystemPortList);
        jPanel10.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel10.add(jScrollPane4);
        this.width = 16 * this.subSystemPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.subSystemPortList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        jPanel10.setMinimumSize(new Dimension(this.width, this.height));
        jPanel10.setPreferredSize(new Dimension(this.width, this.height));
        jPanel10.setMaximumSize(new Dimension(this.width * 2, this.height));
        jPanel10.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiUtil.setAccessibleLabel(this.subSystemPortLabel, this.subSystemPortList, "", this.subSystemPortLabel.getText(), this.subSystemPortLabel.getText());
        gridBagPanel.add(jPanel11);
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)jPanel10, 0, 1, 2);
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)new JLabel(), 1);
        this.cvWizard = (CreateVolumeWizard)this.getParent();
        this.getNextButton().setEnabled(false);
        return gridBagPanel;
    }

    public void fillData() {
        Object object;
        this.cvWizard = (CreateVolumeWizard)this.getParent();
        this.volumeData = this.cvWizard.getData();
        this.quantityTextLabel.setText(this.volumeData.get(Util.getString("DISK_VOLUME_QUANTITY_LABEL")).toString());
        this.sizeTextLabel.setText(String.valueOf(this.volumeData.get(Util.getString("DISK_VOLUME_SIZE_LABEL")).toString()) + " " + this.volumeData.get(Util.getString("DISK_UNITS_LABEL")).toString());
        Object v = this.volumeData.get(Util.getString("DISK_VOLUME_AVAILABLE_ARRAYS_LABEL"));
        if (v != null) {
            object = (GUIStoragePool)v;
            if (((GUIEntity)object).getDeviceId().toString().length() == 0) {
                this.arrayTextLabel.setText(" (" + ((GUIStoragePool)object).getInstanceId() + ")");
            } else {
                this.arrayTextLabel.setText(((GUIEntity)object).getDeviceId());
            }
        }
        this.raidLevelTextLabel.setText(this.volumeData.get(Util.getString("DISK_RAIDLEVEL_LABEL")).toString());
        this.hostPortTypeTextLabel.setText(this.volumeData.get(CreateVolumeSelectHostPortsStep.HOSTPORTS_TYPE_NAME_DATA).toString());
        object = this.volumeData.get(Util.getString("DISK_NAME_LABEL")).toString();
        if (((String)object).length() <= 0) {
            object = Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL");
        }
        this.nameTextLabel.setText((String)object);
        Vector vector = this.generateVolumeList(this.nameTextLabel.getText(), Integer.valueOf(this.quantityTextLabel.getText()));
        if (vector.size() == 0) {
            vector = null;
        }
        this.cvWizard.addVolumeData(Util.getString("DISK_VOLUMES_LABEL"), vector);
        this.volumeListModel = this.addVectorToModel(vector);
        this.volumeList.setModel(this.volumeListModel);
        Vector vector2 = (Vector)this.volumeData.get(CreateVolumeSelectHostPortsStep.HOSTPORTS_DATA);
        Vector<String> vector3 = new Vector<String>();
        GUIPort gUIPort = null;
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        int n = 0;
        while (vector2 != null && n < vector2.size()) {
            try {
                gUIPort = (GUIPort)vector2.get(n);
            }
            catch (ClassCastException classCastException) {
                gUIPort = null;
            }
            if (gUIPort != null) {
                string = gUIPort.getWwpn();
                string2 = gUIPort.getHostName();
                string3 = gUIPort.getTypeName();
                if (string2 != null && string2.trim().length() > 0) {
                    string = String.valueOf(string) + "( " + string2;
                    if (string3 != null && string3.trim().length() > 0 && gUIPort.getType() != 0) {
                        string = String.valueOf(string) + ", " + string3;
                    }
                    string = String.valueOf(string) + " )";
                }
                vector3.add(string);
            } else {
                vector3.add((String)vector2.get(n));
            }
            ++n;
        }
        this.hostPortListModel = this.addVectorToModel(vector3);
        this.hostPortList.setModel(this.hostPortListModel);
        Vector vector4 = (Vector)this.volumeData.get(CreateVolumeSelectSubsystemPortsStep.SUBSYSTEM_DATA);
        Vector<String> vector5 = new Vector<String>();
        gUIPort = null;
        int n2 = 0;
        while (vector4 != null && n2 < vector4.size()) {
            gUIPort = (GUIPort)vector4.get(n2);
            string = gUIPort.getWwpn();
            string2 = gUIPort.getHostName();
            if (string2 != null && string2.trim().length() > 0) {
                string = String.valueOf(string) + " (" + string2 + ")";
            }
            vector5.add(string);
            ++n2;
        }
        this.subSystemPortListModel = this.addVectorToModel(vector5);
        this.subSystemPortList.setModel(this.subSystemPortListModel);
        HashMap hashMap = (HashMap)this.volumeData.get(CreateVolumeZoneActionStep.ZONE_LIST_DATA);
        Vector<Object> vector6 = new Vector();
        if (hashMap != null) {
            vector6 = new Vector(hashMap.values());
        }
        this.zoneActionListModel = this.addVectorToModel(vector6);
        this.zoneActionList.setModel(this.zoneActionListModel);
    }

    public boolean nextBegin() {
        return false;
    }

    public boolean previousBegin() {
        this.volumeData = null;
        return true;
    }

    private void getExistingVolumes() {
        DiskDataAccessor diskDataAccessor = DiskDataAccessor.getInstance();
        diskDataAccessor.getVolumeNamesBySubsystem(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4 && response != null) {
                    String[] stringArray = (String[])response.responseData;
                    CreateVolumeReviewStep.this.volumesmap = new HashMap();
                    int n = 0;
                    while (stringArray != null && n < stringArray.length) {
                        CreateVolumeReviewStep.this.volumesmap.put(stringArray[n], stringArray[n]);
                        ++n;
                    }
                }
            }
        }, this.subsystemID);
    }

    private Vector generateVolumeList(String string, int n) {
        Vector<String> vector = new Vector<String>();
        if (string.length() == 0) {
            vector.add(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"));
            return vector;
        }
        if (string.equals(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"))) {
            return vector;
        }
        if (n == 1 && this.volumesmap.get(string) == null) {
            if (!string.equals(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"))) {
                vector.add(string);
            }
            return vector;
        }
        int n2 = 1;
        String string2 = new String();
        int n3 = 0;
        while (n3 < n) {
            string2 = String.valueOf(string) + n2;
            while (this.volumesmap.get(string2) != null) {
                string2 = String.valueOf(string) + ++n2;
            }
            vector.add(string2);
            string2 = String.valueOf(string) + ++n2;
            ++n3;
        }
        return vector;
    }

    private DefaultListModel addVectorToModel(Vector vector) {
        DefaultListModel defaultListModel = new DefaultListModel();
        if (vector == null) {
            return defaultListModel;
        }
        int n = 0;
        while (n < vector.size()) {
            defaultListModel.add(n, vector.get(n));
            ++n;
        }
        return defaultListModel;
    }
}

