/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.drives;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.tape.common.LocationSortComparator;
import org.eclipse.aperi.gui.tape.common.TapeGuiTable;
import org.eclipse.aperi.gui.tape.common.TapeLocation;
import org.eclipse.aperi.gui.tape.drives.DrivesDDI;
import org.eclipse.aperi.gui.tape.drives.DrivesTableModel;

public class DrivesListPanel
extends JPanel
implements TJCTableMouseInterface {
    private static final String ACTION_VIEW_DETAILS = "TAPE_VIEW_DETAILS_LABEL";
    private DrivesDDI theDDI;
    private TapeGuiTable table = new TapeGuiTable();
    private DrivesTableModel tableModel;
    private JPanel p = new JPanel();
    private JPanel tablePanel = new JPanel();
    private boolean dblClick = false;
    private static DefaultTableCellRenderer drillDownRenderer = new DrillDownRenderer();

    public DrivesListPanel(DrivesDDI drivesDDI) {
        this.theDDI = drivesDDI;
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        this.p.setLayout(new BorderLayout());
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBorder(new TitledBorder(String.valueOf(Util.getString("TAPE_DRIVES_LABEL")) + " " + this.theDDI.library.getDisplayName()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.table.setMouseListener(this);
        this.buildtable();
        this.tablePanel.add((Component)this.table, gridBagConstraints);
        this.add((Component)this.p, "Center");
        this.p.add((Component)this.tablePanel, "Center");
        return this;
    }

    public boolean select(int n, int n2) {
        boolean bl = true;
        return bl;
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
        if (n < 0 || n2 < 0) {
            return;
        }
        int n5 = this.table.getPointedRow(n4);
        this.table.setSelectedRows(n5, n5);
        this.selectionChanged(true);
    }

    public void selectionChanged(boolean bl) {
    }

    public void doubleClick(int n, int n2) {
    }

    public void showDefaultChart(int n) {
    }

    public void buildtable() {
        this.tableModel = new DrivesTableModel(this.theDDI);
        this.table.setCellRenderer(JLabel.class, drillDownRenderer);
        this.table.setFrozenColumns(1);
        this.table.setBaseTableModel(this.tableModel);
        this.table.sortByColumn(0, 1);
        this.table.setSelectionPolicy(0);
        this.table.setColumnComparator(TapeLocation.class, new LocationSortComparator());
        this.table.updateUI();
    }

    private static class DrillDownRenderer
    extends DefaultTableCellRenderer {
        private DrillDownRenderer() {
        }

        public void setValue(Object object) {
            String string = ((JLabel)object).getText();
            this.setText(string);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(10);
            Icon icon = ((JLabel)object).getIcon();
            this.setIcon(icon);
        }
    }
}

