/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.tape.common.model.GUIFrame;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.common.model.TapeDataAccessor;
import org.eclipse.aperi.gui.tape.frames.FramesDDI;
import org.eclipse.aperi.gui.tape.library.LibraryDDI;
import org.eclipse.aperi.request.Response;

public class LibraryDetailsPanel
extends JPanel
implements FocusListener,
ActionListener {
    private LibraryDDI aDDI;
    private FramesDDI theDDI;
    private Insets insetA;
    private JPanel p = new JPanel();
    private JPanel summaryPanel = GuiUtil.getPanel();
    private JPanel btnPanel = new JPanel();
    private BoldLabel lbLibrary = new BoldLabel();
    private BoldLabel lbManuallyName = new BoldLabel();
    private BoldLabel lbDescription = new BoldLabel();
    private JLabel lbState = new JLabel();
    private BoldLabel lbDrives = new BoldLabel();
    private BoldLabel lbMediaChangers = new BoldLabel();
    private BoldLabel lbIOPorts = new BoldLabel();
    private BoldLabel lbFrames = new BoldLabel();
    private BoldLabel lbCartridgeCap = new BoldLabel();
    private BoldLabel lbFirmwareVer = new BoldLabel();
    private BoldLabel lbElementMgr1 = new BoldLabel();
    private BoldLabel lbElementMgr2 = new BoldLabel();
    private BoldLabel lbLockPresent = new BoldLabel();
    private BoldLabel lbLocked = new BoldLabel();
    private BoldLabel lbSecurity = new BoldLabel();
    private BoldLabel lbOwnerName = new BoldLabel();
    private BoldLabel lbOwnerContact = new BoldLabel();
    private BoldLabel lbType = new BoldLabel();
    private BoldLabel lbVendor = new BoldLabel();
    private BoldLabel lbSerialNr = new BoldLabel();
    private BoldLabel lbUserAttr1 = new BoldLabel();
    private BoldLabel lbUserAttr2 = new BoldLabel();
    private BoldLabel lbUserAttr3 = new BoldLabel();
    private GUILibrary libDetails;
    private GUIFrame frDetails;
    private JButton btnLaunch = new JButton(Util.getString("TAPE_LAUNCH_LABEL"));
    private JTextField txtManuallyName = new JTextField(30);
    private JTextField txtUserAttr1 = new JTextField(30);
    private JTextField txtUserAttr2 = new JTextField(30);
    private JTextField txtUserAttr3 = new JTextField(30);
    private String savedName = "";
    private String savedUdp1 = "";
    private String savedUdp2 = "";
    private String savedUdp3 = "";
    private String savedElmMgr = "";
    private boolean redisplay = false;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    Capabilities capabilities = this.guiMain.getCapabilities();
    private static ElementManagerHelperInterface elementManagerHelper = new ElementManagerHelperInterface(){

        public String extractGUID(Object object) {
            return ((GUILibrary)object).getId();
        }

        public String extractDefaultElementManager(Object object) {
            return ((GUILibrary)object).getElementManager();
        }

        public String extractDisplayName(Object object) {
            return ((GUILibrary)object).getName();
        }
    };

    public LibraryDetailsPanel(GUILibrary gUILibrary, GUIFrame gUIFrame, LibraryDDI libraryDDI) {
        this.aDDI = libraryDDI;
        this.libDetails = gUILibrary;
        this.frDetails = gUIFrame;
    }

    public JComponent getComponent() {
        this.setLayout(new FlowLayout(0));
        this.p.setLayout(new BorderLayout());
        this.summaryPanel.setLayout(new GridBagLayout());
        this.btnPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = this.insetA = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_LIBRARY_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.lbLibrary.setText(String.valueOf(this.libDetails.getDisplayName()));
        this.summaryPanel.add((Component)this.lbLibrary, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.lbManuallyName.setText(Util.getString("TAPE_NAME_LABEL"));
        this.summaryPanel.add((Component)this.lbManuallyName, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.savedName = this.libDetails.getUserProvidedName();
        this.txtManuallyName.setText(String.valueOf(this.savedName));
        this.txtManuallyName.addFocusListener(this);
        if (!this.capabilities.isTapeAdmin()) {
            this.txtManuallyName.setEditable(false);
        }
        this.summaryPanel.add((Component)this.txtManuallyName, gridBagConstraints);
        GuiUtil.setAccessible(this.txtManuallyName, this.txtManuallyName.getText(), this.txtManuallyName.getText());
        GuiUtil.setAccessibleLabel(this.lbManuallyName, this.txtManuallyName, "", this.lbManuallyName.getText(), this.lbManuallyName.getText());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_DESCRIPTION_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.lbDescription.setText(String.valueOf(this.libDetails.getDescription()));
        this.summaryPanel.add((Component)this.lbDescription, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_LIBRARY_TYPE_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.lbType.setText(String.valueOf(this.frDetails.getType()));
        this.summaryPanel.add((Component)this.lbType, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_LIBRARY_VENDOR_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.lbVendor.setText(String.valueOf(this.frDetails.getVendor()));
        this.summaryPanel.add((Component)this.lbVendor, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_LIBRARY_SERIAL_NUMBER_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.lbSerialNr.setText(String.valueOf(this.frDetails.getSerialNumber()));
        this.summaryPanel.add((Component)this.lbSerialNr, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_STATE_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.lbState = GUIEntityUtil.getEntityStateLabel(this.libDetails);
        this.summaryPanel.add((Component)this.lbState, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_DRIVES_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        this.lbDrives.setText(String.valueOf(this.libDetails.getDrives()));
        this.summaryPanel.add((Component)this.lbDrives, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_MEDIA_CHANGERS_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        this.lbMediaChangers.setText(String.valueOf(this.libDetails.getMediaChangers()));
        this.summaryPanel.add((Component)this.lbMediaChangers, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_IOPORTS_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        this.lbIOPorts.setText(String.valueOf(this.libDetails.getIoPorts()));
        this.summaryPanel.add((Component)this.lbIOPorts, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_FIRMWARE_VERSION_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        this.lbFirmwareVer.setText(String.valueOf(this.libDetails.getVersion()));
        this.summaryPanel.add((Component)this.lbFirmwareVer, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_LIBRARY_OWNER_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        this.lbOwnerName.setText(String.valueOf(this.libDetails.getOwnerName()));
        this.summaryPanel.add((Component)this.lbOwnerName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_LIBRARY_OWNER_CONTACT_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        this.lbOwnerContact.setText(String.valueOf(this.libDetails.getOwnerContact()));
        this.summaryPanel.add((Component)this.lbOwnerContact, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_LOCK_PRESENT_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        if (!this.frDetails.isLockPresent()) {
            this.lbLockPresent.setText(Util.getString("TAPE_NO_LABEL"));
            this.summaryPanel.add((Component)this.lbLockPresent, gridBagConstraints);
        } else {
            this.lbLockPresent.setText(Util.getString("TAPE_YES_LABEL"));
            this.summaryPanel.add((Component)this.lbLockPresent, gridBagConstraints);
        }
        this.summaryPanel.add((Component)this.lbLockPresent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_LOCKED_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        if (!this.frDetails.isLocked()) {
            this.lbLocked.setText(Util.getString("TAPE_NO_LABEL"));
        } else {
            this.lbLocked.setText(Util.getString("TAPE_YES_LABEL"));
        }
        this.summaryPanel.add((Component)this.lbLocked, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("TAPE_SECURITY_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        this.lbSecurity.setText(String.valueOf(this.frDetails.getSecurity()));
        this.summaryPanel.add((Component)this.lbSecurity, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        this.lbUserAttr1.setText(Util.getString("TAPE_USER_ATTR1_LABEL"));
        this.summaryPanel.add((Component)this.lbUserAttr1, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        this.savedUdp1 = this.libDetails.getUserAttrib1();
        this.txtUserAttr1.setText(String.valueOf(this.savedUdp1));
        this.txtUserAttr1.addFocusListener(this);
        this.summaryPanel.add((Component)this.txtUserAttr1, gridBagConstraints);
        if (!this.capabilities.isTapeAdmin()) {
            this.txtUserAttr1.setEditable(false);
        }
        GuiUtil.setAccessible(this.txtUserAttr1, this.txtUserAttr1.getText(), this.txtUserAttr1.getText());
        GuiUtil.setAccessibleLabel(this.lbUserAttr1, this.txtUserAttr1, "", this.lbUserAttr1.getText(), this.lbUserAttr1.getText());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        this.lbUserAttr2.setText(Util.getString("TAPE_USER_ATTR2_LABEL"));
        this.summaryPanel.add((Component)this.lbUserAttr2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        this.savedUdp2 = this.libDetails.getUserAttrib2();
        this.txtUserAttr2.setText(String.valueOf(this.savedUdp2));
        this.txtUserAttr2.addFocusListener(this);
        this.summaryPanel.add((Component)this.txtUserAttr2, gridBagConstraints);
        if (!this.capabilities.isTapeAdmin()) {
            this.txtUserAttr2.setEditable(false);
        }
        GuiUtil.setAccessible(this.txtUserAttr2, this.txtUserAttr2.getText(), this.txtUserAttr2.getText());
        GuiUtil.setAccessibleLabel(this.lbUserAttr2, this.txtUserAttr2, "", this.lbUserAttr2.getText(), this.lbUserAttr2.getText());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        this.lbUserAttr3.setText(Util.getString("TAPE_USER_ATTR3_LABEL"));
        this.summaryPanel.add((Component)this.lbUserAttr3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        this.savedUdp3 = this.libDetails.getUserAttrib3();
        this.txtUserAttr3.setText(String.valueOf(this.savedUdp3));
        this.txtUserAttr3.addFocusListener(this);
        this.summaryPanel.add((Component)this.txtUserAttr3, gridBagConstraints);
        if (!this.capabilities.isTapeAdmin()) {
            this.txtUserAttr3.setEditable(false);
        }
        GuiUtil.setAccessible(this.txtUserAttr3, this.txtUserAttr3.getText(), this.txtUserAttr3.getText());
        GuiUtil.setAccessibleLabel(this.lbUserAttr3, this.txtUserAttr3, "", this.lbUserAttr3.getText(), this.lbUserAttr3.getText());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        this.lbElementMgr1.setText(GuiUtil.getString("TAPE_ELEMENT_MANAGER_LABEL"));
        this.summaryPanel.add((Component)this.lbElementMgr1, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        this.lbElementMgr2.setText(ElementManagerManager.getInstance().getElementManager(this.libDetails, this.getElementManagerHelper()));
        this.btnPanel.add((Component)this.lbElementMgr2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        this.btnLaunch.setEnabled(ElementManagerManager.getInstance().hasElementManager(this.libDetails, this.getElementManagerHelper()));
        this.btnLaunch.addActionListener(this);
        this.btnPanel.add((Component)this.btnLaunch, gridBagConstraints);
        this.summaryPanel.add((Component)this.btnPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets.top = 10;
        this.add((Component)this.p, gridBagConstraints2);
        this.p.add((Component)this.summaryPanel, "North");
        return this;
    }

    private void showAndAddListeners() {
        this.guiMain.setSaveActionEnabled(true, false);
        this.guiMain.addSaveActionListener(this);
    }

    public void disableAndRemoveListeners() {
        this.guiMain.setSaveActionEnabled(false, false);
        this.guiMain.removeSaveActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (actionEvent.getActionCommand().equals("Save")) {
            this.SaveAndRefresh();
        } else if (object == this.btnLaunch) {
            ElementManagerManager.getInstance().launchElementManager(this.libDetails, this.getElementManagerHelper());
        }
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return elementManagerHelper;
    }

    public void saveAll(boolean bl) {
        this.redisplay = bl;
        TapeDataAccessor tapeDataAccessor = TapeDataAccessor.getInstance();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (!this.txtManuallyName.getText().equals(this.savedName)) {
            hashtable.put("USER_PROVIDED_NAME", this.txtManuallyName.getText());
        }
        if (!this.txtUserAttr1.getText().equals(this.savedUdp1)) {
            hashtable.put("USER_ATTRIB1", this.txtUserAttr1.getText());
        }
        if (!this.txtUserAttr2.getText().equals(this.savedUdp2)) {
            hashtable.put("USER_ATTRIB2", this.txtUserAttr2.getText());
        }
        if (!this.txtUserAttr3.getText().equals(this.savedUdp3)) {
            hashtable.put("USER_ATTRIB3", this.txtUserAttr3.getText());
        }
        if (hashtable.size() > 0) {
            tapeDataAccessor.setLibraryAttributes(new GuiRequestor(){

                public void handleResponse(short s, Response response) {
                    int n;
                    Serializable serializable;
                    if (s == 0 && (serializable = response.responseData) != null && (n = ((Integer)serializable).intValue()) == 0) {
                        LibraryDetailsPanel.this.savedName = LibraryDetailsPanel.this.txtManuallyName.getText();
                        LibraryDetailsPanel.this.savedUdp1 = LibraryDetailsPanel.this.txtUserAttr1.getText();
                        LibraryDetailsPanel.this.savedUdp2 = LibraryDetailsPanel.this.txtUserAttr2.getText();
                        LibraryDetailsPanel.this.savedUdp3 = LibraryDetailsPanel.this.txtUserAttr3.getText();
                        if (LibraryDetailsPanel.this.redisplay) {
                            LibraryDetailsPanel.this.aDDI.getData();
                        }
                    }
                }
            }, this.libDetails.getId(), hashtable);
        }
    }

    public void changesPending(boolean bl) {
        if (this.hasChanged()) {
            int n = JOptionPane.showConfirmDialog(this, Util.getString("TAPE_LIBRARY_DETAILS_SAVE_LABEL"), Util.getString("TAPE_LIBRARY_DETAILS_SAVE_TITLE"), 0);
            switch (n) {
                case 0: {
                    this.saveAll(bl);
                }
                case 1: {
                    this.disableAndRemoveListeners();
                    break;
                }
            }
        }
    }

    public boolean hasChanged() {
        return !this.txtManuallyName.getText().equals(this.savedName) || !this.txtUserAttr1.getText().equals(this.savedUdp1) || !this.txtUserAttr2.getText().equals(this.savedUdp2) || !this.txtUserAttr3.getText().equals(this.savedUdp3);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.txtManuallyName && !focusEvent.isTemporary() && !this.hasChanged() || focusEvent.getComponent() == this.txtUserAttr1 && !focusEvent.isTemporary() && !this.hasChanged() || focusEvent.getComponent() == this.txtUserAttr2 && !focusEvent.isTemporary() && !this.hasChanged() || focusEvent.getComponent() == this.txtUserAttr3 && !focusEvent.isTemporary() && !this.hasChanged()) {
            this.disableAndRemoveListeners();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.txtManuallyName && !focusEvent.isTemporary() || focusEvent.getComponent() == this.txtUserAttr1 && !focusEvent.isTemporary() || focusEvent.getComponent() == this.txtUserAttr2 && !focusEvent.isTemporary() || focusEvent.getComponent() == this.txtUserAttr3 && !focusEvent.isTemporary()) {
            this.showAndAddListeners();
        }
    }

    private void SaveAndRefresh() {
        this.saveAll(true);
        this.disableAndRemoveListeners();
    }
}

