/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoAssociation;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoUnit;
import org.eclipse.aperi.gui.topo.widget.ITopoAssociationModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoLine
extends AbstractJTopoAssociation {
    protected static final int DOT_HALF_SIZE = 2;
    protected Color color;
    protected Vector lineV;
    protected Rectangle2D.Float dot1;
    protected Rectangle2D.Float dot2;
    protected boolean firstPassOfLayout;

    protected AbstractJTopoLine() {
        this((ITopoAssociationModel)null, true);
    }

    protected AbstractJTopoLine(ITopoAssociationModel iTopoAssociationModel, boolean bl) {
        super(iTopoAssociationModel, bl);
        this.setOpaque(false);
        this.lineV = new Vector();
        this.dot1 = new Rectangle2D.Float();
        this.dot2 = new Rectangle2D.Float();
        this.removeMouseListener(this.mlClick);
        this.removeMouseListener(this.mlDrag);
        this.removeMouseMotionListener(this.mlDrag);
        this.mlClick = null;
        this.mlDrag = null;
        this.initState();
    }

    private void initState() {
        this.color = null;
        this.lineV.clear();
        this.dot1.setRect(0.0f, 0.0f, 0.0f, 0.0f);
        this.dot2.setRect(0.0f, 0.0f, 0.0f, 0.0f);
        this.firstPassOfLayout = false;
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    public void modelChanged() {
        this.modelChanged_setHealth();
    }

    protected void modelChanged_setHealth() {
        ITopoAssociationModel iTopoAssociationModel = (ITopoAssociationModel)this.widgetModel;
        Integer n = iTopoAssociationModel.getHealth();
        this.color = GraphModelConstant.STATUS_UNKNOWN.equals(n) ? TopoResource.COLOR_LINE_UNKNOWN : (GraphModelConstant.STATUS_NORMAL.equals(n) ? TopoResource.COLOR_LINE_NORMAL : (GraphModelConstant.STATUS_WARNING.equals(n) ? TopoResource.COLOR_LINE_WARNING : (GraphModelConstant.STATUS_CRITICAL.equals(n) ? TopoResource.COLOR_LINE_CRITICAL : (GraphModelConstant.STATUS_MISSING.equals(n) ? TopoResource.COLOR_LINE_MISSING : TopoResource.COLOR_LINE_NA))));
    }

    public boolean isValidateRoot() {
        return true;
    }

    public void setOverlayHealthEnabled(boolean bl) {
    }

    public void setOverlayPerfEnabled(boolean bl) {
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord arrangeRecord) {
    }

    public boolean isFirstPassOfLayout() {
        return this.firstPassOfLayout;
    }

    public void setFirstPassOfLayout(boolean bl) {
        this.firstPassOfLayout = bl;
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.lineV.size() == 0) {
            return;
        }
        ITopoAssociationModel iTopoAssociationModel = (ITopoAssociationModel)this.widgetModel;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (iTopoAssociationModel.isThick()) {
            graphics2D.setStroke(new BasicStroke(3.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(1.0f));
        }
        graphics2D.setPaint(this.color);
        int n = 0;
        while (n < this.lineV.size()) {
            Line2D.Float float_ = (Line2D.Float)this.lineV.elementAt(n);
            graphics2D.draw(float_);
            ++n;
        }
        if (this.dot1 != null) {
            graphics2D.fill(this.dot1);
        }
        if (this.dot2 != null) {
            graphics2D.fill(this.dot2);
        }
    }

    protected class DefaultLayout
    implements LayoutManager {
        protected int gap = 20;

        protected DefaultLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            if (AbstractJTopoLine.this.firstPassOfLayout) {
                AbstractJTopoLine.this.setBounds(0, 0, 1, 1);
                return;
            }
            try {
                ITopoAssociationModel iTopoAssociationModel = (ITopoAssociationModel)AbstractJTopoLine.this.widgetModel;
                if (iTopoAssociationModel == null) {
                    return;
                }
                AbstractJTopoUnit abstractJTopoUnit = iTopoAssociationModel.getFromWidget().getLastVisibleUnit();
                AbstractJTopoUnit abstractJTopoUnit2 = iTopoAssociationModel.getToWidget().getLastVisibleUnit();
                AbstractJTopoCanvas.CanvasPanel canvasPanel = AbstractJTopoLine.this.canvas.getCanvasPanel();
                if (abstractJTopoUnit != abstractJTopoUnit2) {
                    Point point = null;
                    Point point2 = null;
                    point = abstractJTopoUnit.getConnectingPoint();
                    point2 = abstractJTopoUnit2.getConnectingPoint();
                    point = SwingUtilities.convertPoint(abstractJTopoUnit.getParent(), point, canvasPanel);
                    point2 = SwingUtilities.convertPoint(abstractJTopoUnit2.getParent(), point2, canvasPanel);
                    this.setStraintLine(point, point2);
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }

        protected void setStraintLine(Point point, Point point2) {
            try {
                Rectangle rectangle = new Rectangle(point.x - 2, point.y - 2, 4, 4);
                Rectangle rectangle2 = new Rectangle(point2.x - 2, point2.y - 2, 4, 4);
                Rectangle rectangle3 = rectangle.union(rectangle2);
                AbstractJTopoLine.this.setBounds(rectangle3);
                AbstractJTopoLine.this.lineV.removeAllElements();
                AbstractJTopoLine.this.lineV.add(new Line2D.Float(point.x - rectangle3.x, point.y - rectangle3.y, point2.x - rectangle3.x, point2.y - rectangle3.y));
                AbstractJTopoLine.this.dot1.setRect(rectangle.x - rectangle3.x, rectangle.y - rectangle3.y, rectangle.width, rectangle.height);
                AbstractJTopoLine.this.dot2.setRect(rectangle2.x - rectangle3.x, rectangle2.y - rectangle3.y, rectangle2.width, rectangle2.height);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }
}

