/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoContainerWithTitle;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoPoster;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSummaryWithTitle;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoEventSource;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoPosterTab
extends AbstractJTopoGroup {
    protected IndexPanel indexPanel;
    protected BodyPanel bodyPanel;
    protected AbstractJTopoPoster poster;
    protected ML_MinusPlus ml_minusPlus;

    protected AbstractJTopoPosterTab() {
        this((ITopoGroupModel)null, true);
    }

    protected AbstractJTopoPosterTab(ITopoGroupModel iTopoGroupModel, boolean bl) {
        super(iTopoGroupModel, bl);
        iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        this.ml_minusPlus = new ML_MinusPlus();
        this.indexPanel = new IndexPanel(iTopoGroupModel);
        this.bodyPanel = new BodyPanel(iTopoGroupModel);
        this.initState();
    }

    private void initState() {
        this.poster = null;
        this.setExpansible(false);
        this.indexPanel.setLogicalParent(this);
        this.indexPanel.getTitlePanel().setLogicalParent(this);
        this.indexPanel.getSummaryPanel().setLogicalParent(this);
        this.bodyPanel.setLogicalParent(this);
        this.bodyPanel.getTitlePanel().setLogicalParent(this);
        this.bodyPanel.getContainerPanel().setLogicalParent(this);
        this.add(this.indexPanel);
    }

    public void resetState() {
        super.resetState();
        this.indexPanel.resetState();
        this.bodyPanel.resetState();
        this.initState();
    }

    public void setSessionModel(AbstractJTopoCanvas abstractJTopoCanvas, String string) {
        super.setSessionModel(abstractJTopoCanvas, string);
        this.indexPanel.setSessionModel(abstractJTopoCanvas, string);
        this.bodyPanel.setSessionModel(abstractJTopoCanvas, string);
    }

    public void setDataModel(GraphEntity graphEntity) {
        super.setDataModel(graphEntity);
        this.indexPanel.setDataModel(graphEntity);
        this.bodyPanel.setDataModel(graphEntity);
    }

    public IndexPanel getIndexPanel() {
        return this.indexPanel;
    }

    public BodyPanel getBodyPanel() {
        return this.bodyPanel;
    }

    public void modelChanged() {
        this.indexPanel.modelChanged();
        this.bodyPanel.modelChanged();
    }

    public void selectionChanged() {
        this.indexPanel.selectionChanged();
        this.bodyPanel.selectionChanged();
    }

    public void highlightChanged() {
        this.indexPanel.highlightChanged();
        this.bodyPanel.highlightChanged();
    }

    public void setExpansible(boolean bl) {
        super.setExpansible(bl);
        if (this.isExpansible) {
            this.setExpanded(this.isExpanded);
        } else {
            this.indexPanel.labelMinusPlus.setVisible(false);
            this.bodyPanel.setVisible(false);
            this.revalidate();
            this.repaint();
            this.bodyPanel.revalidate();
            this.bodyPanel.repaint();
        }
    }

    public void setExpanded(boolean bl) {
        super.setExpanded(bl);
        if (this.isExpanded) {
            this.indexPanel.labelMinusPlus.setIcon(TopoResource.ICON_BOX_MINUS);
            this.indexPanel.labelMinusPlus.setVisible(true);
            this.bodyPanel.setVisible(true);
        } else {
            this.indexPanel.labelMinusPlus.setIcon(TopoResource.ICON_BOX_PLUS);
            this.indexPanel.labelMinusPlus.setVisible(true);
            this.bodyPanel.setVisible(false);
        }
        this.revalidate();
        this.repaint();
        this.bodyPanel.revalidate();
        this.bodyPanel.repaint();
    }

    public void setLogicalParent(AbstractJTopoEntity abstractJTopoEntity) {
        this.logicalParent = abstractJTopoEntity;
        this.poster = (AbstractJTopoPoster)abstractJTopoEntity;
    }

    public AbstractJTopoPoster getPoster() {
        return this.poster;
    }

    public void setPoster(AbstractJTopoPoster abstractJTopoPoster) {
        this.setLogicalParent(abstractJTopoPoster);
    }

    public Vector getLogicalChilds() {
        return this.bodyPanel.getEntities();
    }

    public boolean isContainLogicalChild(AbstractJTopoEntity abstractJTopoEntity) {
        return this.bodyPanel.isContainEntity(abstractJTopoEntity);
    }

    public void addLogicalChild(AbstractJTopoEntity abstractJTopoEntity) {
        AbstractJTopoPosterTab abstractJTopoPosterTab = (AbstractJTopoPosterTab)abstractJTopoEntity.getLogicalParent();
        if (abstractJTopoPosterTab != null) {
            abstractJTopoPosterTab.removeLogicalChild(abstractJTopoEntity);
        }
        abstractJTopoEntity.setLogicalParent(this);
        this.bodyPanel.addEntity(abstractJTopoEntity);
        this.setExpansible(this.isContainNonfilterable());
    }

    public void removeLogicalChild(AbstractJTopoEntity abstractJTopoEntity) {
        if (abstractJTopoEntity.getLogicalParent() == this) {
            abstractJTopoEntity.setLogicalParent(null);
        }
        this.bodyPanel.removeEntity(abstractJTopoEntity);
        this.setExpansible(this.isContainNonfilterable());
    }

    public void removeAllLogicalChilds() {
        Vector vector = this.bodyPanel.getEntities();
        int n = 0;
        while (n < vector.size()) {
            AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)vector.elementAt(n);
            if (abstractJTopoEntity.getLogicalParent() == this) {
                abstractJTopoEntity.setLogicalParent(null);
            }
            ++n;
        }
        this.bodyPanel.removeAllEntities();
        this.setExpansible(false);
    }

    public void setOverlayHealthEnabled(boolean bl) {
        this.indexPanel.setOverlayHealthEnabled(bl);
        this.bodyPanel.setOverlayHealthEnabled(bl);
    }

    public void setOverlayPerfEnabled(boolean bl) {
        this.indexPanel.setOverlayPerfEnabled(bl);
        this.bodyPanel.setOverlayPerfEnabled(bl);
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord arrangeRecord) {
        this.indexPanel.setArrange(arrangeRecord);
        this.bodyPanel.setArrange(arrangeRecord);
    }

    protected void handleMinusPlusMouseClick(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            this.setExpanded(!this.isExpanded);
        } else {
            this.handleMouseClick(mouseEvent);
        }
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class BodyPanel
    extends AbstractJTopoContainerWithTitle {
        protected JLabel labelMinusPlus;

        public BodyPanel(ITopoNodeModel iTopoNodeModel) {
            super(iTopoNodeModel, false);
            iTopoNodeModel = (ITopoGroupModel)this.widgetModel;
            this.labelMinusPlus = new JLabel();
            this.labelMinusPlus.setIcon(TopoResource.ICON_BOX_MINUS);
            this.add((Component)this.labelMinusPlus, 0);
            this.labelMinusPlus.addMouseListener(AbstractJTopoPosterTab.this.ml_minusPlus);
            this.labelMinusPlus.addMouseListener(this.mlDrag);
            this.labelMinusPlus.addMouseMotionListener(this.mlDrag);
            this.containerPanel.setLayout(new TopoLayoutUtilities.HorizontalLayout());
        }

        protected void reattach() {
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        implements LayoutManager {
            private int spacingForMinusPlus = 10;

            public void addLayoutComponent(String string, Component component) {
            }

            public void removeLayoutComponent(Component component) {
            }

            public Dimension preferredLayoutSize(Container container) {
                Dimension dimension = new Dimension(0, 0);
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right;
                dimension.height += insets.top + insets.bottom;
                int n = 0;
                int n2 = 0;
                Dimension dimension2 = BodyPanel.this.titlePanel.getPreferredSize();
                n += dimension2.width;
                n2 += dimension2.height;
                dimension2 = BodyPanel.this.containerPanel.getPreferredSize();
                n = dimension2.width > (n += this.spacingForMinusPlus) ? dimension2.width : n;
                dimension.width += n;
                dimension.height += (n2 += dimension2.height);
                return dimension;
            }

            public Dimension minimumLayoutSize(Container container) {
                return this.preferredLayoutSize(container);
            }

            public void layoutContainer(Container container) {
                Insets insets = container.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                Dimension dimension = BodyPanel.this.titlePanel.getPreferredSize();
                Rectangle rectangle = new Rectangle();
                rectangle.x = n;
                rectangle.y = n2;
                rectangle.width = container.getWidth() - insets.left - insets.right;
                rectangle.height = dimension.height;
                BodyPanel.this.titlePanel.setBounds(rectangle);
                n2 += BodyPanel.this.titlePanel.getHeight();
                dimension = BodyPanel.this.labelMinusPlus.getPreferredSize();
                rectangle = new Rectangle();
                rectangle.x = container.getWidth() - insets.right - dimension.width / 2 - 1;
                rectangle.y = insets.top - dimension.height / 2;
                rectangle.width = dimension.width;
                rectangle.height = dimension.height;
                BodyPanel.this.labelMinusPlus.setBounds(rectangle);
                dimension = BodyPanel.this.containerPanel.getPreferredSize();
                rectangle = new Rectangle();
                rectangle.x = n;
                rectangle.y = n2;
                rectangle.width = BodyPanel.this.titlePanel.getWidth();
                rectangle.height = dimension.height;
                BodyPanel.this.containerPanel.setBounds(rectangle);
            }
        }
    }

    protected class DefaultLayout
    extends TopoLayoutUtilities.VerticalLayout {
    }

    protected class IndexPanel
    extends AbstractJTopoSummaryWithTitle {
        protected JLabel labelMinusPlus;

        public IndexPanel(ITopoGroupModel iTopoGroupModel) {
            super(iTopoGroupModel, false);
            iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
            this.labelMinusPlus = new JLabel();
            this.add((Component)this.labelMinusPlus, 0);
            this.labelMinusPlus.addMouseListener(AbstractJTopoPosterTab.this.ml_minusPlus);
            this.labelMinusPlus.addMouseListener(this.mlDrag);
            this.labelMinusPlus.addMouseMotionListener(this.mlDrag);
        }

        protected void reattach() {
        }

        protected LayoutManager createDefaultLayout() {
            return new DefaultLayout();
        }

        protected class DefaultLayout
        implements LayoutManager {
            private int spacingForMinusPlus = 10;

            public void addLayoutComponent(String string, Component component) {
            }

            public void removeLayoutComponent(Component component) {
            }

            public Dimension preferredLayoutSize(Container container) {
                Dimension dimension = new Dimension(0, 0);
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right;
                dimension.height += insets.top + insets.bottom;
                int n = 0;
                int n2 = 0;
                Dimension dimension2 = IndexPanel.this.titlePanel.getPreferredSize();
                n += dimension2.width;
                n2 += dimension2.height;
                dimension2 = IndexPanel.this.summaryPanel.getPreferredSize();
                n = dimension2.width > (n += this.spacingForMinusPlus) ? dimension2.width : n;
                dimension.width += n;
                dimension.height += (n2 += dimension2.height);
                return dimension;
            }

            public Dimension minimumLayoutSize(Container container) {
                return this.preferredLayoutSize(container);
            }

            public void layoutContainer(Container container) {
                Insets insets = container.getInsets();
                int n = insets.left;
                int n2 = insets.top;
                Dimension dimension = IndexPanel.this.titlePanel.getPreferredSize();
                Rectangle rectangle = new Rectangle();
                rectangle.x = n;
                rectangle.y = n2;
                rectangle.width = container.getWidth() - insets.left - insets.right;
                rectangle.height = dimension.height;
                IndexPanel.this.titlePanel.setBounds(rectangle);
                n2 += IndexPanel.this.titlePanel.getHeight();
                dimension = IndexPanel.this.labelMinusPlus.getPreferredSize();
                rectangle = new Rectangle();
                rectangle.x = container.getWidth() - insets.right - dimension.width / 2 - 1;
                rectangle.y = insets.top - dimension.height / 2;
                rectangle.width = dimension.width;
                rectangle.height = dimension.height;
                IndexPanel.this.labelMinusPlus.setBounds(rectangle);
                dimension = IndexPanel.this.summaryPanel.getPreferredSize();
                rectangle = new Rectangle();
                rectangle.x = n;
                rectangle.y = n2;
                rectangle.width = IndexPanel.this.titlePanel.getWidth();
                rectangle.height = dimension.height;
                IndexPanel.this.summaryPanel.setBounds(rectangle);
            }
        }
    }

    protected class ML_MinusPlus
    extends MouseAdapter {
        protected ML_MinusPlus() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.setSource(new TopoEventSource(mouseEvent));
            AbstractJTopoPosterTab.this.handleMinusPlusMouseClick(mouseEvent);
        }
    }
}

