/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.identity;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.identity.MainframeLinuxHWID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class HardwareID
implements Serializable {
    static final long serialVersionUID = 1177468458824214297L;
    private static final int MAX_HWID_LENGTH = 20;
    public byte[] hardwareID;
    public String manufacturer;
    public String hostName;
    public short osType;
    public short cpuArchitecture;
    private transient boolean isPCArchitecture;
    public static String model;
    public static String serialNumber;

    private void init(byte[] byArray, String string, String string2, short s, short s2) {
        this.hardwareID = byArray;
        this.manufacturer = string;
        this.hostName = string2;
        this.osType = s;
        this.cpuArchitecture = s2;
    }

    public HardwareID(byte[] byArray, String string, String string2, short s, short s2) {
        this.init(byArray, string, string2, s, s2);
    }

    public HardwareID(byte[] byArray, String string, String string2, short s) {
        this.init(byArray, string, string2, s, (short)0);
    }

    public HardwareID(byte[] byArray, String string) throws LocalizableException {
        MutableShort mutableShort = new MutableShort();
        short s = HardwareID.getOSType(mutableShort);
        this.init(byArray, string, HardwareID.getLocalHostName(), s, mutableShort.value);
    }

    public HardwareID(String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "HardwareID", "localHostName");
        }
        this.isPCArchitecture = false;
        this.manufacturer = "UNKNOWN";
        MutableShort mutableShort = new MutableShort();
        this.osType = HardwareID.getOSType(mutableShort);
        this.cpuArchitecture = mutableShort.value;
        mutableShort = null;
        HardwareID.initIDs();
        try {
            if (this.cpuArchitecture != 5) {
                this.queryHardware();
            } else {
                MainframeLinuxHWID.query(this);
                this.manufacturer = "IBM";
            }
            if (this.osType != 6) {
                this.hardwareID = GUID.readGUID().toByteArray();
            }
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(HardwareID.class.getName(), "HardwareID", localizableException);
            }
            localizableException.print();
        }
        if (this.hardwareID == null && this.isPCArchitecture) {
            MessageLog.logMessage("GEN0083I");
            try {
                this.queryEthernetCard();
                MessageLog.logMessage("GEN0084I");
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(HardwareID.class.getName(), "HardwareID", localizableException);
                }
                localizableException.print();
            }
        }
        this.hostName = string;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "HardwareID");
        }
    }

    public HardwareID() throws LocalizableException {
        this(HardwareID.getLocalHostName());
    }

    public static native String getLocalHostName() throws LocalizableException;

    public void setBogusHardwareID(String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "setBogusHardwareID", "bogus");
        }
        this.hardwareID = string.getBytes();
        if (this.hardwareID.length > 20) {
            byte[] byArray = new byte[20];
            System.arraycopy(this.hardwareID, 0, byArray, 0, byArray.length);
            this.hardwareID = byArray;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "setBogusHardwareID");
        }
    }

    private static native void initIDs();

    private native void queryHardware() throws LocalizableException;

    private native void queryEthernetCard() throws LocalizableException;

    private static short handleHPUX() {
        int n;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "handleHPUX", "");
        }
        int n2 = 3;
        String string = System.getProperty("os.version");
        if (string != null && (n = string.indexOf(46)) >= 0) {
            int n3;
            if ((n3 = string.indexOf(46, ++n)) < 0) {
                n3 = string.length();
            }
            String string2 = string.substring(n, n3);
            int n4 = 11;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
            if (n4 == 10) {
                n2 = 7;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "handleHPUX", (short)n2);
        }
        return (short)n2;
    }

    public static short getOSType(MutableShort mutableShort) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "getOSType", "cpuArchitecture");
        }
        int n = 0;
        mutableShort.value = 0;
        String string = System.getProperty("os.name", " ");
        if (string.equalsIgnoreCase("Solaris")) {
            n = 6;
            mutableShort.value = (short)3;
        } else if (string.equalsIgnoreCase("SunOS")) {
            n = 6;
            mutableShort.value = (short)3;
        } else if (string.equalsIgnoreCase("linux")) {
            n = 1;
            String string2 = System.getProperty("os.arch", " ");
            mutableShort.value = (string2 = string2.toLowerCase()).startsWith("s390") ? (short)5 : (string2.startsWith("ppc") ? (short)1 : (short)2);
        } else if (string.regionMatches(true, 0, "win", 0, 3)) {
            mutableShort.value = (short)2;
            String string3 = System.getProperty("os.version", " ");
            n = string3.charAt(0) >= '5' ? 5 : 4;
        } else if (string.equalsIgnoreCase("aix")) {
            n = 2;
            mutableShort.value = 1;
        } else if (string.equalsIgnoreCase("HP-UX")) {
            n = HardwareID.handleHPUX();
            mutableShort.value = (short)4;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "getOSType", (short)n);
        }
        return (short)n;
    }

    public static short getOSType() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "getOSType", "");
        }
        MutableShort mutableShort = new MutableShort();
        short s = HardwareID.getOSType(mutableShort);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "getOSType", s);
        }
        return s;
    }

    public static short getCPUArch() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "getCPUArch", "");
        }
        MutableShort mutableShort = new MutableShort();
        HardwareID.getOSType(mutableShort);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "getCPUArch", mutableShort.value);
        }
        return mutableShort.value;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(HardwareID.class.getName(), "equals", "obj");
        }
        HardwareID hardwareID = (HardwareID)object;
        boolean bl2 = bl = Arrays.equals(this.hardwareID, hardwareID.hardwareID) && this.manufacturer.compareToIgnoreCase(hardwareID.manufacturer) == 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(HardwareID.class.getName(), "equals", bl);
        }
        return bl;
    }
}

