/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResAliasTable;

public class Alias
extends TResAliasTable {
    public static AliasCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new AliasCursor(dBConnection, hashtable, vector);
    }

    public Alias() {
        this.clear();
    }

    public Alias(int n, String string, String string2, String string3) {
        this.clear();
        this.m_AliasId = n;
        this.m_FabricWwn = string;
        this.m_AliasName = string2;
        this.m_Description = string3;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_AliasId != Integer.MIN_VALUE) {
            hashtable.put(Alias.getColumnInfo("ALIAS_ID"), String.valueOf(this.m_AliasId));
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(Alias.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htColsAndValues.put(Alias.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_AliasName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key ALIAS_NAME not found");
        }
        this.htColsAndValues.put(Alias.getColumnInfo("ALIAS_NAME"), this.m_AliasName);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_ALIAS", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Alias.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        if (hashtable.get(Alias.getColumnInfo("ALIAS_NAME")) == null) {
            throw new SQLException(" ERROR: key ALIAS_NAME not found");
        }
        return DBQueryAssistant.performInsert("T_RES_ALIAS", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_AliasName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key ALIAS_NAME not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), this.m_AliasName);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_ALIAS", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Alias.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), hashtable.get(Alias.getColumnInfo("FABRIC_WWN")));
        if (hashtable.get(Alias.getColumnInfo("ALIAS_NAME")) == null) {
            throw new SQLException(" ERROR: key ALIAS_NAME not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), hashtable.get(Alias.getColumnInfo("ALIAS_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_ALIAS", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_AliasName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key ALIAS_NAME not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), this.m_AliasName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_ALIAS", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Alias.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), hashtable.get(Alias.getColumnInfo("FABRIC_WWN")));
        if (hashtable.get(Alias.getColumnInfo("ALIAS_NAME")) == null) {
            throw new SQLException(" ERROR: key ALIAS_NAME not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), hashtable.get(Alias.getColumnInfo("ALIAS_NAME")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_ALIAS", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_FabricWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key FABRIC_WWN not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("FABRIC_WWN"), this.m_FabricWwn);
        if (this.m_AliasName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key ALIAS_NAME not found");
        }
        this.htWhereClause.put(Alias.getColumnInfo("ALIAS_NAME"), this.m_AliasName);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_ALIAS", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Alias retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Alias alias = null;
        if (hashtable.get(Alias.getColumnInfo("FABRIC_WWN")) == null) {
            throw new SQLException(" ERROR: key FABRIC_WWN not found");
        }
        hashtable2.put(Alias.getColumnInfo("FABRIC_WWN"), hashtable.get(Alias.getColumnInfo("FABRIC_WWN")));
        if (hashtable.get(Alias.getColumnInfo("ALIAS_NAME")) == null) {
            throw new SQLException(" ERROR: key ALIAS_NAME not found");
        }
        hashtable2.put(Alias.getColumnInfo("ALIAS_NAME"), hashtable.get(Alias.getColumnInfo("ALIAS_NAME")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_ALIAS", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                alias = new Alias();
                alias.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return alias;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_ALIAS", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_ALIAS", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setAliasId(dBResultSet.getInt("ALIAS_ID"));
        this.setFabricWwn(dBResultSet.getString("FABRIC_WWN"));
        this.setAliasName(dBResultSet.getString("ALIAS_NAME"));
        this.setDescription(dBResultSet.getString("DESCRIPTION"));
    }

    public static class AliasCursor
    extends DBCursor {
        private Alias element = new Alias();
        private DBConnection con;

        public AliasCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_ALIAS", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public Alias getObject() throws SQLException {
            Alias alias = null;
            if (this.DBrs != null) {
                alias = new Alias();
                alias.setFields(this.con, this.DBrs);
            }
            return alias;
        }

        public Alias getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

