/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TViewComputerAttrsTable;

public class ComputerAttrs
extends TViewComputerAttrsTable {
    private String m_VendorId_str;

    public void setVendor(String string) {
        this.m_VendorId_str = string;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public static ComputerAttrsCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new ComputerAttrsCursor(dBConnection, hashtable, vector);
    }

    public ComputerAttrs() {
        this.clear();
    }

    public ComputerAttrs(String string, String string2, short s, String string3, String string4, String string5, int n, String string6, byte[] byArray, short s2, String string7, Timestamp timestamp, byte[] byArray2, short s3, String string8, String string9, short s4, int n2, short s5, short s6, Timestamp timestamp2, Timestamp timestamp3, String string10, String string11, String string12, String string13, String string14, short s7, String string15, Timestamp timestamp4, short s8, int n3, int n4, String string16, String string17, String string18, String string19, short s9, short s10, int n5, int n6, double d, double d2, double d3, Timestamp timestamp5, String string20, Timestamp timestamp6, double d4, double d5, int n7, int n8) {
        this.clear();
        this.m_Guid = string;
        this.m_HostUrl = string2;
        this.m_OsType = s;
        this.m_OsVersion = string3;
        this.m_NetworkName = string4;
        this.m_DomainName = string5;
        this.m_ComputerId = n;
        this.m_HostName = string6;
        this.m_HardwareId = byArray;
        this.m_VendorId = s2;
        this.m_TimeZone = string7;
        this.m_DiscoveredTime = timestamp;
        this.m_ProductStates = byArray2;
        this.m_CpuArchitecture = s3;
        this.m_OriginalAlias = string8;
        this.m_IpAddress = string9;
        this.m_Detectable = s4;
        this.m_OperationalStatus = n2;
        this.m_ConsolidatedStatus = s5;
        this.m_PropagatedStatus = s6;
        this.m_ChangedTimestamp = timestamp2;
        this.m_UpdateTimestamp = timestamp3;
        this.m_UserAttrib1 = string10;
        this.m_UserAttrib2 = string11;
        this.m_UserAttrib3 = string12;
        this.m_Name = string13;
        this.m_WinDomainName = string14;
        this.m_DiscoveryMethod = s7;
        this.m_NameIsLocal = string15;
        this.m_WhenDiscovered = timestamp4;
        this.m_TimesMissing = s8;
        this.m_DomainId = n3;
        this.m_GroupId = n4;
        this.m_Manufacturer = string16;
        this.m_Model = string17;
        this.m_SerialNumber = string18;
        this.m_ProcessorType = string19;
        this.m_ProcessorCount = s9;
        this.m_ProcessorSpeed = s10;
        this.m_Ram = n5;
        this.m_SwapSpace = n6;
        this.m_DiskCapacity = d;
        this.m_FsFreeSpace = d2;
        this.m_DiskFreeSpace = d3;
        this.m_LastBootTime = timestamp5;
        this.m_ProbeStatus = string20;
        this.m_LastProbeTime = timestamp6;
        this.m_OwnedDiskCap = d4;
        this.m_OwnedDiskFreeSp = d5;
        this.m_ClusterId = n7;
        this.m_NodeHostedId = n8;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_Guid != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("GUID"), this.m_Guid);
        }
        if (this.m_HostUrl != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("HOST_URL"), this.m_HostUrl);
        }
        if (this.m_OsType != Short.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("OS_TYPE"), String.valueOf(this.m_OsType));
        }
        if (this.m_OsVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("OS_VERSION"), this.m_OsVersion);
        }
        if (this.m_NetworkName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("NETWORK_NAME"), this.m_NetworkName);
        }
        if (this.m_DomainName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("DOMAIN_NAME"), this.m_DomainName);
        }
        if (this.m_ComputerId != Integer.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("COMPUTER_ID"), String.valueOf(this.m_ComputerId));
        }
        if (this.m_HostName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("HOST_NAME"), this.m_HostName);
        }
        if (this.m_HardwareId != DBConstants.INVALID_BYTE_ARRAY_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("HARDWARE_ID"), new String(this.m_HardwareId));
        }
        if (this.m_VendorId != Short.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_TimeZone != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("TIME_ZONE"), this.m_TimeZone);
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
        if (this.m_ProductStates != DBConstants.INVALID_BYTE_ARRAY_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("PRODUCT_STATES"), new String(this.m_ProductStates));
        }
        if (this.m_CpuArchitecture != Short.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("CPU_ARCHITECTURE"), String.valueOf(this.m_CpuArchitecture));
        }
        if (this.m_OriginalAlias != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("ORIGINAL_ALIAS"), this.m_OriginalAlias);
        }
        if (this.m_IpAddress != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_ChangedTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("CHANGED_TIMESTAMP"), this.m_ChangedTimestamp);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_WinDomainName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("WIN_DOMAIN_NAME"), this.m_WinDomainName);
        }
        if (this.m_DiscoveryMethod != Short.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("DISCOVERY_METHOD"), String.valueOf(this.m_DiscoveryMethod));
        }
        if (this.m_NameIsLocal != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("NAME_IS_LOCAL"), this.m_NameIsLocal);
        }
        if (this.m_WhenDiscovered != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("WHEN_DISCOVERED"), this.m_WhenDiscovered);
        }
        if (this.m_TimesMissing != Short.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("TIMES_MISSING"), String.valueOf(this.m_TimesMissing));
        }
        if (this.m_DomainId != Integer.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("DOMAIN_ID"), String.valueOf(this.m_DomainId));
        }
        if (this.m_GroupId != Integer.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("GROUP_ID"), String.valueOf(this.m_GroupId));
        }
        if (this.m_Manufacturer != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("MANUFACTURER"), this.m_Manufacturer);
        }
        if (this.m_Model != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("MODEL"), this.m_Model);
        }
        if (this.m_SerialNumber != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("SERIAL_NUMBER"), this.m_SerialNumber);
        }
        if (this.m_ProcessorType != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("PROCESSOR_TYPE"), this.m_ProcessorType);
        }
        if (this.m_ProcessorCount != Short.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("PROCESSOR_COUNT"), String.valueOf(this.m_ProcessorCount));
        }
        if (this.m_ProcessorSpeed != Short.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("PROCESSOR_SPEED"), String.valueOf(this.m_ProcessorSpeed));
        }
        if (this.m_Ram != Integer.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("RAM"), String.valueOf(this.m_Ram));
        }
        if (this.m_SwapSpace != Integer.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("SWAP_SPACE"), String.valueOf(this.m_SwapSpace));
        }
        if (this.m_DiskCapacity != Double.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("DISK_CAPACITY"), String.valueOf(this.m_DiskCapacity));
        }
        if (this.m_FsFreeSpace != Double.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("FS_FREE_SPACE"), String.valueOf(this.m_FsFreeSpace));
        }
        if (this.m_DiskFreeSpace != Double.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("DISK_FREE_SPACE"), String.valueOf(this.m_DiskFreeSpace));
        }
        if (this.m_LastBootTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("LAST_BOOT_TIME"), this.m_LastBootTime);
        }
        if (this.m_ProbeStatus != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("PROBE_STATUS"), this.m_ProbeStatus);
        }
        if (this.m_LastProbeTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("LAST_PROBE_TIME"), this.m_LastProbeTime);
        }
        if (this.m_OwnedDiskCap != Double.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("OWNED_DISK_CAP"), String.valueOf(this.m_OwnedDiskCap));
        }
        if (this.m_OwnedDiskFreeSp != Double.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("OWNED_DISK_FREE_SP"), String.valueOf(this.m_OwnedDiskFreeSp));
        }
        if (this.m_ClusterId != Integer.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("CLUSTER_ID"), String.valueOf(this.m_ClusterId));
        }
        if (this.m_NodeHostedId != Integer.MIN_VALUE) {
            hashtable.put(ComputerAttrs.getColumnInfo("NODE_HOSTED_ID"), String.valueOf(this.m_NodeHostedId));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_VIEW_COMPUTER_ATTRS", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performInsert("T_VIEW_COMPUTER_ATTRS", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_COMPUTER_ATTRS", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_VIEW_COMPUTER_ATTRS", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_COMPUTER_ATTRS", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_VIEW_COMPUTER_ATTRS", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_VIEW_COMPUTER_ATTRS", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static ComputerAttrs retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        ComputerAttrs computerAttrs = null;
        if (hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_VIEW_COMPUTER_ATTRS", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                computerAttrs = new ComputerAttrs();
                computerAttrs.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return computerAttrs;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable2.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            hashtable2.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable2.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_VIEW_COMPUTER_ATTRS", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performDelete("T_VIEW_COMPUTER_ATTRS", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setGuid(dBResultSet.getString("GUID"));
        this.setHostUrl(dBResultSet.getString("HOST_URL"));
        this.setOsType(dBResultSet.getShort("OS_TYPE"));
        this.setOsVersion(dBResultSet.getString("OS_VERSION"));
        this.setNetworkName(dBResultSet.getString("NETWORK_NAME"));
        this.setDomainName(dBResultSet.getString("DOMAIN_NAME"));
        this.setComputerId(dBResultSet.getInt("COMPUTER_ID"));
        this.setHostName(dBResultSet.getString("HOST_NAME"));
        this.setHardwareId(dBResultSet.getBytes("HARDWARE_ID"));
        this.setVendorId(dBResultSet.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(dBConnection, this.m_VendorId));
        this.setTimeZone(dBResultSet.getString("TIME_ZONE"));
        this.setDiscoveredTime(dBResultSet.getTimestamp("DISCOVERED_TIME"));
        this.setProductStates(dBResultSet.getBytes("PRODUCT_STATES"));
        this.setCpuArchitecture(dBResultSet.getShort("CPU_ARCHITECTURE"));
        this.setOriginalAlias(dBResultSet.getString("ORIGINAL_ALIAS"));
        this.setIpAddress(dBResultSet.getString("IP_ADDRESS"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(dBResultSet.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(dBResultSet.getShort("PROPAGATED_STATUS"));
        this.setChangedTimestamp(dBResultSet.getTimestamp("CHANGED_TIMESTAMP"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setUserAttrib1(dBResultSet.getString("USER_ATTRIB1"));
        this.setUserAttrib2(dBResultSet.getString("USER_ATTRIB2"));
        this.setUserAttrib3(dBResultSet.getString("USER_ATTRIB3"));
        this.setName(dBResultSet.getString("NAME"));
        this.setWinDomainName(dBResultSet.getString("WIN_DOMAIN_NAME"));
        this.setDiscoveryMethod(dBResultSet.getShort("DISCOVERY_METHOD"));
        this.setNameIsLocal(dBResultSet.getString("NAME_IS_LOCAL"));
        this.setWhenDiscovered(dBResultSet.getTimestamp("WHEN_DISCOVERED"));
        this.setTimesMissing(dBResultSet.getShort("TIMES_MISSING"));
        this.setDomainId(dBResultSet.getInt("DOMAIN_ID"));
        this.setGroupId(dBResultSet.getInt("GROUP_ID"));
        this.setManufacturer(dBResultSet.getString("MANUFACTURER"));
        this.setModel(dBResultSet.getString("MODEL"));
        this.setSerialNumber(dBResultSet.getString("SERIAL_NUMBER"));
        this.setProcessorType(dBResultSet.getString("PROCESSOR_TYPE"));
        this.setProcessorCount(dBResultSet.getShort("PROCESSOR_COUNT"));
        this.setProcessorSpeed(dBResultSet.getShort("PROCESSOR_SPEED"));
        this.setRam(dBResultSet.getInt("RAM"));
        this.setSwapSpace(dBResultSet.getInt("SWAP_SPACE"));
        this.setDiskCapacity(dBResultSet.getDouble("DISK_CAPACITY"));
        this.setFsFreeSpace(dBResultSet.getDouble("FS_FREE_SPACE"));
        this.setDiskFreeSpace(dBResultSet.getDouble("DISK_FREE_SPACE"));
        this.setLastBootTime(dBResultSet.getTimestamp("LAST_BOOT_TIME"));
        this.setProbeStatus(dBResultSet.getString("PROBE_STATUS"));
        this.setLastProbeTime(dBResultSet.getTimestamp("LAST_PROBE_TIME"));
        this.setOwnedDiskCap(dBResultSet.getDouble("OWNED_DISK_CAP"));
        this.setOwnedDiskFreeSp(dBResultSet.getDouble("OWNED_DISK_FREE_SP"));
        this.setClusterId(dBResultSet.getInt("CLUSTER_ID"));
        this.setNodeHostedId(dBResultSet.getInt("NODE_HOSTED_ID"));
    }

    public static class ComputerAttrsCursor
    extends DBCursor {
        private ComputerAttrs element = new ComputerAttrs();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")) != null) {
                hashtable.put(ComputerAttrs.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(ComputerAttrs.getColumnInfo("VENDOR_ID")))));
            }
            return hashtable;
        }

        public ComputerAttrsCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_VIEW_COMPUTER_ATTRS", dBConnection, ComputerAttrsCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public ComputerAttrs getObject() throws SQLException {
            ComputerAttrs computerAttrs = null;
            if (this.DBrs != null) {
                computerAttrs = new ComputerAttrs();
                computerAttrs.setFields(this.con, this.DBrs);
            }
            return computerAttrs;
        }

        public ComputerAttrs getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

