/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;

public class DataPath
extends TResDataPathTable {
    public static DataPathCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new DataPathCursor(dBConnection, hashtable, vector);
    }

    public DataPath() {
        this.clear();
    }

    public DataPath(int n, int n2, int n3, int n4, int n5, int n6, String string, Timestamp timestamp, int n7, int n8) {
        this.clear();
        this.m_DataPathId = n;
        this.m_HostLunId = n2;
        this.m_DeviceLunId = n3;
        this.m_InitiatorPortId = n4;
        this.m_TargetPortId = n5;
        this.m_VolumeId = n6;
        this.m_UnknownHostName = string;
        this.m_UpdateTimestamp = timestamp;
        this.m_MaskingInfoId = n7;
        this.m_SubsystemId = n8;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_DataPathId != Integer.MIN_VALUE) {
            hashtable.put(DataPath.getColumnInfo("DATA_PATH_ID"), String.valueOf(this.m_DataPathId));
        }
        if (this.m_HostLunId != Integer.MIN_VALUE) {
            hashtable.put(DataPath.getColumnInfo("HOST_LUN_ID"), String.valueOf(this.m_HostLunId));
        }
        if (this.m_DeviceLunId != Integer.MIN_VALUE) {
            hashtable.put(DataPath.getColumnInfo("DEVICE_LUN_ID"), String.valueOf(this.m_DeviceLunId));
        }
        if (this.m_UnknownHostName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DataPath.getColumnInfo("UNKNOWN_HOST_NAME"), this.m_UnknownHostName);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(DataPath.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_MaskingInfoId != Integer.MIN_VALUE) {
            hashtable.put(DataPath.getColumnInfo("MASKING_INFO_ID"), String.valueOf(this.m_MaskingInfoId));
        }
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            hashtable.put(DataPath.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_InitiatorPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htColsAndValues.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), String.valueOf(this.m_InitiatorPortId));
        if (this.m_TargetPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TARGET_PORT_ID not found");
        }
        this.htColsAndValues.put(DataPath.getColumnInfo("TARGET_PORT_ID"), String.valueOf(this.m_TargetPortId));
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htColsAndValues.put(DataPath.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_DATA_PATH", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key INITIATOR_PORT_ID not found");
        }
        if (hashtable.get(DataPath.getColumnInfo("TARGET_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key TARGET_PORT_ID not found");
        }
        if (hashtable.get(DataPath.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_DATA_PATH", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_InitiatorPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), String.valueOf(this.m_InitiatorPortId));
        if (this.m_TargetPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TARGET_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), String.valueOf(this.m_TargetPortId));
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DATA_PATH", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), hashtable.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")));
        if (hashtable.get(DataPath.getColumnInfo("TARGET_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key TARGET_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), hashtable.get(DataPath.getColumnInfo("TARGET_PORT_ID")));
        if (hashtable.get(DataPath.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), hashtable.get(DataPath.getColumnInfo("VOLUME_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DATA_PATH", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_InitiatorPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), String.valueOf(this.m_InitiatorPortId));
        if (this.m_TargetPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TARGET_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), String.valueOf(this.m_TargetPortId));
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DATA_PATH", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), hashtable.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")));
        if (hashtable.get(DataPath.getColumnInfo("TARGET_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key TARGET_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), hashtable.get(DataPath.getColumnInfo("TARGET_PORT_ID")));
        if (hashtable.get(DataPath.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), hashtable.get(DataPath.getColumnInfo("VOLUME_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DATA_PATH", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_InitiatorPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key INITIATOR_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), String.valueOf(this.m_InitiatorPortId));
        if (this.m_TargetPortId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TARGET_PORT_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("TARGET_PORT_ID"), String.valueOf(this.m_TargetPortId));
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(DataPath.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_DATA_PATH", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static DataPath retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        DataPath dataPath = null;
        if (hashtable.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key INITIATOR_PORT_ID not found");
        }
        hashtable2.put(DataPath.getColumnInfo("INITIATOR_PORT_ID"), hashtable.get(DataPath.getColumnInfo("INITIATOR_PORT_ID")));
        if (hashtable.get(DataPath.getColumnInfo("TARGET_PORT_ID")) == null) {
            throw new SQLException(" ERROR: key TARGET_PORT_ID not found");
        }
        hashtable2.put(DataPath.getColumnInfo("TARGET_PORT_ID"), hashtable.get(DataPath.getColumnInfo("TARGET_PORT_ID")));
        if (hashtable.get(DataPath.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        hashtable2.put(DataPath.getColumnInfo("VOLUME_ID"), hashtable.get(DataPath.getColumnInfo("VOLUME_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_DATA_PATH", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                dataPath = new DataPath();
                dataPath.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return dataPath;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_DATA_PATH", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_DATA_PATH", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setDataPathId(dBResultSet.getInt("DATA_PATH_ID"));
        this.setHostLunId(dBResultSet.getInt("HOST_LUN_ID"));
        this.setDeviceLunId(dBResultSet.getInt("DEVICE_LUN_ID"));
        this.setInitiatorPortId(dBResultSet.getInt("INITIATOR_PORT_ID"));
        this.setTargetPortId(dBResultSet.getInt("TARGET_PORT_ID"));
        this.setVolumeId(dBResultSet.getInt("VOLUME_ID"));
        this.setUnknownHostName(dBResultSet.getString("UNKNOWN_HOST_NAME"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setMaskingInfoId(dBResultSet.getInt("MASKING_INFO_ID"));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
    }

    public static class DataPathCursor
    extends DBCursor {
        private DataPath element = new DataPath();
        private DBConnection con;

        public DataPathCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_DATA_PATH", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public DataPath getObject() throws SQLException {
            DataPath dataPath = null;
            if (this.DBrs != null) {
                dataPath = new DataPath();
                dataPath.setFields(this.con, this.DBrs);
            }
            return dataPath;
        }

        public DataPath getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

