/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResHbaAttributeSnapshotTable;

public class HbaAttributeSnapshot
extends TResHbaAttributeSnapshotTable {
    public static HbaAttributeSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new HbaAttributeSnapshotCursor(dBConnection, hashtable, vector);
    }

    public HbaAttributeSnapshot() {
        this.clear();
    }

    public HbaAttributeSnapshot(int n, String string, String string2, short s, int n2) {
        this.clear();
        this.m_HbaId = n;
        this.m_DriverVersion = string;
        this.m_FirmwareVersion = string2;
        this.m_Detectable = s;
        this.m_OperationalStatus = n2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_DriverVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(HbaAttributeSnapshot.getColumnInfo("DRIVER_VERSION"), this.m_DriverVersion);
        }
        if (this.m_FirmwareVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(HbaAttributeSnapshot.getColumnInfo("FIRMWARE_VERSION"), this.m_FirmwareVersion);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(HbaAttributeSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(HbaAttributeSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_HbaId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HBA_ID not found");
        }
        this.htColsAndValues.put(HbaAttributeSnapshot.getColumnInfo("HBA_ID"), String.valueOf(this.m_HbaId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(HbaAttributeSnapshot.getColumnInfo("HBA_ID")) == null) {
            throw new SQLException(" ERROR: key HBA_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_HbaId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HBA_ID not found");
        }
        this.htWhereClause.put(HbaAttributeSnapshot.getColumnInfo("HBA_ID"), String.valueOf(this.m_HbaId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(HbaAttributeSnapshot.getColumnInfo("HBA_ID")) == null) {
            throw new SQLException(" ERROR: key HBA_ID not found");
        }
        this.htWhereClause.put(HbaAttributeSnapshot.getColumnInfo("HBA_ID"), hashtable.get(HbaAttributeSnapshot.getColumnInfo("HBA_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_HbaId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HBA_ID not found");
        }
        this.htWhereClause.put(HbaAttributeSnapshot.getColumnInfo("HBA_ID"), String.valueOf(this.m_HbaId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(HbaAttributeSnapshot.getColumnInfo("HBA_ID")) == null) {
            throw new SQLException(" ERROR: key HBA_ID not found");
        }
        this.htWhereClause.put(HbaAttributeSnapshot.getColumnInfo("HBA_ID"), hashtable.get(HbaAttributeSnapshot.getColumnInfo("HBA_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_HbaId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key HBA_ID not found");
        }
        this.htWhereClause.put(HbaAttributeSnapshot.getColumnInfo("HBA_ID"), String.valueOf(this.m_HbaId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static HbaAttributeSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        HbaAttributeSnapshot hbaAttributeSnapshot = null;
        if (hashtable.get(HbaAttributeSnapshot.getColumnInfo("HBA_ID")) == null) {
            throw new SQLException(" ERROR: key HBA_ID not found");
        }
        hashtable2.put(HbaAttributeSnapshot.getColumnInfo("HBA_ID"), hashtable.get(HbaAttributeSnapshot.getColumnInfo("HBA_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                hbaAttributeSnapshot = new HbaAttributeSnapshot();
                hbaAttributeSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return hbaAttributeSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setHbaId(dBResultSet.getInt("HBA_ID"));
        this.setDriverVersion(dBResultSet.getString("DRIVER_VERSION"));
        this.setFirmwareVersion(dBResultSet.getString("FIRMWARE_VERSION"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
    }

    public static class HbaAttributeSnapshotCursor
    extends DBCursor {
        private HbaAttributeSnapshot element = new HbaAttributeSnapshot();
        private DBConnection con;

        public HbaAttributeSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_HBA_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public HbaAttributeSnapshot getObject() throws SQLException {
            HbaAttributeSnapshot hbaAttributeSnapshot = null;
            if (this.DBrs != null) {
                hbaAttributeSnapshot = new HbaAttributeSnapshot();
                hbaAttributeSnapshot.setFields(this.con, this.DBrs);
            }
            return hbaAttributeSnapshot;
        }

        public HbaAttributeSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

