/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResIpTargetTable;

public class IpTarget
extends TResIpTargetTable {
    public static IpTargetCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new IpTargetCursor(dBConnection, hashtable, vector);
    }

    public IpTarget() {
        this.clear();
    }

    public IpTarget(String string, String string2, String string3, String string4, String string5, String string6) {
        this.clear();
        this.m_HostName = string;
        this.m_IpAddress = string2;
        this.m_UserId = string3;
        this.m_Password = string4;
        this.m_ReadCommunityName = string5;
        this.m_RwCommunityName = string6;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_HostName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(IpTarget.getColumnInfo("HOST_NAME"), this.m_HostName);
        }
        if (this.m_UserId != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(IpTarget.getColumnInfo("USER_ID"), this.m_UserId);
        }
        if (this.m_Password != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(IpTarget.getColumnInfo("PASSWORD"), this.m_Password);
        }
        if (this.m_ReadCommunityName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(IpTarget.getColumnInfo("READ_COMMUNITY_NAME"), this.m_ReadCommunityName);
        }
        if (this.m_RwCommunityName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(IpTarget.getColumnInfo("RW_COMMUNITY_NAME"), this.m_RwCommunityName);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htColsAndValues.put(IpTarget.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_IP_TARGET", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(IpTarget.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        return DBQueryAssistant.performInsert("T_RES_IP_TARGET", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(IpTarget.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_IP_TARGET", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(IpTarget.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(IpTarget.getColumnInfo("IP_ADDRESS"), hashtable.get(IpTarget.getColumnInfo("IP_ADDRESS")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_IP_TARGET", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(IpTarget.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_IP_TARGET", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(IpTarget.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(IpTarget.getColumnInfo("IP_ADDRESS"), hashtable.get(IpTarget.getColumnInfo("IP_ADDRESS")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_IP_TARGET", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(IpTarget.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_IP_TARGET", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static IpTarget retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        IpTarget ipTarget = null;
        if (hashtable.get(IpTarget.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        hashtable2.put(IpTarget.getColumnInfo("IP_ADDRESS"), hashtable.get(IpTarget.getColumnInfo("IP_ADDRESS")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_IP_TARGET", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                ipTarget = new IpTarget();
                ipTarget.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return ipTarget;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_IP_TARGET", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_IP_TARGET", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setHostName(dBResultSet.getString("HOST_NAME"));
        this.setIpAddress(dBResultSet.getString("IP_ADDRESS"));
        this.setUserId(dBResultSet.getString("USER_ID"));
        this.setPassword(dBResultSet.getString("PASSWORD"));
        this.setReadCommunityName(dBResultSet.getString("READ_COMMUNITY_NAME"));
        this.setRwCommunityName(dBResultSet.getString("RW_COMMUNITY_NAME"));
    }

    public static class IpTargetCursor
    extends DBCursor {
        private IpTarget element = new IpTarget();
        private DBConnection con;

        public IpTargetCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_IP_TARGET", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public IpTarget getObject() throws SQLException {
            IpTarget ipTarget = null;
            if (this.DBrs != null) {
                ipTarget = new IpTarget();
                ipTarget.setFields(this.con, this.DBrs);
            }
            return ipTarget;
        }

        public IpTarget getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

