/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResOutbandAgentTable;

public class OutbandAgent
extends TResOutbandAgentTable {
    public static OutbandAgentCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new OutbandAgentCursor(dBConnection, hashtable, vector);
    }

    public OutbandAgent() {
        this.clear();
    }

    public OutbandAgent(int n, String string, String string2, String string3, String string4) {
        this.clear();
        this.m_OutbandAgentId = n;
        this.m_HostName = string;
        this.m_IpAddress = string2;
        this.m_UserId = string3;
        this.m_Password = string4;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_OutbandAgentId != Integer.MIN_VALUE) {
            hashtable.put(OutbandAgent.getColumnInfo("OUTBAND_AGENT_ID"), String.valueOf(this.m_OutbandAgentId));
        }
        if (this.m_HostName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(OutbandAgent.getColumnInfo("HOST_NAME"), this.m_HostName);
        }
        if (this.m_UserId != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(OutbandAgent.getColumnInfo("USER_ID"), this.m_UserId);
        }
        if (this.m_Password != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(OutbandAgent.getColumnInfo("PASSWORD"), this.m_Password);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htColsAndValues.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_OUTBAND_AGENT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(OutbandAgent.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        return DBQueryAssistant.performInsert("T_RES_OUTBAND_AGENT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_OUTBAND_AGENT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(OutbandAgent.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), hashtable.get(OutbandAgent.getColumnInfo("IP_ADDRESS")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_OUTBAND_AGENT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_OUTBAND_AGENT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(OutbandAgent.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), hashtable.get(OutbandAgent.getColumnInfo("IP_ADDRESS")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_OUTBAND_AGENT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_IpAddress == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key IP_ADDRESS not found");
        }
        this.htWhereClause.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), this.m_IpAddress);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_OUTBAND_AGENT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static OutbandAgent retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        OutbandAgent outbandAgent = null;
        if (hashtable.get(OutbandAgent.getColumnInfo("IP_ADDRESS")) == null) {
            throw new SQLException(" ERROR: key IP_ADDRESS not found");
        }
        hashtable2.put(OutbandAgent.getColumnInfo("IP_ADDRESS"), hashtable.get(OutbandAgent.getColumnInfo("IP_ADDRESS")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_OUTBAND_AGENT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                outbandAgent = new OutbandAgent();
                outbandAgent.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return outbandAgent;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_OUTBAND_AGENT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_OUTBAND_AGENT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setOutbandAgentId(dBResultSet.getInt("OUTBAND_AGENT_ID"));
        this.setHostName(dBResultSet.getString("HOST_NAME"));
        this.setIpAddress(dBResultSet.getString("IP_ADDRESS"));
        this.setUserId(dBResultSet.getString("USER_ID"));
        this.setPassword(dBResultSet.getString("PASSWORD"));
    }

    public static class OutbandAgentCursor
    extends DBCursor {
        private OutbandAgent element = new OutbandAgent();
        private DBConnection con;

        public OutbandAgentCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_OUTBAND_AGENT", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public OutbandAgent getObject() throws SQLException {
            OutbandAgent outbandAgent = null;
            if (this.DBrs != null) {
                outbandAgent = new OutbandAgent();
                outbandAgent.setFields(this.con, this.DBrs);
            }
            return outbandAgent;
        }

        public OutbandAgent getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

