/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TStatSpaceHistTable;

public class SpaceHist
extends TStatSpaceHistTable {
    public static SpaceHistCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new SpaceHistCursor(dBConnection, hashtable, vector);
    }

    public SpaceHist() {
        this.clear();
    }

    public SpaceHist(int n, int n2, String string, Timestamp timestamp, short s, double d, double d2) {
        this.clear();
        this.m_FilesystemId = n;
        this.m_StatisticId = n2;
        this.m_StatisticType = string;
        this.m_StatisticTime = timestamp;
        this.m_AccumCount = s;
        this.m_FileCount = d;
        this.m_TotalSize = d2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_FilesystemId != Integer.MIN_VALUE) {
            hashtable.put(SpaceHist.getColumnInfo("FILESYSTEM_ID"), String.valueOf(this.m_FilesystemId));
        }
        if (this.m_StatisticId != Integer.MIN_VALUE) {
            hashtable.put(SpaceHist.getColumnInfo("STATISTIC_ID"), String.valueOf(this.m_StatisticId));
        }
        if (this.m_StatisticType != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(SpaceHist.getColumnInfo("STATISTIC_TYPE"), this.m_StatisticType);
        }
        if (this.m_StatisticTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(SpaceHist.getColumnInfo("STATISTIC_TIME"), this.m_StatisticTime);
        }
        if (this.m_AccumCount != Short.MIN_VALUE) {
            hashtable.put(SpaceHist.getColumnInfo("ACCUM_COUNT"), String.valueOf(this.m_AccumCount));
        }
        if (this.m_FileCount != Double.MIN_VALUE) {
            hashtable.put(SpaceHist.getColumnInfo("FILE_COUNT"), String.valueOf(this.m_FileCount));
        }
        if (this.m_TotalSize != Double.MIN_VALUE) {
            hashtable.put(SpaceHist.getColumnInfo("TOTAL_SIZE"), String.valueOf(this.m_TotalSize));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_STAT_SPACE_HIST", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performInsert("T_STAT_SPACE_HIST", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_SPACE_HIST", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_STAT_SPACE_HIST", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_SPACE_HIST", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_STAT_SPACE_HIST", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_STAT_SPACE_HIST", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static SpaceHist retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        SpaceHist spaceHist = null;
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_STAT_SPACE_HIST", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                spaceHist = new SpaceHist();
                spaceHist.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return spaceHist;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_STAT_SPACE_HIST", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_STAT_SPACE_HIST", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setFilesystemId(dBResultSet.getInt("FILESYSTEM_ID"));
        this.setStatisticId(dBResultSet.getInt("STATISTIC_ID"));
        this.setStatisticType(dBResultSet.getString("STATISTIC_TYPE"));
        this.setStatisticTime(dBResultSet.getTimestamp("STATISTIC_TIME"));
        this.setAccumCount(dBResultSet.getShort("ACCUM_COUNT"));
        this.setFileCount(dBResultSet.getDouble("FILE_COUNT"));
        this.setTotalSize(dBResultSet.getDouble("TOTAL_SIZE"));
    }

    public static class SpaceHistCursor
    extends DBCursor {
        private SpaceHist element = new SpaceHist();
        private DBConnection con;

        public SpaceHistCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_STAT_SPACE_HIST", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public SpaceHist getObject() throws SQLException {
            SpaceHist spaceHist = null;
            if (this.DBrs != null) {
                spaceHist = new SpaceHist();
                spaceHist.setFields(this.con, this.DBrs);
            }
            return spaceHist;
        }

        public SpaceHist getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

