/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaChangerAttributeSnapshotTable;

public class TapeMediaChangerAttributeSnapshot
extends TResTapeMediaChangerAttributeSnapshotTable {
    public static TapeMediaChangerAttributeSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new TapeMediaChangerAttributeSnapshotCursor(dBConnection, hashtable, vector);
    }

    public TapeMediaChangerAttributeSnapshot() {
        this.clear();
    }

    public TapeMediaChangerAttributeSnapshot(int n, int n2, String string, short s) {
        this.clear();
        this.m_TapeMediaChangerId = n;
        this.m_OperationalStatus = n2;
        this.m_FirmwareVersion = string;
        this.m_Detectable = s;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(TapeMediaChangerAttributeSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_FirmwareVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeMediaChangerAttributeSnapshot.getColumnInfo("FIRMWARE_VERSION"), this.m_FirmwareVersion);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(TapeMediaChangerAttributeSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_TapeMediaChangerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_MEDIA_CHANGER_ID not found");
        }
        this.htColsAndValues.put(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), String.valueOf(this.m_TapeMediaChangerId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_MEDIA_CHANGER_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_TapeMediaChangerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_MEDIA_CHANGER_ID not found");
        }
        this.htWhereClause.put(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), String.valueOf(this.m_TapeMediaChangerId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_MEDIA_CHANGER_ID not found");
        }
        this.htWhereClause.put(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), hashtable.get(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_TapeMediaChangerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_MEDIA_CHANGER_ID not found");
        }
        this.htWhereClause.put(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), String.valueOf(this.m_TapeMediaChangerId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_MEDIA_CHANGER_ID not found");
        }
        this.htWhereClause.put(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), hashtable.get(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_TapeMediaChangerId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_MEDIA_CHANGER_ID not found");
        }
        this.htWhereClause.put(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), String.valueOf(this.m_TapeMediaChangerId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static TapeMediaChangerAttributeSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        TapeMediaChangerAttributeSnapshot tapeMediaChangerAttributeSnapshot = null;
        if (hashtable.get(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_MEDIA_CHANGER_ID not found");
        }
        hashtable2.put(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID"), hashtable.get(TapeMediaChangerAttributeSnapshot.getColumnInfo("TAPE_MEDIA_CHANGER_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                tapeMediaChangerAttributeSnapshot = new TapeMediaChangerAttributeSnapshot();
                tapeMediaChangerAttributeSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return tapeMediaChangerAttributeSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setTapeMediaChangerId(dBResultSet.getInt("TAPE_MEDIA_CHANGER_ID"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setFirmwareVersion(dBResultSet.getString("FIRMWARE_VERSION"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
    }

    public static class TapeMediaChangerAttributeSnapshotCursor
    extends DBCursor {
        private TapeMediaChangerAttributeSnapshot element = new TapeMediaChangerAttributeSnapshot();
        private DBConnection con;

        public TapeMediaChangerAttributeSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_TAPE_MEDIA_CHANGER_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public TapeMediaChangerAttributeSnapshot getObject() throws SQLException {
            TapeMediaChangerAttributeSnapshot tapeMediaChangerAttributeSnapshot = null;
            if (this.DBrs != null) {
                tapeMediaChangerAttributeSnapshot = new TapeMediaChangerAttributeSnapshot();
                tapeMediaChangerAttributeSnapshot.setFields(this.con, this.DBrs);
            }
            return tapeMediaChangerAttributeSnapshot;
        }

        public TapeMediaChangerAttributeSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

