/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResVendorSnapshotTable;

public class VendorSnapshot
extends TResVendorSnapshotTable {
    private String m_VendorId_str;

    public void setVendor(String string) {
        this.m_VendorId_str = string;
    }

    public String getVendor() {
        return this.m_VendorId_str;
    }

    public static VendorSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new VendorSnapshotCursor(dBConnection, hashtable, vector);
    }

    public VendorSnapshot() {
        this.clear();
    }

    public VendorSnapshot(int n, short s, String string, String string2) {
        this.clear();
        this.m_SnapshotId = n;
        this.m_VendorId = s;
        this.m_VendorName = string;
        this.m_VendorDescription = string2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_VendorId != Short.MIN_VALUE) {
            hashtable.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(this.m_VendorId));
        }
        if (this.m_VendorDescription != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(VendorSnapshot.getColumnInfo("VENDOR_DESCRIPTION"), this.m_VendorDescription);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htColsAndValues.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htColsAndValues.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_VENDOR_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        if (hashtable.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_VENDOR_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_VENDOR_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")));
        if (hashtable.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_VENDOR_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_VENDOR_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")));
        if (hashtable.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_VENDOR_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_VendorId_str != null) {
            this.m_VendorId = Normalizer.VendorGetID(dBConnection, this.m_VendorId_str);
        }
        if (this.m_VendorName == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key VENDOR_NAME not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), this.m_VendorName);
        if (this.m_SnapshotId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SNAPSHOT_ID not found");
        }
        this.htWhereClause.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), String.valueOf(this.m_SnapshotId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_VENDOR_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static VendorSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        VendorSnapshot vendorSnapshot = null;
        if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")) == null) {
            throw new SQLException(" ERROR: key VENDOR_NAME not found");
        }
        hashtable2.put(VendorSnapshot.getColumnInfo("VENDOR_NAME"), hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_NAME")));
        if (hashtable.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")) == null) {
            throw new SQLException(" ERROR: key SNAPSHOT_ID not found");
        }
        hashtable2.put(VendorSnapshot.getColumnInfo("SNAPSHOT_ID"), hashtable.get(VendorSnapshot.getColumnInfo("SNAPSHOT_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_VENDOR_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                vendorSnapshot = new VendorSnapshot();
                vendorSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return vendorSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        if (hashtable2.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            hashtable2.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable2.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_VENDOR_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
            hashtable.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_VENDOR_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSnapshotId(dBResultSet.getInt("SNAPSHOT_ID"));
        this.setVendorId(dBResultSet.getShort("VENDOR_ID"));
        this.setVendor(Normalizer.VendorGetName(dBConnection, this.m_VendorId));
        this.setVendorName(dBResultSet.getString("VENDOR_NAME"));
        this.setVendorDescription(dBResultSet.getString("VENDOR_DESCRIPTION"));
    }

    public static class VendorSnapshotCursor
    extends DBCursor {
        private VendorSnapshot element = new VendorSnapshot();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")) != null) {
                hashtable.put(VendorSnapshot.getColumnInfo("VENDOR_ID"), String.valueOf(Normalizer.VendorGetID(dBConnection, (String)hashtable.get(VendorSnapshot.getColumnInfo("VENDOR_ID")))));
            }
            return hashtable;
        }

        public VendorSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_VENDOR_SNAPSHOT", dBConnection, VendorSnapshotCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public VendorSnapshot getObject() throws SQLException {
            VendorSnapshot vendorSnapshot = null;
            if (this.DBrs != null) {
                vendorSnapshot = new VendorSnapshot();
                vendorSnapshot.setFields(this.con, this.DBrs);
            }
            return vendorSnapshot;
        }

        public VendorSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

