/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBlade;
import org.eclipse.aperi.infrastructure.database.objects.SwitchBladeType;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class BladeXmlToDBMapper
extends DBAttributeMapper {
    private static final String VENDOR = "Vendor";
    private static final String SERIALNUMBER = "SerialNumber";
    private static final String TYPE = "Type";
    private static final String STATUS = "Status";
    private static final String CONSTATUS = "ConStatus";
    private static final String SLOT = "Slot";
    private static final String MODEL = "Model";
    private static final String FIRMWAREVERSION = "Firmware Version";
    protected static final String SWITCHWWN = "Switch WWN";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "BladeXml";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public BladeXmlToDBMapper() {
        System.out.println("Constructor of FcBladeXmlToDBMapper");
        this.m_dataConverter.addComplexDataConversion(VENDOR.toLowerCase(), ":", 2);
        this.m_dataConverter.addComplexDataConversion(SERIALNUMBER.toLowerCase(), ":", 3);
        this.m_dataConverter.addComplexDataConversion(SWITCHWWN.toLowerCase(), ":", 2);
        ColumnInfo columnInfo = SwitchBlade.getColumnInfo("VENDOR_ID");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        ColumnInfo columnInfo2 = SwitchBlade.getColumnInfo("SWITCH_BLADE_ID");
        columnInfo2.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put(VENDOR.toLowerCase(), mapperInfo);
        ColumnInfo columnInfo3 = SwitchBlade.getColumnInfo("SERIAL_NUMBER");
        columnInfo3.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put(SERIALNUMBER.toLowerCase(), new MapperInfo(columnInfo3));
        ColumnInfo columnInfo4 = SwitchBlade.getColumnInfo("SLOT");
        this.m_htAttribToMapperInfo.put(SLOT.toLowerCase(), new MapperInfo(columnInfo4));
        ColumnInfo columnInfo5 = SwitchBlade.getColumnInfo("SWITCH_BLADE_TYPE_ID");
        this.m_htAttribToMapperInfo.put(TYPE.toLowerCase(), new MapperInfo(columnInfo5));
        ColumnInfo columnInfo6 = SwitchBlade.getColumnInfo("MODEL_ID");
        this.m_htAttribToMapperInfo.put(MODEL.toLowerCase(), new MapperInfo(columnInfo6));
        ColumnInfo columnInfo7 = SwitchBlade.getColumnInfo("OPERATIONAL_STATUS");
        this.m_htAttribToMapperInfo.put(STATUS.toLowerCase(), new MapperInfo(columnInfo7));
        ColumnInfo columnInfo8 = SwitchBlade.getColumnInfo("CONSOLIDATED_STATUS");
        this.m_htAttribToMapperInfo.put(CONSTATUS.toLowerCase(), new MapperInfo(columnInfo8));
        ColumnInfo columnInfo9 = SwitchBlade.getColumnInfo("FIRMWARE_REVISION");
        this.m_htAttribToMapperInfo.put(FIRMWAREVERSION.toLowerCase(), new MapperInfo(columnInfo9));
        this.m_htAttribToMapperInfo.put(SWITCHWWN.toLowerCase(), new MapperInfo(SwitchBlade.getColumnInfo("SWITCH_WWN")));
    }

    private short getTypeID(DBConnection dBConnection, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            string = "unknown";
        }
        short s = Short.MIN_VALUE;
        Vector<String> vector = new Vector<String>();
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        vector.add("SWITCH_BLADE_TYPE_ID");
        hashtable.put(SwitchBladeType.getColumnInfo("TYPE_NAME"), string);
        SwitchBladeType.SwitchBladeTypeCursor switchBladeTypeCursor = null;
        try {
            switchBladeTypeCursor = SwitchBladeType.getCursor(dBConnection, hashtable, vector);
            if (switchBladeTypeCursor.next()) {
                Object[] objectArray = switchBladeTypeCursor.getAttribute(vector);
                s = (short)((Integer)objectArray[0]).intValue();
            } else {
                SwitchBladeType switchBladeType = new SwitchBladeType();
                switchBladeType.setSwitchBladeTypeId((short)AutoIdentifier.getIdentifier(16, 1));
                switchBladeType.setTypeName(string);
                switchBladeType.insert(dBConnection);
                dBConnection.commit();
                s = switchBladeType.getSwitchBladeTypeId();
            }
        }
        finally {
            if (switchBladeTypeCursor != null) {
                switchBladeTypeCursor.close();
            }
        }
        if (s == Short.MIN_VALUE) {
            throw new SQLException("Type value of \"" + string + "\" was not able to be normalized.");
        }
        return s;
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        String string2 = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, string2, new Object[]{dBConnection, hashtable, string});
        MapperResult mapperResult = null;
        String string3 = (String)hashtable.get("UniqueIdXml");
        if (string3 != null) {
            String string4 = (String)hashtable.get(STATUS);
            if (string4 != null) {
                object = this.convertSNIAOPStatToBitArrValue(string4);
                hashtable.put(STATUS, object[0]);
                Vector<String> vector = new Vector<String>();
                vector.add(object[1]);
                String string5 = DBConstants.convertOperationalstatusArrayToConsolidatedValue(vector);
                if (string5 != null) {
                    hashtable.put(CONSTATUS, string5);
                }
            }
            hashtable.put(VENDOR, string3);
            hashtable.put(SERIALNUMBER, string3);
            if (hashtable.get(TYPE) == null) {
                hashtable.put(TYPE, "unknown");
            }
        } else {
            SQLException sQLException = new SQLException("Required field, UniqueIdXml, was not found.");
            this.logException(this.myClassname, string2, sQLException, "");
            throw sQLException;
        }
        object = (String)hashtable.get(TYPE);
        object = Short.toString(this.getTypeID(dBConnection, (String)object));
        hashtable.put(TYPE, object);
        mapperResult = super.persist(dBConnection, hashtable, string);
        this.logExit(this.myClassname, string2, mapperResult);
        return mapperResult;
    }
}

