/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.mapping.AttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.DBTableMapper;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class MapperManager {
    public static final String CIMOM_SOURCE = "CIMOM";
    public static final String LEGACY_FABRIC_SOURCE = "LFABRIC";
    public static final String SANMXML_10 = "SANXML_1_0";
    public static final String SMIS_10 = "SMIS_1_0";
    public static final String SLP_10 = "SLP_1_0";
    public static final String TPCDB_10 = "DBMapper";
    private static final String mapperPkg = "org.eclipse.aperi.infrastructure.mapping";
    private static ILogger myLogger = DBConstants.getLogger();
    private static String myClassname = "org.eclipse.aperi.infrastructure.mapping.MapperManager.java";
    private static Hashtable mapperInstancesCache = new Hashtable();
    public static final String SMIS1_0 = "SMIS";
    public static final String SANMXML1_0 = "";
    public static final String SLP1_0 = "SLP";
    public static final String CIMOM = "CIMOM";
    public static final String TPCDB1_0 = "DBMapper";

    private MapperManager() {
    }

    public static AttributeMapper retrieveMapper(String string, String string2, String string3, String string4, Hashtable hashtable) {
        String string5 = "retrieveMapper( String infoSource, String objectName, String spec, String destination, Hashtable params )";
        AttributeMapper attributeMapper = null;
        String string6 = String.valueOf(string) + string3 + string2 + "To" + string4;
        String string7 = null;
        while (attributeMapper == null && string2 != null) {
            string7 = String.valueOf(string) + string3 + string2 + "To" + string4;
            if (myLogger.isLogging()) {
                myLogger.text(IRecordType.TYPE_INFO, myClassname, string5, "Searching for mapper named \"" + string7 + "\"");
            }
            if ((attributeMapper = MapperManager.classRetrieval(string7)) == null) {
                string7 = String.valueOf(string) + string2 + "To" + string4;
                if (myLogger.isLogging()) {
                    myLogger.text(IRecordType.TYPE_INFO, myClassname, string5, "Searching for mapper named \"" + string7 + "\"");
                }
                attributeMapper = MapperManager.classRetrieval(string7);
            }
            if (attributeMapper != null) continue;
            string2 = DBTableMapper.getLookup(string2, hashtable);
        }
        if (attributeMapper != null) {
            mapperInstancesCache.put("org.eclipse.aperi.infrastructure.mapping." + string6, attributeMapper);
            mapperInstancesCache.put("org.eclipse.aperi.infrastructure.mapping." + string7, attributeMapper);
        }
        return attributeMapper;
    }

    private static AttributeMapper classRetrieval(String string) {
        Class<?> clazz = null;
        String string2 = "classRetrieval( String classname )";
        String string3 = "org.eclipse.aperi.infrastructure.mapping." + string;
        Object object = mapperInstancesCache.get(string3);
        if (object == null) {
            try {
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (myLogger.isLogging()) {
                    myLogger.exception(IRecordType.TYPE_ERROR, myClassname, string2, classNotFoundException, "Could not find class " + string3 + ".");
                }
                clazz = null;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                if (myLogger.isLogging()) {
                    myLogger.exception(IRecordType.TYPE_ERROR, myClassname, string2, exceptionInInitializerError, "Class " + string3 + " failed initialization and thus can not be used.");
                }
                clazz = null;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (myLogger.isLogging()) {
                    myLogger.exception(IRecordType.TYPE_ERROR, myClassname, string2, noClassDefFoundError, "Runtime error: Class definition for " + string3 + " once existed, but can no longer be found.");
                }
                clazz = null;
            }
            if (clazz != null) {
                try {
                    object = clazz.newInstance();
                    if (!(object instanceof AttributeMapper)) {
                        if (myLogger.isLogging()) {
                            myLogger.text(IRecordType.TYPE_ERROR, myClassname, string2, "Class matching requested " + string3 + " was found, but did not extend AttributeMapper and is thus invalid.");
                        }
                        object = null;
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (myLogger.isLogging()) {
                        myLogger.exception(IRecordType.TYPE_ERROR, myClassname, string2, instantiationException, "Can not instantiate class " + string3);
                    }
                    object = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (myLogger.isLogging()) {
                        myLogger.exception(IRecordType.TYPE_ERROR, myClassname, string2, illegalAccessException, "Requested class, " + string3 + ", is not accessible");
                    }
                    object = null;
                }
            }
        }
        return (AttributeMapper)object;
    }

    public static AttributeMapper getMapper(String string, String string2, String string3, Hashtable hashtable) {
        AttributeMapper attributeMapper = null;
        String string4 = String.valueOf(string) + string3 + "To" + string2;
        String string5 = string3;
        attributeMapper = MapperManager.retrieveAttributeMapperClass(mapperPkg, string4);
        if (attributeMapper == null) {
            String string6 = String.valueOf(string) + MapperManager.extractGenericName(string3) + "To" + string2;
            attributeMapper = MapperManager.retrieveAttributeMapperClass(mapperPkg, string6);
        }
        if (attributeMapper == null && (string3 = DBTableMapper.getLookup(string3, hashtable)) != null) {
            string4 = String.valueOf(string) + string3 + "To" + string2;
            attributeMapper = MapperManager.retrieveAttributeMapperClass(mapperPkg, string4);
        }
        if (string4 != null && attributeMapper != null) {
            mapperInstancesCache.put("org.eclipse.aperi.infrastructure.mapping." + string4, attributeMapper);
            mapperInstancesCache.put("org.eclipse.aperi.infrastructure.mapping." + string + string5 + "To" + string2, attributeMapper);
        }
        return attributeMapper;
    }

    private static String extractGenericName(String string) {
        return string.substring(string.indexOf("_") + 1);
    }

    private static AttributeMapper retrieveAttributeMapperClass(String string, String string2) {
        Class<?> clazz = null;
        Object var3_3 = null;
        String string3 = String.valueOf(string) + "." + string2;
        var3_3 = mapperInstancesCache.get(string3);
        if (var3_3 == null) {
            try {
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                clazz = null;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                noClassDefFoundError.printStackTrace();
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                exceptionInInitializerError.printStackTrace();
            }
            if (clazz != null) {
                try {
                    var3_3 = clazz.newInstance();
                    if (!(var3_3 instanceof AttributeMapper)) {
                        System.err.println("ERROR - " + string3 + " is not an AttributeMapper subclass");
                        var3_3 = null;
                    }
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
        }
        return var3_3;
    }

    public static boolean testMappers(boolean bl) {
        boolean bl2 = true;
        String string = System.getProperty("user.dir");
        File file = new File(String.valueOf(string) + "\\com\\ibm\\tpc\\infrastructure\\mapping\\");
        String[] stringArray = file.list(new mapperTestFileFilter());
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].replaceFirst(".java", SANMXML1_0);
            AttributeMapper attributeMapper = MapperManager.classRetrieval(string2);
            System.out.println("\tFound Mapper: " + string2);
            if (attributeMapper == null) {
                bl2 = false;
            }
            if (attributeMapper != null && bl) {
                Hashtable hashtable = ((DBAttributeMapper)attributeMapper).m_htAttribToMapperInfo;
                for (String string3 : hashtable.keySet()) {
                    System.out.println("\t\t" + string3);
                }
            }
            ++n;
        }
        return bl2;
    }

    public static class mapperTestFileFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.indexOf("ToDBMapper.java") != -1;
        }
    }
}

