/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCapabilityDataToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "CapabilityData";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public SMISCapabilityDataToDBMapper() {
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>();
        vector.add("ACCESS_ASSIGNMENT");
        vector.add("ACCESS_POINT");
        vector.add("ACCESS_UNASSIGNMENT");
        vector.add("ATTACH_DEVICE");
        vector.add("CONTROLLER_REQ_IDENTITY");
        vector.add("CONTROLLER_SUPP_COLL");
        vector.add("DISK_DATA");
        vector.add("EXPOSE_PATH");
        vector.add("EXTENT_DATA");
        vector.add("NUM_VOLUMES");
        vector.add("ONE_HW_ID_PER_VIEW");
        vector.add("PORTS_PER_VIEW");
        vector.add("RAID_LEVELS");
        vector.add("SMIS_PROFILE");
        vector.add("SMIS_SUB_PROFILES");
        vector.add("SMIS_VERSION");
        vector.add("SPC_ALLOWS_DEFAULT_VIEWS");
        vector.add("SPC_ALLOWS_NO_INITIATORS");
        vector.add("SPC_ALLOWS_NO_LUS");
        vector.add("SPC_ALLOWS_NO_TGTS");
        vector.add("TARGET_PORT_RESTRICTION");
        vector.add("UNIQUE_NUM_PER_PORT");
        vector.add("VOLUME_CREATION");
        vector.add("VOLUME_DELETION");
        vector.add("VOLUME_EXPANSION");
        vector.add("VOLUME_SHRINKING");
        vector.add("CLNT_SELCTBL_DEVNO");
        ColumnInfo columnInfo = CapabilityData.getColumnInfo("CAPABILITY_DATA_ID");
        columnInfo.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put("CAPABILITY_DATA_ID".toLowerCase(), new MapperInfo(columnInfo));
        int n = 0;
        while (n < vector.size()) {
            object2 = CapabilityData.getColumnInfo((String)vector.elementAt(n));
            if (((ColumnInfo)object2).getDataType() == 5) {
                this.m_dataConverter.addSimpleDataConversion(((String)vector.elementAt(n)).toLowerCase(), "Boolean");
            }
            object = new MapperInfo((ColumnInfo)object2);
            this.m_htAttribToMapperInfo.put(((String)vector.elementAt(n)).toLowerCase(), object);
            ++n;
        }
        ColumnInfo columnInfo2 = CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID");
        columnInfo2.setIsPrimaryKey();
        object2 = new MapperInfo(columnInfo2);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", object2);
        object = CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID");
        ((ColumnInfo)object).setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo((ColumnInfo)object);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_cimom2namespaceid", mapperInfo);
        this.m_htAttribToMapperInfo.put("CAPABILITY_DATA_ID2".toLowerCase(), new MapperInfo(CimkeySubsystem.getColumnInfo("CAPABILITY_DATA_ID")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        String string2 = (String)hashtable.get("ref_toplevelsystem_id");
        String string3 = (String)hashtable.get("ref_toplevelsystem_cimom2namespaceid");
        if (string2 == null || string3 == null) throw new SQLException("Missing SubsystemID or Cimom2NamespaceId");
        Object object = new CimkeySubsystem();
        ((TResCimkeySubsystemTable)object).setSubsystemId(Integer.parseInt(string2));
        ((TResCimkeySubsystemTable)object).setCimNamespaceId(Integer.parseInt(string3));
        if (!((CimkeySubsystem)object).retrieve(dBConnection)) throw new SQLException("No CimKeySubsystem entry found");
        int n = ((TResCimkeySubsystemTable)object).getCapabilityDataId();
        if (n == Integer.MIN_VALUE || n == 0) {
            n = AutoIdentifier.getIdentifier(1, 1);
            hashtable.put("CAPABILITY_DATA_ID2".toLowerCase(), String.valueOf(n));
        } else {
            hashtable.remove("ref_toplevelsystem_cimom2namespaceid");
            hashtable.remove("ref_toplevelsystem_id");
        }
        hashtable.put("CAPABILITY_DATA_ID".toLowerCase(), String.valueOf(n));
        object = super.persist(dBConnection, hashtable, string);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", object);
        return object;
    }
}

